/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * stdio_internal.h
 *
 * Header file used by all of the stdio module components (both PCN and C).
 */

#ifndef _PCN_INCLUDE_STDIO_INTERNAL_H
#define _PCN_INCLUDE_STDIO_INTERNAL_H

#ifndef PCN

#include <stdio.h>
#include <errno.h>
#include "pcn_c_hdr.h"
#include "pcn_types.h"

struct s_fmt {
  int findex;
  char string[1];
};

#else  /* !PCN */

#include "pcn_stdio.h"

#endif /* !PCN */

#define ARG_TYPE_INT	1
#define ARG_TYPE_DOUBLE	2
#define ARG_TYPE_CHAR	3
#define ARG_TYPE_TUPLE	4

#define PRINT_TERM	-2	/* if print argument a TERM */
#define PRINT_LTERM	-3	/* if print argument a LONG TERM */

#define SCAN_INT	0
#define SCAN_CHAR	1
#define SCAN_FLOAT	2
#define SCAN_STRING	3
#define SCAN_TERM	-4

#endif /* _PCN_INCLUDE_STDIO_INTERNAL_H */

