/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * stdio_fscanf.c
 */

#include "stdio_internal.h"


/*
 * If format string looks like "%d %f" this will
 * temporily change the format string to look like "%d".
 * Then call fscanf().  Then change the format string to
 * look like " %f".
 */
#define scan_arg(cPtr, fp, fmt, arg, eof) \
{ \
    char __ch = *(++cPtr); \
    *cPtr = '\0'; \
    (eof) = fscanf(fp, (fmt), (arg)); \
    *cPtr = __ch; \
    fmt = cPtr; \
}


/*
 * _p_stdio_get_scan_arg()
 *
 * Get one argument for scanf()
 */
void _p_stdio_get_scan_arg(fp, fmt, type, i, f, sbuf, eof)
FILE **fp;
struct s_fmt *fmt;
int_t *type, *i, *eof;
char_t *sbuf;
double_t *f;
{
    int is_long = 0;
    int printed;
    
    char *cPtr;
    char *fmt_ptr = fmt->string + fmt->findex;
    
    *eof = 0;
    if ((cPtr = strchr(fmt_ptr, '%')) != NULL)
    {
	is_long = 0;
	printed = 0;
	while (!printed)
	{
	    switch (*(++cPtr))
	    {
	    case '%': 
		if ((cPtr = strchr(++cPtr, '%')) == NULL)
		{
		    *eof = EOF;
		    printed++;
		}
		break;
	    case '*': 
		if ((cPtr = strchr(++cPtr, '%')) == NULL)
		{
		    *eof = EOF;
		    printed++;
		}
		break;
	    case 'l': 
		is_long = 1;
		break;
	    case 'd':
	    case 'i':
	    case 'o':
	    case 'u':
	    case 'x':
	    case 'X':
		if (is_long)
		{
		    long tmp_l;
		    scan_arg(cPtr, *fp, fmt_ptr, &tmp_l, *eof);
		    *i = (int_t) tmp_l;
		}
		else
		{
		    int tmp_i;
		    scan_arg(cPtr, *fp, fmt_ptr, &tmp_i, *eof);
		    *i = (int_t) tmp_i;
		}
		printed++;
		*type = SCAN_INT;
		break;
	    case 'f':
	    case 'e':
	    case 'E':
	    case 'g':
	    case 'G':
		if (is_long)
		{
		    double tmp_d;
		    scan_arg(cPtr, *fp, fmt_ptr, &tmp_d, *eof);
		    *f = (double_t) tmp_d;
		}
		else
		{
		    float tmp_f;
		    scan_arg(cPtr, *fp, fmt_ptr, &tmp_f, *eof);
		    *f = (double_t) tmp_f;
		}
		printed++;
		*type = SCAN_FLOAT;
		break;
	    case 'c':
	    {
		char c;
		scan_arg(cPtr, *fp, fmt_ptr, &c, *eof);
		*i = (int_t) c;
		printed++;
		*type = SCAN_CHAR;
		break;
	    }
	    case 's':
		scan_arg(cPtr, *fp, fmt_ptr, sbuf, *eof); 
		*i = strlen(sbuf) + 1;
		*type = SCAN_STRING;
		printed++;
		break;
		
	    default:
		break;
	    }
	}
	fmt->findex = fmt_ptr - fmt->string;
    }
    else
    {
	*eof = fscanf(*fp, fmt_ptr, NULL);
    }
} /* _p_stdio_get_scan_arg() */
