/*
 * PCN System Linker -- pcnlink
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * link_code.c		- Support routines for link_code.pcn
 *
 * Foreign procedures used for code generation into the custom info file.
 */

#include "link_internal.h"


/*
 * _p_link_code_header()
 */
void _p_link_code_header(buf, buf_len, file_number, module_number,
			 proc_number)
char_t *buf;
int_t *buf_len;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
{
    sprintf((char *) buf,
	    "SC pc_%ld_%ld_%ld[] = {\n",
	    (long) *file_number, (long) *module_number, (long) *proc_number);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_header(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_header() */


/*
 * _p_link_code_fork()
 */
void _p_link_code_fork(buf, buf_len, opcode, opword, file_number,
		       module_number, proc_number)
char_t *buf;
int_t *buf_len;
int_t *opcode;
u_int_t *opword;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
{
    sprintf((char *) buf,
	    "0x%lx,(code_t)(&_p_%ld_%ld_%ld),\n",
	    (unsigned long) *opword, (long) *file_number,
	    (long) *module_number, (long) *proc_number);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_fork(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_fork() */


/*
 * _p_link_code_recurse()
 */
void _p_link_code_recurse(buf, buf_len, opcode, opword, file_number,
			  module_number, proc_number)
char_t *buf;
int_t *buf_len;
int_t *opcode;
u_int_t *opword;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
{
    sprintf((char *) buf,
	    "0x%lx,(code_t)(&_p_%ld_%ld_%ld),",
	    (unsigned long) *opword, (long) *file_number,
	    (long) *module_number, (long) *proc_number);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_recurse(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_recurse() */


/*
 * _p_link_code_halt()
 */
void _p_link_code_halt(buf, buf_len, opcode, opword)
char_t *buf;
int_t *buf_len;
int_t *opcode;
u_int_t *opword;
{
    sprintf((char *) buf,
	    "0x%lx,",
	    (unsigned long) *opword);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_halt(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_halt() */


/*
 * _p_link_code_default()
 */
void _p_link_code_default(buf, buf_len, opcode, opword)
char_t *buf;
int_t *buf_len;
int_t *opcode;
u_int_t *opword;
{
    sprintf((char *) buf,
	    "0x%lx,",
	    (unsigned long) *opword);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_default(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_default() */


/*
 * _p_link_code_try()
 */
void _p_link_code_try(buf, buf_len, opcode, opword, file_number,
		      module_number, proc_number, jump_offset)
char_t *buf;
int_t *buf_len;
int_t *opcode;
u_int_t *opword;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
int_t *jump_offset;
{
    sprintf((char *) buf,
	    "0x%lx,(code_t)(&(pc_%ld_%ld_%ld[%ld])),\n",
	    (unsigned long) *opword, (long) *file_number,
	    (long) *module_number, (long) *proc_number, (long) *jump_offset);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_try(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_try() */


/*
 * _p_link_code_put_data()
 */
void _p_link_code_put_data(buf, buf_len, opcode, opword, tag_string,
			   file_number, module_number,
			   proc_number, data_loc)
char_t *buf;
int_t *buf_len;
int_t *opcode;
u_int_t *opword;
char_t *tag_string;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
int_t *data_loc;
{
    sprintf((char *) buf,
	    "0x%lx,(code_t)(&%s_%ld_%ld_%ld_%ld),\n",
	    (unsigned long) *opword, tag_string, (long) *file_number,
	    (long) *module_number, (long) *proc_number, (long) *data_loc);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_put_data(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_put_data() */


/*
 * _p_link_code_copy_mut()
 */
void _p_link_code_copy_mut(buf, buf_len, opcode, opword)
char_t *buf;
int_t *buf_len;
int_t *opcode;
u_int_t *opword;
{
    sprintf((char *) buf,
	    "0x%lx,",
	    (unsigned long) *opword);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_copy_mut(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_copy_mut() */


/*
 * _p_link_code_call_foreign()
 */
void _p_link_code_call_foreign(buf, buf_len, opcode, opword)
char_t *buf;
int_t *buf_len;
int_t *opcode;
u_int_t *opword;
{
    sprintf((char *) buf,
	    "0x%lx,(code_t)",
	    (unsigned long) *opword);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_call_foreign(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_call_foreign() */


/*
 * _p_link_code_1_cell()
 */
void _p_link_code_1_cell(buf, buf_len, opcode, opword)
char_t *buf;
int_t *buf_len;
int_t *opcode;
u_int_t *opword;
{
    sprintf((char *) buf,
	    "0x%lx,\n",
	    (unsigned long) *opword);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_1_cell(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_1_cell() */


/*
 * _p_link_code_2_cell()
 */
void _p_link_code_2_cell(buf, buf_len, opcode, opword, word2)
char_t *buf;
int_t *buf_len;
int_t *opcode;
u_int_t *opword;
u_int_t *word2;
{
    sprintf((char *) buf,
	    "0x%lx,0x%lx,\n",
	    (unsigned long) *opword, (unsigned long) *word2);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_2_cell(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_2_cell() */


/*
 * _p_link_code_counter()
 */
void _p_link_code_counter(buf, buf_len, file_number, module_number,
			  proc_number, counter_number)
char_t *buf;
int_t *buf_len;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
int_t *counter_number;
{
    sprintf((char *) buf,
	    "\n#ifdef GAUGE\n(code_t)(&cnt_%ld_%ld_%ld[%ld]),\n#else\n0,\n#endif\n",
	    (long) *file_number, (long) *module_number,
	    (long) *proc_number, (long) *counter_number);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_counter(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_counter() */


/*
 * _p_link_code_timer()
 */
void _p_link_code_timer(buf, buf_len, file_number, module_number,
			proc_number, timer_number)
char_t *buf;
int_t *buf_len;
int_t *file_number;
int_t *module_number;
int_t *proc_number;
int_t *timer_number;
{
    sprintf((char *) buf,
	    "\n#ifdef GAUGE\n(code_t)(&tm_%ld_%ld_%ld[%ld]),\n#else\n0,\n#endif\n",
	    (long) *file_number, (long) *module_number,
	    (long) *proc_number, (long) *timer_number);
#ifdef DEBUG_BUF_OVERFLOW
    if (strlen((char *) buf) >= *buf_len)
    {
	fprintf(stderr,
		"Fatal Error: _p_link_code_timer(): Buffer overflow\n");
	exit_from_c(1);
    }
#endif    
} /* _p_link_code_timer() */
