/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * pcn_types.h
 *
 * Typedefs and defines for the PCN data structure types that a
 * user would access from foreign code.
 */

#ifndef _PCN_INCLUDE_PCN_TYPES_H
#define _PCN_INCLUDE_PCN_TYPES_H

#ifndef PCN

/*
 * typedefs for basic PCN data type
 *
 * Note:  sizeof(cell_t) must always be the same size as a pointer,
 *	because cells are routinely used to hold pointers.
 */
#ifdef rs6000
typedef int		int_t;		/* 32 (or 64?) bit integer */
typedef unsigned int	u_int_t;	/* unsigned 32 (or 64?) bit integer */
#else 
typedef long		int_t;		/* 32 (or 64?) bit integer */
typedef unsigned long	u_int_t;	/* unsigned 32 (or 64?) bit integer */
#endif
typedef double		double_t;
typedef	int_t		cell_t;
typedef char		char_t;
typedef unsigned char	u_char_t;

#if !defined(symmetry) || !defined(_TYPES_)
/* Only do this typedef if sys/types.h has not been included */
typedef int_t		bool_t;
#endif

#ifndef TRUE
#define	TRUE		1
#endif
#ifndef FALSE
#define	FALSE		0
#endif

#endif /* PCN */

#endif /* _PCN_INCLUDE_PCN_TYPES_H */
