/*
 * PCN Abstract Machine Emulator
 * Authors:     Steve Tuecke and Ian Foster
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * byte_ord.c
 *
 * A simple program for figuring out the integer byte ordering used
 * used by a machine.
 *
 * Here are some machines that I have tested:
 *	NeXT (68030):		low byte first, high byte last
 *	Sun 3 (68030):		low byte first, high byte last
 *	Sun 4 (SPARC):		low byte first, high byte last
 * 	Encore (NS32x32):	high byte first, low byte last
 *	Seq. Balance(NS32x32):	high byte first, low byte last
 *	Vax:			high byte first, low byte last
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>

main()
{
    int fd;
    int i, j, *k;
    char buf[10];

    if ((fd = open("byte_order.out", O_RDWR | O_CREAT | O_TRUNC, 0777)) == -1)
    {
	printf("Failed to open byte_order.out\n");
	exit(0);
    }

    i = 0x10203040;
    
    write(fd, &i, 4);
    lseek(fd, (off_t) 0, L_SET);
    read(fd, buf, 4);
    lseek(fd, (off_t) 0, L_SET);
    read(fd, &j, 4);
    k = (int *) buf;

    printf("bytes: %x, %x, %x, %x\n",
	   (int) buf[0],
	   (int) buf[1], 
	   (int) buf[2], 
	   (int) buf[3]);
    printf("j  = %x\n", j);
    printf("*k = %x\n", *k);
    if (buf[0] == 0x10
	&& buf[1] == 0x20
	&& buf[2] == 0x30
	&& buf[3] == 0x40)
    {
	printf("Integers are low order byte first, high order byte last\n");
    }
    else if (buf[0] == 0x40
	&& buf[1] == 0x30
	&& buf[2] == 0x20
	&& buf[3] == 0x10)
    {
	printf("Integers are high order byte first, low order byte last\n");
    }
    else
    {
	printf("Integers are some wierd ordering\n");
    }
}
