sub help_init {
$help_initialized = 1;
$usage{"abbrev"} = <<END;
abbrev command
abbrev abbreviation
abbrev
END

$help{"abbrev"} = <<END;
abbrev displays information about command abbreviations. Abbreviations
are generated automatically from the internal command list, so they
may not be optimal. I'm always open to suggestions for better
abbreviation generation algorithms.

Given an abbreviation or command as an argument, abbrev prints out the
corresponding abbreviation-command pair if one exists. If the abbreviation
is ambiguous, the list of matching commands is printed.

abbrev with no arguments prints a complete list of abbreviations.
END

$usage{"delete-group"} = <<END;
delete-group groupname
END

$help{"delete-group"} = <<END;
Delete a group from the group database. Deleting a group also undefines
it.
END

$usage{"list-group"} = <<END;
list-group groupname
END

$help{"list-group"} = <<END;
Display the contents of group groupname.
END

$usage{"hosts"} = <<END;
hosts
END

$help{"hosts"} = <<END;
Print a list of current hosts.
END

$usage{"listen-port"} = <<END;
listen-port
END

$help{"listen-port"} = <<END;
Prints the port that host-control is listening on.
END

$usage{"apropos"} = <<END;
apropos regexp
END

$help{"apropos"} = <<END;
Search for help topics whose name or contents matches regexp.
END

$help{"host-variables"} = <<END;
Host variables affect execution on the host-control process itself, and are
set with the "set" command.

Valid host variables and their default values are:
    startnode-query [on]
	If on, query the user before actually starting any node daemons.

    collect-output [yes]
	If yes, collect all node output without displaying. To display, 
	do a "dump-output". 
	If no, display node output to the terminal as it comes in.

    kill-nodes-on-exit [prompt]
        If yes, send a kill message to all connected node-control daemons
	when host-control is exited.
        If no, do not send a kill message to all connected node-control daemons
	when host-control is exited.
        If prompt, prompt the user before exiting.
END

$help{"node-variables"} = <<END;
Node varibles affect the execution of the node control daemons and are 
set with the "rset" (remote set) command. 

Valid node variables and their default values are:
    pcn-dir [some pathname]
	The directory a forked PCN node process is executed in. This
	is not necessary if PCN nodes are started using the host control
	program (as opposed to the start-nodes script).

    pcn [pcn.ARCH.bsd]
	The name of the PCN executable. Again, not necessary if PCN nodes
	are started using the host control program.

    enabled [yes]
	If yes, PCN nodes can be started on this node.
	This variable is set by the "enable" and "disable" commands.
END

$help{"variables"} = <<END;
There are two types of variables that host-control can set: host variables
and node variables. See the help for host-variables and node-variables.
END

$help{"environment"} = <<END;
The following environment variables are meaningful to host-control:
    PCN_CONTROL_DIR
        Defines the directory that is used for the lists
	of nodes, hosts, and groups.

    EDITOR
    	Defines the editor used by the edit command unless the host-control
    	variable "editor" is set.
END

$usage{"usage"} = <<END;
usage command
END

$help{"usage"} = <<END;
Print usage information for command.
END

$usage{"save-group"} = <<END;
save-group groupname
END

$help{"save-group"} = <<END;
Save the given group to the file $control_dir/groups/groupname.def.
END

$usage{"undefine-group"} = <<END;
undefine-group groupname
END

$help{"undefine-group"} = <<END;
Remove the definition for groupname (but not the saved file if it
exists).
END

$usage{"define-group"} = <<END;
define-group groupname
END

$help{"define-group"} = <<END;
Define a host group. Enter one host per line when prompted. Enter
a blank line when finished. To save a group for later use, use the
save-group command.
END

$usage{"disable"} = <<END;
disable [<host>|<architecture>|<group>] ...
disable [host=<hostname>] ...
disable [group=<groupname>] ...
disable [arch=<architecture>] ...
END

$help{"disable"} = <<END;
Disable a host or all machines of a given architecture or group.
END

$usage{"dump-output"} = <<END;
dump-output [hosts]
END

$help{"dump-output"} = <<END;
Dump the saved node output for the given hosts, or for all hosts if none
are specified.
END

$usage{"enable"} = <<END;
enable [<host>|<architecture>|<group>] ...
enable [host=<hostname>] ...
enable [group=<groupname>] ...
enable [arch=<architecture>] ...
END

$help{"enable"} = <<END;
Enable a host or all machines of a given architecture or group.
END

$usage{"flush-output"} = <<END;
flush-output [hosts]...
END

$help{"flush-output"} = <<END;
Flush the saved node output for the given hosts, or for all hosts if
none are specified.
END

$usage{"list-groups"} = <<END;
list-groups
END

$help{"list-groups"} = <<END;
List all currently loaded groups.
END

$usage{"load-group"} = <<END;
load-group groupname
END

$help{"load-group"} = <<END;
Load the given group from the file PCN_CONTROL_DIR/groups/groupname.def.
END

$usage{"enabled"} = <<END;
enabled
END

$help{"enabled"} = <<END;
Print a list of enabled nodes.
END

$usage{"node-rusage"} = <<END;
node-rusage all|hostname
END

$help{"node-rusage"} = <<END;
Return the user and system time used by the node's children.
END

$usage{"restart"} = <<END;
restart
END

$help{"restart"} = <<END;
Restart host-control.
END
    
$usage{"edit"} = <<END;
edit [files]
END

$help{"edit"} = <<END;
Invoke an editor determined by the host-control variable "editor". If
"editor" is not defined, use the editor specfied by the environment
variable EDITOR. Otherwise, use vi.
END

$usage{"kj"} = <<END;
kj [all|hostname] string
END

$help{"kj"} = <<END;
Kill a process by name on the specified node.
END

$usage{"kill-pcn"} = <<END;
kill-pcn [all|hostname] pids
END

$help{"kill-pcn"} = <<END;
Kill a PCN node process.
END

$usage{"write-nodes"} = <<END;
write-nodes filename
END

$help{"write-nodes"} = <<END;
Write the list of currently connected nodes to a file.
END

$usage{"connect-to-node"} = <<END;
connect-to-node host port
END

$help{"connect-to-node"} = <<END;
Connect to a node given the hostname and port the node is listening on.
END

$usage{"eval"} = <<END;
eval expression
END

$help{"eval"} = <<END;
Evaluate a perl expression. 
END

$usage{"uptime"} = <<END;
uptime [all|hostname]
END

$help{"uptime"} = <<END;
Run the uptime command remotely.
END

$usage{"load-config"} = <<END;
load-config filename
END

$help{"load-config"} = <<END;
Load a host configuration file. 
This file is of the format:
%%TEX \\begin{verbatim}
	arch: archicture
	variable value
	variable value
	<blank line>

	arch: arch2
	...
	<blank line>
	node: host1
	node: host2

	host: host1
	variable value
	...
	<blank line>	    
%%TEX \\end{verbatim}
The arch: section describes a series of variables to be set for the given
architecture.

The host: section describes a series of variables to be set for the given
host.

Each node: line results in a node control daemon being started on that
host.
END

$usage{"reconnect"} = <<END;
reconnect
END

$help{"reconnect"} = <<END;
Disconnect from all node control daemons and reconnect to them.
END

$usage{"status"} = <<END;
status [all|hostname]
END

$help{"status"} = <<END;
Query node control daemons for the status of PCN node processes.
END

$usage{"help"} = <<END;
help [command-name]
END

$help{"help"} = <<END;
This help.
END

$usage{"pushd"} = <<END;
pushd directory
END

$help{"pushd"} = <<END;
Push to a new directory.
END

$usage{"popd"} = <<END;
popd
END

$help{"popd"} = <<END;
Pop the top directory from the directory stack.
END

$usage{"pwd"} = <<END;
pwd
END

$help{"pwd"} = <<END;
Print the current working directory.
END

$usage{"dirs"} = <<END;
dirs
END

$help{"dirs"} = <<END;
Print the directory stack.
END

$usage{"quit"} = <<END;
quit
END

$help{"quit"} = <<END;
Quit host-control.
END

$usage{"arch"} = <<END;
arch [all|hostname]
END

$help{"arch"} = <<END;
Perform an arch command on the specified hosts.
END

$usage{"conns"} = <<END;
conns
END

$help{"conns"} = <<END;
Print a listing of currently connected node control daemons.
END

$usage{"ps"} = <<END;
ps all|hostname ps-arguments
END

$help{"ps"} = <<END;
Perform a ps command on the specified hosts.
END

$usage{"!"} = <<END;
! command arguments
END

$help{"!"} = <<END;
Perform a shell escape locally.
END

$usage{"cd"} = <<END;
cd directory
END

$help{"cd"} = <<END;
Change directory.
END

$usage{"set"} = <<END;
set 				to see all variables
set variable			to see the value of variable
set variable value		to set variable = value
END

$help{"set"} = <<END;
Set a host variable.
END

$usage{"rset"} = <<END;
rset [all|hostname]				to see all variables
rset [all|hostname] variable			to see the value of variable
rset [all|hostname] variable value		to set variable = value
END

$help{"rset"} = <<END;
Set a node variable.
END

$usage{"unset"} = <<END;
unset variable
END

$help{"unset"} = <<END;
Remove the binding for a variable.
END

$usage{"wait-for-pending"} = <<END;
wait-for-pending
END

$help{"wait-for-pending"} = <<END;
Wait for all started node control daemons to connect to the host.
END

$usage{"start-node"} = <<END;
startnode host1 host2 ...
startnode filename
startnode user@host:node-control-command
END

$help{"start-node"} = <<END;
Start a node control daemon on the specified hosts. The host can also
be specified as user@host:node-control-command. This means to start a
node on host as user, running node-control-command. For example:
	startnode rolson@zaphod.ncsa.uiuc.edu:control/node-control

Startnode can fail for several reasons. If the user does not have the
correct login on the remote machine, the message
	Startnode failed: login incorrect
will appear. If the local machine is not allowed to run rsh on the
remote machine, the message:
	Startnode failed: Permission denied
will appear. 
	
If an attempt to a machine fails, a second attempt may be made under
the following circumstances. One can define a group (see define-group)
containing a list of machines. If a node is running on one machine in
the group and that group is defined (groups will be loaded when
necessary), host-control will attempt to use that machine to start a
node. For example, if the group uiuc contains the machines
	bassoon.cs.uiuc.edu
	flute.cs.uiuc.edu
and there is a node running on flute, 
	startnode bassoon.cs.uiuc.edu
results in flute attempting to start a node on bassoon. The intent is
that groups of machines that are allowed to rsh between themselves
can be defined. Once a node is started manually on one machine, nodes
can be started automatically on the other machines.

Arguments can also be files containing lists of hosts.
END

$usage{"alias"} = <<END;
alias					to list all aliases
alias alias				to list alias for name
alias alias name				to alias name to alias
END

$help{"alias"} = <<END;
Set an alias for a command.
END

$usage{"unalias"} = <<END;
unalias alias
END

$help{"unalias"} = <<END;
Remove an alias for a command.
END

$usage{"kill"} = <<END;
kill [all|hostname]
END

$help{"kill"} = <<END;
Kill the specified node control daemons.
END

}

1;
