#include <pwd.h>
#include "regexp.h"
#include <stdio.h>
#include <time.h>

#ifndef DONT_INCLUDE_STRING
#include <string.h>
#endif
#ifdef INCLUDE_STRINGS
#include <strings.h>
#endif

#ifdef STRCHR_TO_INDEX
#define strchr(S,C)     index(S,C)
#define strrchr(S,C)    rindex(S,C)
#endif

#if defined(solbourne) || defined(symmetry)
typedef long time_t;
#endif

#include "assoc.h"

#define MatchLength(regexp, which) ((regexp)->endp[which] - (regexp)->startp[which])
#define GetMatch(regexp, which, string) \
    strncpy(string, (regexp)->startp[which], MatchLength(regexp,which)); \
    string[MatchLength(regexp,which)] = '\0';

AssocArray *defs, *state_start, *state_end, *state_color;

FILE *openFile();
void initRegexps();
void go();

char *strdup();

char *progname;
int lineno;

extern int errno;
extern char *sys_errlist[];

regexp *empty, *comment;
regexp *match_name;
regexp *match_state, *match_start, *match_end, *match_color;

char currentState[100];

char *inputFile, *eventFile, *stateFile;
FILE *inputFP, *eventFP, *stateFP;

main(argc, argv)
int argc;
char **argv;
{
    progname = argv[0];
    if (argc != 4)
    {
	fprintf(stderr, "Usage: %s input event-file state-file\n", progname);
	exit(1);
    }
    inputFile = argv[1];
    eventFile = argv[2];
    stateFile = argv[3];
    inputFP = openFile(inputFile, "r");
    eventFP = openFile(eventFile, "w");
    stateFP = openFile(stateFile, "w");
    lineno = 0;

    initRegexps();

    defs = assoc_new();
    state_start = assoc_new();
    state_end = assoc_new();
    state_color = assoc_new();

    go();

    fclose(inputFP);
    fclose(eventFP);
    fclose(stateFP);
}

void go()
{
    char buf[1000], name[100], date[100], *s, string[100];
    int l, nlen;
    int num;
    struct passwd *pw;
    time_t tim;
    struct tm *tm;
    AssocState *state;

    tim = time(0);
    tm = localtime(&tim);
    strcpy(date, asctime(tm));
    if (s = strchr(date, '\n'))
	*s = 0;

    pw = getpwuid(getuid());

    if (s = strchr(pw->pw_gecos, ','))
	*s = 0;
    if (pw)
    {
	fprintf(eventFP, "\n\
/*\n\
 * Event definitions.\n\
 *\n\
 * This file generated automatically by %s from %s\n\
 * by %s (%s) on %s.\n\
 *\n\
 */\n\
\n\
/* Start event definitions */\n\
",
		progname, inputFile, pw->pw_name,
		pw->pw_gecos, date);
    }

    num = 1;

    while (fgets(buf, sizeof(buf), inputFP) != NULL)
    {
	lineno++;
	l = strlen(buf);
	buf[l - 1] = 0;
	l--;

	if (regexec(empty, buf))
	{
#ifdef DEBUG
	    printf("Skipping empty line\n");
#endif
	    continue;
	}
	else if (regexec(comment, buf))
	{
#ifdef DEBUG
	    printf("Skipping comment\n");
#endif
	    continue;
	}
	else if (regexec(match_state, buf))
	{
#ifdef DEBUG
	    printf("Got state and breaking\n");
#endif
	    break;
	}
	else if (regexec(match_name, buf))
	{
	    nlen = match_name->endp[1] - match_name->startp[1];
	    strncpy(name, match_name->startp[1], nlen);
	    name[nlen] = 0;
#ifdef DEBUG
	    printf("Got name '%s'\n", name);
#endif
	    fprintf(eventFP, "#define %s %d\n", name, num);
	    assoc_assign(defs, name, (void *) num);
	    num++;
	}
	else
	{
	    fprintf(stderr, "Syntax error at line %d\n", lineno);
	}
    }

    fprintf(eventFP, "/* End event definitions */\n");

    GetMatch(match_state, 1, currentState);

    while (fgets(buf, sizeof(buf), inputFP) != NULL)
    {
	lineno++;
	l = strlen(buf);
	buf[l - 1] = 0;
	l--;

	if (regexec(empty, buf))
	{
#ifdef DEBUG
	    printf("Skipping empty line\n");
#endif
	    continue;
	}
	else if (regexec(comment, buf))
	{
#ifdef DEBUG
	    printf("Skipping comment\n");
#endif
	    continue;
	}
	else if (regexec(match_state, buf))
	{
	    GetMatch(match_state, 1, currentState);
#ifdef DEBUG
	    printf("got new current state '%s'\n",currentState);
#endif
	}
	else if (regexec(match_start, buf))
	{
	    GetMatch(match_start, 1, string);
#ifdef DEBUG
	    printf("got start '%s'\n", string);
#endif
	    assoc_assign(state_start, currentState, strdup(string));
	}
	else if (regexec(match_end, buf))
	{
	    GetMatch(match_end, 1, string);
#ifdef DEBUG
	    printf("got end '%s'\n", string);
#endif
	    assoc_assign(state_end, currentState, strdup(string));
	}
	else if (regexec(match_color, buf))
	{
	    GetMatch(match_color, 1, string);
#ifdef DEBUG
	    printf("got color '%s'\n", string);
#endif
	    assoc_assign(state_color, currentState, strdup(string));
	}
	else
	{
	    fprintf(stderr, "Syntax error at line %d\n", lineno);
	}
    }

    num = 1;
    for (state = assoc_iter_init(state_start); state;
	 state = assoc_iter_next(state))
    {
	char *stateName, *start, *end, *color;
	int startNum, endNum;

	stateName = assoc_this_key(state);
	start = (char *) assoc_this_value(state);
	end = (char *) assoc_lookup(state_end, stateName);
	color = (char *) assoc_lookup(state_color, stateName);
#ifdef DEBUG
	printf("Got '%s' '%s' '%s' '%s'\n",
	       stateName, start, end, color);
#endif
	startNum = (int) assoc_lookup(defs, start);
	endNum = (int) assoc_lookup(defs, end);

	fprintf(stateFP, "%d %d %d %s %s\n",
		num++, startNum, endNum, color, stateName);
	
    }
}

FILE *openFile(s, m)
char *s, *m;
{
    FILE *fp;

    fp = fopen(s, m);
    if (fp == NULL)
    {
	fprintf(stderr, "Error opening file %s: %s\n",
		s, sys_errlist[errno]);
	exit(1);
    }
    return fp;
}

void initRegexps()
{
    empty = regcomp("^[ \t]*$");
    comment = regcomp("^[ \t]*#");

    match_name = regcomp("^[ \t]*([^ \t]+)[ \t]*$");

    match_state = regcomp("^[ \t]*state[ \t]+([^ \t]+)[ \t]*$");
    match_start= regcomp("^[ \t]*start[ \t]+([^ \t]+)[ \t]*$");
    match_end = regcomp("^[ \t]*end[ \t]+([^ \t]+)[ \t]*$");
    match_color = regcomp("^[ \t]*color[ \t]+([^ \t]+)[ \t]*$");
}
    
int errreport = 0;		/* Report errors via errseen? */
char *errseen = NULL;		/* Error message. */
    
void
regerror(s)
char *s;
{
	if (errreport)
		errseen = s;
	else
		error(s, "");
}

#ifndef ERRAVAIL
error(s1, s2)
char *s1;
char *s2;
{
	fprintf(stderr, "regexp: ");
	fprintf(stderr, s1, s2);
	fprintf(stderr, "\n");
	exit(1);
}
#endif

char *strdup(s)
char *s;
{
    char *rc;

    rc = (char *) malloc(strlen(s) + 1);
    strcpy(rc, s);
    return rc;
}
