#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /tmp_mnt/ufs/pcn/carl/PCN/IF/Xsw/RCS/pshalf.c,v 1.2 91/09/13 17:02:53 carl Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#include <stdio.h>
#include <X11/Xlib.h>
#include <ctype.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Simple.h>

#define BPL		 1	/* Bytes per scanline */
#define PAT_SIZE	 5
#define NUMGRAY	 	 64
#define MAXCOLOR	 ((unsigned long)65535)
#define MAXCOLORS	 256

static char grey_message[] = "Couldn't allocate gray";
static char color_message[] = "Couldn't allocate color";
static char file_message[] = "Can't access palette file:";

/*
 * Compare two strings ignoring case, comparing at most n characters.
 */
static
strnicmp (a, b, n)
    register char	*a;
    register char	*b;
    register int	 n;
{
    if (n <= 0)	{
	return (0);
    }
    while (*a && *b && n > 1)	{
	if ((isupper (*a) ? tolower (*a) : *a) !=
	    (isupper (*b) ? tolower (*b) : *b))	{
	    break;
	}
	a += 1;
	b += 1;
	n -= 1;
    }
    return (*a - *b);
}

int load_color_palette (dpy, screen, palette, colors)
    Display		*dpy;
    int			 screen;
    char		*palette;
     unsigned int       *colors;
{
  extern FILE		*fopen ();
  FILE		*fp;
  XColor		 gray;
  XColor		 viscolor;
  char		 buf[BUFSIZ];
  int			 num_gray;
  register char	*bp;
  register char	*ep;
  long	 gval;
  unsigned long	 gdist;
  unsigned long	 lval;
  int num_colors = 0;
  char * err_buf;
  
  if (DisplayPlanes (dpy, screen) > 1)	{
    if (!(strnicmp (palette, "greyscale", 9) &&
	  strnicmp (palette, "grayscale", 9)))	{
      if ((num_gray = atoi (&palette[9])) <= 0)	{
	num_gray = NUMGRAY;
      }
      if (num_gray > MAXCOLORS)	{
	num_gray = MAXCOLORS;
      }
      
      if (num_gray > 1)	{
	if (!(gdist = MAXCOLOR / (num_gray - 1)))	{
	  gdist = 1;
	}
	gray.flags = DoRed | DoGreen | DoBlue;
	lval = gval = MAXCOLOR;
	while (gval >= 0 && gval <= lval && num_colors < num_gray)    {
	  if (gval < gdist)	{
	    gval = 0;
	  }
	  gray.red = gray.green = gray.blue = (unsigned long)gval;
	  if (XAllocColor (dpy, DefaultColormap (dpy, screen),
			   &gray))	{
	    colors[num_colors++] = gray.pixel;
	  } else	{
	    err_buf = XtMalloc(strlen(grey_message)+ 12);
	    sprintf(err_buf, "%s-%l", grey_message, gval);
	    XtWarning(err_buf);
	    XtFree(err_buf);
	  }
	  lval = gval;
	  gval -= gdist;
	}
      }
    } else	{
      if (!(fp = fopen (palette, "r")))	{
	err_buf = XtMalloc(strlen(file_message)+strlen(palette)+8);
	sprintf(err_buf, "%s %s",file_message, palette);
	XtWarning(err_buf);
	XtFree(err_buf);
	return -1;
      }
      while (fgets (buf, sizeof (buf), fp))	{
	buf[sizeof (buf) - 1] = '\0';
	bp = buf;
	while (*bp == ' ' || *bp == '\t')	{
	  bp += 1;
	}
	ep = &buf[strlen (buf) - 1];
	while (ep >= bp && (*ep == '\n' || *ep == ' ' || *ep == '\t')){
	  *ep-- = '\0';
	}
	if (ep >= bp)	{
	  if (!XParseColor (dpy, DefaultColormap (dpy, screen),
			    bp, &viscolor))	{
	    fprintf (stderr, "Bad color: %s\n", bp);
	    continue;
	  }
	  
	  if (XAllocColor (dpy, DefaultColormap (dpy, screen),
			   &viscolor))	{
	    colors[num_colors++] = viscolor.pixel;
	  } else	{
	    err_buf = XtMalloc(strlen(color_message)+ strlen(bp));
	    sprintf(err_buf, "%s %s", color_message, bp);
	    XtWarning(err_buf);
	    XtFree(err_buf);
	  } 
	}
      }
      fclose(fp);
    }
  }
  return num_colors;
}


