#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/RCS/Utility.c,v 1.1 1992/04/17 18:26:54 mei Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#include "Xsw.h"
#include "XtPrivate.h"

Boolean XswStrCmp(s1, s2)
char *s1, *s2;
{
  Boolean result = True;
  char c1, c2;
  
  if (strlen(s1) == strlen(s2)) {
/* hui 4/16 change assignment from NULL */
    while (*s1 != '\0') {
      c1 = LOWER_CASE(*s1);
      c2 = LOWER_CASE(*s2);
      if (c1 != c2) {
	result = False;
	break;
      } else {
	s1++; s2++;
      }
    }
  } else {
    result = False;
  }
  return result;
 
}

Boolean
XswIsVisible(w)
Widget w;
{
  XWindowAttributes window_attributes;

  if (XtIsRealized(w)) {
    XGetWindowAttributes(XtDisplay(w), XtWindow(w), &window_attributes);
    
    return (window_attributes.map_state == IsViewable);
  } else {
    return False;
  }
}     

Widget
XswGetShell(w)
Widget w;
{
  if (XtIsWidget(w) && !XtIsShell(w)) {
    return XswGetShell(XtParent(w));
  } else {
    if (XtIsWidget(w)) return w;
    else return XswTopWidget();
  }
}

void
XswGrabPointer(w)
Widget w;
{
  int x, y;
  Dimension width, height;
  Arg args[10];
  int n;

  if (w != NULL) {
    if (XtIsRealized(w)) {
      n = 0;
      XtSetArg(args[n], XtNwidth, &width); n++;
      XtSetArg(args[n], XtNheight, &height); n++;
      XtGetValues(w, args, n);  
      
      x = width/2; y = height/2;
      
      XWarpPointer(XtDisplay(w), None, XtWindow(w), (int)0, (int)0, 
		   (unsigned int)0, (unsigned int)0, x, y);
    }
  }
}

Display *
XswGetDisplay(app_context)
struct _XtAppStruct * app_context;
{
  return app_context->list[0];
}


