#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/carl/PCN/IF/Xsw/RCS/QuerySet.c,v 1.3 1992/01/23 03:14:00 carl Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#define QUERYSET
#include <X11/IntrinsicP.h>
#include "Xsw.h"

#include <X11/Shell.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include "Query.h"
#include "Dir.h"
#include "QuerySetP.h"

#define NOT_IN_LIST -1
#define NONE -1

/******************************************************************
 *
 * Query Set Resources
 *
 ******************************************************************/

static XtResource resources[] = {
#define offset(field) XtOffset(QuerySet, querySet.field)
  { XtNfileTags, XtCFileTags, XtRStringList, sizeof(StringList),
      offset(file_tags), XtRString, "file"},
  { XtNnames, XtCNames, XtRSCPairList, sizeof(SCPairList),
      offset(names), XtRString, "Query Popup"},
  { XtNdirectory, XtCDirectory, XtRWidget, sizeof(Widget),
      offset(dir_w), XtRString, ""},
  { XtNhelp, XtCHelp, XtRWidget, sizeof(Widget),
      offset(help_w), XtRString, ""},
};

static void Initialize();

externaldef(querysetclassrec) QuerySetClassRec querySetClassRec = {
  {
    /* superclass	  */	(WidgetClass)&objectClassRec,
    /* class_name	  */	"QuerySet",
    /* widget_size	  */	sizeof(QuerySetRec),
    /* class_initialize   */    NULL,
    /* class_part_initialize*/	NULL,
    /* class_inited       */	FALSE,
    /* initialize	  */	Initialize,
    /* initialize_hook    */	NULL,		
    /* realize		  */	NULL,
    /* actions		  */	NULL,
    /* num_actions	  */	0,
    /* resources	  */	resources,
    /* num_resources	  */	XtNumber(resources),
    /* xrm_class	  */	NULLQUARK,
    /* compress_motion	  */	FALSE,
    /* compress_exposure  */	FALSE,
    /* compress_enterleave*/ 	FALSE,
    /* visible_interest	  */	FALSE,
    /* destroy		  */	NULL,
    /* resize		  */	NULL,
    /* expose		  */	NULL,
    /* set_values	  */	NULL,
    /* set_values_hook    */	NULL,			
    /* set_values_almost  */	NULL,  
    /* get_values_hook    */	NULL,			
    /* accept_focus	  */	NULL,
    /* version		  */	XtVersion,
    /* callback_offsets   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry	    */  NULL,
    /* display_accelerator  */	NULL,
    /* extension	    */  NULL
  }
};

externaldef(querySetClass)
WidgetClass querySetClass = (WidgetClass)&querySetClassRec;

static int NameToIndex(qs, name)
QuerySet qs;
String name;
{
  int i;

  i = 0;
  while (qs->querySet.names[i].string != NULL) {
    if (XswStrCmp(name, qs->querySet.names[i].string)) break;
    i++;
  }

  if (qs->querySet.names[i].string != NULL)
    return i;
  else
    return NOT_IN_LIST;
}
 
  

static void PopupQuery(w,qs,call)
Widget w;
QuerySet qs;
caddr_t call;
{
  String name;

  XtVaGetValues(w, XtNlabel, &name, NULL);
  
  XswQuerySetPopup(qs, name);

}

static void Done(w,qs,call)
     Widget w;
     QuerySet qs;
     caddr_t call;
{
  XswQueryReturnStruct * query_ret;

  if (qs->querySet.current != NONE) {
    query_ret = 
      XswQueryGetAll(qs->querySet.query_w[qs->querySet.current]);

    XswSCPairListCall(qs->querySet.names, 
		      qs->querySet.names[qs->querySet.current].string,
		      qs, query_ret);
  }
}

static void Cancel(w,qs,call)
     Widget w;
     QuerySet qs;
     caddr_t call;
{
  XswQuerySetPopdownCurrent(qs);
}

static void Clear(w,qs,call)
     Widget w;
     QuerySet qs;
     caddr_t call;
{
  if (qs->querySet.current != NONE)
    XswQueryClear(qs->querySet.query_w[qs->querySet.current]);
}

static void Help(w,qs,call)
     Widget w;
     QuerySet qs;
     caddr_t call;
{
  if (qs->querySet.help_w != NULL) {
    if (qs->querySet.current != NONE) {
      XswHelpShow(qs->querySet.help_w,
		  qs->querySet.names[qs->querySet.current].string,
		  XswGetShell(w), XswRight);
      XtAddGrab(qs->querySet.help_w, False, False);
    }
  }
}



/*
 * Start of query set methods
 */
static void 
  Initialize(request, new)
QuerySet request, new;
{
  int i, n;
  Widget popup, paned, box;
  
  new->querySet.current = NONE;
  new->querySet.tags = (StringList)XtMalloc(1*sizeof(String));
  new->querySet.tags[0] = NULL;
  new->querySet.strings = NULL;

  XswRegisterCallback("XswPopupQuery", PopupQuery, new);
  XswRegisterCallback("XswQueryDone", Done, new);
  XswRegisterCallback("XswQueryCancel", Cancel, new);
  XswRegisterCallback("XswQueryClear", Clear, new);
  XswRegisterCallback("XswQueryHelp", Help, new);

  n = 0;
  while (new->querySet.names[n].string != NULL) n++;

  new->querySet.query_w = (Widget *)XtMalloc(sizeof(Widget)*n);

  i = 0;
  while (new->querySet.names[i].string != NULL) {
    popup = 
      XtCreatePopupShell(new->querySet.names[i].string,
			 transientShellWidgetClass,
			 XswTopWidget(), NULL, 0);

    paned = 
      XtCreateManagedWidget("Query Shell", panedWidgetClass,
			    popup, NULL, 0);
    box =
      XtCreateManagedWidget("queryBox", boxWidgetClass,
			    paned, NULL, 0);
    XswMakeCommandButtons(box);

    new->querySet.query_w[i] =
      XtCreateManagedWidget("Query", queryWidgetClass,
			    paned, NULL, 0);
  
    i++;
  }

}

void XswQuerySetSaveValues(qs, ret_struct)
QuerySet qs;
XswQueryReturnStruct * ret_struct;
{
  int i, j, k;
  StringList temp, stemp;

  if (qs->querySet.current != NONE) {
    j = 0;
    while (ret_struct->flag[j] != NULL) {
      i = 0;
      while(qs->querySet.tags[i] != NULL) {
	if (XswStrCmp(qs->querySet.tags[i], ret_struct->flag[j]))
	  break;
	i++;
      }
      if (qs->querySet.tags[i] == NULL) {
	temp = (StringList)XtMalloc(sizeof(String)*(i+2));
	stemp = (StringList)XtMalloc(sizeof(String)*(i+2));
	for(k=0; k < i; k++) {
	  temp[k] = qs->querySet.tags[k];
	  stemp[k] = qs->querySet.strings[k];
	}
	temp[i] = XtNewString(ret_struct->flag[j]);
	temp[i+1] = NULL;
	stemp[i] = NULL;
	stemp[i+1] = NULL;
	XtFree((char *) qs->querySet.tags);
	qs->querySet.tags = temp;
	XtFree((char *) qs->querySet.strings);
	qs->querySet.strings = stemp;
      }
      XtFree((char *) qs->querySet.strings[i]);
      qs->querySet.strings[i] = XtNewString(ret_struct->entry[j]);
      j++;
    }
  }
}

void XswQuerySetPopdownCurrent(qs)
QuerySet qs;
{
  if (qs->querySet.current != NONE) {
    XtPopdown(XtParent(XtParent(qs->querySet.query_w[qs->querySet.current])));
    qs->querySet.current = NONE;
  }
}

Boolean XswQuerySetValue(qs, queryname, tag, value)
QuerySet qs;
String queryname;
String tag;
String value;
{
  int i;

  i = NameToIndex(qs, queryname);

  if (i != NOT_IN_LIST) {
      XswQuerySetEntry(qs->querySet.query_w[i],
		       tag, value);
      return True;
  } else {
    return False;
  }
}

void XswQuerySetPopup(qs, name)
QuerySet qs;
String name;
{
  int i, j;
  StringList lPtr;

  i = NameToIndex(qs, name);

  if (i != NOT_IN_LIST) {
    XswQuerySetPopdownCurrent(qs);
    qs->querySet.current = i;
    j = 0;
    while (qs->querySet.tags[j] != NULL) {
      XswQuerySetEntry(qs->querySet.query_w[i],
		       qs->querySet.tags[j], 
		       qs->querySet.strings[j]);
      j++;
    }
    if (qs->querySet.dir_w != NULL) {
      lPtr = XswDirGetEntriesAndClear(qs->querySet.dir_w);
      if (*lPtr != NULL) {
	j = 0;
	while (qs->querySet.file_tags[j] != NULL) {
	  XswQuerySetEntry(qs->querySet.query_w[i],
			   qs->querySet.file_tags[j], 
			   *lPtr);
	  j++;
	}
      }
    }
    XswPopup(XtParent(qs->querySet.query_w[i]), XtGrabNonexclusive,
	     XswTopWidget(), XswRight);
  }
}

