/*
 * $Header: /tmp_mnt/ufs/pcn/carl/PCN/IF/Xsw/RCS/QueryP.h,v 1.2 91/09/13 17:01:38 carl Exp $
 *
 * Private declarations for QueryWidgetClass
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#ifndef _QueryP_h
#define _QueryP_h

#include "Query.h"
#include <X11/Xaw/PanedP.h>

typedef struct {int empty;} QueryClassPart;

typedef struct _QueryClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    PanedClassPart	paned_class;
    QueryClassPart	query_class;
} QueryClassRec;

extern QueryClassRec queryClassRec;

typedef struct _QueryPart {
  /* resources */
  StringSet entries;
  DType directory;

  /* private */
  XswQueryReturnStruct ret_struct;
  Widget entry_w;
  Widget dir_w;
} QueryPart;


typedef struct _QueryRec {
    CorePart	core;
    CompositePart	composite;
    ConstraintPart	constraint;
    PanedPart		paned;
    QueryPart	query;
} QueryRec;


typedef struct {
    /* resources */
  int dummy;
} QueryConstraintsPart;

typedef struct _QueryConstraintsRec {
    PanedConstraintsPart	paned;
    QueryConstraintsPart	query;
} QueryConstraintsRec, *QueryConstraints;

#endif /* _QueryP_h */

