#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/RCS/Query.c,v 1.1 1992/04/17 18:26:25 mei Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

/* 
 * Query.c - Query composite widget
 * 
 */
#include <stdio.h>
#include <string.h>

#include <X11/IntrinsicP.h>
#include <X11/Xresource.h>
#include "Xsw.h"

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/AsciiSrc.h>
#include <X11/Xaw/Form.h>
#include "Dir.h"
#include "Entry.h"
#include "QueryP.h"

#define FIELDWIDTH 200

#define TAG 0
#define LBL 1
#define DFLT 2
#define EXT 3

/****************************************************************
 *
 * query Resources
 *
 ****************************************************************/

static XtResource resources[] = {
#define offset(field) XtOffset(QueryWidget, query.field)
  { XtNdirectory, XtCDirectory, XtRDType, sizeof(DType),
      offset(directory), XtRString, "None"},
  { XtNentries, XtCEntries, XtRStringSet, sizeof(StringSet),
      offset(entries), XtRImmediate, (XtPointer)NULL},
};

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

static void Initialize();
static void Destroy();
static void ClassPartInitialize();

QueryClassRec queryClassRec = {
  {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &panedClassRec,
    /* class_name         */    "query",
    /* widget_size        */    sizeof(QueryRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */	ClassPartInitialize,
    /* class_inited       */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */	NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions	  */	0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    Destroy,
    /* resize             */    XtInheritResize,
    /* expose             */    NULL,
    /* set_values         */    NULL,
    /* set_values_hook    */	NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */	NULL,
    /* accept_focus       */    NULL,
    /* version            */	XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	XtInheritQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension          */	NULL
  },{
/* composite_class fields */
    /* geometry_manager   */    XtInheritGeometryManager,
    /* change_managed     */    XtInheritChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension          */	NULL
  },{
/* constraint class fields */
    /* subresources       */    NULL,
    /* subresource_count  */    0,
    /* constraint_size    */    sizeof(QueryConstraintsRec),
    /* initialize         */    NULL,
    /* destroy            */    NULL,
    /* set_values         */    NULL,
    /* extension          */    NULL
  }
};

WidgetClass queryWidgetClass = (WidgetClass)&queryClassRec;
     
     
XswQueryReturnStruct *
  XswQueryGetAll(w)
QueryWidget w;
{ 
  char *exist;
  int i, num_entries;
  StringList list;
  
  list = XswEntryGetAll(w->query.entry_w);
  num_entries = XswCountStrings(list);
  
  XswFreeStringList(w->query.ret_struct.entry);
  XswFreeStringList(w->query.ret_struct.flag);
  w->query.ret_struct.entry = 
    (StringList)XtMalloc((num_entries+1)*sizeof(String));
  w->query.ret_struct.flag =
    (StringList)XtMalloc((num_entries+1)*sizeof(String));

  for (i=0; i < num_entries; i++) {
#ifdef DONT_INCLUDE
    /*
     * Steve Tuecke, 11/25/92		THIS IS A HACK FIX!
     * This look is apparently trying to determine if list[i]
     * has a proper extension, and if not then appending a proper
     * extension.
     * However, the following call to XswGetExtension() is missing
     * and argument as is causing it crash.  Since I cannot find
     * the proper argument to pass to it (a set of extensions),
     * I'm just commenting this test out so that it doesn't crash.
     */
    exist = XswGetExtension(list[i]);
#else
    exist = ".cnt";
#endif
    if(!strcmp(exist,"") && strcmp(list[i],"")) {
      w->query.ret_struct.entry[i] = 
	(String)XtMalloc(strlen(list[i])+
			 strlen(w->query.entries[EXT][i])+1);
      sprintf(w->query.ret_struct.entry[i], "%s%s",
	      list[i], w->query.entries[EXT][i]);
    } else {
      w->query.ret_struct.entry[i] = XtNewString(list[i]);
    }
    w->query.ret_struct.flag[i] = 
      XtNewString(w->query.entries[TAG][i]);
  }
  w->query.ret_struct.entry[i] = NULL;
  w->query.ret_struct.flag[i] = NULL;
  
  if (w->query.dir_w != NULL) {
    list = XswDirGetEntries(w->query.dir_w);
    num_entries = XswCountStrings(list);
    
    XswFreeStringList(w->query.ret_struct.file);
    w->query.ret_struct.file =
      (StringList)XtMalloc((num_entries+1)*sizeof(String));
    
    for (i=0; i < num_entries; i++) {
      w->query.ret_struct.file[i] = XtNewString(list[i]);
    }
    w->query.ret_struct.file[i] = NULL;
  }
  
  return &(w->query.ret_struct);
}

void
  XswQueryClear(w)
QueryWidget w;
{
  XswEntryClear(w->query.entry_w);

  if (w->query.dir_w != NULL) {
    (void)XswDirGetEntriesAndClear(w->query.dir_w);
  }
}


/* ARGSUSED */
Boolean CvtStringToDType(display, args, nargs,
			      fromVal, toVal, converter_data)
     Display* display;
     XrmValuePtr args, fromVal, toVal;
     int *nargs;
     XtPointer* converter_data;
{
  static int result;
 
  if (XswStrCmp((char *)fromVal->addr, "none"))
    result = NoList;
  else if (XswStrCmp((char *)fromVal->addr, "single"))
    result = Single;
  else if (XswStrCmp((char *)fromVal->addr, "multi"))
    result = Multi;
  else 
    XtStringConversionWarning((String) fromVal->addr, "DType");

  DONE(DType, result);
}

/* ARGSUSED */
static void
ClassPartInitialize(class)
WidgetClass class;
{
  XtSetTypeConverter(XtRString, XtRDType,
		     CvtStringToDType, NULL, 0,
		     XtCacheAll, NULL); 
}

static void
Destroy(w)
QueryWidget w;
{   
  XswFreeStringList(w->query.ret_struct.entry);
  XswFreeStringList(w->query.ret_struct.file);
}

/* ARGSUSED */
static void
Initialize(request, new)
QueryWidget request, new;
{
  Widget previous_w, vert_w;
  Cardinal arg_cnt;
  Arg args[20];
  int i;

  new->query.ret_struct.entry = NULL;
  new->query.ret_struct.flag = NULL;
  new->query.ret_struct.file = NULL;

  if (new->query.entries != NULL) {
    new->query.entries = XswInvert(new->query.entries);
    
    new->query.entry_w = 
      XtVaCreateManagedWidget("Entry", 
                   entryWidgetClass,
                   (Widget) new,
                   XtNlabels, new->query.entries[LBL],
                   XtNdefaults, new->query.entries[DFLT],
                   NULL);
  } else {
    new->query.entry_w = NULL;
  }

  if (new->query.directory != NoList) {
    new->query.dir_w = 
      XtVaCreateManagedWidget("Directory", 
            dirWidgetClass, 
            (Widget) new,
            XtNselectType, 
             (new->query.directory == Single) ? Single : Multi,
            NULL);
  } else {
    new->query.dir_w = NULL;
  }

}

/****************************************************
void 
XswQuerySetEntries(w, list)
QueryWidget w;
StringList list;
{
  XswEntrySetAll(w->query.entry_w, list);
}
******************************************************/

void 
XswQuerySetEntry(w, tag, value)
QueryWidget w;
String tag;
String value;
{
  if (w->query.entry_w != NULL) {
    int entry = 0;
    while (w->query.entries[TAG][entry] != NULL) {
      if (XswStrCmp(tag, w->query.entries[TAG][entry])) break;
      else entry++;
    }
    
    if (w->query.entries[TAG][entry] != NULL) 
      XswEntrySetOne(w->query.entry_w, entry, value);
  }
}

String
XswQueryGetEntry(w, tag)
QueryWidget w;
String tag;
{
  if (w->query.entry_w != NULL) {
    int entry = 0;
    while (w->query.entries[TAG][entry] != NULL) {
      if (XswStrCmp(tag, w->query.entries[TAG][entry])) break;
      else entry++;
    }
    
    if (w->query.entries[TAG][entry] != NULL) 
      return XswEntryGetOne(w->query.entry_w, entry);
    else return NULL;
  } else return NULL;
}

StringList
XswQueryGetEntries(w)
QueryWidget w;
{
  if (w->query.entry_w != NULL) {
    return XswEntryGetAll(w->query.entry_w);
  }
}


