/*
 * $XConsortium: MyListP.h,v 1.12 89/12/11 15:09:04 kit Exp $
 *
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Chris D. Peterson, MIT X Consortium
 */


/* 
 * MyListP.h - Private definitions for MyList widget
 * 
 * This is the MyList widget, it is useful to display a myList, without the
 * overhead of having a widget for each item in the myList.  It allows 
 * the user to select an item in a myList and notifies the application through
 * a callback function.
 *
 *	Created: 	8/13/88
 *	By:		Chris D. Peterson
 *                      MIT - Project Athena
 */

#ifndef _XawMyListP_h
#define _XawMyListP_h

/***********************************************************************
 *
 * MyList Widget Private Data
 *
 ***********************************************************************/

#include <X11/Xaw/SimpleP.h>
#include "MyList.h"

#define NO_HIGHLIGHT            XAW_MYLIST_NONE
#define OUT_OF_RANGE            -1
#define OKAY                     0

/* New fields for the MyList widget class record */

typedef struct {int foo;} MyListClassPart;

/* Full class record declaration */
typedef struct _MyListClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    MyListClassPart	myList_class;
} MyListClassRec;

extern MyListClassRec myListClassRec;

/* New fields for the MyList widget record */
typedef struct {
    /* resources */
    Pixel	foreground, highlight;
    Dimension	space;
    int         longest;
    int         max_chars;
    int         nitems;		/* number of items in the myList. */
    int         top_item;
    XFontStruct	*font;
    ListElement *    list;
    Boolean     vertical;
    Boolean     rotate;
    Boolean     zoom;
    Boolean     rigid_zoom;
    int         current_item;
    XtCallbackList  callback;

    /* private state */
    int save_top;
    Dimension save_space;
    int         tog_state;      /* state to switch on motion event */
    GC		normgc,		/* a couple o' GC's. */
                revgc,
                cleargc;		/* used when inactive. */

} MyListPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _MyListRec {
    CorePart	core;
    SimplePart	simple;
    MyListPart	myList;
} MyListRec;

#endif /* _XawMyListP_h */
