/*
 * $XConsortium: MultiListP.h,v 1.12 89/12/11 15:09:04 kit Exp $
 *
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Chris D. Peterson, MIT X Consortium
 */


/* 
 * MultiListP.h - Private definitions for MultiList widget
 * 
 * This is the MultiList widget, it is useful to display a multiList, without the
 * overhead of having a widget for each item in the multiList.  It allows 
 * the user to select an item in a multiList and notifies the application through
 * a callback function.
 *
 *	Created: 	8/13/88
 *	By:		Chris D. Peterson
 *                      MIT - Project Athena
 */

#ifndef _XswMultiListP_h
#define _XswMultiListP_h

/***********************************************************************
 *
 * MultiList Widget Private Data
 *
 ***********************************************************************/

#include <X11/Xaw/SimpleP.h>
#include "MultiList.h"

#define NO_HIGHLIGHT            XSW_LIST_NONE
#define OUT_OF_RANGE            -1
#define OKAY                     0

/* New fields for the MultiList widget class record */

typedef struct {int foo;} MultiListClassPart;

/* Full class record declaration */
typedef struct _MultiListClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    MultiListClassPart	multiList_class;
} MultiListClassRec;

extern MultiListClassRec multiListClassRec;

/* New fields for the MultiList widget record */
typedef struct {
    /* resources */
    Pixel	foreground;
    Dimension	internal_width,
        	internal_height,
                column_space,
                row_space;
    int         default_cols;
    Boolean     force_cols,
                paste,
                vertical_cols;
    Boolean     single;
    int         longest;
    int         nitems;		/* number of items in the multiList. */
    XFontStruct	*font;
    String *    list;
    XtCallbackList  callback;

    /* private state */
    Boolean *   state;
    Boolean toggle_state;

    int  is_highlighted, /* set to the item currently highlighted. */
         highlight,      /*set to the item that should be highlighted.*/
         col_width,	/* width of each column. */
         row_height,	/* height of each row. */
         nrows,		/* number of rows in the multiList. */
         ncols;		/* number of columns in the multiList. */
    GC		normgc,		/* a couple o' GC's. */
                revgc,
                graygc;		/* used when inactive. */

} MultiListPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _MultiListRec {
    CorePart	core;
    SimplePart	simple;
    MultiListPart	multiList;
} MultiListRec;

#endif /* _XswMultiListP_h */
