#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/RCS/Help.c,v 1.1 1992/04/17 18:25:10 mei Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

/* 
 * Help.c - Help shell widget
 * 
 */
#include <stdio.h>
#include <sys/param.h>

#include <X11/IntrinsicP.h>
#include <X11/Xresource.h>
#include "Xsw.h"

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Label.h>
#include "HelpP.h"


#define INDX 0
#define FNAME 1

/****************************************************************
 *
 * help Resources
 *
 ****************************************************************/

static XtResource resources[] = {
#define offset(field) XtOffset(HelpWidget, help.field)
  { XtNhelpSet, XtCHelpSet, XtRStringSet, sizeof(StringSet),
      offset(help_set), XtRString, "help:default.hlp"},
};

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

static void Initialize();
static void Destroy();

HelpClassRec helpClassRec = {
  {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &transientShellClassRec,
    /* class_name         */    "help",
    /* widget_size        */    sizeof(HelpRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */	NULL,
    /* class_inited       */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */	NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions	  */	0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    XtInheritResize,
    /* expose             */    NULL,
    /* set_values         */    NULL,
    /* set_values_hook    */	NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */	NULL,
    /* accept_focus       */    NULL,
    /* version            */	XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	XtInheritQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension          */	NULL
  },{
/* composite_class fields */
    /* geometry_manager   */    XtInheritGeometryManager,
    /* change_managed     */    XtInheritChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension          */	NULL
  }
};

WidgetClass helpWidgetClass = (WidgetClass)&helpClassRec;

static char *
GetFileName(w)
Widget w;
{
        static char *old;
        static Arg getargs[] = { {XtNstring, (XtArgVal) &old} };

        XtGetValues(w, getargs, (Cardinal) 1);
        return(old);
}

/* Function:    SetTextFile() sets the text file of the specified widget.
 * Arguments:   w:              Widget to set.
 *              filename:       Name of filename.
 * Returns:     Nothing.
 * Notes:
 * XXX The bookkeeping involved here is necessary because the Text widget
 * uses pointer comparison to detect if the string has actually changed.
 */

static void
SetTextFile(w, filename)
     Widget w;
char *filename;
{
  char *old;
  FILE *fp;

  old = GetFileName(w);

  /* Make a copy of the new name and modify the widget. */

  if ((fp = fopen(filename, "r")) != NULL) {
    fclose(fp);

    XtVaSetValues(w, XtNstring, XtNewString(filename), NULL);

    /* ...and free the old name, now that it's no longer used. */
   /* 4/24 hui, caused memory leak in R5    
     XtFree(old); */ 
  }
}


/* Function:    HelpClose() closes a help window.
 * Arguments:   Standard Xt callback arguments.
 * Returns:     Nothing.
 * Notes:
 */

/*ARGSUSED*/
static void
HelpClose(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
  XtPopdown((Widget)client_data);
}

     
static void
Destroy(w)
HelpWidget w;
{   
  ;
}

/* ARGSUSED */
static void
Initialize(request, neww)
HelpWidget request, neww;
{
  Widget close;
  Dimension height;
  Dimension gap;

  neww->help.pane_w =
    XtVaCreateManagedWidget("helpPane",
                          panedWidgetClass,
                          (Widget)neww,
			  NULL);
  neww->help.label_w =
    XtVaCreateManagedWidget("helpLabel", 
                          labelWidgetClass, 
			  neww->help.pane_w,
			  NULL);

  neww->help.text_w =
    XtVaCreateManagedWidget("helpText",
                          asciiTextWidgetClass, 
			  neww->help.pane_w,
                          XtNtype, XawAsciiFile,
                          XtNeditType, XawtextRead,
                          XtNstring, XtNewString("/dev/null"),
			  NULL);
  neww->help.box_w =
    XtVaCreateManagedWidget("helpBox",
                          boxWidgetClass,
			  neww->help.pane_w,
			  NULL);
  close = 
    XtVaCreateManagedWidget("close",
                          commandWidgetClass,
			  neww->help.box_w,
			  NULL);
  XtAddCallback(close, XtNcallback, HelpClose, (XtPointer)neww);
  XtAddCallback(close, XtNdestroyCallback, HelpClose, (XtPointer)neww);

  XtVaGetValues(close, XtNheight, &height, NULL);
  XtVaGetValues(neww->help.box_w, XtNvSpace, &gap, NULL);
  height += 2*gap;

  XtVaSetValues(neww->help.box_w, XtNmax, height, XtNmin, height, NULL);
}


Boolean 
XswHelpShow(w, name, origin_w, position)
HelpWidget w;
String name;
Widget origin_w;
PType position;
{
  static char message[] = "No help available for: ";
  static char no_file[] = "Can't find requested help file: ";
  String text;
  String file_name;
  Dimension label_height, box_height;
  int i;
  
  if ((w == NULL)) {
    XtWarning("Invalid help widget!");
    return False;
  }

  i = 0;
  while (w->help.help_set[i] != NULL) {
    if (XswStrCmp(name, w->help.help_set[i][INDX])) break;
    i++;
  }

  if (w->help.help_set[i] != NULL) {
    file_name = XswGetLibName(w->help.help_set[i][FNAME]);
    if (file_name[0] != '\0') {
      XtVaSetValues(w->help.label_w, XtNlabel, name, NULL);
      SetTextFile(w->help.text_w, file_name);
      if (!XswIsVisible((Widget) w)) {
        SetTextFile(w->help.text_w, file_name);
/* my try 
        XtPopup(XtParent(w->help.pane_w), XtGrabNone);
*/
	XswPopup(w->help.pane_w, XtGrabNone,
		 origin_w, position);
      }
      return True;
    } else {
      text = XtMalloc(strlen(no_file)+
		      strlen(w->help.help_set[i][FNAME])+2);
      sprintf(text, "%s%s", no_file, w->help.help_set[i][FNAME]);
      XtWarning(text);
      XtFree(text);
    }
  } else {
    text = XtMalloc(strlen(message)+strlen(name)+2);
    sprintf(text, "%s%s", message, name);
    XtWarning(text);
    XtFree(text);
  }
  return False;
}


