#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/RCS/Converters.c,v 1.1 1992/04/17 18:23:28 mei Exp $";
#endif

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#include <string.h>
#include <ctype.h>

#include "Xsw.h"

static String
  skip_space(string)
String string;
{
  if (string == NULL) return;

  while ((*string != 0) && (isspace(*string))) string++;

  return string;
}

static void
  clean_end(string)
String string;
{
  int len = strlen(string) - 1;

  while((len >= 0) && (isspace(string[len]))) len--;

  string[len+1] = 0;
}

/* ARGSUSED */
static Boolean
  CvtStringToStringList(display, args, nargs,
			fromVal, toVal, converter_data)
Display* display;
XrmValuePtr args, fromVal, toVal;
int *nargs;
XtPointer* converter_data;
{
  static StringList result;

  result = XswStringToStringList((char *)fromVal->addr, ",;");

  DONE(StringList, result);
}

/* ARGSUSED */
static Boolean
  CvtStringToWidget(display, args, nargs,
			fromVal, toVal, converter_data)
Display* display;
XrmValuePtr args, fromVal, toVal;
int *nargs;
XtPointer* converter_data;
{
  static Widget result;

  result = XtNameToWidget(XswTopWidget(), (char *)fromVal->addr);

  DONE(Widget, result);
}

/* ARGSUSED */
Boolean CvtStringToPixelList(display, args, nargs,
			      fromVal, toVal, converter_data)
     Display* display;
     XrmValuePtr args, fromVal, toVal;
     int *nargs;
     XtPointer* converter_data;
{
  static Pixel * result;
  StringList list;

  list = XswStringToStringList((String)fromVal->addr, " ,;:");

  MAKE_LIST(result, Pixel, XtRPixel, list, (Pixel)-1);

  DONE(Pixel *, result);
}

/* ARGSUSED */
Boolean CvtStringToSCPair(display, args, nargs,
			      fromVal, toVal, converter_data)
     Display* display;
     XrmValuePtr args, fromVal, toVal;
     int *nargs;
     XtPointer* converter_data;
{
  static SCPair result;
  StringList list;
  XrmValue from, to; 
  XtCacheRef cache_ref_return; 

  list = XswStringToStringList((String)fromVal->addr, ":");

  if (list[0] != NULL) {
    result.string = XtNewString(list[0]);
    if (list[1] != NULL) {
      from.addr = list[1];
      from.size = strlen(list[1]) + 1;
      to.addr = (XtPointer)&(result.callback);
      to.size = sizeof(XtCallbackRec *);
      XtConvertAndStore(XswTopWidget(),
			XtRString, &from, XtRCallback, &to);
    } else {
      result.callback = NULL;
    }
  } else {
    result.string = XtNewString("");
    result.callback = NULL;
    XtStringConversionWarning((char *)fromVal->addr, "SCPair");
  }
 
  XswFreeStringList(list);

  DONE(SCPair, result);
}

/* ARGSUSED */
Boolean CvtStringToSCPairList(display, args, nargs,
			      fromVal, toVal, converter_data)
     Display* display;
     XrmValuePtr args, fromVal, toVal;
     int *nargs;
     XtPointer* converter_data;
{
  static SCPair * result;
  StringList list;
  static SCPair end_it;

  end_it.string = NULL;
  end_it.callback = NULL;

  list = XswStringToStringList((String)fromVal->addr, ",;");

  MAKE_LIST(result, SCPair, XtRSCPair, list, end_it);

  DONE(SCPair *, result);
}

/* ARGSUSED */
Boolean CvtStringToStringSet(display, args, nargs,
			      fromVal, toVal, converter_data)
     Display* display;
     XrmValuePtr args, fromVal, toVal;
     int *nargs;
     XtPointer* converter_data;
{
  static StringSet result, temp;
  StringList list;
  int n, i;
  int j, k;
  int max = -1;

  list = XswStringToStringList((String)fromVal->addr, ",;");

  n = XswCountStrings(list);

  temp = (StringList *)XtMalloc((n+1)*sizeof(StringList *));
  for (i=0; i < n; i++) {
    temp[i] = XswStringToStringList(list[i], ":");
    if (XswCountStrings(temp[i]) > max)
      max = XswCountStrings(temp[i]); 
  }
  temp[i] = NULL;

  result = (StringList *)XtMalloc((n+1)*sizeof(StringList *));
  for (i=0; i < n; i++) {
    result[i] = (StringList)XtMalloc((max+1)*sizeof(String));
    k = 0;
    while (temp[i][k] != NULL) {
      result[i][k] = XtNewString(temp[i][k]);
      k++;
    }
    while (k < max) {
      result[i][k] = XtNewString("");
      k++;
    }
    XswFreeStringList(temp[i]);
    result[i][k] = NULL;
  }
  XtFree((char *) temp);
  result[i] = NULL;

  XswFreeStringList(list);

  DONE(StringSet, result);
}

StringSet
  XswInvert(set)
StringSet set;
{
  StringSet temp;
  int i, j;
  int w, h;
  
  if (set == NULL) return;

  h = XswCountStrings(set[0]);

  temp = (StringSet)XtMalloc((h+1)*sizeof(StringList));

  w = 0;
  while (set[w] != NULL) w++;

  for (i=0; i < h; i++) {
    temp[i] = (StringList)XtMalloc((w+1)*sizeof(String));
    for (j=0; j < w; j++) {
      temp[i][j] = set[j][i];
    }
    temp[i][j] = NULL;
  }
  temp[i] = NULL;

  return temp;
}
    

/* ARGSUSED */
static void CvtStringToFloat(args, nargs, fromVal, toVal)
     XrmValuePtr args, fromVal, toVal;
     int *nargs;
{
  static float result;

  if (sscanf((char *)fromVal->addr, "%f", &result) == 1) {
    toVal->size = sizeof(float);
    toVal->addr = (XPointer) &result;
  }
  else
    XtStringConversionWarning((char *) fromVal->addr, "Float");
}


void XswInitConverters(parent)
Widget parent;
{
  XtSetTypeConverter(XtRString, XtRStringList,
		     CvtStringToStringList, NULL, 0,
		     XtCacheAll, NULL); 

  XtSetTypeConverter(XtRString, XtRPixelList,
		     CvtStringToPixelList, NULL, 0,
		     XtCacheAll, NULL); 

  XtSetTypeConverter(XtRString, XtRSCPair,
		     CvtStringToSCPair, NULL, 0,
		     XtCacheAll, NULL); 

  XtSetTypeConverter(XtRString, XtRSCPairList,
		     CvtStringToSCPairList, NULL, 0,
		     XtCacheAll, NULL); 

  XtSetTypeConverter(XtRString, XtRStringSet,
		     CvtStringToStringSet, NULL, 0,
		     XtCacheAll, NULL); 

  XtSetTypeConverter(XtRString, XtRWidget,
		     CvtStringToWidget, NULL, 0,
		     XtCacheNone, NULL); 
}     


StringList
  XswStringToStringList(string, seperators)
String string;
char * seperators;
{
  static StringList result;
  String data, sPtr;
  int n, i;
  
  data = sPtr = (String)XtMalloc(sizeof(char) * (strlen(string) + 3));
  sprintf(data, " %s ", string);

  n = 0;
  while(strtok(sPtr, seperators) != NULL) {
    n++; 
    sPtr = NULL;
  }
  
  sprintf(data, " %s ", string);
  sPtr = strtok(data, seperators);
  result = (StringList)XtMalloc((n+1) * sizeof(String));
  for(i=0; i < n; i++) {
    sPtr = skip_space(sPtr);
    clean_end(sPtr);
    if (!strcmp(sPtr, XtNEMPTY))
      result[i] = XtNewString("");
    else
      result[i] = XtNewString(sPtr);
    sPtr = strtok(NULL, seperators);
  }
  result[i] = NULL;

  XtFree(data);
  return result;
}


