static char *rcsid = "$Header: /ufs/comp/carl/PCN/IF/Xpert/RCS/pcnbuttons.c,v 1.22 1992/01/23 03:05:13 carl Exp $";

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/
#include <stdio.h>
#include <sys/param.h>
#include <Xsw/Xsw.h>

#include <X11/Shell.h>
#include <Xsw/Query.h>
#include <Xsw/QuerySet.h>
#include <Xsw/Dir.h>

void PCNAckOk();
extern String PCNAck;
static char CmdBuffer[1024];

/* Number of nodes of allocated cosmic environment cube */

static int CubeAllocated = 0;

void GenericCallback(w, function, query_ret)
Widget w;
void (*function)();
XswQueryReturnStruct * query_ret;
{
  char * text_buffer;

  if ((query_ret->entry[0] != NULL) &&
      !XswStrCmp(query_ret->entry[0], "")) {
    text_buffer = XtNewString(query_ret->entry[0]);
    
    XswQuerySetSaveValues(w, query_ret);
    XswQuerySetPopdownCurrent(w);
    (*function)(w, XswTopWidget(), text_buffer);
    XtFree(text_buffer);
  } else {
    XtWarning("Must complete text field.");
  }
}

void EditIt(w, cw, text)
Widget w;
String text;
Widget cw;
{
  sprintf(CmdBuffer,"(EDIT \"%s\")\n",text);
  send_command(cw,CmdBuffer,True, NULL, NULL, NULL);
}

void CompileIt(w, cw, text)
Widget w;
String text;
Widget cw;
{
  sprintf(CmdBuffer,"(COMPILE \"%s\")\n",text);
  send_command(cw,CmdBuffer,True,
	       PCNAckOk,
	       "You must create a PCN window before compiling", NULL);
}

void RunIt(w, cw, text)
Widget w;
String text;
Widget cw;
{
  char *s;
  /* send string to emacs */
  sprintf(CmdBuffer,"(RUN \"");
  s = CmdBuffer + strlen(CmdBuffer);

  while (*text != '\0') {
    if (*text == '"') *s++ = '\\'; 
    *s++ = *text++;
  }
  sprintf(s,"\")\n");
  send_command(cw,CmdBuffer,True, 
	       PCNAckOk,
	       "You must create a PCN window before executing a PCN command", NULL);
}

void GaugeIt(w, cw, text)
Widget w;
String text;
Widget cw;
{
  Widget ppshow();

  XswWidgetTool("GaugeDisplay",ppshow(shell, text, 3),shell);
}

void ProfileCallback(w, client, query_ret)
Widget w;
XtPointer client;
XswQueryReturnStruct * query_ret;
{
  char * text_buffer;
  char * cPtr;
  int i, len;

  text_buffer = (char *)XtMalloc(1000*sizeof(char));

  for (i=0; i < 4; i++) {
    if ((query_ret->entry[i] == NULL) ||
	XswStrCmp(query_ret->entry[i], "")) break;
  }
  if (i == 4) {
    sprintf(text_buffer,"(PROFILE \"");
    
    len = strlen(text_buffer);
    i = 0;
    while (query_ret->entry[0][i] != '\0') {
      if (query_ret->entry[0][i] == '"') text_buffer[len++ + i] = '\\';
      text_buffer[len+i] = query_ret->entry[0][i];
      i++;
    }
    text_buffer[len+i] = '\0';
    
    sprintf(text_buffer, "%s\" \"%s\" (",text_buffer,
	    query_ret->entry[1]);
    
    i = 0;
    while(query_ret->file[i] != NULL){
      sprintf(text_buffer, "%s \"%s\"",text_buffer, query_ret->file[i]);
      i++;
    }
    
    if (i > 0) {
      sprintf(text_buffer,
	      "%s) \"%s\" \"%s\")\n", text_buffer,
	      query_ret->entry[2],query_ret->entry[3]);

      XswQuerySetSaveValues(w, query_ret);
      XswQuerySetPopdownCurrent(w);
      send_command(w,text_buffer,True, PCNAckOk,
		   "You must create a PCN window prior to profiling", NULL);
    } else {
      XtWarning("Must select a module or modules.");
    }
  } else {
    XtWarning("Must complete all text fields.");
  }
  XtFree(text_buffer);
}

String XswQueryReturnGetValue(query_ret,tag)
     XswQueryReturnStruct *query_ret;
     String tag;
{
  int i = 0;
  while (query_ret->flag[i] != NULL &&
	 ! XswStrCmp(tag,query_ret->flag[i]))
    i++;
  return query_ret->entry[i];
}


void PCNCallback(w, client, query_ret)
Widget w;
XtPointer client;
XswQueryReturnStruct * query_ret;
{
  int i;
  char nodearg[sizeof("-n XXXXXX")];
  char *remote_arg;
  char localhost[MAXHOSTNAMELEN];
  int nodes = atoi(XswQueryReturnGetValue(query_ret,"nodes"));
  char *host = XswQueryReturnGetValue(query_ret,"host");

  if (strcmp(XswQueryReturnGetValue(query_ret,"executable"),"")) {
    gethostname(localhost,MAXHOSTNAMELEN);
    nodes = (nodes == 0) ? 1 : nodes; 
    if (nodes > 1)
      sprintf(nodearg,"-n %d",nodes);
    else 
      nodearg[0] = '\0';
    if (!strcmp(host,""))
      host = localhost;
    if (XswStrCmp(host,localhost) == False)
      remote_arg = "t";
    else
      remote_arg = "nil";
    sprintf(CmdBuffer,"(PCN \"%s %s\" %d \"%s\" \"%s\" %s)\n",
	    XswQueryReturnGetValue(query_ret,"executable"), nodearg,
	    nodes, host,
	    XswQueryReturnGetValue(query_ret,"path"),
	    remote_arg);
    
    XswQuerySetSaveValues(w, query_ret);
    XswQuerySetPopdownCurrent(w);
    send_command(w,CmdBuffer,True, NULL, NULL, NULL);
  } else {
    XtWarning("Must specify an executable name.");
  }
}
  
#define START 0
#define PCN_KILLED 1
#define CUBE_FREED 2
#define ALLOCATE_CUBE 3
#define CUBE_ALLOCATED 4
#define START_PCN 5

void CosmicPCNCallback(w, state, query_ret)
Widget w;
int state;
XswQueryReturnStruct * query_ret;
{
  int i;
  int nodes = atoi(XswQueryReturnGetValue(query_ret,"nodes"));
  char argstring[25];

  XswQuerySetSaveValues(w, query_ret);
  XswQuerySetPopdownCurrent(w); 

  if (!strcmp(XswQueryReturnGetValue(query_ret,"executable"),"")) {
    XtWarning("Must specify PCN executable.");
    return;
  };

  while (1) 
    switch (state) {
    case START:
      send_command(w,"(KILLPCN)",False,
		   CosmicPCNCallback, PCN_KILLED, query_ret);
      break;
    case PCN_KILLED:
      if (CubeAllocated == nodes)
	state = START_PCN;
      else if (CubeAllocated)
	send_command(w,"(FREECUBE)",False,
		     CosmicPCNCallback, CUBE_FREED, query_ret);
      else
	state = ALLOCATE_CUBE;
      break;
    case CUBE_FREED:
      if (strcmp(PCNAck,"OK")) {
	XtWarning("Could not deallocate a cube.");
	XBell(XtDisplay(XswTopWidget()),0);
	return;
      } 
      CubeAllocated = 0;
      state = (nodes > 0) ? ALLOCATE_CUBE : START_PCN;
      break;
    case ALLOCATE_CUBE:
      if (strcmp(XswQueryReturnGetValue(query_ret,"host_type"),"")) {
	sprintf(CmdBuffer,"(ALLOCATECUBE %s %d %s)",
		XswQueryReturnGetValue(query_ret,"host_type"),
		nodes,
		XswQueryReturnGetValue(query_ret,"node_memory"));
	send_command(w,CmdBuffer,False,
		     CosmicPCNCallback, CUBE_ALLOCATED, query_ret);
      }
      break;
    case CUBE_ALLOCATED:
      if (strcmp(PCNAck,"OK")) {
	XtWarning("Could not allocate a cube.");
	XBell(XtDisplay(XswTopWidget()),0);
	return;
      }
      state = START_PCN;
      break;
    case START_PCN:
      if (nodes == 0)
	strcpy(argstring,"-uni");
      else 
	sprintf(argstring,"-nk %d",
		atoi(XswQueryReturnGetValue(query_ret,"node_heap")) / 4);
      sprintf(CmdBuffer,"(PCN \"%s %s \" %d \"%s\" \"%s\" nil)\n",
	      XswQueryReturnGetValue(query_ret,"executable"),  
	      argstring, nodes,
	      XswQueryReturnGetValue(query_ret,"host_type"),".");
      send_command(w,CmdBuffer,True,NULL,NULL,NULL);
      return;
    }
}

void ChangePCNDir(w, client_data, path)
     Widget w;
     XtPointer client_data;
     String path;
{
  chdir(path);
  sprintf(CmdBuffer,"(CD \"%s/\")",path);
  if (XtIsRealized(XswTopWidget()))
    send_command(w,CmdBuffer,False, NULL, NULL, NULL);

}

void QuitXpert(w,client,call)
     Widget w;
     XtPointer client;
     XtPointer call;
{ 
  void exit_from_editor();
  exit_from_editor(w,client,call);
}

/* ARGSUSED */
void 
QuitXpertAction(w, event, params, num_params)
     Widget w;
     XEvent *event;
     String *params;
     int num_params;
{
  QuitXpert(w,NULL,NULL); 
}

void HelpButton(w,help,call)
Widget w;
Widget help;
XtPointer call;
{ 
  XswHelpShow(help, "Xpcn", XswGetShell(w), XswRight);
}

void InitQuerySet(qs)
     Widget qs;
{
  char hostname[MAXHOSTNAMELEN];

}

void InitPCNbuttons(parent,directory,querys)
Widget parent;
Widget directory;
Widget querys;
{ 
  int i;

  InitQuerySet(querys);

  /* ??? make local - use Parent() */
  /* XswRegisterCallback("QuitButton",QuitButton,context); */

  /*register_user_callbacks(lPtr);*/
  XswMakeCommandButtons(parent);
}









