
#if (!defined(lint) && !defined(SABER)) 
static char *rcsid = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Model/RCS/model.c,v 1.11 1992/04/17 21:10:58 mei Exp $";
#endif

/*AERO_MESG*/

/********************************************************/
/* File : model.c                                       */
/* Content : contains routines that is call upon to     */
/*   distribute profile data to every procedures        */
/* Date : OLD routines  (updated for version 005)       */
/********************************************************/

#include <stdio.h>

#ifdef HISTOGRAM
#include <Xsw/Xsw.h>
#include <Gauge/Gauge.h>
#endif

#ifndef _MODEL_H
#include "model.h"
#endif

/********************************************************/
/* Name : assign_counter_values                         */
/* Content : used during reading in the profile filer,  */
/*   1) read in the values and distributed to different */
/*   procedure and clause's snapshot data structure     */
/*   according to the offset retrieved from part from   */
/*   .mod                                               */
/*   2) some partial accumulation of "total" counts is  */
/*   done as each set of counters is handled            */
/* Date : updated (12/91)                               */
/********************************************************/
/*ARGSUSED*/
char *assign_counter_values(proc_name,proc,args)
     char *proc_name;
     Procedure *proc;
     AssignArg *args;
{
  int node_no = args->node_no;
  int snap_no = args->snap_no;
  Histo *hPtr = args->hPtr;
  long *counters = (long *) args->buff;
  char *snapname = (char *) args->snapname;
  int last_uses;
  Clause *clauses;
  ProcedureProfileData *sPtr, /* ptr to a snapshot's profile data */
                       *tPtr; /* temporary ptr */
  Node *nPtr; /* temporary ptr */
  ClauseProfileData *cPtr, *clauPtr;
  int i;


   sPtr = insert_procsnapprof(proc,snap_no,node_no);

if (proc->type != FOREIGN_PROCEDURE) {

/* hui 12/30 find the position and allocate data space , always 
   need to do this because assign_timer_values will use it */
   clauPtr = insert_clausnapprof(proc,proc->size,snap_no,node_no);

/* Distribute counter values */

    sPtr->counts.copy = counters[proc->offsets.copy];

    sPtr->counts.suspend = 
      (proc->type == PCN_PARALLEL) ? 0 : counters[proc->offsets.suspend];
 
/** insert clause data to every clause segment **/
    for(i=0;i< proc->size;i++) {
      clauses=proc->clauses+i;
      cPtr=clauPtr+i;
      cPtr->counts.commit= counters[clauses->commit_offset];
    }/*for*/
        
/** Note that the index is from the last and the content 
    for last cPtr->counts.failure is sPtr's suspend and
    all later .failure is adding .failure of its next
    clause and its commits
**/
    last_uses =  sPtr->counts.suspend;
    for(i=proc->size-1;i>=0;i--) {
      clauses=proc->clauses+i;
      cPtr=clauPtr+i;
      cPtr->counts.failure = last_uses;
      last_uses = cPtr->counts.use = 
	cPtr->counts.failure+cPtr->counts.commit;

/** Note that sPtr's data are summation of clause's **/
      sPtr->counts.commit += cPtr->counts.commit;
      sPtr->counts.failure += cPtr->counts.failure;
      sPtr->counts.use += cPtr->counts.commit;
    }/*for*/

/* do the procedure's total profile accumulation */
    tPtr=proc->total+snap_no;
    tPtr->counts.use += sPtr->counts.use;
    tPtr->counts.commit += sPtr->counts.commit;
    tPtr->counts.failure += sPtr->counts.failure;
    tPtr->counts.suspend += sPtr->counts.suspend;
    if(strcmp(snapname,LASTSNAP)==0) {/* last snapshot */
      hPtr->info.reductions += 
              tPtr->counts.commit;
      hPtr->info.suspensions += 
              tPtr->counts.suspend;
    }/*if*/
    
/* do the node's total profile accumulation */
    nPtr=hPtr->nodes+node_no;
    tPtr=nPtr->total+snap_no;
    tPtr->counts.use += sPtr->counts.use;
    tPtr->counts.commit += sPtr->counts.commit;
    tPtr->counts.failure += sPtr->counts.failure;
  
}
args->snapPtr=sPtr;

return (char *) args;
}

/********************************************************/
/* Name : assign_timer_values                           */
/* Content : used during reading in the profile file,   */
/*  1) According to the type of procedure calls it is   */
/*    timer values is distributed among different       */
/*    procedure's data structure                        */
/*  2) partial accumulation of cost is done at the same */
/*    time                                              */
/* Date : updated (12/91)                               */
/********************************************************/
/*ARGSUSED*/
char *assign_timer_values(proc_name,proc,args)
     char *proc_name;
     Procedure *proc;
     AssignArg *args;
{
  int node_no = args->node_no;
  int snap_no = args->snap_no;
  Histo *hPtr = args->hPtr;
  double *timers = (double *) args->buff;
  char *snapname = (char *) args->snapname;
  ProcedureProfileData *sPtr,
                       *tPtr;

/* assuming the space is already allocated by 
   assign_counter_values procedure -- assuming 
   a fix order of counter file */

sPtr=lookup_procsnapprof(proc,snap_no,node_no);

if( sPtr == (ProcedureProfileData *) NULL) {
 sprintf(TextBuffer,
  "can not find procedure snap data block for node[%d] snap[%d]",
    node_no,snap_no);
  GaugeError("assign_timer_values",TextBuffer);
}/* if */

if (proc->type != FOREIGN_PROCEDURE) 
    sPtr->cost.idle = timers[proc->offsets.idle];
  else {
    RGraph *ctemp;
    Foreign *fPtr;
    Clause *cPtr;
    ClauseProfileData *clauPtr;
    Node *nPtr;

/**** serious problem here -- what if the caller clause
  did not get a snap shot at the same time ?? ****/

    for(ctemp = proc->callers; ctemp != (RGraph *) NULL ;
        ctemp = ctemp->next) {
      cPtr = ctemp->clause_ptr;

/* using the clause the caller is pt to */
      clauPtr=lookup_clausnapprof2(cPtr,snap_no,node_no);
      if( clauPtr == (ClauseProfileData *) NULL) {
         sprintf(TextBuffer,
           "can not find the procedure snap data block for node[%d] snap[%d]",
            node_no,snap_no);
         GaugeError("assign_timer_values",TextBuffer);
       }/* if */


      for(fPtr = cPtr->foreigns; fPtr->procedure != NULL;
          fPtr++) {
	if (fPtr->procedure == proc) {
	  sPtr->cost.success += timers[fPtr->timer];
	  sPtr->counts.commit +=
               clauPtr->counts.commit;
	  sPtr->counts.use += 
               clauPtr->counts.commit;
	}/*if*/
      }/*for*/
    }/*for*/

    sPtr->cost.total = sPtr->cost.success;
    sPtr->counts.use = sPtr->counts.commit;

/* accumulate the procedure's total profile */
    tPtr=proc->total+snap_no;
    tPtr->counts.use += sPtr->counts.commit;
    tPtr->counts.commit += sPtr->counts.commit;
    if(strcmp(snapname,LASTSNAP)==0) {/* last snapshot */
      hPtr->info.reductions += 
              tPtr->counts.commit;
      hPtr->info.suspensions += 
              tPtr->counts.suspend;
    } /* if */

/* accumulate for the node's total profile */
    nPtr=hPtr->nodes+node_no;
    tPtr=nPtr->total+snap_no;
    tPtr->counts.use += sPtr->counts.commit;
    tPtr->counts.commit += sPtr->counts.commit;

  }/*if-else*/
  return (char *) args;
}


