
#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Model/Gauge/RCS/Viewer.c,v 1.6 1992/04/17 18:17:49 mei Exp $";
#endif

/* AERO_MESG */
/********************************************************/
/* File: Viewer.c                                       */
/* Content: Viewer composite  Widget for displaying the */
/*  profile data                                        */
/*  It controls the color scale, the two scroll bars for*/
/*  the profile data's big bitmap and also the color    */
/*  coded bar scale and also the color bar range select */
/*  tool                                                */
/* Date: Old routines (Updated 3/1992)                  */
/********************************************************/
#include <stdio.h>
#include <math.h>
#include <string.h>

#include <X11/IntrinsicP.h>
#include <X11/Xresource.h>
#include <X11/Shell.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Scrollbar.h>

#include "Xsw/Xsw.h"
#include "Xsw/Chart.h"
#include "Xsw/MyList.h"
#include "Xsw/Scale.h"
#include "Xsw/MyList.h"
#include "ViewerP.h"
#include "Range.h"

#define DEFAULT_CHART_WIDTH     20      /* in cells */
#define DEFAULT_CHART_HEIGHT    20      /* in cells */

#define DEFAULT_CELL_SIZE       16      /* in pixels */
#define BIGVALUE           10000.0

#define ViewChange               2
#define NotViewChange            3

#define UP                       2
#define DOWN                     3

typedef int OType;
#define Horizontal               1
#define Vertical                 2
#define BUF_SIZE              1025

Boolean in_make_chart = False;
Boolean in_set_range= False;

/********************************************************/
/* Viewer Resources                                     */
/********************************************************/
static XtResource resources[] = {
#define offset(field) XtOffset(ViewerWidget, viewer.field)
  { XtNviewChange, XtCCallback, XtRCallback, sizeof(XtPointer),
      offset(view_change_callback), XtRCallback, NULL},
  { XtNcellWidth, XtCCellSize, XtRInt, sizeof(int),
      offset(cell_width), XtRImmediate, (XPointer)DEFAULT_CELL_SIZE },
  { XtNcellHeight, XtCCellSize, XtRInt, sizeof(int),
      offset(cell_height), XtRImmediate, (XPointer)DEFAULT_CELL_SIZE },
  { XtNwidthInCells, XtCNumberCells, XtRDimension, sizeof(Dimension),
      offset(width), XtRImmediate, (XPointer)DEFAULT_CHART_WIDTH },
  { XtNheightInCells, XtCNumberCells, XtRDimension, sizeof(Dimension),
      offset(height), XtRImmediate, (XPointer)DEFAULT_CHART_HEIGHT },
  { XtNhlist, XtCList, XtRPointer, sizeof(String *),
      offset(hlist), XtRImmediate, (XPointer)NULL },
  { XtNvlist, XtCList, XtRPointer, sizeof(String *),
      offset(vlist), XtRImmediate, (XPointer)NULL },
  { XtNzptr, XtCZptr, XtRInt, sizeof(int),
      offset(zptr), XtRImmediate, 0 },
  { XtNlog, XtCLog, XtRBoolean, sizeof(Boolean),
      offset(log), XtRString, "False" },
  { XtNzoom, XtCZoom, XtRBoolean, sizeof(Boolean),
      offset(zoom), XtRString, "False" },
  { XtNbucket, XtCBucket, XtRBoolean, sizeof(Boolean),
      offset(bucket), XtRString, "False" },
  { XtNgetValueFunction, XtCGetValueFunction, XtRPointer, sizeof(void *),
      offset(get_value), XtRString, NULL },
  { XtNradioView, XtCRadioView, XtRWidget, sizeof(Widget),
      offset(radio_view), XtRImmediate, NULL},
  { XtNrootType, XtCType, XtRVTypeList, sizeof(VTypeList),
      offset(root_type), XtRString, "ThreeD"},
  { XtNshowType, XtCType, XtRVType, sizeof(VType),
      offset(show_type), XtRString, "ThreeD"},
  { XtNdata, XtCData, XtRStringList, sizeof(StringList),
      offset(data), XtRString, "Time"},
  { XtNtitle, XtCTitle, XtRString, sizeof(String),
      offset(title), XtRString, ""},
  { XtNtext, XtCText, XtRString, sizeof(String),
      offset(text), XtRString, ""},
};

/********************************************************/
/* Full class record constant                           */
/********************************************************/
static void make_bars(), make_buckets();
static void set_range( /* RangeWidget rw, 
             XtPointer client_data, call_data */); 
static void recalc_cell();
static void AdjustChart();
static void ScaleState(/* ViewerWidget w, int state */);
static void popUpRbar(/* ViewerWidget w */);
static void popDownRbar(/* RangeWidget rw,
             XtPointer client_data, call_data */);
static void clear_set_range(/* RangeWidget rw, 
             XtPointer client_data, call_data */);

static void Initialize();
static void Destroy();
static void ClassPartInitialize();
static Boolean SetValues();

ViewerClassRec viewerClassRec = {
  {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &formClassRec,
    /* class_name         */    "viewer",
    /* widget_size        */    sizeof(ViewerRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */	ClassPartInitialize,
    /* class_inited       */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */	NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions	  */	0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    Destroy,
    /* resize             */    XtInheritResize,
    /* expose             */    NULL,
    /* set_values         */    SetValues,
    /* set_values_hook    */	NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */	NULL,
    /* accept_focus       */    NULL,
    /* version            */	XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	XtInheritQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension          */	NULL
  },{
/* composite_class fields */
    /* geometry_manager   */    XtInheritGeometryManager,
    /* change_managed     */    XtInheritChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,
    /* delete_child	  */	XtInheritDeleteChild,
    /* extension          */	NULL
  },{
/* constraint class fields */
    /* subresources       */    NULL,
    /* subresource_count  */    0,
    /* constraint_size    */    sizeof(ViewerConstraintsRec),
    /* initialize         */    NULL,
    /* destroy            */    NULL,
    /* set_values         */    NULL,
    /* extension          */    NULL
  },
  { /* form_class fields */
    /* layout             */   XtInheritLayout
  }
};


WidgetClass viewerWidgetClass = (WidgetClass)&viewerClassRec;

/********************************************************/
/********************************************************/
static Boolean
NoSelections(list, length)
ListElement * list;
int length;
{
  int i;

  for(i = 0; i < length; i++) {
    if (list[i].state) return False;
  }

  return True;
}
  
double col_value(w, list, i)
ViewerWidget w;
ListElement *list;
{
  double value = 0.0;
  Boolean none_selected;
  int cnt;

  if (w->viewer.root_type[i] != ThreeD) {
    value = 
      (*w->viewer.get_value)(w->viewer.vlist[0].pointer,
			     list->pointer,
			     w->viewer.data[i],
                             w->viewer.zptr);
  } else {
    none_selected = NoSelections(w->viewer.vlist, w->viewer.height);
    for(cnt=0; cnt < w->viewer.height; cnt++) {
      if ((w->viewer.vlist[cnt].state) || (none_selected))
	value +=
	  (*w->viewer.get_value)(w->viewer.vlist[cnt].pointer,
				 list->pointer,
				 w->viewer.data[i],
                                 w->viewer.zptr);
    }
  }
  return value;
}

double row_value(w, list, i)
ViewerWidget w;
ListElement *list;
{
  double value = 0.0;
  Boolean none_selected;
  int cnt;

  if (w->viewer.root_type[i] != ThreeD) {
    value = 
      (*w->viewer.get_value)(list->pointer,
			     w->viewer.hlist[0].pointer,
			     w->viewer.data[i], 
                             w->viewer.zptr);
  } else {
    none_selected = NoSelections(w->viewer.hlist, w->viewer.width);
    for(cnt=0; cnt < w->viewer.width; cnt++) {
      if ((w->viewer.hlist[cnt].state) || (none_selected))
	value +=
	  (*w->viewer.get_value)(list->pointer,
				 w->viewer.hlist[cnt].pointer,
				 w->viewer.data[i], 
                                 w->viewer.zptr);
    }
  }
  return value;
}

/* ARGSUSED */
static void
resize_colors(w, view, dummy)
Widget w;
ViewerWidget view;
int dummy;
{
  int thickness;
  int i;
  Arg arg[10];
  Dimension height; 
  double maximum, minimum;
  
  XtRemoveAllCallbacks(view->viewer.color_code.colors,XtNchartResize);
  XtVaGetValues(view->viewer.color_code.scale,
           XtNmaximum, &maximum, XtNminimum, &minimum, NULL);

  height = XswScaleGetCoord(view->viewer.color_code.scale, maximum);
  XtVaGetValues(view->viewer.color_code.box, 
                   XtNdefaultDistance, &thickness, NULL);
  height -= thickness;

  if (height <= 0) height = 1;
  XtVaSetValues(view->viewer.color_code.dummy,
                   XtNheight, height, NULL);
  height = XswScaleGetCoord(view->viewer.color_code.scale, minimum) -
    XswScaleGetCoord(view->viewer.color_code.scale, maximum);  

  if (height <= 0) height = 1;

  XtVaSetValues(view->viewer.color_code.colors, 
                   XtNheight, height, NULL);

  XtAddCallback(view->viewer.color_code.colors,
		XtNchartResize, resize_colors, view);

}

/********************************************************/
/* Name: make_color_code                                */
/* Content: initialize the color bar's widget set and   */
/*  also the Range Select's popup shell and widget      */
/* Date: OLD ROUTINE (updated 3/1992 hui)               */
/********************************************************/
static void
make_color_code(w)
ViewerWidget w;
{
  int          styles, thickness;
  Boolean      *state;
  double       *cells;
  int          i;
  Arg          arg[20];
  Dimension    height;
  String       palette;
/*
  Cardinal     n;
*/
  int          n;
  Dimension    width;
  

  w->viewer.color_code.up = False;

  XtVaGetValues(w->viewer.chart_w,
                  XtNheight, &height,
                  XtNpalette, &palette, NULL);
  
  w->viewer.color_code.scale = XtVaCreateManagedWidget(
                      "colorScale", 
                      scaleWidgetClass,
                      w->viewer.color_code.box,
                      XtNlog, w->viewer.log,
                      XtNpalette, palette,
                      XtNheight, height,
                      XtNvertical, True,
                      XtNbottom, XtChainBottom,
                      XtNtop, XtChainTop,
                      XtNleft, XtChainLeft,
                      XtNright, XtChainLeft,
                      NULL);
  n = 0;
  SETDOUBLEARG(arg[n], XtNmaximum, w->viewer.maximum); n++;
  SETDOUBLEARG(arg[n], XtNminimum, w->viewer.minimum); n++;
  XtSetValues(w->viewer.color_code.scale,arg,n);
  
  styles = XswChartNumValues(w->viewer.chart_w);

  state = (Boolean *)XtCalloc(styles, sizeof(Boolean));
  cells = (double *)XtCalloc(styles, sizeof(double));

  for(i=0; i < styles; i++) {
    cells[i] = (double)(styles - i - 1)/(double)styles;
  }

  height = XswScaleGetCoord(w->viewer.color_code.scale,
			   w->viewer.maximum);
  XtVaGetValues(w->viewer.color_code.box, 
                XtNdefaultDistance, &thickness,
                NULL);
  height -= thickness;

  w->viewer.color_code.dummy = XtVaCreateManagedWidget(
                   "dummy",
                    boxWidgetClass,
                    w->viewer.color_code.box,
                    XtNheight, height,
                    XtNfromHoriz, w->viewer.color_code.scale,
                    XtNbottom, XtChainTop,
                    XtNtop, XtChainTop,
                    XtNleft, XtChainLeft,
                    XtNright, XtChainRight,
                    XtNborderWidth, (Dimension)0,
                    NULL);
  height =
    XswScaleGetCoord(w->viewer.color_code.scale,w->viewer.minimum) -
       XswScaleGetCoord(w->viewer.color_code.scale, w->viewer.maximum);

  w->viewer.color_code.cell = cells;
  w->viewer.color_code.state = state;

  w->viewer.color_code.colors = XtVaCreateManagedWidget(
                 "chart",
                 chartWidgetClass,
                 w->viewer.color_code.box,
                 XtNheight, height,
                 XtNstateArray, state,
                 XtNcellArray, cells,
                 XtNzoom, True,
                 XtNrigidZoom, False,
                 XtNborderWidth, 1,
                 XtNlog, False,
                 XtNtwoD, False,
                 XtNspacing, 0,
                 XtNwidthInCells, 1,
                 XtNheightInCells, styles,
                 XtNfromHoriz, w->viewer.color_code.scale,
                 XtNfromVert, w->viewer.color_code.dummy,
                 XtNbottom, XtChainBottom,
                 XtNtop, XtChainTop,
                 XtNleft, XtChainLeft,
                 XtNright, XtChainRight,
                 NULL);

  XtUninstallTranslations(w->viewer.color_code.colors);

  XtAddCallback(w->viewer.color_code.colors,
		XtNchartResize, resize_colors, w);
  XtAddCallback(w->viewer.color_code.colors,
		XtNdestroyCallback, XswFreeMemCallback, state);
  XtAddCallback(w->viewer.color_code.colors,
		XtNdestroyCallback, XswFreeMemCallback, cells);

/* hui 3/5/92 */
  XtVaGetValues(w->viewer.color_code.colors,XtNwidth,&width,NULL);
  w->viewer.color_code.popbar=XtVaCreatePopupShell(
                "RangeSelect",
                transientShellWidgetClass,
                w->viewer.color_code.box,
                NULL);
 
  w->viewer.color_code.rbar=XtVaCreateManagedWidget(
                "rangebar",
                 rangeWidgetClass,
                 w->viewer.color_code.popbar,
                 XtNpalette, palette,
                 XtNcellArray,cells,
                 XtNstateArray,state,
                 XtNfromHoriz, w->viewer.color_code.colors,
                 XtNvertDistance,0,
                 XtNvSpace,0,
                 XtNwidth,width,
                 XtNbarBlocks,styles,
                 XtNisLog, w->viewer.log,
                 NULL);
  XtAddCallback(w->viewer.color_code.rbar,XtNsetRange,set_range,(XtPointer)w);
  XtAddCallback(w->viewer.color_code.rbar,
                       XtNclearSetRange, clear_set_range, (XtPointer)w);
  XtAddCallback(w->viewer.color_code.rbar,
                        XtNresetRange, XswRangeReset,
                        (XtPointer) w->viewer.color_code.rbar);

  XtAddCallback(w->viewer.color_code.rbar,
                        XtNpopDownRange, popDownRbar,(XtPointer)w);
 
}


static void
switch_view(w)
ViewerWidget w;
{
  Dimension old_width, new_width;
  int old_long, new_long;
  XtVarArgsList varglist;
  
  varglist = XtVaCreateArgsList(NULL,
				XtNnumberStrings, 0,
				XtNlongest, 0, NULL);

  XtVaGetValues(w->viewer.vlist_w, XtNwidth, &old_width, 
                                   XtNlongest, &old_long,NULL);

  
  switch (w->viewer.show_type) {
  case ByNodes:
    XtVaSetValues(w->viewer.vlist_w, XtNlist, w->viewer.hlist,
		  XtVaNestedList, varglist, NULL);
    XtVaSetValues(w->viewer.chart_w, XtNwidthInCells, 
		  (Dimension)w->viewer.n_views,
		  XtNheightInCells, w->viewer.width, NULL);
    break;
  case ByProcedures:
    XtVaSetValues(w->viewer.vlist_w, XtNlist, w->viewer.vlist,
		  XtVaNestedList, varglist, NULL);
    XtVaSetValues(w->viewer.chart_w, XtNwidthInCells, 
		  (Dimension)w->viewer.n_views,
		  XtNheightInCells, w->viewer.height, NULL);
    break;
  default:
    XtVaSetValues(w->viewer.hlist_w, XtNlist, w->viewer.hlist,
		  XtVaNestedList, varglist, NULL);
    XtVaSetValues(w->viewer.vlist_w, XtNlist, w->viewer.vlist,
		  XtVaNestedList, varglist, NULL);
    XtVaSetValues(w->viewer.chart_w, XtNwidthInCells, w->viewer.width,
		  XtNheightInCells, w->viewer.height, NULL);
    break;
  }

  XtVaGetValues(w->viewer.vlist_w, XtNwidth, &new_width, 
                                   XtNlongest, &new_long,NULL);

  /* 4/13 hui for R5 form Widget's changes */
  if( new_long > old_width) {	
     AdjustChart(w, new_long-old_width, 0,0,0);
     XtVaSetValues(w->viewer.vlist_w,
                  XtNwidth,(Dimension) new_long, NULL);
     } else {
         XtVaSetValues(w->viewer.vlist_w,
                  XtNwidth,(Dimension) new_long, NULL);
         AdjustChart(w, new_long-old_width, 0,0,0);
  }

  XtFree(varglist);
  
}

static void
FreeBuckets(bucket)
Bucket * bucket;
{
  if (bucket != NULL) {
    FreeBuckets(bucket->next);
    XtFree((char *) bucket);
  }
}

/*ARGSUSED*/
static void
make_buckets (w, nPtr, maxPtr, minPtr, type)
ViewerWidget w;
int *nPtr;
double *maxPtr, *minPtr;
int type;
{
  double min, max;
  double interval;
  Dimension height, old_width, new_width, width;
  int i, n, cnt;
  double percent;
  double maximum;
  double minimum;
  int number;
  double * tmp_cell;
  char label[50];
  Bucket * pointer;
  Boolean save_log;
  int new_long;

  save_log = w->viewer.log;
  w->viewer.log = False;
  make_bars(w, &number, &maximum, &minimum, NotViewChange);
  w->viewer.log = save_log;

  *maxPtr = 0.0;
  *minPtr = BIGVALUE;
  
  width = ((w->viewer.show_type == Bucket3D) ? 1 : w->viewer.n_views);
  
  if (maximum == minimum)	{
    min = max = minimum;
    interval = 1.0;
    *nPtr = 1;
  } else	{
    XtVaGetValues(w->viewer.chart_w, XtNheight, &height, NULL);
    n = height/w->viewer.cell_height;
    do	{
      linear_scale (minimum, maximum,
		    n, &min, &max, &interval);
      n -= 1;
    } while ((((max - min) / interval) + 1 >
	     height/w->viewer.cell_height) &&
	     (n > 0));
    if (n == 0) 
      XtWarning("Problem in make_buckets n = 0.");
    *nPtr =((max - min) / interval) + 
      (max > maximum ? 0 : 1);
  }
  if (w->viewer.blist != NULL) {
    for(i=0; i < w->viewer.n_buckets; i++) {
      FreeBuckets(w->viewer.blist[i].pointer);
    }
    XtFree((char *) w->viewer.blist);
  }
  w->viewer.n_buckets = *nPtr;
  w->viewer.blist = 
    (ListElement *)XtCalloc(*nPtr + 2, sizeof(ListElement));
  *nPtr *= width;
  tmp_cell = (double *)XtCalloc(*nPtr + 2, sizeof(double));
  
  i = 0;
  for (; min <= max; min += interval)	{
    if ((min > max-interval) && (max > maximum))	{
      break;
    }
    w->viewer.blist[i].pointer = (void *)XtMalloc(sizeof(Bucket));
    pointer = (Bucket *)w->viewer.blist[i].pointer;
    percent = 0.0;
    for(cnt = 0; cnt < number; cnt++) {
      if ((w->viewer.masterval[cnt] >= min) &&
	  (w->viewer.masterval[cnt] < min+interval)) {
	tmp_cell[(i*width)+(cnt%width)]++;
	percent++;
	pointer->next = (Bucket *)XtMalloc(sizeof(Bucket));
	pointer = pointer->next;
	switch(w->viewer.show_type) {
	case ByProcedures:
	  pointer->vPtr = w->viewer.vlist[cnt].pointer;
	  break;
	case ByNodes:
	  pointer->hPtr = w->viewer.hlist[cnt].pointer;
	  break;
	case Bucket3D:
	  pointer->vPtr = w->viewer.vlist[cnt / w->viewer.width].pointer;
	  pointer->hPtr = w->viewer.hlist[cnt % w->viewer.width].pointer;
	  break;
	default:
	  XtWarning("Invalid type in call to make_buckets.");
	  break;
	}
      }
    }
    pointer->next = NULL;
    if (percent > *maxPtr) *maxPtr = percent;
    if (percent < *minPtr) *minPtr = percent;
    
    (void)sprintf (label, "%g-%g", min, min+interval);
    w->viewer.blist[i].label = XtNewString(label);
    w->viewer.blist[i].state = False;
    
    i++;
  }
  *minPtr = 0;
  w->viewer.blist[i].label = NULL;
  for(cnt = 0; cnt < *nPtr; cnt++) {
    w->viewer.masterval[cnt] = tmp_cell[cnt];
    w->viewer.state[cnt] = w->viewer.blist[cnt/width].state;
  }
  XtFree((char *) tmp_cell);
  
  if (w->viewer.vlist_w != NULL) {
    XtVaGetValues(w->viewer.vlist_w, XtNwidth, &old_width, NULL);

    XtVaSetValues(w->viewer.vlist_w, XtNlist, w->viewer.blist,
		  XtNlongest, 0, XtNnumberStrings, 0, NULL);

    XtVaGetValues(w->viewer.vlist_w, 
                          XtNlongest, &new_long,
                          XtNwidth, &new_width, NULL);

    /* hui 4/14 for R5's new formWidget changes */
    if(new_long > old_width) {
        AdjustChart(w, new_long-old_width, 0,0,0);
        if( new_long != new_width)
           XtVaSetValues(w->viewer.vlist_w, 
                              XtNwidth, new_long, NULL);
        } else {
           if( new_long != new_width)
              XtVaSetValues(w->viewer.vlist_w,
                                 XtNwidth, new_long, NULL);
           AdjustChart(w, new_long-old_width, 0,0,0);
    }
  }
  if (w->viewer.chart_w != NULL) {
    XtVaSetValues(w->viewer.chart_w, XtNwidthInCells, width,
		  XtNheightInCells, w->viewer.n_buckets, NULL);
  }
}

static void
make_bars(w, nPtr, maxPtr, minPtr, type)
ViewerWidget w;
int *nPtr;
double *maxPtr, *minPtr;
int type;
{
  double percent;
  double sum = 0;
  int vcnt, hcnt, cnt, i, c_max;
  int width, height;
  Boolean none_selected;

  *maxPtr = 0.0;
  *minPtr = BIGVALUE;

/*  if (type == ViewChange) */
  
  switch_view(w);

  i = 0;
  while(w->viewer.data[i] != NULL) i++;

  switch (w->viewer.show_type) {
  case ByNodes:
    height = w->viewer.width; width = i;
    break;
  case ByProcedures:
    height = w->viewer.height; width = i;
    break;
  default:
    height = w->viewer.height; width = w->viewer.width;
    break;
  }

  for(vcnt=0; vcnt < height; vcnt++) {
    for(hcnt=0; hcnt < width; hcnt++) {
      switch (w->viewer.show_type) {
      case ByNodes:
	percent = 0.0;
	if (w->viewer.root_type[hcnt] == ByNodes) {
	  c_max = 1; none_selected = True;
	} else {
	  c_max = w->viewer.height;
	  none_selected = 
	    NoSelections(w->viewer.vlist, w->viewer.height);
	}
	for(cnt=0; cnt < c_max; cnt++) {
	  if ((w->viewer.vlist[cnt].state) || (none_selected))
	    percent += 
	      (*w->viewer.get_value)(w->viewer.vlist[cnt].pointer,
				     w->viewer.hlist[vcnt].pointer,
				     w->viewer.data[hcnt],
                                     w->viewer.zptr);
	}
	if (type == ViewChange)
	  w->viewer.state[hcnt + vcnt*(width)] = 
	    w->viewer.hlist[hcnt].state;      
	break;
      case ByProcedures:
	percent = 0.0;
	if (w->viewer.root_type[hcnt] == ByProcedures) {
	  c_max = 1; none_selected = True;
	} else {
	  c_max = w->viewer.width;
	  none_selected = 
	    NoSelections(w->viewer.hlist, w->viewer.width);
	}
	for(cnt=0; cnt < c_max; cnt++) {
	  if ((w->viewer.hlist[cnt].state) || (none_selected))
	    percent +=
	      (*w->viewer.get_value)(w->viewer.vlist[vcnt].pointer,
				     w->viewer.hlist[cnt].pointer,
				     w->viewer.data[hcnt],
                                     w->viewer.zptr);
	}
	if (type == ViewChange)
	  w->viewer.state[hcnt + vcnt*(width)] = 
	    w->viewer.vlist[vcnt].state;     
	break;
      default:
	percent =
	  (*w->viewer.get_value)(w->viewer.vlist[vcnt].pointer,
				 w->viewer.hlist[hcnt].pointer,
				 w->viewer.data[0],
                                 w->viewer.zptr); 
	if (type == ViewChange)
	  w->viewer.state[hcnt + vcnt*(width)] = 
	    (w->viewer.vlist[vcnt].state || 
	     w->viewer.hlist[hcnt].state);
	break;
      }
      w->viewer.masterval[hcnt+vcnt*(width)] = percent;
    
/* there is a distinguish between log or linear values */
/* in linear, min can be 0.0 but in log min=smallest val */
/* next to 0.0 */
      if (w->viewer.show_type == ThreeD) {
	if (percent > *maxPtr) *maxPtr = percent;
        if (w->viewer.log) {
          if ((percent < *minPtr) && (percent > 0))
            *minPtr = percent;
          } else {
            if (percent < *minPtr) *minPtr = percent;
        }/*if log */
        } else {
           sum += percent;
      } /* if ThreeD */

    }/* for (hcnt) loop */
    if (w->viewer.show_type != ThreeD) {
      if (sum > *maxPtr) *maxPtr = sum;
      if (w->viewer.log) {
        if ((sum < *minPtr) && (sum > 0))
          *minPtr = sum;
        } else if (sum < *minPtr) *minPtr = sum;

      sum = 0;
     }/* if !ThreeD*/ 
  }/* for (vcnt) loop */

  *nPtr = width*height;
  
}

/********************************************************/
/* Name: calc_cell                                      */
/* Content: calculate the percentage values for the     */
/*  cell array with the given maximum, minimum values   */
/*  Note: this routine is split from the old MakeChart  */
/*  routines to make it more flexible                   */
/* Date: 3/1992 (hui)                                   */
/********************************************************/
void
calc_cell(w, maximum, minimum, number)
ViewerWidget w;
double maximum,minimum;
int number; /* number of cells */
{
double lmax,lmin, percent;
double previous=0.0;
int i,cnt;
Arg arg[10];

  if(maximum < minimum) {
     XtWarning("Calc_cell: maximum is smaller than minimum");
     minimum=0; /* set minimum to 0 */
  }
  if(maximum==minimum)   /* boundary case */
     minimum=0;
    
  if (maximum > 0) lmax = log10(maximum);
       else lmax = 1.0; /* in case both max and min=0 */
  if (minimum > 0) lmin = log10(minimum);
       else lmin = lmax-1;

  if(w->viewer.log) {  /* save them */
    i = 0;
    SETDOUBLEARG(arg[i], XtNcalcMax, lmax); i++;
    SETDOUBLEARG(arg[i], XtNcalcMin, lmin); i++;
    XtSetValues(w->viewer.color_code.rbar, arg, i);    
    } else {
       i = 0;
       SETDOUBLEARG(arg[i], XtNcalcMax, maximum); i++;
       SETDOUBLEARG(arg[i], XtNcalcMin, minimum); i++;
       XtSetValues(w->viewer.color_code.rbar, arg, i);    
  } /* if */

  for(cnt=0; cnt < number; cnt++) {
      percent = w->viewer.masterval[cnt];
     
      if (w->viewer.log) {
         percent = percent + previous;
         if (percent > 0) percent = log10(percent);
             else percent = lmin;
 
         percent = (percent - lmin)/(lmax - lmin);
 
         if ((w->viewer.show_type != ThreeD) &&
                 (((cnt+1) % w->viewer.n_views) != 0 )) {
           previous += w->viewer.masterval[cnt];
           } else {
           previous = 0.0;
         }/* if */
 
         if ((w->viewer.show_type != ThreeD) &&
                 (((cnt) % w->viewer.n_views) != 0 )) {
           percent -= w->viewer.masterval[cnt-1];
         }/* if */
       }
       else
          percent = (percent - minimum)/(maximum - minimum);
  
      if (percent > 1.0) percent = 1.0;
      if (percent < 0.0) percent = 0.0;

      if(in_set_range && (w->viewer.cell[cnt] == -1.0))
         percent = 0.0;    /*is out of bound*/ 


      w->viewer.cell[cnt] = percent;
  } /* for*/

#ifdef DEBUG
printcells(w,number);
#endif
}

/********************************************************/
/* Name: MakeChart                                      */
/* Content:i) retrieve the profile data with make_bars()*/
/*  and make_buckets() calls, ii) update the color scale*/ 
/*  and the color bar, and iii) calculate the relative  */
/*  values for each data cell and then display them     */
/* Date: OLD ROUTINE (updated 3/1992 hui)               */
/********************************************************/
void
MakeChart(w, type)
ViewerWidget w;
int type;
{
  double maximum = 0.0;
  double minimum = BIGVALUE;
  int i,number;
  Arg arg[10];

  if (in_make_chart || in_set_range) return;

  in_make_chart = True;
  
  if (w->viewer.bucket) 
    make_buckets(w, &number, &maximum, &minimum, type);
  else
    make_bars(w, &number, &maximum, &minimum, type);
  
  if (w->viewer.n_views > 1) minimum = 0;

  w->viewer.maximum = maximum;
  w->viewer.minimum = minimum;

  i = 0; /* saving for future RESETS */
  SETDOUBLEARG(arg[i], XtNsaveMax, maximum); i++;
  SETDOUBLEARG(arg[i], XtNsaveMin, minimum); i++;
  XtSetValues(w->viewer.color_code.rbar, arg, i);    

  i = 0;
  SETDOUBLEARG(arg[i], XtNmaximum, maximum); i++;
  SETDOUBLEARG(arg[i], XtNminimum, minimum); i++;
  XtSetValues(w->viewer.color_code.scale, arg, i);    

  resize_colors(NULL, w, NULL);
  
/* NshowMax and NshowMin is the range of scale display  */
/* the cell (percentage) values should be calculated    */
/* in respects to n(ew)maximum and n(new)minimum, since */
/* that is what the color code bar will be showing only */

  if (w->viewer.show_type != ThreeD) {
    XtSetValues(w->viewer.scale_w, arg, i);
    XtVaGetValues(w->viewer.scale_w,
            XtNshowMax, &maximum, XtNshowMin, &minimum, NULL);
  }
 

  calc_cell(w,maximum,minimum,number); 
  
  if (w->viewer.chart_w != NULL) {
    XswChartRedisplay(w->viewer.chart_w);
  }
  in_make_chart = False;
}

/* ARGSUSED */
Boolean CvtStringToVType(display, args, nargs,
			      fromVal, toVal, converter_data)
     Display* display;
     XrmValuePtr args, fromVal, toVal;
     int *nargs;
     XtPointer* converter_data;
{
  static int result;
 
  if (XswStrCmp((char *)fromVal->addr, "threed"))
    result = ThreeD;
  else if (XswStrCmp((char *)fromVal->addr, "byprocedures"))
    result = ByProcedures;
  else if (XswStrCmp((char *)fromVal->addr, "bynodes"))
    result = ByNodes;
  else 
    XtStringConversionWarning((char *) fromVal->addr, "VType");

  DONE(VType, result);
}

/* ARGSUSED */
Boolean CvtStringToVTypeList(display, args, nargs,
			      fromVal, toVal, converter_data)
     Display* display;
     XrmValuePtr args, fromVal, toVal;
     int *nargs;
     XtPointer* converter_data;
{
  static VTypeList result;
  int i;
  int n = 0;
  String data;
  XrmValue from, to;
  XtCacheRef cache_ref_return;

  data = XtNewString((char *)fromVal->addr);

  while(strtok(data, " ") != NULL) {
    n++; 
    if (data != NULL) {
      XtFree(data);
      data = NULL;
    }
  }

  data = strtok((char *)fromVal->addr, " ");
  result = (VTypeList)XtMalloc((n+1) * sizeof(VType));
  for(i=0; i < n; i++) {
    from.addr = data;
    from.size = strlen(data) + 1;
    to.addr = (XtPointer)&(result[i]);
    to.size = sizeof(VType);
    XtCallConverter(display, CvtStringToVType,
		    (XrmValuePtr)NULL, (Cardinal)0, 
		    &from, &to, &cache_ref_return);

    data = strtok(NULL, " ");
  }
  result[i] = END_OF_LIST;
  DONE(VTypeList, result);
}

/* ARGSUSED */
static void
ChangeBounds(w, viewer, dummy)
Widget w;
ViewerWidget viewer;
int dummy;
{
  if (!in_make_chart) MakeChart(viewer, NotViewChange);
}


static void
ListSelect(w, viewer, info)
Widget w;
ViewerWidget viewer;
XPointer info;
{
  int j, max;
  MyListItemInfo *cur_info = (MyListItemInfo *) info;
  Arg args[2];

  XtSetArg(args[0], XtNnumberStrings, &max);

  if (w == viewer->viewer.vlist_w) {
    XswChartSetRow(viewer->viewer.chart_w, 
		   cur_info->item, cur_info->state);
    if (!cur_info->state && (viewer->viewer.show_type == ThreeD)) {
      XtGetValues(viewer->viewer.hlist_w, args, 1);
      for(j=0; j< max; j++)
	XswListSetItem(viewer->viewer.hlist_w, j, False);
    }
  } else {
    XswChartSetCol(viewer->viewer.chart_w,
		   cur_info->item, cur_info->state);
    if (!cur_info->state) {
      XtGetValues(viewer->viewer.vlist_w, args, 1);
      for(j=0; j< max; j++)
	XswListSetItem(viewer->viewer.vlist_w, j, False);
    }
  }
}

Boolean SolidRow(viewer, row)
ViewerWidget viewer;
int row;
{
  int i=0;
  Boolean result = True;

  while(i < viewer->viewer.width) {
    if (!viewer->viewer.state[i + row*viewer->viewer.width]) {
      result = False;
      break;
    }
    i++;
  }

  return result;
}

Boolean SolidCol(viewer, col)
ViewerWidget viewer;
int col;
{
  int i=0;
  Boolean result = True;

  while(i < viewer->viewer.height) {
    if (!viewer->viewer.state[col + i*viewer->viewer.width]) {
      result = False;
      break;
    }
    i++;
  }

  return result;
}

/* ARGSUSED */
static void
ChartSelect(w, viewer, info)
Widget w;
ViewerWidget viewer;
XPointer info;
{
  ChartPointInfo *cur_info = (ChartPointInfo *) info;
  
  if (cur_info->state) {
    if (viewer->viewer.show_type != ThreeD)
      XswListSetItem(viewer->viewer.vlist_w, cur_info->y, True);
    else {
      if (!viewer->viewer.vlist[cur_info->y].state)
	if (SolidRow(viewer, cur_info->y))
	  XswListSetItem(viewer->viewer.vlist_w, cur_info->y, True);
      if (!viewer->viewer.hlist[cur_info->x].state)
	if (SolidCol(viewer, cur_info->x))
	  XswListSetItem(viewer->viewer.hlist_w, cur_info->x, True);
    }  
  } else {
    if (viewer->viewer.show_type == ThreeD)
      XswListSetItem(viewer->viewer.hlist_w, cur_info->x, False);
    XswListSetItem(viewer->viewer.vlist_w, cur_info->y, False); 
  }
}

void
GetVertParams(viewer, position, pixels, cell_size, cells)
ViewerWidget viewer;
int *position;
Dimension *pixels;
int *cell_size;
Dimension *cells;
{
  int i;
  Arg args[5];

  i = 0;
  XtSetArg(args[i], XtNcurY, position); i++;
  XtSetArg(args[i], XtNheight, pixels);   i++;
  XtSetArg(args[i], XtNcellHeight, cell_size);   i++;
  XtSetArg(args[i], XtNheightInCells, cells);   i++;
  XtGetValues(viewer->viewer.chart_w, args, i);
}

void
GetHorizParams(viewer, position, pixels, cell_size, cells)
ViewerWidget viewer;
int *position;
Dimension *pixels;
int *cell_size;
Dimension *cells;
{
  int i;
  Arg args[5];

  i = 0;
  XtSetArg(args[i], XtNcurX, position); i++;
  XtSetArg(args[i], XtNwidth, pixels);   i++;
  XtSetArg(args[i], XtNcellWidth, cell_size);   i++;
  XtSetArg(args[i], XtNwidthInCells, cells);   i++;
  XtGetValues(viewer->viewer.chart_w, args, i);
}

void
SetVertParams(viewer, position)
ViewerWidget viewer;
int position;
{
  Arg args[2];

  XtSetArg(args[0], XtNtopItem, position);
  XtSetValues(viewer->viewer.vlist_w, args, 1);
  XtSetArg(args[0], XtNcurY, position);
  XtSetValues(viewer->viewer.chart_w, args, 1);
}

void
SetHorizParams(viewer, position)
ViewerWidget viewer;
int position;
{
  Arg args[2];

  XtSetArg(args[0], XtNtopItem, position);
  XtSetValues(viewer->viewer.hlist_w, args, 1);
  XtSetArg(args[0], XtNcurX, position);
  XtSetValues(viewer->viewer.chart_w, args, 1);
}

/* ARGSUSED */
static void
resize_thumbs(w, viewer, dummy)
Widget w;
ViewerWidget viewer;
int dummy;
{
  Dimension cells, pixels;
  int cell_size, position;
  
  if (viewer->viewer.show_type == ThreeD) {
    if (viewer->viewer.zoom) {
      XawScrollbarSetThumb(viewer->viewer.hscroll_w,
			   (float)0.0, (float)1.0);
    } else {
      GetHorizParams(viewer, &position, &pixels, &cell_size, &cells);
      XawScrollbarSetThumb(viewer->viewer.hscroll_w,
			   (float)position/(float)cells,
		(int)((float)pixels/(float)cell_size)/(float)cells);
    }
  }
  if (viewer->viewer.zoom) {
    XawScrollbarSetThumb(viewer->viewer.vscroll_w,
			 (float)0.0, (float)1.0);
  } else {
    GetVertParams(viewer, &position, &pixels, &cell_size, &cells);
    XawScrollbarSetThumb(viewer->viewer.vscroll_w,
			 (float)position/(float)cells,
	   (int)((float)pixels/(float)cell_size)/(float)cells);
  }
}

/* ARGSUSED */
static void
scroll_left_right(w, viewer, direction)
Widget w;
ViewerWidget viewer;
int direction;
{
    Dimension cells, pixels;
    int cell_size, position;

    if (viewer->viewer.zoom) return;

    GetHorizParams(viewer, &position, &pixels, &cell_size, &cells);

    if ((direction < 0) && (position>0)) position--;
    else if ((direction > 0) && (position < cells - (pixels/cell_size)))
      position++;

    SetHorizParams(viewer, position);
    if ((float)pixels/(float)cell_size <= (float)cells)
      XawScrollbarSetThumb(w,
			   (float)position/(float)cells,
			   (float)-1.0);
}

/* ARGSUSED */
static void
scroll_up_down(w, viewer, direction)
Widget w;
ViewerWidget viewer;
int direction;
{
    Dimension cells, pixels;
    int cell_size, position;
    if (viewer->viewer.zoom) return;

    GetVertParams(viewer, &position, &pixels, &cell_size, &cells);

    if ((direction < 0) && (position>0)) position--;
    else if ((direction > 0) && (position < cells - (pixels/cell_size)))
      position++;

    SetVertParams(viewer, position);
    if ((float)pixels/(float)cell_size <= (float)cells)
      XawScrollbarSetThumb(w,
			   (float)position/(float)cells,
			   (float)-1.0);
}

/* ARGSUSED */
static void
thumb_left_right(w, viewer, ptr)
Widget w;
ViewerWidget viewer;
XtPointer ptr;
{
    Dimension cells, pixels;
    int cell_size, position;
    float percent= *(float *) ptr;

    if (viewer->viewer.zoom) return;

    GetHorizParams(viewer, &position, &pixels, &cell_size, &cells);

    position = (int)(percent*(double)cells);
    if (position > cells - (pixels/cell_size))
      position = cells - (pixels/cell_size);

    SetHorizParams(viewer, position);

    XawScrollbarSetThumb(w,
			 (float)position/(float)cells,
			   (float)-1.0);
}

/* ARGSUSED */
static void
thumb_up_down(w, viewer, ptr)
Widget w;
ViewerWidget viewer;
XtPointer ptr;
{
    Dimension cells, pixels;
    int cell_size, position;
    float percent= *(float *) ptr;

    if (viewer->viewer.zoom) return;

    GetVertParams(viewer, &position, &pixels, &cell_size, &cells);

    position = (int)(percent*(double)cells);
    if (position > cells - (pixels/cell_size))
      position = cells - (pixels/cell_size);

    SetVertParams(viewer, position);

    XawScrollbarSetThumb(w,
			 (float)position/(float)cells,
			   (float)-1.0);

}

/********************************************************/
/********************************************************/
/* ARGSUSED */
static void
ClassPartInitialize(class)
WidgetClass class;
{
  XtSetTypeConverter(XtRString, XtRVType,
		     CvtStringToVType, NULL, 0,
		     XtCacheAll, NULL); 
  XtSetTypeConverter(XtRString, XtRVTypeList,
		     CvtStringToVTypeList, NULL, 0,
		     XtCacheAll, NULL); 
}

static void
Destroy(cw)
ViewerWidget cw;
{   
  XtFree((char *) cw->viewer.cell);
  XtFree((char *) cw->viewer.masterval);
  XtFree((char *) cw->viewer.state);
  XtFree((char *) cw->viewer.blist);
  XtFree((char *) cw->viewer.color_code.cell);
  XtFree((char *) cw->viewer.color_code.state);
}

/* ARGSUSED */
static void
Initialize(request, neww)
ViewerWidget request, neww;
{
  int i;
  Arg arg[20];
  Dimension height, width, gap, text_width;
  int thickness;
  double max = 400;
  double min = 0.1;
  int nitems;
  Dimension sheight, lheight;

  neww->viewer.chart_w = NULL;
  neww->viewer.vlist_w = NULL;
  neww->viewer.blist = NULL;
  neww->viewer.n_views = 0;
  neww->viewer.maximum = 100.0;
  neww->viewer.minimum = 0.0;
  neww->viewer.text = XtNewString("");

  while (neww->viewer.data[neww->viewer.n_views] != NULL) 
    neww->viewer.n_views++;

  neww->viewer.title_w = XtVaCreateManagedWidget(
                      "titleArea",
                      labelWidgetClass,
                      (Widget) neww, 
                      XtNbottom, XtChainTop,
                      XtNright, XtChainRight,
                      XtNleft, XtChainLeft,
                      XtNfromVert, NULL,
                      XtNfromHoriz, NULL,
                      XtNlabel, neww->viewer.title,
                      NULL);

  neww->viewer.dummy_w = XtVaCreateManagedWidget(
                      "dummy",
                      boxWidgetClass,
                      (Widget) neww,
                      XtNbottom, XtChainTop,
                      XtNtop, XtChainTop,
                      XtNright, XtChainLeft,
                      XtNleft, XtChainLeft,
                      XtNborderWidth, (Dimension)0,
                      XtNfromVert, neww->viewer.title_w,
                      NULL);
  
  neww->viewer.hlist_w = XtVaCreateWidget(
                      "hlist",
                      myListWidgetClass,
                      (Widget) neww,
                      XtNbottom, XtChainTop,
                      XtNtop, XtChainTop,
                      XtNright, XtChainRight,
                      XtNleft, XtChainLeft,
                      XtNfromVert, neww->viewer.title_w,
                      XtNfromHoriz, neww->viewer.dummy_w,
                      XtNvertical, False,
                      XtNspacing, neww->viewer.cell_width,
                      XtNzoom, neww->viewer.zoom,
                      XtNlist, neww->viewer.hlist,
                      XtNrotate, True,
                      NULL); 
  XtAddCallback(neww->viewer.hlist_w, XtNcallback, ListSelect, neww);
  XtVaGetValues(neww->viewer.hlist_w, XtNheight, &lheight, NULL);
  
  neww->viewer.scale_w = XtVaCreateWidget(
                     "scale", 
                     scaleWidgetClass,
                     (Widget) neww,
                     XtNbottom, XtChainTop,
                     XtNtop, XtChainTop,
                     XtNright, XtChainRight,
                     XtNleft, XtChainLeft,
                     XtNfromVert, neww->viewer.title_w,
                     XtNfromHoriz, NULL,
                     XtNvertical, False,
                     XtNspacing, neww->viewer.cell_width,
                     XtNzoom, neww->viewer.zoom,
                     XtNlist, neww->viewer.hlist,
                     XtNlog, neww->viewer.log,
                     NULL);
  XtVaGetValues(neww->viewer.scale_w, XtNheight, &sheight, NULL);

/* to make certain they are of equal height 4/14 hui */
  if(sheight > lheight)
      XtVaSetValues(neww->viewer.hlist_w, XtNheight, sheight, NULL);
  else if( lheight > sheight)
      XtVaSetValues(neww->viewer.scale_w, XtNheight, lheight, NULL);
    
/* */
  i=0;
  SETDOUBLEARG(arg[i], XtNmaximum, max); i++;
  SETDOUBLEARG(arg[i], XtNminimum, min); i++;
  XtSetValues(neww->viewer.scale_w, arg, i);    
/* */
     
  neww->viewer.vlist_w = XtVaCreateManagedWidget(
                       "vlist",
                       myListWidgetClass,
                       (Widget) neww,
                       XtNbottom, XtChainBottom,
                       XtNtop, XtChainTop,
                       XtNright, XtChainLeft,
                       XtNleft, XtChainLeft,
                       XtNfromVert, neww->viewer.hlist_w,
                       XtNvertical, True,
                       XtNlist, neww->viewer.vlist,
                       XtNspacing, neww->viewer.cell_height,
                       XtNzoom, neww->viewer.zoom,
                       NULL);
  XtAddCallback(neww->viewer.vlist_w, XtNcallback, ListSelect, neww);

  XtVaGetValues(neww->viewer.hlist_w,XtNnumberStrings,&nitems,NULL);
  neww->viewer.width = nitems;
  XtVaGetValues(neww->viewer.vlist_w,XtNnumberStrings,&nitems,NULL);
  neww->viewer.height = nitems;

  neww->viewer.masterval = (double *)
    XtCalloc(neww->viewer.width*neww->viewer.height, 
	   sizeof(double));
  neww->viewer.cell = (double *)
    XtCalloc(neww->viewer.width*neww->viewer.height, 
	   sizeof(double));
  neww->viewer.state = (Boolean *)
    XtCalloc(neww->viewer.width*neww->viewer.height, 
	   sizeof(Boolean));

  neww->viewer.chart_w = XtVaCreateManagedWidget(
                      "chart",
                      chartWidgetClass,
                      (Widget) neww,
                      XtNbottom, XtChainBottom,
                      XtNtop, XtChainTop,
                      XtNright, XtChainRight,
                      XtNleft, XtChainLeft,
                      XtNresizable, True,
                      XtNcellArray, (double *)(neww->viewer.cell),
                      XtNstateArray, (double *)(neww->viewer.state),
                      XtNfromVert, neww->viewer.dummy_w,
                      XtNfromHoriz, neww->viewer.vlist_w,
                      XtNcellWidth, neww->viewer.cell_width,
                      XtNcellHeight, neww->viewer.cell_height,
                      XtNwidthInCells, neww->viewer.width,
                      XtNheightInCells, neww->viewer.height,
                      XtNtwoD, (neww->viewer.show_type != ThreeD),
                      XtNlog, neww->viewer.log,
                      XtNzoom, neww->viewer.zoom,
                      NULL);
  XtAddCallback(neww->viewer.chart_w, XtNcallback, ChartSelect, neww);
  XtAddCallback(neww->viewer.chart_w, XtNchartResize, resize_thumbs, neww);
  
  XtVaGetValues(neww->viewer.vlist_w,XtNwidth,&width,NULL);
  XtVaSetValues(neww->viewer.dummy_w,XtNwidth,width,NULL);
  XtVaGetValues((Widget) neww,XtNdefaultDistance,&thickness,NULL);
  XtVaSetValues(neww->viewer.scale_w,XtNindent,width+thickness,NULL);
  text_width = width + thickness;
	
  XtVaGetValues(neww->viewer.hlist_w,XtNheight,&height,NULL);
  XtVaSetValues(neww->viewer.scale_w,XtNheight,height,NULL);
  XtVaSetValues(neww->viewer.dummy_w,XtNheight,height,NULL);
  XtVaGetValues(neww->viewer.chart_w,XtNheight,&height,XtNwidth,&width,NULL);
  XtVaSetValues(neww->viewer.hlist_w,XtNwidth,width,NULL);
  XtVaSetValues(neww->viewer.scale_w,XtNaxisLength,width,NULL);
  text_width += (width + thickness);

  XtVaSetValues(neww->viewer.vlist_w,XtNheight,height,NULL);

  neww->viewer.vscroll_w = XtVaCreateManagedWidget(
                      "scrollVert",
		      scrollbarWidgetClass,
                      (Widget) neww,
                      XtNheight,height,
                      XtNbottom, XtChainBottom,
                      XtNtop, XtChainTop,
                      XtNright, XtChainRight,
                      XtNleft, XtChainRight,
                      XtNfromVert, neww->viewer.dummy_w,
                      XtNfromHoriz, neww->viewer.chart_w,
                      XtNorientation, XtorientVertical,
                      NULL);
  XtAddCallback(neww->viewer.vscroll_w, XtNscrollProc,
		scroll_up_down, neww);
  XtAddCallback(neww->viewer.vscroll_w, XtNjumpProc,
		thumb_up_down, neww);
  
  neww->viewer.hscroll_w = XtVaCreateWidget(
                       "scrollHoriz",
                       scrollbarWidgetClass,
                       (Widget) neww,
                       XtNwidth, width,
                       XtNbottom, XtChainBottom,
                       XtNtop, XtChainBottom,
                       XtNright, XtChainRight,
                       XtNleft, XtChainLeft,
                       XtNfromVert, neww->viewer.chart_w,
                       XtNfromHoriz, neww->viewer.vlist_w,
                       XtNorientation, XtorientHorizontal,
                       NULL);
  XtAddCallback(neww->viewer.hscroll_w, XtNscrollProc,
		scroll_left_right, neww);
  XtAddCallback(neww->viewer.hscroll_w, XtNjumpProc,
		thumb_left_right, neww);

  XtVaGetValues((Widget) neww,XtNdefaultDistance,&thickness,NULL);

  if (neww->viewer.show_type == ThreeD) {
    XtVaGetValues(neww->viewer.hscroll_w,XtNheight,&gap,NULL);
    gap += 2*thickness;
  } else {
    gap = thickness;
  }

  XtVaGetValues(neww->viewer.vscroll_w,XtNwidth,&width,NULL);
  text_width += width;

  XtVaSetValues(neww->viewer.title_w, XtNwidth, text_width, NULL);

  neww->viewer.text_w = XtVaCreateManagedWidget(
                   "textArea",
                   labelWidgetClass,
                   (Widget) neww,
                   XtNvertDistance, gap,
                   XtNbottom, XtChainBottom,
                   XtNtop, XtChainBottom,
                   XtNright, XtChainRight,
                   XtNleft, XtChainLeft,
                   XtNfromVert, neww->viewer.chart_w,
                   XtNfromHoriz, NULL,
                   XtNlabel, neww->viewer.text,
                   NULL); 
  XtVaSetValues(neww->viewer.text_w, XtNwidth, text_width, NULL);

  neww->viewer.color_code.box = XtVaCreateWidget(
                     "ColorScale", 
                     formWidgetClass,
                     (Widget) neww,
                     XtNheight, height,
                     XtNbottom, XtChainBottom,
                     XtNtop, XtChainTop,
                     XtNright, XtChainRight,
                     XtNleft, XtChainRight,
                     XtNfromVert, neww->viewer.dummy_w,
                     XtNfromHoriz, neww->viewer.vscroll_w,
                     NULL);
  
  if (neww->viewer.show_type != ThreeD) {
    XtUnmanageChild(neww->viewer.dummy_w);
    XtManageChild(neww->viewer.scale_w);
  } else {
    XtManageChild(neww->viewer.hlist_w);
    XtManageChild(neww->viewer.hscroll_w);
  }

  make_color_code(neww);
  resize_thumbs(NULL, neww, NULL);
  MakeChart(neww, ViewChange);
  XtAddCallback(neww->viewer.scale_w, XtNcallback, ChangeBounds, neww); 


  if (neww->viewer.show_type == Bucket3D)
    neww->viewer.return_view.type = ThreeD;
  else 
    neww->viewer.return_view.type = neww->viewer.show_type;
  neww->viewer.return_view.data = neww->viewer.data;
  
  XtCallCallbacks((Widget) neww, XtNviewChange, &(neww->viewer.return_view));
}  

static int 
count_line(buf)
char buf[];
{
short i, j=1;

   for(i=0;i<BUF_SIZE; i++) {
    if(buf[i]=='\n')
      j++;
    if(buf[i]=='\0')
      return j;
   }
}

/* ARGSUSED */
static Boolean
SetValues(current, request, neww)
Widget current, request, neww;
{
  ViewerWidget curcw = (ViewerWidget) current;
  ViewerWidget newcw = (ViewerWidget) neww;
  Boolean do_redisplay = False;
  Boolean make_chart = False;
  Boolean call_view_change = False;
  int change_type = NotViewChange;
  Dimension width, gap, old_gap;
  Arg args[5];
  int i;
  int thickness;
  int o_line_cnt, n_line_cnt;
  Dimension o_iheight, o_height, o_lheight, n_height;
  char Buf[BUF_SIZE];
  String p;

  
  if (strcmp(newcw->viewer.title, curcw->viewer.title)) {
   
/* hui 4/13 */
    XtVaGetValues(newcw->viewer.title_w, 
                  XtNwidth, &width,
		  XtNheight, &o_height,
                  XtNlabel, &p,
                  XtNinternalHeight, &o_iheight,
                  NULL);

    /* 4/13 hui for R5's form Widget changes */
    strcpy(Buf,p);
    old_gap=o_height;
    o_line_cnt=count_line(Buf);
    o_lheight= (o_height-(2*o_iheight)) / o_line_cnt;
    n_line_cnt=count_line(newcw->viewer.title);
    n_height= (o_lheight*n_line_cnt) + 2* o_iheight;
    gap=n_height;

    if(old_gap > gap) {
      XtVaSetValues(newcw->viewer.title_w, 
		  XtNlabel, newcw->viewer.title, NULL);
      XtVaSetValues(newcw->viewer.title_w,XtNwidth,width,NULL);
      AdjustChart(newcw, (int)(gap-old_gap), 0, 0, 0);
      } else {
        AdjustChart(newcw, (int)(gap-old_gap), 0, 0, 0);
        XtVaSetValues(newcw->viewer.title_w, 
		  XtNlabel, newcw->viewer.title, NULL);
        XtVaSetValues(newcw->viewer.title_w,XtNwidth,width,NULL);
    }

    do_redisplay = True;
  }

  if (strcmp(newcw->viewer.text, curcw->viewer.text)) {
    XtFree(curcw->viewer.text);
    XtVaGetValues(newcw->viewer.text_w,
                XtNlabel, &p,
                XtNinternalHeight, &o_iheight,
                XtNheight, &o_height,
                XtNwidth, &width,
                NULL);
    strcpy(Buf,p);
    old_gap=o_height;

    /* 4/13 hui for R5's form Widget changes */
    o_line_cnt=count_line(Buf);
    o_lheight= (o_height-(2*o_iheight)) / o_line_cnt;
    n_line_cnt=count_line(newcw->viewer.text);
    n_height= (o_lheight*n_line_cnt) + 2* o_iheight;
    gap=n_height;
 
    if(old_gap > gap) {
      XtVaSetValues(newcw->viewer.text_w, 
		  XtNlabel, newcw->viewer.text, NULL);
      XtVaSetValues(newcw->viewer.text_w, XtNwidth, width, NULL);
      AdjustChart(newcw, 0, 0, 0, (int)(old_gap-gap));
      } else {
        AdjustChart(newcw, 0, 0, 0, (int)(old_gap-gap));
        XtVaSetValues(newcw->viewer.text_w, 
		  XtNlabel, newcw->viewer.text, NULL);
        XtVaSetValues(newcw->viewer.text_w,XtNwidth,width,NULL);
    }

    do_redisplay = True;
  }
 
  if (newcw->viewer.bucket != curcw->viewer.bucket) {
    if ((newcw->viewer.bucket) && (newcw->viewer.show_type == ThreeD))
      newcw->viewer.show_type = Bucket3D;
    if ((!newcw->viewer.bucket) && (newcw->viewer.show_type == Bucket3D))
      newcw->viewer.show_type = ThreeD;
    make_chart = True;
    change_type = ViewChange;
    do_redisplay = True;
  }
  
  if (newcw->viewer.data != curcw->viewer.data) {
    newcw->viewer.n_views = 0;
    while (newcw->viewer.data[newcw->viewer.n_views] != NULL) 
      newcw->viewer.n_views++;
    make_chart = True;
    do_redisplay = True;
    call_view_change = True;
  }

  if (newcw->viewer.root_type != curcw->viewer.root_type) {
    VType show_type = newcw->viewer.root_type[0];
    for(i=1; i < newcw->viewer.n_views; i++) {
      if (newcw->viewer.root_type[i] != ThreeD) {
	if (show_type != ThreeD) {
	  if (show_type != newcw->viewer.root_type[i]) {
	    XtWarning("Invalid type list specified.");
	  }
	} else {
	  show_type = newcw->viewer.root_type[i];
	}
      }
    }
    if (show_type != ThreeD) {
      newcw->viewer.show_type = show_type;
    }
  }

  if (newcw->viewer.show_type != curcw->viewer.show_type) {
    if ((newcw->viewer.bucket) && (newcw->viewer.show_type == ThreeD))
      newcw->viewer.show_type = Bucket3D;
    XtVaGetValues(newcw->viewer.hscroll_w, XtNheight, &gap, NULL);
    XtVaGetValues((Widget)newcw, XtNdefaultDistance, &thickness, NULL);
    XtVaGetValues(newcw->viewer.chart_w, XtNwidth, &width, NULL);

    if ((newcw->viewer.show_type != ThreeD) &&
	(curcw->viewer.show_type == ThreeD)) {
      XtUnmanageChild(newcw->viewer.hlist_w);
      XtUnmanageChild(newcw->viewer.hscroll_w);
      XtUnmanageChild(newcw->viewer.dummy_w);
      XtVaSetValues(newcw->viewer.text_w,
                         XtNvertDistance,(Dimension)thickness,NULL); 
      XtManageChild(newcw->viewer.scale_w);
      XtVaSetValues(newcw->viewer.scale_w, XtNaxisLength, width, NULL);
      AdjustChart(newcw,0,0,0,(int)gap);
    } else if ((newcw->viewer.show_type == ThreeD) &&
	       (curcw->viewer.show_type != ThreeD)) {
      XtVaSetValues(newcw->viewer.text_w, XtNvertDistance,
		    (Dimension)(gap + 2*thickness), NULL);      
      XtUnmanageChild(newcw->viewer.scale_w);
      XtManageChild(newcw->viewer.dummy_w);
      XtManageChild(newcw->viewer.hlist_w);
      XtManageChild(newcw->viewer.hscroll_w);
      XtVaSetValues(newcw->viewer.hlist_w,XtNwidth,width,NULL);
      XtVaSetValues(newcw->viewer.hscroll_w,XtNwidth,width,NULL);
      AdjustChart(newcw,0,0,0,(int)-gap);
    }

    XtSetArg(args[0], XtNtwoD, (newcw->viewer.show_type != ThreeD));
    XtSetArg(args[1], XtNwidthInCells, 
	     ((newcw->viewer.show_type != ThreeD) ? 
	      (Dimension)1 : newcw->viewer.width));
    XtSetValues(newcw->viewer.chart_w, args, 2);
    
    change_type = ViewChange;
    make_chart = True;
    do_redisplay = True;
    if (!(((newcw->viewer.show_type == Bucket3D) ||
	   (newcw->viewer.show_type == ThreeD)) &&
	  ((curcw->viewer.show_type == Bucket3D) ||
	   (curcw->viewer.show_type == ThreeD))))
      call_view_change = True;
  }

  if (newcw->viewer.log != curcw->viewer.log) {
    XtSetArg(args[0], XtNlog, newcw->viewer.log);
    XtSetValues(newcw->viewer.chart_w, args, 1);
    XtSetValues(newcw->viewer.scale_w, args, 1);
    XtVaSetValues(newcw->viewer.color_code.rbar, 
                   XtNisLog, newcw->viewer.log, NULL);
/*The update in scale widget will remade scale ticks */
    XtSetValues(newcw->viewer.color_code.scale, args, 1);
/*hui 3/3 make the color scale blocks to redrawn */
    XtCallCallbacks(newcw->viewer.color_code.colors,XtNchartResize,NULL);

    do_redisplay = True;
  }

  if (newcw->viewer.zoom != curcw->viewer.zoom) {
    XtSetArg(args[0], XtNzoom, newcw->viewer.zoom);
    XtSetValues(newcw->viewer.chart_w, args, 1);
    XtSetValues(newcw->viewer.vlist_w, args, 1);
    XtSetValues(newcw->viewer.hlist_w, args, 1);

    do_redisplay = True;
  }

  if (newcw->viewer.width * newcw->viewer.height * newcw->viewer.n_views !=
      curcw->viewer.width * curcw->viewer.height * curcw->viewer.n_views) {
    unsigned size = newcw->viewer.width * newcw->viewer.height * newcw->viewer.n_views;

    XtFree((char *) curcw->viewer.cell);
    XtFree((char *) curcw->viewer.masterval);
    XtFree((char *) curcw->viewer.state);

    newcw->viewer.cell = (double *) XtCalloc(size,sizeof(double));
    newcw->viewer.state = (Boolean *) XtCalloc(size,sizeof(Boolean));
    XtVaSetValues(newcw->viewer.chart_w,
		  XtNcellArray,  newcw->viewer.cell,
		  XtNstateArray, newcw->viewer.state, NULL);
  }

    
  if (make_chart) MakeChart(newcw, change_type);

  if (newcw->viewer.show_type != ThreeD) { 
    ScaleState(newcw, DOWN);
  } else {
    if (newcw->viewer.color_code.up) {
      ScaleState(newcw, UP);
    }
  }

  if (call_view_change) {
    if (newcw->viewer.show_type == Bucket3D)
      newcw->viewer.return_view.type = ThreeD;
    else 
      newcw->viewer.return_view.type = newcw->viewer.show_type;
    newcw->viewer.return_view.data = newcw->viewer.data;
    
    XtCallCallbacks((Widget) newcw, XtNviewChange, &(newcw->viewer.return_view));
  }
  return do_redisplay;
}
/********************************************************/
/********************************************************/

/********************************************************/
/* Name: AdjustChart                                    */
/* Content: To adjust the physical space for the big    */
/*  bitmap display for the profile data                 */
/*  Note : only one case can be non-zero at a time      */
/* Date: OLD ROUTINE (Updated 4/92)                     */
/********************************************************/
static void
AdjustChart(w, x0, y0, x1, y1)
     ViewerWidget w;
     int x0, y0, x1, y1;
{
  Dimension width, height, d_width;
  Dimension d_width1;
  int indent1;
  int indent;
  Arg args[10];
  Dimension vheight;
  
  XtVaGetValues(w->viewer.chart_w, XtNwidth, &width,
		XtNheight, &height, NULL);
#ifdef DEBUG
printf(" ---IN AdjustChart -- \n");
printf(" chart_w's width(%d) height(%d)\n", width, height);
printf(" with call of x0(%d),y0(%d),x1(%d),y1(%d)\n",x0,y0,x1,y1);
#endif

  if (y0 != 0) { ;
/** 
  ??XtSetArg(args[0], XtNheight, (Dimension)(height-y1));
    XtSetArg(args[0], XtNheight, (Dimension)(height-y0));
**/
    XtVaSetValues(w->viewer.chart_w, 
                XtNheight, (Dimension)(height-y0), NULL);
    XtVaSetValues(w->viewer.vlist_w, 
                XtNheight, (Dimension)(height-y0), NULL);
    XtVaSetValues(w->viewer.vscroll_w, 
                XtNheight, (Dimension)(height-y0), NULL);
    XtVaSetValues(w->viewer.color_code.box, 
                XtNheight, (Dimension)(height-y0), NULL);
  }
  if (y1 != 0) {
    XtVaSetValues(w->viewer.chart_w, 
               XtNheight, (Dimension)(height+y1), NULL);
    XtVaSetValues(w->viewer.vlist_w, 
               XtNheight, (Dimension)(height+y1), NULL);
    XtVaSetValues(w->viewer.vscroll_w, 
               XtNheight, (Dimension)(height+y1), NULL);
    XtVaGetValues(w->viewer.vscroll_w,
               XtNheight, &vheight, NULL);
    XtVaSetValues(w->viewer.color_code.box, 
               XtNheight, (Dimension)(height+y1), NULL);
  }
  if (x0 != 0) {
    x1 -= x0;
    if(x1 < 0) { /* 4/14 hui for R5 form widget difference */
      AdjustChart( w, 0, 0, x1, 0);
      x1=0;
    }
    XtVaGetValues(w->viewer.dummy_w, XtNwidth, &d_width, NULL);
    XtVaSetValues(w->viewer.dummy_w, 
		  XtNwidth, (Dimension)(d_width+x0), NULL);
    XtVaGetValues(w->viewer.scale_w, XtNindent, &indent, NULL);
    XtVaSetValues(w->viewer.scale_w, 
		  XtNindent, (int)(indent+x0), NULL);
    XtVaGetValues(w->viewer.dummy_w, XtNwidth, &d_width1, NULL);
    XtVaGetValues(w->viewer.scale_w, XtNindent, &indent1, NULL);
  }
  if (x1 != 0) {
    XtVaSetValues(w->viewer.chart_w,
                  XtNwidth, (Dimension)(width+x1), NULL);
    XtVaSetValues(w->viewer.hscroll_w,
                  XtNwidth, (Dimension)(width+x1), NULL);
    XtVaSetValues(w->viewer.hlist_w, 
                  XtNwidth, (Dimension)(width+x1), NULL);
    XtVaSetValues(w->viewer.scale_w, 
                  XtNaxisLength, (Dimension)(width+x1), NULL);
  }
}

/********************************************************/
/* Name: ScaleState                                     */
/* Content: To bring up or remove the color bar(in the  */
/*  viwer.color_code.box) along with the Range Select   */
/*  shell                                               */
/* Date: OLD ROUTINE (Updated 3/1993 hui)               */
/********************************************************/
static void
ScaleState(w, state)
     ViewerWidget w;
     int state;
{
  Dimension width, height;
  int thickness; 

  XtVaGetValues(w->viewer.color_code.box, XtNwidth, &width, NULL);
  XtVaGetValues((Widget)w, XtNdefaultDistance, &thickness, NULL);
  
  if (state == DOWN) {
   if (XtIsManaged(w->viewer.color_code.box)) {
     popDownRbar(w->viewer.color_code.rbar,w,NULL);
     XtUnmanageChild(w->viewer.color_code.box);
     AdjustChart(w,0,0,width+2*thickness,0);/* reordered for R5 */
   }/*if managed*/
  } else {
   if (!XtIsManaged(w->viewer.color_code.box)) {
     AdjustChart(w,0,0,-(width+2*thickness),0);/* reduce the main chart display */
     XtVaGetValues(w->viewer.chart_w, XtNheight, &height, NULL);
     XtVaSetValues(w->viewer.color_code.scale,
                                XtNheight, height, NULL);
     resize_colors(NULL, w, NULL);
     XtManageChild(w->viewer.color_code.box);/* display the color scale */
     popUpRbar(w);
    }/* if not managed */
  }/* if state */

}

/********************************************************/

#if NeedFunctionPrototypes
Widget XswViewerChartWidget (
   Widget w
)
#else
Widget 
XswViewerChartWidget(w)
Widget w;
#endif
{
ViewerWidget vw=(ViewerWidget) w;

  return vw->viewer.chart_w;
}

/********************************************************/
/* Name: XswViewerGetZptr                               */
/* Content: Return the current snapshot number being    */
/*   used in the main display                           */
/* Date: 2/24/1992 (hui)                                */
/********************************************************/
#if NeedFunctionPrototypes
void XswViewerGetZptr(
Widget w,
int *zptr 
)
#else
void 
XswViewerGetZptr(w,zptr)
Widget w;
int *zptr;
#endif
{
ViewerWidget vw=(ViewerWidget) w;

    *zptr = vw->viewer.zptr;
}

/********************************************************/
/* Name: XswViewerSetZptr                               */
/* Content: To set the snapshot number being used in    */
/*   the main display                                   */
/* Date: 2/24/1992 (hui)                                */
/********************************************************/
/* ARGSUSED */
#if NeedFunctionPrototypes
void XswViewerSetZptr(
Widget w,
int newZptr
)
#else
void
XswViewerSetZptr(w,newZptr)
Widget w;
int newZptr;
#endif
{
ViewerWidget vw=(ViewerWidget) w;

   vw->viewer.zptr=newZptr;
}

/********************************************************/
/* Name: clear_set_range                                */
/* Content: Reset the max and min to the ones saved     */
/*   for the main display before any range selection is */
/*   done and recalculate the main display's cell data  */
/* Date: 3/1992  (hui)                                  */
/********************************************************/
static void
clear_set_range(rw,client_data, call_data)
RangeWidget rw;
XtPointer client_data, /* ViewerWidget */
          call_data;
{
ViewerWidget vw= (ViewerWidget) client_data;
double maxptr;
double minptr;

   XtVaGetValues((Widget)rw, XtNsaveMax,&maxptr,XtNsaveMin,&minptr, NULL);
   
   recalc_cell(vw,&maxptr,&minptr);

   vw->viewer.minimum=maxptr;
   vw->viewer.maximum=minptr;

   if(vw->viewer.chart_w != NULL) {
       XswChartRedisplay(vw->viewer.chart_w);
   } /* if */

}

/********************************************************/
/* Name: printcells                                     */
/* Content: A debug routine for printing out the        */
/*  content of the viewer's cell array                  */
/* Date: 3/1992 (hui)                                   */
/********************************************************/
printcells(w, number)
ViewerWidget w;
int number;
{
int i;

  for(i=0;i<number;i++) {
    if(i%5==0) printf("\n");
    printf("[%2d](%6f)",i, w->viewer.cell[i]);
  }
  printf("\n");
}


/********************************************************/
/* Name: recalc_cell                                    */
/* Content: This is called when a Range is selected to  */
/*  expand a certain subset of data in the main profile */
/*  display.                                            */
/*  i) given the new max and min bound(*maxptr,*minptr) */
/*     first mark those cell value that is out of bound */
/*  ii) at the same time compute the new max and min    */
/*     from the acceptable range of values              */
/*  iii) recalculate the cell value with the call to    */
/*     calc_cell() and return the new max and min       */
/* Date: 3/1992 (hui)                                   */
/********************************************************/
static void
recalc_cell(vw, maxptr, minptr)
ViewerWidget vw;
double *maxptr, *minptr;
{
double    omaximum = *maxptr;
double    ominimum = *minptr;
int       i;
int       width, height, number;
double    ovalue;
double    opercent;
double    nmaximum=0.0;
double    nminimum=BIGVALUE;
Arg       arg[20];


/**********/
  i = 0;
  while(vw->viewer.data[i] != NULL) i++;
 
  switch (vw->viewer.show_type) {
  case ByNodes:
    height = vw->viewer.width; width = i;
    break;
  case ByProcedures:
    height = vw->viewer.height; width = i;
    break;
  default:
    height = vw->viewer.height; width = vw->viewer.width;
    break;
  }
  number= height * width;
/**********/

/* mark for the out of bound cells */
  for(i=0;i<number;i++) { 
     ovalue=vw->viewer.masterval[i];
/* set out of bound cells to (-1) */
     if( (ovalue>omaximum) || (ovalue < ominimum) )
        vw->viewer.cell[i]= -1.0;
        else { /* checking for newmaximum and nminimum */

           if(ovalue > nmaximum) 
              nmaximum=ovalue;

           if(vw->viewer.log) { 
              if((ovalue<nminimum) && (ovalue>0))
                nminimum=ovalue;
                } else {
                   if(ovalue<nminimum) 
                      nminimum=ovalue;
           }/*if*/

        } /* else >0.0 */

  }/* for */
  if(nminimum == BIGVALUE) /* boundary case */
    nminimum = 0.0; /* set it to 0 */

#ifdef DEBUG
printcells(vw,number);
#endif

  vw->viewer.maximum = nmaximum;
  vw->viewer.minimum = nminimum;

  i = 0;
  SETDOUBLEARG(arg[i], XtNmaximum, nmaximum); i++;
  SETDOUBLEARG(arg[i], XtNminimum, nminimum); i++;
  XtSetValues(vw->viewer.color_code.scale, arg, i);    
 /* make the color scale blocks to redrawn */
  resize_colors(NULL,vw,NULL);

/* recalculate the new percentages from the masterval array */
  calc_cell(vw,nmaximum, nminimum, number);

  *maxptr=nmaximum;
  *minptr=nminimum;
}

/********************************************************/
/* Name: set_range                                      */
/* Content: callback routine to handle the range change */
/*   request from the Range Widget                      */
/* Date: 3/6/1992 (hui)                                 */
/********************************************************/
/* ARGSUSED */
static void
set_range(rw,client_data,call_data)
RangeWidget rw;
XtPointer client_data,  /* the viewer widget */
          call_data;    /* NULL */
{
ViewerWidget vw=(ViewerWidget) client_data;
int maxidx;
int minidx;
double maximum, minimum;

    in_set_range=True;
    XswRangeGetNew(rw, &maximum, &minimum); /* get new max/min */
             /* calculate new cell values and also new max/min */
    recalc_cell(vw, &maximum, &minimum); 

    vw->viewer.maximum=maximum;  /* store the new max and min */
    vw->viewer.minimum=minimum;  

    if(vw->viewer.chart_w != NULL) {
       XswChartRedisplay(vw->viewer.chart_w);
    }
    in_set_range=False;
}

/********************************************************/
/* Name: popUpRbar                                      */
/* Content : calculate the popup position and popup the */
/*  Range Selection's window                            */
/*  Note: did not de-sensitice other commands and a     */
/*  RangeReset is done before the popup call            */
/* Date: 3/1992 (hui)                                   */
/********************************************************/
static void
popUpRbar(vw)
ViewerWidget vw;
{
Position x,y;
Dimension width, height;
 
/* find a popup postion */
   XtVaGetValues(vw->viewer.color_code.box,
                    XtNwidth, &width, XtNheight, &height, NULL);
   XtTranslateCoords(vw->viewer.color_code.box, 
                     (Position) width+10,
                     (Position) -60,
                     &x,&y);
   XtVaSetValues(vw->viewer.color_code.popbar, XtNx, x, XtNy, y, NULL);
 
   XtCallCallbacks((Widget)vw->viewer.color_code.rbar,
                       XtNresetRange, NULL);
   XswRangeReset(NULL, vw->viewer.color_code.rbar, NULL);
/* popup the range selection */
   XtPopup(vw->viewer.color_code.popbar,XtGrabNone);
}

/********************************************************/
/* Name: popDownRbar                                    */
/* Content: To popdown the Range Selection's window     */
/* Date: 3/1992 (hui)                                   */
/********************************************************/
static void
popDownRbar(rw,client_data,call_data)
RangeWidget rw;
XtPointer client_data, /* ViewerWidget */
          call_data;
{
ViewerWidget vw= (ViewerWidget) client_data;

   XtPopdown(vw->viewer.color_code.popbar);
}

/********************************************************/
/* Name: XswViewerGetBounds                             */
/* Content: To return the viewer display's maximum and  */
/*   minimum values                                     */
/* Date: 3/1992 (hui)                                   */
/********************************************************/
#if NeedFunctionPrototypes
void XswViewerGetBounds(
ViewerWidget w,
double * maxPtr,
double * minPtr
)
#else
void
XswViewerGetBounds(w, maxPtr, minPtr)
ViewerWidget w;
double * maxPtr, * minPtr;
#endif
{
  *maxPtr = w->viewer.maximum;
  *minPtr = w->viewer.minimum;
}

/********************************************************/
#if NeedFunctionPrototypes
void XswViewerPopupScale(
Widget w
)
#else
void
XswViewerPopupScale(w)
Widget w;
#endif
{
ViewerWidget vw=(ViewerWidget) w;

  if (vw->viewer.show_type == ThreeD) {  
    if (vw->viewer.color_code.up) {
      ScaleState(vw, DOWN);
      vw->viewer.color_code.up = False;
    } else {
      ScaleState(vw, UP);
      vw->viewer.color_code.up = True;
    }
  }
}
    

#if NeedFunctionPrototypes
void XswViewerClearSelections(
Widget w
)
#else
void
XswViewerClearSelections(w)
Widget w;
#endif
{
  ViewerWidget vw = (ViewerWidget) w;
  int i, j, num;

  if (vw->viewer.bucket) {
    for(i=0; i < vw->viewer.n_buckets; i++) {
	XswListSetItem(vw->viewer.vlist_w, i, False);
	vw->viewer.state[i] = False;   
      }
  } else {
    num = 0; 
    while(vw->viewer.data[num] != NULL) num++;

    switch (vw->viewer.show_type) {
    case ByNodes:
      for(i=0; i < vw->viewer.width; i++) {
	XswListSetItem(vw->viewer.vlist_w, i, False);
	for(j=0; j < num; j++)
	  vw->viewer.state[j + i*num] = False;
      }
      break;
    case ByProcedures:
      for(i=0; i < vw->viewer.height; i++) {
	XswListSetItem(vw->viewer.vlist_w, i, False);
	for(j=0; j < num; j++)
	  vw->viewer.state[j + i*num] = False;
      }
      break;
    case ThreeD:
      for(j=0; j < vw->viewer.height; j++) {
	for(i=0; i < vw->viewer.width; i++) {
	  if (j==0) XswListSetItem(vw->viewer.hlist_w, i, False);
	  vw->viewer.state[i + j*vw->viewer.width] = False;
	}
	XswListSetItem(vw->viewer.vlist_w, j, False); 
      }
      break;
    }
  }
  if (vw->viewer.chart_w != NULL) {
    XswChartRedisplay(vw->viewer.chart_w);
  }
}

#if NeedFunctionPrototypes
VType XswViewerViewType(
Widget w
)
#else
VType
XswViewerViewType(w)
Widget w;
#endif
{
ViewerWidget vw=(ViewerWidget) w;

  return vw->viewer.show_type;
}

#if NeedFunctionPrototypes
Boolean XswViewerIsBucket(
Widget w
)
#else
Boolean 
XswViewerIsBucket(w)
Widget w;
#endif
{
ViewerWidget vw=(ViewerWidget) w;

  return vw->viewer.bucket;
}


static void
MapOneList(w, orientation, pointer, f, data, d)
ViewerWidget w;
OType orientation;
void * pointer;
void (*f)();
String data;
void * d;
{
  int i, length;
  Boolean no_select;
  ListElement * list;

  if (orientation == Vertical) {
    length = w->viewer.height;
    list = w->viewer.vlist;
  } else {
    length = w->viewer.width;
    list = w->viewer.hlist;
  }

  no_select = NoSelections(list, length); 

  for(i=0; i < length; i++) {
    if (list[i].state || no_select) {
      if (orientation == Vertical) {
	(*f)(list[i].pointer, pointer, data, d, w->viewer.zptr);
      } else {
	(*f)(pointer, list[i].pointer, data, d, w->viewer.zptr);
      }	
    }
  }
}

static void
MapBothLists(w, f, data, d)
ViewerWidget w;
void (*f)();
String data;
void * d;
{
  int i, j;
  Boolean no_hselect, no_vselect;

  no_hselect = NoSelections(w->viewer.hlist, w->viewer.width); 
  no_vselect = NoSelections(w->viewer.vlist, w->viewer.height); 

  for(j=0; j < w->viewer.width; j++) {
    if (w->viewer.hlist[j].state || no_hselect) {
      for(i=0; i < w->viewer.height; i++) {
	if (w->viewer.vlist[i].state || no_vselect)
	  (*f)(w->viewer.vlist[i].pointer, w->viewer.hlist[j].pointer,
	       data, d, w->viewer.zptr);
      }
    }
  }
}


#if NeedFunctionPrototype
void XswViewerMapSelections(
Widget w,
void (*f)(),
void * d
#else
void
XswViewerMapSelections(w, f, d)
Widget w;
void (*f)();
void * d;
#endif
{
  ViewerWidget vw=(ViewerWidget) w;
  int i, j;
  Boolean no_select;
  Bucket * pointer;
 
  if (vw->viewer.bucket) {
    no_select = NoSelections(vw->viewer.blist, vw->viewer.n_buckets);
    for(j=0; j < vw->viewer.n_buckets; j++) {
      if (vw->viewer.blist[j].state || no_select) {
	pointer = ((Bucket *)vw->viewer.blist[j].pointer)->next;
	while (pointer != NULL) {
	  switch (vw->viewer.show_type) { 
	  case ByProcedures :
	    for(i=0; i < vw->viewer.n_views; i++) {
	      if (vw->viewer.root_type[i] != ThreeD) {
		(*f)(pointer->vPtr, NULL, vw->viewer.data[i], d, vw->viewer.zptr);
	      } else {
		MapOneList(w, Horizontal, pointer->vPtr, f,
                           vw->viewer.data[i], d); 
	      }
	    }
	    break;
	  case ByNodes:
	    for(i=0; i < vw->viewer.n_views; i++) {
	      if (vw->viewer.root_type[i] != ThreeD) {
		(*f)(NULL, pointer->hPtr, vw->viewer.data[i], d, vw->viewer.zptr);
	      } else {
		MapOneList(w, Vertical, pointer->hPtr, f, 
			   vw->viewer.data[i], d);
	      }
	    }
	    break;
	  case Bucket3D:    
	    (*f)(pointer->vPtr, pointer->hPtr, vw->viewer.data[0], d, vw->viewer.zptr);
	    break;
	  }
	  pointer = pointer->next;
	}
      }
    }
  } else {
    
    switch (vw->viewer.show_type) {
    case ByNodes:
      for(i=0; i < vw->viewer.n_views; i++) {
	if (vw->viewer.root_type[i] != ThreeD) {
	  MapOneList(w, Horizontal, NULL, f, vw->viewer.data[i], d);
	} else {
	  MapBothLists(w, f, vw->viewer.data[i], d);
	}
      }
      break;
    case ByProcedures:
      for(i=0; i < vw->viewer.n_views; i++) {
	if (vw->viewer.root_type[i] != ThreeD) {
	  MapOneList(w, Vertical, NULL, f, vw->viewer.data[i], d);
	} else {
	  MapBothLists(w, f, vw->viewer.data[i], d);
	}
      }
      break;
    case ThreeD:
      no_select = True;
      for(j=0; j < vw->viewer.height; j++) {
	for(i=0; i < vw->viewer.width; i++) {
	  if (vw->viewer.state[i + j*vw->viewer.width]) {
	    no_select = False;
	    break;
	  }
	}
      }
      
      for(j=0; j < vw->viewer.height; j++) {
	for(i=0; i < vw->viewer.width; i++) {
	  if (vw->viewer.state[i + j*vw->viewer.width] || no_select)
	  (*f)(vw->viewer.vlist[j].pointer, vw->viewer.hlist[i].pointer,
	       vw->viewer.data[0], d, vw->viewer.zptr);
	}
      }
      break;
    }
  }
  if (vw->viewer.chart_w != NULL) {
    XswChartRedisplay(vw->viewer.chart_w);
  }
}


#if NeedFunctionPrototype
void XswViewerMapSelectedRows(
Widget w,
void (*f)(),
void * d
#else
void 
XswViewerMapSelectedRows(w, f, d)
Widget w;
void (*f)();
void * d;
#endif
{
  ViewerWidget vw=(ViewerWidget) w;
  int i, j;
  Boolean no_select;
  Bucket * pointer;
 
  if (vw->viewer.bucket) {
    no_select = NoSelections(vw->viewer.blist, vw->viewer.n_buckets);
    for(j=0; j < vw->viewer.n_buckets; j++) {
      if (vw->viewer.blist[j].state || no_select) {
	pointer = ((Bucket *)vw->viewer.blist[j].pointer)->next;
	(*f)(pointer, pointer, vw->viewer.data[0], d, vw->viewer.zptr);
      }
    }
  } else {
    switch (vw->viewer.show_type) {
    case ByNodes:
      no_select = True;
      for(i=0; i < vw->viewer.width; i++) {
	if (vw->viewer.hlist[i].state) {
	  no_select = False;
	  break;
	}
      }
      for(i=0; i < vw->viewer.width; i++) 
	if (vw->viewer.hlist[i].state || no_select)
	  (*f)(NULL, vw->viewer.hlist[i], vw->viewer.data[0], d, vw->viewer.zptr);
      break;

      case ByProcedures:
      no_select = True;
      for(i=0; i < vw->viewer.height; i++) {
	if (vw->viewer.vlist[i].state) {
	  no_select = False;
	  break;
	}
      }
      for(i=0; i < vw->viewer.height; i++) 
	if (vw->viewer.vlist[i].state || no_select)
	  (*f)(vw->viewer.vlist[i], NULL, vw->viewer.data[0], d, vw->viewer.zptr);
      break;

    case ThreeD:
      no_select = True;
      for(j=0; j < vw->viewer.height; j++) {
	for(i=0; i < vw->viewer.width; i++) {
	  if (vw->viewer.state[i + j*vw->viewer.width]) {
	    no_select = False;
	    break;
	  }
	}
      }
      
      for(j=0; j < vw->viewer.height; j++) {
	for(i=0; i < vw->viewer.width; i++) {
	  if (vw->viewer.state[i + j*vw->viewer.width] || no_select)
	    (*f)(vw->viewer.vlist[j].pointer, vw->viewer.hlist[i].pointer,
		 vw->viewer.data[0], d, vw->viewer.zptr);
	}
      }
      break;
    }
  }
  if (vw->viewer.chart_w != NULL) {
    XswChartRedisplay(vw->viewer.chart_w);
  }
}

#if NeedFunctionPrototypesOFF
double XswViewerColumnValue(
Widget w,
ListElement *list
)
#else
double XswViewerColumnValue(w, list)
Widget w;
ListElement *list;
#endif
{
  ViewerWidget vw=(ViewerWidget) w;
  double value = 0.0;
  int cnt;

  for(cnt=0; cnt < vw->viewer.n_views; cnt++) {
    value += col_value(vw, list, cnt);
  }

  return value;
}

#if NeedFunctionPrototypesOFF
double XswViewerRowValue(
Widget w,
ListElement *list
)
#else
double 
XswViewerRowValue(w, list)
Widget w;
ListElement *list;
#endif
{
  ViewerWidget vw=(ViewerWidget) w;
  double value = 0.0;
  int cnt;

  for(cnt=0; cnt < vw->viewer.n_views; cnt++) {
    value += row_value(vw, list, cnt);
  }

  return value;
}


/*ARGSUSED*/
#if NeedFunctionPrototypesOFF
double XswViewerBucketValue(
Widget w,
ListElement *list 
)
#else
double 
XswViewerBucketValue(w, list)
Widget w;
ListElement *list;
#endif
{
  ViewerWidget vw=(ViewerWidget) w;
  int value = 0;
  Bucket *pointer;

  for (pointer = (Bucket *) list; pointer != NULL; pointer = pointer->next)
    value++;

  return (double) value;
}

/* Disable and enable making the chart */

void XswViewerDisableViewUpdate()
{ in_make_chart = True; }

void XswViewerEnableViewUpdate()
{ in_make_chart = False;}

#if NeedFunctionPrototypes
void XswViewerUpdateView(
Widget w 
)
#else
void XswViewerUpdateView(w)
Widget w;
#endif
{
ViewerWidget vw= (ViewerWidget) w;

  MakeChart(vw, ViewChange);
} 

#if NeedFunctionPrototypes
void XswViewerSetText(
Widget w,
String text
)
#else
void 
XswViewerSetText(w, text)
Widget w;  /* ViewerWidget */
String text;
#endif
{
  XtVaSetValues(w, XtNtext, XtNewString(text), NULL);
}

#if NeedFunctionPrototypes
int XswViewerSelectedRows(
     Widget w,
     MType mode,
     Boolean ** vPtr,
     int * nPtr 
)
#else
int 
XswViewerSelectedRows(w, mode, vPtr, nPtr)
     Widget w;
     MType mode;
     Boolean ** vPtr;
     int * nPtr;
#endif
{
  ViewerWidget vw=(ViewerWidget) w;
  int i, j;
  int selected = 0;

  *vPtr = (Boolean *)XtMalloc(sizeof(Boolean) * (vw->viewer.height));
  if ((mode == AND) ||
      ((vw->viewer.show_type != ThreeD) &&
       (vw->viewer.show_type != Bucket3D))) {
	for (i = 0; i < vw->viewer.height; i++) {
	  (*vPtr)[i] = vw->viewer.vlist[i].state;
	  if ((*vPtr)[i])
	    selected++;
	  else if (mode == OR) {
	    for(j=0; j < vw->viewer.width; j++) {
	      if (vw->viewer.hlist[j].state) {
		(*vPtr)[i] = True;
		selected++;
	      }
	    }
	  }
	}
      } else {
	for (i = 0; i < vw->viewer.height; i++) {
	  (*vPtr)[i] = False;
	  for(j=0; j < vw->viewer.width; j++) {
	    if (vw->viewer.state[j + i*vw->viewer.width]) {
	      (*vPtr)[i] = True;
	      selected++;
	      break;
	    }
	  }
	}
      }
  
  *nPtr = vw->viewer.height;

  if (selected == 0 && mode == OR) {
    selected = *nPtr;
    for(i=0; i < *nPtr; i++) {
      (*vPtr)[i] = True;
    }
  }
  return selected;
}

#if NeedFunctionPrototypes
int XswViewerSelectedColumns(
     Widget w,
     MType mode,
     Boolean ** vPtr,
     int * nPtr
)
#else
int 
XswViewerSelectedColumns(w, mode, vPtr, nPtr)
     Widget w;
     MType mode;
     Boolean ** vPtr;
     int * nPtr;
#endif
{
  ViewerWidget vw=(ViewerWidget) w;
  int i, j;
  int selected = 0;

  *vPtr = (Boolean *)XtMalloc(sizeof(Boolean) * (vw->viewer.width));
  if ((mode == AND) ||
      ((vw->viewer.show_type != ThreeD) &&
       (vw->viewer.show_type != Bucket3D))) {
	for (i = 0; i < vw->viewer.width; i++) {
	  (*vPtr)[i] = vw->viewer.hlist[i].state;
	  if ((*vPtr)[i])
	    selected++;
	  else if (mode == OR) {
	    for(j=0; j < vw->viewer.height; j++) {
	      if (vw->viewer.vlist[j].state) {
		(*vPtr)[i] = True;
		selected++;
	      }
	    }
	  }
	}
      } else {
	for (i = 0; i < vw->viewer.width; i++) {
	  (*vPtr)[i] = False;
	  for(j=0; j < vw->viewer.height; j++) {
	    if (vw->viewer.state[i + j*vw->viewer.width]) {
	      (*vPtr)[i] = True;
	      selected++;
	      break;
	    }
	  }
	}
      }
  
  *nPtr = vw->viewer.width;

  if (selected == 0 && mode == OR) {
    selected = *nPtr;
    for(i=0; i < *nPtr; i++) {
      (*vPtr)[i] = True;
    }
  }
  return selected;
}
