#if ( !defined(lint) && !defined(SABER))
  static char PCN_rcsid[] = "$Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Model/Gauge/RCS/ViewMenu.c,v 1.1 1992/04/17 18:16:34 mei Exp $";
#endif

/* AERO_MESG */

#include <Xsw/Xsw.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

#include <Xsw/Count.h>
#include <Xsw/Chart.h>
#include "Viewer.h"

typedef struct {
  String title;
  StringList data;
  VTypeList type;
  PixelList colors;
  PatternList patterns;
  Widget vw; 
} ViewData, *ViewDataPtr;
 
/* ARGSUSED */
static void
select_view(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
  ViewDataPtr pointer = (ViewDataPtr)client_data;
  Widget radio_view;

  XtVaSetValues(pointer->vw, XtNtitle,pointer->title, 
		XtNdata, pointer->data, 
		XtNrootType, pointer->type, NULL);
  XtVaSetValues(XswViewerChartWidget(pointer->vw), 
		XtNcolors, pointer->colors, 
		XtNpatterns, pointer->patterns, NULL);
  XtVaGetValues(pointer->vw, XtNradioView, &radio_view, NULL);
  if (radio_view != NULL)
    XtCallCallbacks(radio_view, XtNcallback, NULL);
}

void 
CreateViewMenu(w, name, currdata)
Widget w;
char * name;
StringList currdata;
{
  static XtResource view_resources[] = {
    { "title", "Title", XtRString, sizeof(String),
	XtOffset(ViewDataPtr, title), XtRString, "View" },
    { "data", "Data", XtRStringList, sizeof (StringList), 
	XtOffset(ViewDataPtr, data), XtRString, "Time" },
    { "type", "Type", XtRVTypeList, sizeof (VTypeList), 
	XtOffset(ViewDataPtr, type), XtRString, "ThreeD" },
    { "colors", "Colors", XtRPixelList, sizeof (PixelList), 
	XtOffset(ViewDataPtr, colors), XtRString, "black" },
    { "patterns", "Patterns", XtRPatternList, sizeof (PatternList), 
	XtOffset(ViewDataPtr, patterns), XtRString, "solid" },
  };

  ViewDataPtr * view;
  Widget null_w, menu_w;
  Arg wargs[3];
  int n, i;
  ViewData data;
  char name1[30];
  ViewDataPtr pointer;
  CountData c_data;  
  
  menu_w = XtCreatePopupShell(name, simpleMenuWidgetClass, 
			      XtParent(w), NULL, 0);
  
  XtGetApplicationResources(menu_w, &c_data, cnt_resources, 
			    XtNumber(cnt_resources), NULL, 0);

  null_w = XtCreateManagedWidget(name,
				 smeLineObjectClass,
				 menu_w, NULL, 0);

  view = (ViewDataPtr *)XtCalloc(c_data.count, sizeof(ViewDataPtr));

  if (c_data.count <= 0) c_data.count = 1;
  for(i = 1; i <= c_data.count; i++) {
    sprintf((char *)name1, "view%d", i);
    null_w = XtCreateManagedWidget(name1,
				   smeBSBObjectClass,
        		           menu_w, wargs, 0);
    XtGetApplicationResources(null_w, &data, view_resources, 
			      XtNumber(view_resources), NULL, 0);
    XtSetArg(wargs[0], XtNlabel, data.title);
    pointer = (ViewDataPtr)XtMalloc(sizeof(ViewData));
    view[i-1] = pointer;
    XtSetValues(null_w, wargs, 1);
    pointer->title = data.title;
    pointer->data = data.data;
    pointer->type = data.type;
    pointer->colors = data.colors;
    pointer->patterns = data.patterns;
    pointer->vw = w;
    XtAddCallback(null_w, XtNcallback, select_view, (XtPointer)pointer);
  }

  n = 0;
  if (currdata != NULL) {
    while (n < c_data.count) {
      i = 0; 
      while (currdata[i] != NULL && view[n]->data[i] != NULL &&
	     (! strcmp(currdata[i],view[n]->data[i])))
	i++;
      if (currdata[i] != NULL || view[n]->data[i] != NULL)
	n++;
      else
	break;
    }
  }
  select_view((Widget)NULL, (XtPointer)view[n], (XtPointer)NULL);
}


