
/********************************************************/
/* File: RangeP.h                                       */
/* Content: Private definitions for Range Widget        */
/*   for selecting a range on a scaled color bar        */
/* Date: 3/1992                                         */
/********************************************************/

#ifndef _XawRangeP_h
#define _XawRangeP_h

/********************************************************/
/* Range Widget's Private Data                          */
/********************************************************/

#include "Range.h"
#include <X11/Xaw/FormP.h>

/* New fields for the Range widget class record */

typedef struct {int foo;} RangeClassPart;

/* Full class record declaration */
typedef struct _RangeClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    FormClassPart       form_class;
    RangeClassPart      range_class;
} RangeClassRec;

extern RangeClassRec rangeClassRec;

typedef struct {
    double max,min; /* min and max values select to be saved */
} RangeSave;

/* New fields for the Range widget record */
typedef struct {
    /* resources */
    XtCallbackList  set_range_callback;
    XtCallbackList  reset_range_callback;
    XtCallbackList  clear_set_range_callback;
    XtCallbackList  pop_down_range_callback;
    int  bar_blocks;  /* number of different blocks in scrollRange */
    int  bar_height;  /* height of the scrollRange scrollbar */
    double  topbound;    /* top of the range bound */
    double  bottombound; /* bottom of the range bound */
    Boolean   *states;
    double    *cells;
    String    palette;
    double calcMax, /* what is actually used to calculate view*/
           calcMin; 
    double saveMax, /* initial values for view calc from database */
           saveMin; 
    Boolean   isLog;

    /* private state */
    int       topcurpos;     /* Current thumb pos of top bar */
    int       bottomcurpos;  /* current thumb pos of bottom bar */
    float     thumb_width;   /* thumb width of the scrollbar */
    int       last_pos;      /* last biggest possible thumb position */
    RangeSave save;
    Widget    info;          /* explanation label widget */
    Widget    colorBar;      /* color bar - a chart widget */
    Widget    topRange;      /* top's Range scrollbar */
    Widget    bottomRange;   /* bottom's Range scrollbar */
    Widget    selectApply;   /* range select button */
    Widget    selectSave;    /* range save button */
    Widget    selectRestore; /* restore saved data */
    Widget    selectReset;   /* range reset button */
    Widget    selectQuit;    /* range quit button */
    Widget    topLabel;
    Widget    topVal;
    Widget    bottomLabel;
    Widget    bottomVal;

} RangePart;


/********************************************************/
/* Full instance record declaration                     */
/********************************************************/

typedef struct _RangeRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    FormPart            form;
    RangePart           range;
} RangeRec;

typedef struct {
   /* resources */
   /* private state */
   Boolean reparented;
} RangeConstraintsPart;

typedef struct {
   FormConstraintsPart     form;
   RangeConstraintsPart    range;
}RangeConstraintsRec, *RangeConstraints;

#endif /* _XawRangeP_h */
