
	% handles I/O streams for object oriented NU-Prolog
	% calls must wait for input

	% execute goal with I/O streams to terminal
execute(Goal, I, O) :-
	out_stream(O),
	call(Goal),
	in_stream(I).

	% write stream of chars to current output
?- out_stream([]) when ever.
?- out_stream(C.S) when C.
out_stream([]).
out_stream(C.S) :-
	put(C),
	out_stream(S).

	% read stream of chars from current input
in_stream(S) :-
	get0(C),
	( C = -1 ->
		S = []
	;
		S = C.S1,
		in_stream(S1)
	).
