% Just a prolog file for the tables
table(0, 0) :- !.
table(1, 1) :- !.
table(2, 0) :- !.
table(3, 0) :- !.
table(4, 1) :- !.
table(5, 0) :- !.
%table(6, 1) :- !.
% If none of the above are suitable set to 0
% The above assumes that there are 3 possible states
% i.e 0, 1, 2
table(_, 0).

% Calculate next state given neighbours state and own
next_state(State, Neighb, NewState) :-
	sum([State | Neighb], 0, Sum),
	table(Sum, NewState).

% Just s imple sum
sum([], Sum, Sum).

sum([A | As], N, Sum) :-
	N2 is N + A,
	sum(As, N2, Sum).
