%Copyright (C) The University of Melbourne 1993
%All Rights Reserved

%Permission to use, copy, modify, and distribute this software and
%its documentation for any purpose and without fee is hereby
%granted, provided that the above copyright notice appear in all
%copies and that both that the copyright notice and this
%permission notice and warranty disclaimer appear in supporting
%documentation, and that the name of The University of Melbourne 
%or any of its entities not be used in advertising or publicity
%pertaining to distribution of the software without specific,
%written prior permission.

%THE UNIVERSITY OF MELBOURNE DISCLAIMS ALL WARRANTIES WITH REGARD
%TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
%MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY
%OF MELBOURNE OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
%SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
%WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
%IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
%THIS SOFTWARE.

%AUTHORS : Jason Lee (jasonl@cs.mu.oz.au)
%	   Andrew Davison (ad@cs.mu.oz.au)

%   Comments :
%	This file contains the prolog definitions of $bb_send/4 and
%	$bb_create_id/3.
%	$bb_send adds the message for id to the input list of id. It
%	delays until the id is ground and any constraints the user
%	has are ground also.
%	$bb_create_id creates an input list and unique id to represent
%	the class.
%	NOTE : the shared variable called BB$_Mesg is a list of all
%	input lists for all classes called directly (not via i_am
%	calls as these are handle a special way), thus $bb_send and
%	$bb_create_id manipulate this list.


% send a message to a class (id) only when constraints are ground
% and when ID is ground, i.e we know which class to send the message to.
% If no such class with ID print error message.
?-$bb_send(_, ID, _, Constraints) when ground(Constraints) and ground(ID).
$bb_send(BB$_Mesg, ID, Mesg, Const) :-
	$bb_add_in(Mesg, ID, BB$_Mesg, Ok),
	( Ok = error ->
	     write(user_error, 'Bebop : no object with id '),
	     write(user_error, ID),
	     write(user_error, ' to send message '),
	     write(user_error, Mesg),
	     writeln(user_error, ' to, so message discarded.'),
	     nl(user_error),
	     flushOutput(user_error)
	).

% Find input list for id so as to add message to it
% If can't find it and at end then there is an error.
$bb_add_in(Mesg, ID, BB$_Mesg, Ok) :-
	var(BB$_Mesg),
	Ok = error.

$bb_add_in(Mesg, ID, BB$_Mesg, Ok) :-
	nonvar(BB$_Mesg),
	BB$_Mesg = [id(Iid, Input) | Rs],
	(Iid = ID ->
		$bb_add_mesg(Mesg, Input),
		Ok = ok
	;
		$bb_add_in(Mesg, ID, Rs, Ok)
	).

% Found input list for id so add message to end of it
$bb_add_mesg(Mesg, Input) :-
	var(Input),
	% If multiple messages at one at a time
	(nonvar(Mesg), Mesg = (M1, MRst) ->
		Input = [M1, InputRst],
		$bb_add_mesg(MRst, InputRst)
	;
		Input = [Mesg | _ ]
	).

$bb_add_mesg(Mesg, Input) :-
	nonvar(Input),
	Input = [_ | Ins],
	$bb_add_mesg(Mesg, Ins).

% Add a new input list with a new id to BB$_Mesg list
$bb_create_id(BB$_Mesg, ID, Input) :-
	var(BB$_Mesg),
	BB$_Mesg = [id(ID, Input) | _],
	ID = 1.

$bb_create_id(BB$_Mesg, ID, Input) :-
	nonvar(BB$_Mesg),
	BB$_Mesg = [_ | Ms],
	$bb_create_id_new(Ms, ID, Input, 1).

$bb_create_id_new(BB$_Mesg, ID, Input, N) :-
	var(BB$_Mesg),
	BB$_Mesg = [id(ID, Input) | _],
	ID is N + 1.

$bb_create_id_new(BB$_Mesg, ID, Input, N) :-
	nonvar(BB$_Mesg),
	N2 is N + 1,
	BB$_Mesg = [_ | Ms],
	$bb_create_id_new(Ms, ID, Input, N2).

% end of send

