%Copyright (C) The University of Melbourne 1993
%All Rights Reserved

%Permission to use, copy, modify, and distribute this software and
%its documentation for any purpose and without fee is hereby
%granted, provided that the above copyright notice appear in all
%copies and that both that the copyright notice and this
%permission notice and warranty disclaimer appear in supporting
%documentation, and that the name of The University of Melbourne 
%or any of its entities not be used in advertising or publicity
%pertaining to distribution of the software without specific,
%written prior permission.

%THE UNIVERSITY OF MELBOURNE DISCLAIMS ALL WARRANTIES WITH REGARD
%TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
%MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY
%OF MELBOURNE OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
%SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
%WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
%IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
%THIS SOFTWARE.

%AUTHORS : Jason Lee (jasonl@cs.mu.oz.au)
%	   Andrew Davison (ad@cs.mu.oz.au)


%   Comments :
% load in files, possible bebop files or prolog files.
% Assume if have no ending like ".nl" that they are bebop files
% And compile then load.
$loadfiles([]).

$loadfiles([File | Fs]) :-
	(ground(File)  ->
		(File = [Name | Suffix] ->
			atomToString(Name, StrName),
			atomToString(Suffix, StrSuffix),
			append(".", StrSuffix, NSuffix),
			append(StrName, NSuffix, StrFile)
		 ;
			atomToString(File, StrFile)
		),
		((append(_, ".nl", StrFile) ; append(_, ".no", StrFile)) -> 
			$loadProlog(StrFile)
		 ;
			$basename(StrFile, FileName, BFile),
			(open(FileName, read, _) ->
				% assume compiler in user paths
				append("bebop -w ", BFile, Compile),
				($lcompile(Compile, true) ->
					(load(BFile) ->
						write('Bebop file '),
						write(FileName),
						writeln(' successfully loaded')
		 			;
						write('Bebop file '),
						write(FileName),
						writeln(' unsuccessfully loaded')
					),
					nl,
					flushOutput(user)
				)
			 ;
				write(user_error, 'Bebop : no file called '),
				write(user_error, StrFile),
				writeln(user_error, ' assuming it is an ordinary prolog file.'),
				nl(user_error),
				flushOutput(user_error),
				$loadProlog(StrFile)
			)
		)
	 ;
		writeln(user_error,'Bebop : load files needs ground file name, that is an atom'),
		nl(user_error),
		flushOutput(user_error)
	),
	$loadfiles(Fs).


% Gets Name of file i.e "file.bp" and the basename "file"
$basename(StrFile, FileName, BFile) :-
	append(BFile, ".bp", StrFile),
	FileName = StrFile.

$basename(StrFile, FileName, StrFile) :-
	append(StrFile, ".bp", FileName).

% call system to compile the file 
% Fails if compililation failed.
$lcompile(Command, Status) :-
	system(Command, 0),
	Status = true.


% just load in oridinary prolog file
$loadProlog(File) :-
	(load(File) ->
		write('Prolog file '),
		write(File),
		writeln(' successfully loaded')
 	;
		write('Prolog file '),
		write(File),
		writeln(' unsuccessfully loaded')
	),
	nl,
	flushOutput(user).

