/*	(C)1992 Institute for New Generation Computer Technology
	(Read COPYRIGHT for detailed information.)
*/
/*=====================================================================
*		cu-Prolog III (Constraint Unification Prolog)
*   Copyright: Institute for New Generation Computer Technology,Japan 
*                           1989--91
==================================================================== */
/*--------------------------------------------------------------------
*		<< UNIFY.C >>		
*		safe/unsafe/PST unification 
--------------------------------------------------------------------*/

#include "include.h"
jmp_buf ufail;			/* unification fail */

#define Npstobj(Head,Env,Tail,Flag)  Neclause(Head,Env,Tail,Flag)
#define UNSAFE 0
#define SAFE 1
#define NOEXTRACT 2
#define EXTRACT 3
int Ocheck_max;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  int tunify(t,e,u,f,flag)
    term unification between (t,e) and (u,f)    
    flag = 0: unsafe
           1: safe, no extract
           2: safe, extract
  return_value --> TRUE/FALSE
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int tunify(t,e,u,f,flag)	/* term unification entry */
register struct term *t, *u;
register struct pair *e, *f;
int flag;     /* 1:safe no-extract, 2:safe extract, 0:unsafe */
{
	struct ustack *usave = usp;
	int  *hsave = hp;
	struct pair *esave = ep;

	Ocheck_max = 0;
	if (setjmp(ufail))
	{
		undo(usave);
		hp = hsave;
		ep = esave;
		return(FALSE);
	}
	if (flag == 1)
		safe_unify(t,e,u,f,NOEXTRACT);
	else if (flag == 2)
		safe_unify(t,e,u,f,EXTRACT);
	else 
		unify(t,e,u,f);
	return(TRUE);
}

void ocheck(p, t, e)		/* occur check of normal unification      */
/* check if var p is contained in (t,e)   */
register struct pair *p;	/* var */
register struct term *t;
register struct pair *e;
{
  register struct pair *q;
  register int i, j;

  if (Ocheck_max++ > 50) longjmp(ufail,1); /* in case of infinite loop */
/*  printf("ocheck ");
  Pterm(p->p_body, p->p_env);
  printf(" in ");
  Pterm(t,e);
  NL;*/
  
  if (t == NULL) return;
  down(q, t, e);

  if (q != NULL) {	/* if t is var  */
    if (p == q)	/*  occured !!  ==> fail */
      longjmp(ufail, 1);
    else
      return;
  }

  switch (t->type.ident) {
    case ATOMIC_TYPE:
    case CONST_LIST_TYPE:
        return;
    case LIST_TYPE:
    case CLAUSE_TYPE:
	ocheck(p,head_of_list(t),e);
	ocheck(p,tail_of_list(t),e);
	return;
    case PST_TYPE: { /* pst */
	struct eclause *ptt;
	struct pst_item *item;
	if ((item = find_pstitem(t,e)) == (struct pst_item *)NULL) {
		ptt = ((struct pst *)t)->p_lists;
		while (ptt != (struct eclause *)NULL) {
			t = Arg2(ptt->c_form);
			ocheck(p,t,e);
			ptt = ptt->c_link;
		}
	}
	else {
	    ptt = item->p_lists;
	    while (ptt != (struct eclause *)NULL) {
	    t = Arg2(ptt->c_form);
	    e = ptt->c_env;
	    ocheck(p, t, e);
	    ptt=ptt->c_link;
	   }
	}
	return;
      }
     default: /* functor */
	for(i = 0, j = t->t_arity;  i < j;  i++)
	      ocheck(p, Arg(t,i), e);
      }
}

void unify(t, e, u, f)
register struct term *t, *u;
register struct pair *e, *f;
{
	register struct pair *p, *q;
	int i, j;

/*	printf("unify:");
	Pterm(t,e);
	printf(" and ");
	Pterm(u,f);
	NL; */
	
	down(p, t, e);
	down(q, u, f);
	if(p != NULL)		/* if t = var */
	  if (p==Anonymous_env) return;  /* if t = Anonymous Var */
	  else if(q != NULL)		/* t:var, u:var */
		if(p == q) /* t,u : the same var */
			return;
		else if (q==Anonymous_env) /* u : Anonymous Var */
			return;
		else {
			upush(&(p->p_body)); /* t->u */
			upush(&(p->p_env));
			p->p_body = u;
			p->p_env = f;
			return;
		}
		else {			/* t:var, u:non-var */
			upush(&(p->p_body)); /* t->u */
			upush(&(p->p_env));
			p->p_body = u;
			p->p_env = f;
			return;
		}
	  else if(q != NULL) 
		if (q==Anonymous_env) return;
		else {		/*  t:nonvar , u:var  */
			upush(&(q->p_body)); /* u->t */
			upush(&(q->p_env));
			q->p_body = t;
			q->p_env = e;
			return;
        		}
	/* t,u : nonvar */

	switch (u->type.ident) {
	case ATOMIC_TYPE : /* t,u: atomic (string,num,quote) */
	  {
	    if ((t==u) || (atomic_equal(u,t))) return;
	    else longjmp(ufail,1);
	  }
	case LIST_TYPE:
	case CONST_LIST_TYPE:
		if (is_list(t)) {
			unify(head_of_list(t),e,head_of_list(u),f);
			unify(tail_of_list(t),e,tail_of_list(u),f);
			return;
		      }
		longjmp(ufail,1);
	case CLAUSE_TYPE:
	  if (is_clause(t)) {
		while ((t != NULL) && (u != NULL)) {
		  unify(((struct clause *)t)->c_form,e,
		  	((struct clause *)u)->c_form,f);
		  t=(struct term *)((struct clause *)t)->c_link;
		  u=(struct term *)((struct clause *)u)->c_link;
		}
		if (t == u) return;
	      }
	  longjmp(ufail, 1);
	case PST_TYPE:
	  if (is_pst(t)) {
	    pst_unify(t,e,u,f,UNSAFE);
	    return;
	  }
	  longjmp(ufail, 1);
        default : /* functor */
	  if(Pred(t) == Pred(u)) {/* t,u: complex term */
	    for(i = 0, j = Pred(t)->f_arity;  i < j;  i++)
	      unify(Arg(t,i), e, Arg(u,i), f); 
	    /* unify each arg */
	    return;
	  }
	  longjmp(ufail,1);
	}
}


void unify_pst_extract();

void safe_unify(t, e, u, f, extflag)	/* unify with occur check */
register struct term *t, *u;
register struct pair *e, *f;
int extflag;			/* NOEXTRACT or EXTRACT */
{
  register struct pair *p, *q;
  int i, j;

/*  printf("safe_unify ");
  Pterm(t,e);
  printf(" and ");
  Pterm(u,f);
  NL; */
  
  down(p, t, e);
  down(q, u, f);
  if(p != NULL)			/* if t = var */
    if (p==Anonymous_env) return;  /* if t = Anonymous Var */
    else if(q != NULL)		/* t:var, u:var */
      if(p == q) /* t,u : the same var */
	return;
      else if (q==Anonymous_env) /* u : Anonymous Var */
	return;
      else {
	upush(&(p->p_body)); /* t->u */
	upush(&(p->p_env));
	p->p_body = u;
	p->p_env = f;
	return;
      }
    else {			/* t:var, u:non-var */
      ocheck(p,u,f);
      upush(&(p->p_body)); /* t->u */
      upush(&(p->p_env));
      p->p_body = u;
      p->p_env = f;
      return;
    }
  else if(q != NULL) 
    if (q==Anonymous_env) return;
    else {		/*  t:nonvar , u:var  */
      ocheck(q,t,e);
      upush(&(q->p_body)); /* u->t */
      upush(&(q->p_env));
      q->p_body = t;
      q->p_env = e;
      return;
    }
  /* t,u : nonvar */
  switch (u->type.ident) {
  case ATOMIC_TYPE : /* t,u: atomic (string,num,quote) */
    {
      if ((t==u) || (atomic_equal(u,t))) return;
      else longjmp(ufail,1);
    }
  case LIST_TYPE:
  case CONST_LIST_TYPE:
    if (is_list(t)) {
      safe_unify(head_of_list(t),e,head_of_list(u),f,extflag);
      safe_unify(tail_of_list(t),e,tail_of_list(u),f,extflag);
      return;
    }
    longjmp(ufail,1);
  case CLAUSE_TYPE:
    if (is_clause(t)) {
      while ((t != NULL) && (u != NULL)) {
	safe_unify(((struct clause *)t)->c_form,e,
		   ((struct clause *)u)->c_form,f,extflag);
	t=(struct term *)((struct clause *)t)->c_link;
	u=(struct term *)((struct clause *)u)->c_link;
      }
      if (t == u) return;
    }
    longjmp(ufail, 1);
  case PST_TYPE:
    if (is_pst(t)) {
/*	    if (extflag == NOEXTRACT) */
		    pst_unify(t,e,u,f,SAFE);
/*	    else 
		    unify_pst_extract(t,e,u,f); */
	    return;
    }
    else longjmp(ufail, 1);
  default : /* functor */
    if(Pred(t) == Pred(u)) {/* t,u: complex term */
      for(i = 0, j = Pred(t)->f_arity;  i < j;  i++)
	safe_unify(Arg(t,i), e, Arg(u,i), f,extflag); 
      /* unify each arg */
      return;
    }
    longjmp(ufail,1);
  }
}

struct pst_item *remove_pstitem(t,e)
struct term *t;
struct pair *e;
{
  struct pst_item *object, *target;
  struct pair *p;

  down(p,t,e);
  target = psttable;
  while ((object = target->p_link) != (struct pst_item *)NULL) {
    if (object->p_var == p) {
      upush(&(target->p_link));
      target->p_link = object->p_link;
      return(object);
    }
    target = object;
  }
  return(object);
}

void pst_unify(t,e,u,f,safeflag)
register struct term *t,*u;
register struct pair *e,*f;
int safeflag;			/* SAFE or UNSAFE */
{
  struct pst_item *target, *object;

/*  printf("pst_unify %d ",safeflag);
  Pterm(t,e);
  printf(" and ");
  Pterm(u,f);
  printf(" ---> ");
*/  
  target = find_pstitem(t,e);
  if (target != (struct pst_item *)NULL) { 
    object = remove_pstitem(u,f);
    if (object != (struct pst_item *)NULL) 
    {
	/*    printf("case1."); */
	    unify_merge_psts(target,object->p_lists,safeflag);
    }
    else {
	/*    printf("case2."); */
	    unify_pstlist_objects(target,((struct pst *)u)->p_lists, f,safeflag);
    }
    }
  else {
    object = find_pstitem(u,f);
    if (object != (struct pst_item *)NULL)
    {
	/*    printf("case3."); */
	    unify_pstlist_objects(object,((struct pst *)t)->p_lists, e, safeflag);
    }
    else {
	/*    printf("case4."); */
      target = record_pstobjects((struct pst *)t,e);
      unify_pstlist_objects(target,((struct pst *)u)->p_lists, f, safeflag);
    }
  }
	  unify(((struct pst *)u)->p_var,f,((struct pst *)t)->p_var,e); 
/*  Pterm(t,e);  NL; */
  
}

void unify_pst_extract(t,e,u,f)	/* safe, extract pst unification */
struct pst *t,*u;		/* t may be changed */
struct pair *e,*f;
{
	struct pst_item *object,*target;
	struct eclause *nttbegin,*ntt,*ot,*tt;
	int i;

	target = find_pstitem(t,e);
	object = find_pstitem(u,f);
	if (target == (struct pst_item *)NULL)
		target = record_pstobjects((struct pst *)t,e);
	if (object == (struct pst_item *)NULL) 
		object = record_pstobjects((struct pst *)u,f);
	nttbegin=(struct eclause *)NULL;
	for(ot=object->p_lists,tt=target->p_lists; ((ot!=NULL) && (tt!=NULL));)
	{
		i = Pred(Arg1(tt->c_form))->f_number - 
			Pred(Arg1(ot->c_form))->f_number;
		if (i == 0)
		{
			safe_unify(tt->c_form,e,ot->c_form,f,1);
			tt = tt->c_link;
			ot = ot->c_link;
		}
		else if (i < 0) tt = tt->c_link;
		else
		{
			if (nttbegin==NULL) nttbegin=ntt=ot;
			else {
				upush(&(ntt->c_link));
				ntt->c_link = ot;
				ntt = ot;
			}
			ot = ot->c_link;
		}
	}
	if (nttbegin != NULL) {
		upush(&(ntt->c_link));
		ntt->c_link = ot;
	}
	else nttbegin = ot;
	upush(&(target->p_lists));
	target->p_lists = nttbegin;
}

struct pst_item *record_pstobjects(t,e)
struct pst *t;
struct pair *e;
{
  struct pst_item *entry = psttable;
  struct term *tt = t->p_var;
  struct pair *p;

 down(p,tt,e);

 while(entry->p_link != (struct pst_item *)NULL) {
    if (p > entry->p_link->p_var) break;
    entry = entry->p_link;
   }
  upush(&(entry->p_link));
  entry->p_link = (struct pst_item *)
    Npst_item(p,(struct eclause *)NULL,entry->p_link);
  entry = entry->p_link;
  entry->p_lists = record_pstlists(t->p_lists,e);
  return(entry);
}

struct eclause *record_pstlists(ptt,e)
struct eclause *ptt;
struct pair *e;
{
  struct eclause *props, *pre;

  if (ptt == (struct eclause *)NULL) return(ptt);
  pre = props = Npstobj(ptt->c_form, e, (struct eclause *)NULL, MEDIUM);
  for (ptt = ptt->c_link; ptt != (struct eclause *)NULL; ) {
    props->c_link =
      Npstobj(ptt->c_form, e, (struct eclause *)NULL, MEDIUM);
    props = props->c_link;
    ptt = ptt->c_link;
   }
  return(pre);
}

void unify_pstlist_objects(entry, ol, e, safeflag)
struct pst_item *entry;
struct eclause *ol;
struct pair *e;
int safeflag;			/* SAFE or UNSAFE */
{
  int i, fnum;
  struct eclause *pl;

  if (ol==(struct eclause *)NULL) return;

  pl=entry->p_lists; /* pl must NOT be NULL */

/*  printf("unify_pstlist_obj ");
  Peclause(pl);
  printf(" -- ");
  Peclause(ol);
  NL;
*/
  
  if (pl == (struct eclause *)NULL) {
    upush(&(entry->p_lists));
    entry->p_lists=record_pstlists(ol,e);
    return;
  }

  i = Pred(Arg1(pl->c_form))->f_number - Pred(Arg1(ol->c_form))->f_number;
  if (i == 0) {
	  if (safeflag == UNSAFE)
		  unify(pl->c_form,pl->c_env,ol->c_form,e);
	  else
		  safe_unify(pl->c_form,pl->c_env,ol->c_form,e,NOEXTRACT);
	  ol=ol->c_link;
  }
  else if (i > 0) {
    upush(&(entry->p_lists));
    entry->p_lists = Npstobj(ol->c_form,e,pl,MEDIUM);
    ol = ol->c_link;
    pl=entry->p_lists;
  }
 /*  else  goes on */

  while (ol != (struct eclause *)NULL) {
    fnum = Pred(Arg1(ol->c_form))->f_number;
    while (pl->c_link != (struct eclause *)NULL) {
     i = Pred(Arg1(pl->c_link->c_form))->f_number - fnum;
     if (i == 0) {
	     if (safeflag== UNSAFE)
		     unify(pl->c_link->c_form,pl->c_link->c_env,ol->c_form,e);
	     else
		     safe_unify(pl->c_link->c_form,
				pl->c_link->c_env,ol->c_form,e,NOEXTRACT);
	     break;
     }
     else if (i > 0) {
       upush(&(pl->c_link));
       pl->c_link = Npstobj(ol->c_form,e,pl->c_link,MEDIUM);
       break;
     }
     pl = pl->c_link;
   }

   if (pl->c_link == (struct eclause *)NULL) {
        upush(&(pl->c_link));
        pl->c_link = record_pstlists(ol,e);
        break;
      }
   else pl=pl->c_link;
   ol = ol->c_link;
  }
}


void unify_merge_psts(target,object,safeflag)
struct pst_item *target;
struct eclause *object;
int safeflag;			/* SAFE or UNSAFE */
{
  int i, fnum;
  struct eclause *next, *pl;

  if (object==(struct eclause *)NULL) return;

  pl=target->p_lists;
  
  if (pl == (struct eclause *)NULL) {
    upush(&(target->p_lists));
    target->p_lists = object;
    return;
  }

  i = Pred(Arg1(pl->c_form))->f_number - Pred(Arg1(object->c_form))->f_number;
  if (i == 0) {
	  if (safeflag == UNSAFE)
		  unify(pl->c_form,pl->c_env,object->c_form,object->c_env);
	  else 
		  safe_unify(pl->c_form,pl->c_env,
			     object->c_form,object->c_env,EXTRACT);
	  object=object->c_link;
  }
  else if (i < 0) {
    upush(&(target->p_lists));
    target->p_lists =
      Npstobj(object->c_form,object->c_env,pl,MEDIUM);
    object = object->c_link;
    pl = target->p_lists;
  }
 /* else goes on */

  while (object != (struct eclause *)NULL) {
    fnum = Pred(Arg1(object->c_form))->f_number;
    while (pl->c_link != (struct eclause *)NULL) {
      i = Pred(Arg1(pl->c_link->c_form))->f_number - fnum;
      if (i == 0) {
	      if (safeflag == UNSAFE)
		      unify(pl->c_link->c_form,pl->c_link->c_env,
			    object->c_form,object->c_env);
	      else
		      safe_unify(pl->c_link->c_form,pl->c_link->c_env,
			    object->c_form,object->c_env,NOEXTRACT);
	      break;
       }
      else if (i > 0) {
	next=pl->c_link;
	upush(&(pl->c_link));
	pl->c_link = object;
	upush(&(object->c_link));
	object->c_link = next;
	break;
	}
     pl=pl->c_link;
    }
   if (pl->c_link == (struct eclause *)NULL) {
	upush(&(pl->c_link));
	pl->c_link = object;
	return;
      }
   else pl=pl->c_link;
   object = object->c_link;
  }
}

struct pair *env(t,e)		/* from merge_pst_objects */
struct eclause *t;
struct pair *e;
{
	if (e==NULL) return(t->c_env);
	else return(e);
}

struct eclause *merge_pst_objects(target,e,object,f,safeflag)
struct eclause *target,*object;
struct pair *e,*f;
int safeflag;			/* SAFE or UNSAFE */
{
	struct eclause *t,*o,*ntbegin=NULL,*nt;
	int i;
	
	if (target == NULL) return(object);
	if (object == NULL) return(target);
	for(t=target,o=object; ((t!=NULL) && (o!=NULL)); )
	{
		i = Pred(Arg1(t->c_form))->f_number -
			Pred(Arg1(o->c_form))->f_number;
		if (i == 0)	/* same label */
		{
			if(safeflag==UNSAFE)
				unify(t->c_form,env(t,e),o->c_form,env(o,f));
			else
				safe_unify(t->c_form,env(t,e),
				      o->c_form,env(o,f),NOEXTRACT);
			if (ntbegin == NULL)  ntbegin=nt=
				   Npstobj(t->c_form,env(t,e),NULL,MEDIUM);
			else  nt->c_link = 
				   Npstobj(t->c_form,env(t,e),NULL,MEDIUM);
			t = t->c_link;
			o = o->c_link;
		}
		else if (i < 0)	/* t < o */
		{
			if (ntbegin == NULL)  ntbegin=nt=
				   Npstobj(t->c_form,env(t,e),NULL,MEDIUM);
			else  nt->c_link = 
				   Npstobj(t->c_form,env(t,e),NULL,MEDIUM);
			t = t->c_link;
		}
		else		/* t > o */
		{
			if (ntbegin == NULL)  ntbegin=nt=
				   Npstobj(o->c_form,env(o,e),NULL,MEDIUM);
			else  nt->c_link = 
				   Npstobj(o->c_form,env(o,e),NULL,MEDIUM);
			o = o->c_link;
		}
	}
	if (t != NULL) nt->c_link = t;
	else if (o != NULL) nt->c_link = o;
	return(ntbegin);
}
