/*
*
*
*		cu-Prolog (Constraint Unification Prolog)
*
*   Copyright: Institute for New Generation Computer Technology,Japan 1989
*
*		<< UNIFY.C >>		
*
*		normal unification 
* 88/6/9
* 90.4.1 ver 3.0
* 90.7.1 ver 3.10
*/

#include "include.h"
jmp_buf ufail;			/* unification fail */

int tunify(t,e,u,f,flag)	/* term unification entry */
register struct term *t, *u;
register struct pair *e, *f;
int flag;			/* 1: safe-unify, else unsafe-unify */
{
	struct ustack *usave = usp;
	long int *hsave = hp;
	struct pair *esave = ep;

	if (setjmp(ufail))
	{
		undo(usave);
		hp = hsave;
		ep = esave;
		return(FALSE);
	}
	if (flag == 1)
		safe_unify(t,e,u,f);
	else
		unify(t,e,u,f);
	return(TRUE);
}

void ocheck(p, t, e)		/* occur check of normal unification      */
/* check if var p is contained in (t,e)   */
register struct pair *p;	/* var */
register struct term *t;
register struct pair *e;
{
  register struct pair *q;
  register int i, j;

  if (t == NULL) return;
  down(q, t, e);

  if (q != NULL) {	/* if t is var  */
    if (p == q)	/*  occured !!  ==> fail */
      longjmp(ufail, 1);
    else
      return;
  }

  switch ((int)t->type.ident) {
    case ATOMIC_TYPE:
    case CONST_LIST_TYPE:
        return;
    case LIST_TYPE:
    case CLAUSE_TYPE:
	ocheck(p,head_of_list(t),e);
	ocheck(p,tail_of_list(t),e);
	return;
    case PST_TYPE: { /* pst */
	struct eclause *ptt;
	struct pst_item *item;
	if ((item = find_pstitem(t,e)) == (struct pst_item *)NULL) {
		ptt = ((struct pst *)t)->p_lists;
		while (ptt != (struct eclause *)NULL) {
			t = Arg2(ptt->c_form);
			ocheck(p,t,e);
			ptt = ptt->c_link;
		}
	}
	else {
	    ptt = item->p_lists;
	    while (ptt != (struct eclause *)NULL) {
	    t = Arg2(ptt->c_form);
	    e = ptt->c_env;
	    ocheck(p, t, e);
	    ptt=ptt->c_link;
	   }
	}
	return;
      }
     default: /* functor */
     j = t->t_arity;
     if (j < 0) j = -j;
	for(i = 0;  i < j;  i++)
	      ocheck(p, Arg(t,i), e);
      }
}

void unify(t, e, u, f)
register struct term *t, *u;
register struct pair *e, *f;
{
	register struct pair *p, *q;
	int i, j;

	down(p, t, e);
	down(q, u, f);
	if(p != NULL)		/* if t = var */
	  if (p==Anonymous_env) return;  /* if t = Anonymous Var */
	  else if(q != NULL)		/* t:var, u:var */
		if(p == q) /* t,u : the same var */
			return;
		else if (q==Anonymous_env) /* u : Anonymous Var */
			return;
		else {
			upush(&(p->p_body)); /* t->u */
			upush(&(p->p_env));
			p->p_body = u;
			p->p_env = f;
			return;
		}
		else {			/* t:var, u:non-var */
			upush(&(p->p_body)); /* t->u */
			upush(&(p->p_env));
			p->p_body = u;
			p->p_env = f;
			return;
		}
	  else if(q != NULL) 
		if (q==Anonymous_env) return;
		else {		/*  t:nonvar , u:var  */
			upush(&(q->p_body)); /* u->t */
			upush(&(q->p_env));
			q->p_body = t;
			q->p_env = e;
			return;
        		}
	/* t,u : nonvar */

	switch ((int)u->type.ident) {
	case ATOMIC_TYPE : /* t,u: atomic (string,num,quote) */
	  {
	    if ((t==u) || (atomic_equal(u,t))) return;
	    else longjmp(ufail,1);
	  }
	case LIST_TYPE:
	case CONST_LIST_TYPE:
		if (is_list(t)) {
			unify(head_of_list(t),e,head_of_list(u),f);
			unify(tail_of_list(t),e,tail_of_list(u),f);
			return;
		      }
		longjmp(ufail,1);
	case CLAUSE_TYPE:
	  if (is_clause(t)) {
		while ((t != NULL) && (u != NULL)) {
		  unify(((struct clause *)t)->c_form,e,
		  	((struct clause *)u)->c_form,f);
		  t=(struct term *)((struct clause *)t)->c_link;
		  u=(struct term *)((struct clause *)u)->c_link;
		}
		if (t == u) return;
	      }
	  longjmp(ufail, 1);
	case PST_TYPE:
	  if (is_pst(t)) {
	    pst_unify(t,e,u,f);
	    return;
	  }
	  longjmp(ufail, 1);
        default : /* functor */
	  if(Pred(t) == Pred(u)) {/* t,u: complex term */
	    for(i = 0, j = Pred(t)->f_arity;  i < j;  i++)
	      unify(Arg(t,i), e, Arg(u,i), f); 
	    /* unify each arg */
	    return;
	  }
	  longjmp(ufail,1);
	}
}


void safe_unify(t, e, u, f)	/* unify with occur check */
register struct term *t, *u;
register struct pair *e, *f;
{
  register struct pair *p, *q;
  int i, j;

  down(p, t, e);
  down(q, u, f);
  if(p != NULL)			/* if t = var */
    if (p==Anonymous_env) return;  /* if t = Anonymous Var */
    else if(q != NULL) {		/* t:var, u:var */
      if(p == q) /* t,u : the same var */
	return;
      else if (q==Anonymous_env) /* u : Anonymous Var */
	return;
      else if ((long int)q < (long int)p) {  /* hack for forall-var */
	upush(&(p->p_body)); /* t->u */
	upush(&(p->p_env));
	p->p_body = u;
	p->p_env = f;
	return;
      }
      else {
	upush(&(q->p_body)); /* u->t */
	upush(&(q->p_env));
	q->p_body = t;
	q->p_env = e;
	return;
      }
    }
    else {			/* t:var, u:non-var */
      ocheck(p,u,f);
      upush(&(p->p_body)); /* t->u */
      upush(&(p->p_env));
      p->p_body = u;
      p->p_env = f;
      return;
    }
  else if(q != NULL) 
    if (q==Anonymous_env) return;
    else {		/*  t:nonvar , u:var  */
      ocheck(q,t,e);
      upush(&(q->p_body)); /* u->t */
      upush(&(q->p_env));
      q->p_body = t;
      q->p_env = e;
      return;
    }
  /* t,u : nonvar */
  switch ((int)u->type.ident) {
  case ATOMIC_TYPE : /* t,u: atomic (string,num,quote) */
    {
      if ((t==u) || (atomic_equal(u,t))) return;
      else longjmp(ufail,1);
    }
  case LIST_TYPE:
  case CONST_LIST_TYPE:
    if (is_list(t)) {
      safe_unify(head_of_list(t),e,head_of_list(u),f);
      safe_unify(tail_of_list(t),e,tail_of_list(u),f);
      return;
    }
    longjmp(ufail,1);
  case CLAUSE_TYPE:
    if (is_clause(t)) {
      while ((t != NULL) && (u != NULL)) {
	safe_unify(((struct clause *)t)->c_form,e,
		   ((struct clause *)u)->c_form,f);
	t=(struct term *)((struct clause *)t)->c_link;
	u=(struct term *)((struct clause *)u)->c_link;
      }
      if (t == u) return;
    }
    longjmp(ufail, 1);
  case PST_TYPE:
    if (is_pst(t)) {
	pst_unify(t,e,u,f);
	return;
    }
    else longjmp(ufail, 1);
  default : /* functor */
    if(Pred(t) == Pred(u)) {/* t,u: complex term */
      for(i = 0, j = Pred(t)->f_arity;  i < j;  i++)
	safe_unify(Arg(t,i), e, Arg(u,i), f);
      /* unify each arg */
      return;
    }
    longjmp(ufail,1);
  }
}

struct pst_item *remove_pstitem(t,e)
struct term *t;
struct pair *e;
{
  struct pst_item *object, *target;
  struct pair *p;

  if (e==(struct pair *)NULL)
    return((struct pst_item *)NULL);

  t = ((struct pst *)t)->p_var;
  down(p,t,e);
  target = psttable;
  while ((object = target->p_link) != (struct pst_item *)NULL) {
    if (object->p_var == p) {
      upush(&(target->p_link));
      target->p_link = object->p_link;
      return(object);
    }
    target = object;
  }
  return(object);
}

void pst_unify(t,e,u,f)
register struct term *t,*u;
register struct pair *e,*f;
{
  struct pst_item *target, *object;

  target = find_pstitem(t,e);
  if (target != (struct pst_item *)NULL) {
    object = remove_pstitem(u,f);
    if (object != (struct pst_item *)NULL)
      unify_merge_psts(target,object->p_lists);
    else unify_pstlist_objects(target,((struct pst *)u)->p_lists, f);
   unify(((struct pst *)u)->p_var,f,((struct pst *)t)->p_var,e);
  }
  else {
    object = find_pstitem(u,f);
    if (object != (struct pst_item *)NULL) {
      unify_pstlist_objects(object,((struct pst *)t)->p_lists, e);
      unify(((struct pst *)t)->p_var,e,((struct pst *)u)->p_var,f);
    }
    else {
      target = record_pstobjects((struct pst *)t,e);
      unify_pstlist_objects(target,((struct pst *)u)->p_lists, f);
      unify(((struct pst *)u)->p_var,f,((struct pst *)t)->p_var,e);
    }
  }
}

struct pst_item *record_pstobjects(t,e)
struct pst *t;
struct pair *e;
{
  struct pst_item *entry = psttable;
  struct term *tt = t->p_var;
  struct pair *p;

 down(p,tt,e);

 while(entry->p_link != (struct pst_item *)NULL) {
    if (p > entry->p_link->p_var) break;
    entry = entry->p_link;
   }
  upush(&(entry->p_link));
  entry->p_link = (struct pst_item *)
    Npst_item(p,(struct eclause *)NULL,entry->p_link);
  entry = entry->p_link;
  entry->p_lists = record_pstlists(t->p_lists,e);
  return(entry);
}

struct eclause *record_pstlists(ptt,e)
struct eclause *ptt;
struct pair *e;
{
  struct eclause *props, *pre;

  if (ptt == (struct eclause *)NULL) return(ptt);
  pre = props = Npstobj(ptt->c_form, e, (struct eclause *)NULL, MEDIUM);
  for (ptt = ptt->c_link; ptt != (struct eclause *)NULL; ) {
    props->c_link =
      Npstobj(ptt->c_form, e, (struct eclause *)NULL, MEDIUM);
    props = props->c_link;
    ptt = ptt->c_link;
   }
  return(pre);
}

void unify_pstlist_objects(entry, ol, e)
struct pst_item *entry;
struct eclause *ol;
struct pair *e;
{
  int i, fnum;
  struct eclause *pl;

  if (ol==(struct eclause *)NULL) return;

  pl=entry->p_lists; /* pl must NOT be NULL */

  if (pl == (struct eclause *)NULL) {
    upush(&(entry->p_lists));
    entry->p_lists=record_pstlists(ol,e);
    return;
  }

  i = Pred(Arg1(pl->c_form))->f_number - Pred(Arg1(ol->c_form))->f_number;
  if (i == 0) {
    unify(pl->c_form,pl->c_env,ol->c_form,e);
    ol=ol->c_link;
  }
  else if (i > 0) {
    upush(&(entry->p_lists));
    entry->p_lists = Npstobj(ol->c_form,e,pl,MEDIUM);
    ol = ol->c_link;
    pl=entry->p_lists;
  }
 /*  else  goes on */

  while (ol != (struct eclause *)NULL) {
    fnum = Pred(Arg1(ol->c_form))->f_number;
    while (pl->c_link != (struct eclause *)NULL) {
     i = Pred(Arg1(pl->c_link->c_form))->f_number - fnum;
     if (i == 0) {
       unify(pl->c_link->c_form,pl->c_link->c_env,ol->c_form,e);
       break;
     }
     else if (i > 0) {
       upush(&(pl->c_link));
       pl->c_link = Npstobj(ol->c_form,e,pl->c_link,MEDIUM);
       break;
     }
     pl = pl->c_link;
   }

   if (pl->c_link == (struct eclause *)NULL) {
        upush(&(pl->c_link));
        pl->c_link = record_pstlists(ol,e);
        break;
      }
   else pl=pl->c_link;
   ol = ol->c_link;
  }
}


void unify_merge_psts(target,object)
struct pst_item *target;
struct eclause *object;
{
  int i, fnum;
  struct eclause *next, *pl;

  if (object==(struct eclause *)NULL) return;

  pl=target->p_lists;
  
  if (pl == (struct eclause *)NULL) {
    upush(&(target->p_lists));
    target->p_lists = object;
    return;
  }

  i = Pred(Arg1(pl->c_form))->f_number - Pred(Arg1(object->c_form))->f_number;
  if (i == 0) {
    unify(pl->c_form,pl->c_env,object->c_form,object->c_env);
    object=object->c_link;
  }
  else if (i > 0) {
    upush(&(target->p_lists));
    target->p_lists =
      Npstobj(object->c_form,object->c_env,pl,MEDIUM);
    object = object->c_link;
    pl = target->p_lists;
  }
 /* else goes on */

  while (object != (struct eclause *)NULL) {
    fnum = Pred(Arg1(object->c_form))->f_number;
    while (pl->c_link != (struct eclause *)NULL) {
      i = Pred(Arg1(pl->c_link->c_form))->f_number - fnum;
      if (i == 0) {
	unify(pl->c_link->c_form,pl->c_link->c_env,
		object->c_form,object->c_env);
	break;
       }
      else if (i > 0) {
	next=pl->c_link;
	upush(&(pl->c_link));
	pl->c_link = object;
	upush(&(object->c_link));
	object->c_link = next;
	break;
	}
     pl=pl->c_link;
    }
   if (pl->c_link == (struct eclause *)NULL) {
	upush(&(pl->c_link));
	pl->c_link = object;
	return;
      }
   else pl=pl->c_link;
   object = object->c_link;
  }
}
