/* sub-function for constraint transformation (transform.c) */
#include "include.h"
#define DEBUG 0

#if MAC == 1
#include "macconst.h"
#endif

/*  values of cs->cs_status */
#define REMOVED 1
/* for CSTR_list */
#define UNTOUCHED 0
#define MODULAR_DEFINED 2
#define UNIT_DEFINED 3
/* for DEF_list */
#define DERIVATION 4
#define REGISTERED 5
#define FALSE_REGISTERED 6
#define REDUCED_DEF 7

struct vpair{			/* link between v1 and v2 */
	struct term *v1;
	struct term *v2;
};

int VPAIR_SIZE = (sizeof(struct vpair) / sizeof(struct pair));
int  CSTR_number;
long int old_CSTR_number;

struct compartment{
	struct clause *cmp_clause, *cmp_oldclause;
	struct term *cmp_vlist;
	struct vpair *cmp_vp;
	struct compartment *cmp_link;
	long int cmp_anum;
	unsigned short int cmp_vnum;
	unsigned short int cmp_vp_size;
};

#define restore_head(Term,VP,VNUM) (\
    (Term == FAIL) ? MFAIL :\
	Nclause(restore_term(Term,VP,VNUM),NULL,ETERNAL))

#ifdef DEBUG
void Pvpair(vp,vn)
struct vpair *vp;
int vn;
{
	register int i;
	for (i = 0; i < vn; i++)
		ttyprint2("%s <--> %s, ",vname(vp[i].v1), vname(vp[i].v2));
}
	       
void Pcomp(cmp)
struct compartment *cmp;
{
	register struct compartment *c;
	for (c = cmp; c != NULL; c = c->cmp_link)
	{
		ttyprint0("--->");
		Pclause(c->cmp_clause,(struct pair *)NULL);
		ttyprint0(" : ");Pvpair(c->cmp_vp,(int)c->cmp_vp_size);ttynl;
	}
}
#endif

int cs_status_type(st)
int st;
{
  static char cs_status_list[9] = {
    'u','r','m','i','d','g','f','x','t'};

  if (st > REDUCED_DEF) return('?');
  else return(cs_status_list[st]);
}

void Pcset_def(cs)			/* print cset */
struct cset *cs;
{
	ttyprint3("[%d(%c,%d)] ",cs->cs_number,
		cs_status_type((int)cs->cs_status),
		Pred(cs->cs_clause->c_form)->f_setcount);
	P_dclause(cs->cs_clause,(struct pair *)NULL);
}

void Pcset_cstr(cs)			/* print cset */
struct cset *cs;
{
	ttyprint2("<%d(%c)> ",cs->cs_number,
		cs_status_type((int)cs->cs_status));
	P_hclause(cs->cs_clause,(struct pair *)NULL);
}

void P_csnumber(cs,mode)
struct cset *cs;
int mode;
{
	register struct cset *c;
	int i = 0;
	
	for (c = cs; c != NULL; c = c->cs_link)
	if ((mode == 1 && c->cs_status == DERIVATION) ||
	    (mode == 2 && c->cs_status == UNTOUCHED) ||
	    (mode == 3 && (c->cs_status == MODULAR_DEFINED || 
			   c->cs_status == UNIT_DEFINED)))
	{
		if (i != 0) {
		ttyputc(',');
		}
		i = 1;
		ttyprint1("%d",c->cs_number);
	}
}	

void P_status(flag)  /* print DEF_list,CSTR_list (for debug) */
int flag;
{
	register struct cset *cs;
	
	ttyprint0("****");
	ttyprint0("DEFS={");P_csnumber(DEF_list,1);ttyprint0("}  ");
	ttyprint0("NON-MODULAR={");P_csnumber(CSTR_list,2);ttyprint0("}  ");
	ttyprint0("MODULAR={");P_csnumber(MODULAR_list,3);ttyprint0("}****");
	for (cs = DEF_list; cs != NULL; cs = cs->cs_link)
	if (cs->cs_status != FALSE_REGISTERED &&
		(flag || cs->cs_number >= (int)old_CSTR_number) )
			{ttynl;Pcset_def(cs);}
/* if (cs->cs_status == DERIVATION) {ttynl;Pcset_def(cs);} */
	for (cs = CSTR_list; cs != NULL; cs = cs->cs_link)
	if (cs->cs_status != REMOVED &&
		(flag || cs->cs_number >= (int)old_CSTR_number))
			 {ttynl;Pcset_cstr(cs);}
/*	if (cs->cs_status == UNTOUCHED) {ttynl;Pcset_cstr(cs);} */
        for (cs = MODULAR_list; cs != NULL; cs = cs->cs_link)
	if (cs->cs_status != REMOVED &&
		(flag || cs->cs_number >= (int)old_CSTR_number))
			 {ttynl;Pcset_cstr(cs);}
	old_CSTR_number = (long int)CSTR_number;
}


struct vpair *Nvpair(vl,vnum)	/* allocate vpair structure */
struct term *vl;
int vnum;
{
	struct vpair *p;
	register int i;
	register struct term *v;
	
	p = (struct vpair *)ealloc(VPAIR_SIZE * vnum);
	for (v = vl; v != NULL; v = vlink(v)) {
	  i = vnumber(v);
	  p[i].v2 = NULL;
	  p[i].v1 = v;
	}
	return(p);
}

struct cset *Ncset(flag)	/* allocate cset structure */
int flag;
{
	register struct cset *s;
#ifdef MAC
	MEMORY_ALLOC(s,cset,flag,6);	/* sizeof(cset)=6 */
#else
	MEMORY_ALLOC(s,cset,flag);
#endif
	s->cs_clause = NULL;
	s->cs_link = NULL;
	s->cs_vlist = NULL;
	s->cs_anumber = s->cs_cnum = 0;
	s->cs_status = UNTOUCHED; /* defalut status */
	s->cs_number = CSTR_number++;
	return(s);
}

/* add c to CSTR_list (in apply_add_clause)*/
void add_clause(c, vlist, anum,empty_flag)
struct clause *c;
struct term *vlist;
int anum,empty_flag;
{
	register struct cset *cs;
	struct func *f;

	f = Pred(c->c_form);
	f->f_setcount++;
	recalc_voccurrence(c,vlist);
	cs = Ncset(TEMPORAL);
	cs->cs_clause = c;
	cs->cs_vlist = vlist;
	cs->cs_anumber = anum;

	if ((c->c_link == NULL) || (empty_flag == TRUE))
	{
		f->f_unitcount++;
		cs->cs_status = UNIT_DEFINED;
		cs->cs_link = MODULAR_list;
                MODULAR_list = cs;
	}
	else if (is_modular_clause(c->c_link)) {
		cs->cs_status = MODULAR_DEFINED;
		M_SOLVED=TRUE;
		cs->cs_link = MODULAR_list;
                MODULAR_list = cs;
	}
	else {
          cs->cs_status = UNTOUCHED;
          cs->cs_link = CSTR_list;
          CSTR_list = cs;
        }
}

void simplify_defs(cl)
struct clause *cl;
{
  void simplify_onedef();
  struct func *f;
  struct ustack *usave = usp;
  long int *hsave = hp;
  struct pair *esave = ep;

  for ( ; cl != (struct clause *)NULL; cl=cl->c_link) {
    f = Pred(cl->c_form);
    simplify_onedef(f);
  }
  undo(usave);
  hp = hsave;
  ep = esave;
}

void simplify_onedef(f)
struct func *f;
{
  void simplify_onedef_sub();
  struct set *s;

  if (isuser(f) && isnot_simplified(f)) {
   set_simplified(f);
      for (s = f->def.f_set; s != (struct set *)NULL; s = s->s_link) {
         if (s->s_clause != (struct clause *)NULL)
           simplify_onedef_sub(f,s);
      }
    }
}

void simplify_onedef_sub(o,s)
struct func *o;
struct set *s;
{
  struct pair *e1, *e2;
  struct term *t1, *t2;
  struct func *f;
  struct set *fs;
  struct clause *cl = s->s_clause;
  struct clause *termset_and_append();
  struct eclause *ec = (struct eclause *)NULL;
  void up_init(),simplify_onedef();
  int i;

  e1 = Nenv((int)s->s_anumber);
  while (cl->c_link != (struct clause *)NULL) {
    t1 = cl->c_link->c_form;
    f = Pred(t1);
    if (o == f)
      cl=cl->c_link;
    else {
      simplify_onedef(f);

      if (isuser(f) && f->f_setcount == 1) {
        fs = f->def.f_set;
        t2 = fs->s_clause->c_form; e2 = Nenv((int)fs->s_anumber);
        if (tunify(t1,e1,t2,e2,1)) { 
          ec = Neclause(fs->s_clause->c_link,e2,ec,TEMPORAL);
          cl->c_link=cl->c_link->c_link;
        }
/*
	else {
        	error_detail(t2,e2,"SIMPLIFICATION of the constraint error");
        }
*/
      }
      else cl = cl->c_link;
    }
  }

  if (ec != (struct eclause *)NULL) {
    up_init();
    s->s_clause = (struct clause *)
      termset((struct term *)s->s_clause,NULL,e1,ETERNAL);
    s->s_clause->c_link = termset_and_append(ec,s->s_clause->c_link);

    if (p_number != 0) {
      renum_pvars((struct pstvar *)pv_list,v_number);
    }
    s->s_clause->c_link = up_restore(s->s_clause->c_link,ETERNAL);
    s->s_anumber = (unsigned short int)(v_number+p_number);
    s->s_vlist = v_list;
    s->s_bodynumber = literalnumber(s->s_clause->c_link);
  }
}

struct clause *termset_and_append(ecl,cl)
struct eclause *ecl;
struct clause *cl;
{
  struct clause *t2, *t1;
  while (ecl != (struct eclause *)NULL) {
    if (ecl->c_form != NULL) {
      t2 = t1 =
        (struct clause *)termset(ecl->c_form,NULL,ecl->c_env,ETERNAL);
      if (cl != (struct clause *)NULL) {
        while (t2->c_link != (struct clause *)NULL)
          t2 = t2->c_link;
        t2->c_link = cl;
      }
      cl = t1;
    }
    ecl = ecl->c_link;
  }
  return(cl);
}


jmp_buf reduce_fail;	/* (reduce_clause, reduce_clause_m,one_def_literal) */
struct eclause *reduce_clause(cl,e) /* entry */
struct clause *cl;
struct pair *e;
{
	struct ustack *usave = usp;
	long int *hsave = hp;
	struct pair *esave = ep;
	struct eclause *reduce_clause_m();

        if (setjmp(reduce_fail))
	{
		undo(usave);
		hp = hsave;
		ep = esave;
		return((struct eclause *)MFAIL);
	}
	return(reduce_clause_m(cl,e));
}

struct eclause *reduce_clause_m(cl,e) /* reduce_clause sub */
struct clause *cl;
struct pair *e;
{
	register struct set *s;
	struct pair *e1;
	register struct term *t;
	register struct func *f;

	if (cl == NULL) return(NULL);
	t = cl->c_form; f = Pred(t); cl = cl->c_link;
    if (is_functor(t)) {
          if ((s = one_def_literal(f)) != NULL) /* reduceable */
            {
		e1 = Nenv((int)s->s_anumber);
		if (tunify(t,e,s->s_clause->c_form,e1,1)==FALSE)
			longjmp(reduce_fail,1);
		else 
                  return(
                         eclause_conc(
                               reduce_clause(cl,e),
                               eclause_conc(
                                    reduce_clause(s->s_constraint,e1),
				    reduce_clause(s->s_clause->c_link,e1))));
              }
          else if (is_funcsys(f) && (f != FORALL_P) && (f != STAY_P)) {
	    struct node *dummy;
	    dummy = Newnode((struct clause *)NULL,(struct eclause *)NULL,
		(struct pair *)NULL,(struct node *)NULL,(struct node *)NULL);
	    if (system_function(t,e,dummy) == SYSFAIL)
		    longjmp(reduce_fail,1);
	    else return(reduce_clause(cl,e));
          }
        }
	{
		struct eclause *result=reduce_clause(cl,e);
		if (result == (struct eclause *)MFAIL) return(result);
		else return(Neclause(t,e,result,MEDIUM));
	}
}

struct set *one_def_literal(f)	/* reduce_clause_m sub */
struct func *f;
{
  if (isuser(f)) {
    switch (f->f_setcount) {
      case 1: return(f->def.f_set);
      case 0:
	if (Handle_Undefined == TRUE) {
	  sprintf(nbuf,">>> %s <<< is UNDEFINED!",f->f_name);
	  error(nbuf);
	  }
	else longjmp(reduce_fail,1); 
      default: return(NULL);
      }
  }
  else return(NULL);
}

void reorder_clause(cl, tc)
struct clause *cl, *tc;
{
	register struct clause *c;

	for (c = cl; c != NULL; c = c->c_link)
		if (c->c_link == tc) break;
	if (c == NULL) return;
	c->c_link = tc->c_link;
	tc->c_link = cl->c_link;
	cl->c_link = tc;
	return;
}

/* satisfiability check */

int satisfiable(cl,anum)
struct clause *cl;
int anum;
{
	int tflagsave;
	struct ustack *usave = usp;
	struct node *Last_Node, *Initial_Goal;

	tflagsave = tflag;
	Notrace_mode;
	upush(&hp);upush(&ep);
	upush(&Last_BT);upush(&Last_SKIP);
	Initial_Goal = Last_Node = 
	  Newnode(cl, (struct eclause *)NULL, Nenv(anum),
		  (struct node *)NULL,(struct node *)NULL);
	Last_BT = Last_SKIP = NULL;
	if (refute(Initial_Goal, Last_Node, DOWN) == FALSE)
	{
		undo(usave);
		tflag = tflagsave;
		return(FALSE);
	}
	tflag = tflagsave;
	undo(usave);
	return(TRUE);
}

/* general predicates for transform.c */
struct clause *surface_copy_clause(cl,flag) /* make copy of cl */
struct clause *cl;
int flag;
{
	if (cl == NULL) return(NULL);
	return(Nclause(cl->c_form,
			surface_copy_clause(cl->c_link,flag),
			flag));
}

int is_modular_clause(cl)	/* check if clause cl is modular */
struct clause *cl;
{
	register struct clause *c;
	for (c = cl; c != NULL; c = c->c_link)
	{
		if (! is_modular_literal(c->c_form)) return(FALSE);
	}
	return(TRUE);
}

int is_modular_literal(t)	/* check if literal t is modular */
struct term *t;
{
	struct func *f;
	register int i;
	register struct term *arg;

	if (! is_functor(t))
	  error_detail(t,(struct pair *)NULL,
			"Only Functors can be used as Constraints");

	f = Pred(t);
	if (f->f_mark & VACUITY_NOCHECK) recalc_f_roles(f);
	for (i = 0; i < f->f_arity; i++)
	{
		arg = Arg(t,i);
		if (isvar(arg)) {
		  if (not_vacuous(f,i))
			if (voccurrence(arg) > 1) { /* double occurrence */
				return(FALSE); 
			}
			/* var dependency */
		}
		else {
			return(FALSE);
		}
	}
	return(TRUE);
}	

/* check if t contains no variable */
/*  useless function */ /*
int has_no_var(t)
struct term *t;
{
	register int i;

	for (i = 0; i < Pred(t)->f_arity; i++)
		if ((! novar(Arg(t,i))) || is_pst(Arg(t,i)))
			return(FALSE);
	return(TRUE);
}
*/

struct eclause *eclause_conc(ec1,ec2) /* concatenate eclauses */
struct eclause *ec1,*ec2;
{
	register struct eclause *ec;

	if (ec1 == NULL) return(ec2);
	if (ec2 == NULL) return(ec1);
	if (ec1 == (struct eclause *)MFAIL||ec2 == (struct eclause *)MFAIL)
		return((struct eclause *)MFAIL);
	ec = ec1;
	while (ec->c_link != NULL)
	  ec = ec->c_link;
	ec->c_link = ec2;
	return(ec1);
}

/*
* sort_clause
*   insert_clause
*        greater_term
*            greater_arg
*                  arg_type
*                  cmp_var,cmp_cplxt,cmp_list,cmp_flt,cmp_int,cmp_str,cmp_fp
*/
struct clause *sort_clause(cl)	/* sort clause for fold transformation */
struct clause *cl;
{
	if (cl == NULL) return(NULL);
	return(insert_clause(cl, sort_clause(cl->c_link)));
}

struct clause *insert_clause(ct, cl) /* insert ct into cl */
struct clause *ct,*cl;
{
	ct->c_link = NULL;
	if (cl == NULL) return(ct);
	if (greater_term(ct->c_form,cl->c_form)) { /* ct > top of cl? */
		ct->c_link = cl;
		return(ct);
	}
	{
	register struct clause *c,*cbefore = cl;

	for (c = cl->c_link; c != NULL; cbefore = c, c = c->c_link)
		if (greater_term(ct->c_form,c->c_form))	/* ct > c? */
			break;
	cbefore->c_link = ct;
	ct->c_link = c;
	return(cl);
	}
}

#define ARG_EQ 0
#define ARG_TRUE 1
#define ARG_FALSE 2

int greater_term(t1,t2)		/* t1 > t2 ?? */
struct term *t1,*t2;
{
  register int i,cp;

  if (Pred(t1)->f_number != Pred(t2)->f_number)
    return(Pred(t1)->f_number > Pred(t2)->f_number);
  for(i = 0; i < Pred(t1)->f_arity; i++)
    if ((cp = greater_arg(Arg(t1,i),Arg(t2,i))) != ARG_EQ)
      return(cp == ARG_TRUE);
  return(FALSE);
}

/*
argument type:
0 variable (cmp_var)
1 complex term that has a variable (cmp_cplxt)
2 list that has a variable (cmp_list)
3 complex term without variable (cmp_cplxt)
4 list without variable (cmp_list)
5 atom, floating number (cmp_flt)
6 atom, integer number (cmp_int)
7 atom, string  (cmp_str)
8 atom, filepointer (cmp_fp)
9 clause (cmp_clause)
10 pst (cmp_pst)
*/
int arg_type(a)			/* return argument type */
struct term *a;
{
  switch ((int)a->type.ident) {
  case VAR_VOID_TYPE:
  case VAR_QNT_TYPE:
  case VAR_PST_TYPE:
  case VAR_GLOBAL_TYPE:
    return(0);
  case ATOMIC_TYPE:
    return(5 + (int)a->t_arity);
  case LIST_TYPE:
    return(2);
  case CONST_LIST_TYPE:
    return(4);
  case CLAUSE_TYPE:
    return(9);
  case PST_TYPE:
    return(10);
  default:
    if ((int)a->t_arity <= 0) return(3);
    return(1);
  }
}

int greater_arg(a1,a2)		/* a1 > a2 ? */
struct term *a1,*a2;
{
  int cp;
  int atype1 = arg_type(a1),atype2 = arg_type(a2);

  if ((cp = (atype1 - atype2)) != 0)
    if (cp > 0) return(ARG_TRUE);
    else return(ARG_FALSE);

  switch(atype1){
    case 0 : return(cmp_var(a1,a2));
    case 1 : return(cmp_cplxt(a1,a2));
    case 2 : return(cmp_list(a1,a2));
    case 3 : return(cmp_cplxt(a1,a2));
    case 4 : return(cmp_list(a1,a2));
    case 5 : return(cmp_flt(a1,a2));
    case 6 : return(cmp_int(a1,a2));
    case 7 : return(cmp_str(a1,a2));
    case 8 : return(cmp_fp(a1,a2));
    case 9 : return(cmp_clause(a1,a2));
    case 10: return(cmp_pst(a1,a2));
    }
}

int cmp_var(a1,a2)		/* compare variable  a1 > a2??*/
struct term *a1,*a2;
{
	register int i;

	i = voccurrence(a1) - voccurrence(a2);
	if (i == 0) return(ARG_EQ);
	else if (i > 0) return(ARG_TRUE);
	else return(ARG_FALSE);
}

int cmp_cplxt(a1,a2)		/* compare complex terms */
struct term *a1,*a2;
{
	register int i,cp;

	if (Pred(a1)->f_number != Pred(a2)->f_number)
		return(Pred(a1)->f_number > Pred(a2)->f_number);
	for(i = 0; i < Pred(a1)->f_arity; i++)
		if ((cp = greater_arg(Arg(a1,i),Arg(a2,i))) != ARG_EQ)
			return(cp);
	return(ARG_EQ);
}

int cmp_list(a1,a2)		/* compare list */
struct term *a1,*a2;
{
	int cp;

	if (a1 == NIL || a2 == NIL)
		if (a1 == a2) return(ARG_EQ);
		else if (a1 == NIL) return(ARG_TRUE);
		else return(ARG_FALSE);

	if (isvar(a1)) { /* patch 1991-03-03 */
	  if (isvar(a2)) return(cmp_var(a1,a2));
	  else return(ARG_FALSE);
	}
	if (isvar(a2)) return(ARG_TRUE);

	if (cp = greater_arg(head_of_list(a1), head_of_list(a2)) != ARG_EQ)
		return(cp);
	else return(cmp_list(tail_of_list(a1),tail_of_list(a2)));
}

int cmp_clause(a1,a2)		/* compare clause */
struct term *a1,*a2;
{
	int cp;
	if (a1 == NULL || a2 == NULL)
		if (a1 == a2) return(ARG_EQ);
		else if (a1 == NULL) return(ARG_TRUE);
		else return(ARG_FALSE);
	if (cp = greater_arg(head_of_list(a1), head_of_list(a2)) != ARG_EQ)
		return(cp);
	else return(cmp_clause(tail_of_list(a1),tail_of_list(a2)));
}

int cmp_flt(a1,a2)
struct term *a1,*a2;
{
	float cp;

	cp = num_value(a1) - num_value(a2);
	if (cp == 0) return(ARG_EQ);
	else if (cp > 0) return(ARG_TRUE);
	else return(ARG_FALSE);
}
int cmp_int(a1,a2)
struct term *a1,*a2;
{
	register int cp;
	cp = (int)num_value(a1) - (int)num_value(a2);
	if (cp == 0) return(ARG_EQ);
	else if (cp > 0) return(ARG_TRUE);
	else return(ARG_FALSE);
}
int cmp_str(a1,a2)
struct term *a1,*a2;
{
	register int cp;
	cp = strcmp(str_value(a1), str_value(a2));
	if (cp == 0) return(ARG_EQ);
	else if (cp > 0) return(ARG_TRUE);
	else return(ARG_FALSE);
}

int cmp_fp(a1,a2)
struct term *a1,*a2;
{
	register int cp;
	
	cp = filep_value(a1) - filep_value(a2);
	if (cp == 0) return(ARG_EQ);
	else if (cp > 0) return(ARG_TRUE);
	else return(ARG_FALSE);
}

int cmp_pst(a1,a2)
struct term *a1, *a2;
{
  register struct eclause *e1, *e2;
  int cp;

  e1 = ((struct pst *)a1)->p_lists;
  e2 = ((struct pst *)a2)->p_lists;

  while ((e1 != (struct eclause *)NULL) && (e2 != (struct eclause *)NULL)) {
    if ((cp = greater_arg(e1->c_form,e2->c_form)) != ARG_EQ)
      return(cp);
    e1 = e1->c_link;
    e2 = e2->c_link;
  }
  if (e1 == e2) return(ARG_EQ);
  else if (e2==(struct eclause *)NULL) return(ARG_TRUE);
  else return(ARG_FALSE);
}

/* init & end unfoldfold */
void init_unfoldfold()
{
	newfsave = newf_list;	/* save newf_list */
	DEF_list = NULL;	/* derivation clauses */
	CSTR_list = NULL;	/* new clauses */
	CSTR_number = 0;	/* initial clause number  */
	MODULAR_list = NULL;
	old_CSTR_number = 0L;
	INITDEF_list = NULL;	/* initial derivation clauses */
	M_SOLVED=FALSE;
}

void end_unfoldfold()
{
	CSTR_list = NULL;	/* new clauses */
	CSTR_number = 0;	/* initial clause number  */
	INITDEF_list = NULL;	/* initial derivation clauses */
	MODULAR_list = NULL;
}

/* c.t. step trace subroutine  */
/*
* step_asking
*   quit_transformation
*   abandon_transformation
*   nth_cset
*   nth_literal
*/
int step_asking()		/* c.t. step trace --> 0(auto),1(cont) */
{
	FILE *filep = wfp;
	wfp = stdout;
#ifndef MAC
    ttyprint0("\n@step <h,b,q,z,u,x,n,CR>?  ");
#endif
    while(1)
    {
#ifndef MAC
	switch(getchar())
#else
	if (*ibufpt == '\0') {
		ttyprint0("\r@step <h,q,z,u,x,n,CR>?  "); ShowSelect();
	}
	next() ;
	switch(cbuf)
#endif
	{
	  case '?' :
	  case 'h' :
#if MAC == 1
	    Alert( TransHelp, 0L);
	    *ibufpt = '\0'; ShowSelect();
#else
	    ttyprint0("NOTATION: [<clause No>(<status>,<literal No.>)]");
	    ttyprint0("New Predicate <=> unmodular body\n");
	    ttyprint0("\t<STATUS> : U=untouched, M=modular_defined,")
	    ttyprint0("I=unit_defined, D=Derived,\t\tG=registered,");
	    ttyprint0("F=False, R=Reduced, T=Temporary\n");
	    ttyprint0("COMMNAD: q:quit\tz:abort");
	    ttyprint0("\tn:normal trace\tx:trace off");
	    ttyprint0("\nb:break\tCR: continue");
	    ttyprint0("\tu <clausese No.> <literal No.>: manual unfolding\n");
	    skip_cr();
#endif
	    break;
	  case 'b': {
	    long int  *hsave = hp;
	    struct pair *esave = ep;
	    struct ustack *usave = utop;
	    struct cset *deflist_save = DEF_list,
                        *cstrlist_save = CSTR_list,
                        *modular_save = MODULAR_list,
		*initdeflist_save = INITDEF_list;
	    struct clause *restliterals_save = REST_literals;
	    int cstrnumber_save = CSTR_number;
	    struct func *flistsave = f_list;
	    struct pst_item *psttable_save = psttable->p_link;
	    struct itrace *newflistsave = newflist_save;
	    utop = usp;
#if MAC == 1
	    *ibufpt = '\0';
#endif
	    if (setjmp(unbreak_reset)) {
		utop = usave; hp = hsave; ep = esave;
		DEF_list = deflist_save; CSTR_list = cstrlist_save;
                MODULAR_list = modular_save;
		INITDEF_list = initdeflist_save;
		REST_literals = restliterals_save;
		CSTR_number = cstrnumber_save;
		f_list = flistsave; newflist_save = newflistsave;
		psttable->p_link = psttable_save;
		break;
		}
	    while(1) {
			f_list = NULL;
			usp = utop;
			newflist_save = newflistsave;
			psttable->p_link = (struct pst_item *)NULL;
	  		prolog_execution();
			}
		}
	  case 'q' : wfp = filep; quit_transformation(); /* quit */
#if MAC == 1
		*ibufpt = '\0';
#endif
	    longjmp(trans_fail,1);
	  case 'z' : wfp = filep; abandon_transformation(); /* abort */
#if MAC == 1
		*ibufpt = '\0';
#endif
	    longjmp(trans_fail,1);
	  case 'u' : {int cnum,lnum; /* manual unfolding */
		struct cset *tc;
		struct clause *tl;
#if MAC == 1
		sscanf(ibufpt,"%d %d",&cnum,&lnum);
		skipline();
#else
		scanf("%d %d",&cnum,&lnum);
		skip_cr();
#endif
		tc = nth_cset(cnum);
		if (tc == NULL) {
			ttyprint1("Error: no clause %d",cnum);
			break;
		}
		tl = nth_literal(tc->cs_clause->c_link,lnum);
		if (tl == NULL) {
			ttyprint0("Error: literal out of range");
			break;
		}
		tc->cs_status = REMOVED;
		if (tc->cs_status != DERIVATION) /* in CSTR_list */
			Pred(tc->cs_clause->c_form)->f_setcount--;
		reorder_clause(tc->cs_clause, tl);
		ttyprint1("manual_unfold [%d] ",lnum);
		Pterm(tc->cs_clause->c_link->c_form,(struct pair *)NULL);
		if (apply(tl->c_form,tc->cs_clause->c_form,tl->c_link,
			(int)tc->cs_anumber, (struct clause *)NULL) == FALSE)
#if MAC == 1
			ttyprint0(" ->FAIL\r")
#else
			ttyprint0(" ->FAIL\r")
#endif
		else
#if MAC == 1
			ttyprint0(" =>TRUE\r")
#else
			ttyprint0(" =>TRUE\r")
#endif
		wfp = filep;
		return(1);
		}
	  case 'x' : CTnotrace; Notrace_mode;
#if MAC == 1
		skipline();
#else
		skip_cr();
#endif
		wfp = filep;
		return(0); /* no trace */
	  case 'n' : CTnormal;
#if MAC == 1
		skipline();
#else
		skip_cr();
#endif
		wfp = filep;
		return(0);/* normal trace */
#if MAC == 1
	  case '\r':
#else
	  case '\n':
#endif
		wfp = filep;
		return(0); /* continue in automode */
	  case 's': /* show all */
	  	P_status(TRUE);
#if MAC == 1
		skipline();
#else
		skip_cr();
#endif
	  default  : break;
	}
   }
}

struct cset *nth_cset(n)	/* cset whose cs_number = n */
int n;
{
	register struct cset *c;
	for (c = DEF_list; c != NULL; c = c->cs_link)
		if (c->cs_status == DERIVATION && 
		    c->cs_number == n) return(c);
	for (c = CSTR_list; c != NULL; c = c->cs_link)
		if (c->cs_status != REMOVED &&
		    c->cs_number == n) return(c);
	return(NULL);
}

struct clause *nth_literal(cl,n)
struct clause *cl;
int n;
{
	register struct clause *c;
	register int i;

	for (c = cl, i = 1; c != NULL; c = c->c_link, i++)
		if (i == n) return(c);
	return(NULL);
}

				/* when transformation fails, */
void abandon_transformation()	/* abandon all new predicates */
{
	register struct cset *cs;
	register struct func *f;

	newf_list = newfsave;	/* restore newf_list (init_unfoldfold) */
	for (cs = INITDEF_list; cs != NULL; cs = cs->cs_link)
		if (cs->cs_status == FALSE_REGISTERED)
		{
			f = Pred(cs->cs_clause->c_form);
			if (f->f_integ == NULL) continue;
			index_func(f);
			reducedfun(f);
			f->def.f_set = NULL;
			f->f_unitcount = f->f_setcount = 0;
			f->f_integ->it_link = newf_list;
			newf_list = f->f_integ;
		}
	newf_list = index_newflist(newf_list,newfsave);
}

void quit_transformation()	/* quit transformation (in step trace) */
{
	register struct cset *cs;
	register struct func *f;
	
	for (cs = DEF_list; cs != NULL; cs = cs->cs_link)
	{
		f = Pred(cs->cs_clause->c_form);
		f->f_setcount = f->f_unitcount = 0; /* reset in add_cs_to_set*/
		if (cs->cs_status == REGISTERED || 
		    cs->cs_status == REMOVED)
			index_func(f); /* register into global hash table */
		else if (cs->cs_status == DERIVATION)
		{
			index_func(f); /* register into global hash table */
			add_cs_to_set(cs,'a');
		}
	}
        for (cs = MODULAR_list; cs != NULL; cs = cs->cs_link)
		if (cs->cs_status != REMOVED)
			add_cs_to_set(cs,'a');
	for (cs = CSTR_list; cs != NULL; cs = cs->cs_link)
		if (cs->cs_status != REMOVED)
			add_cs_to_set(cs,'a');
}

/* skip user's input "....CR" */
#ifndef MAC
void skip_cr()
{
	while( getchar() != '\n') ;
}
#endif

void show_newdefs()		/* show newly defined clauses */
{
	register struct cset *cs;
	register struct func *f;
	FILE *filep = wfp;
	wfp = stdout;
	for (cs = DEF_list; cs != NULL; cs = cs->cs_link)
	{
		f = Pred(cs->cs_clause->c_form);
		if isnoreduced(f)
			Showfunc(f);
	}
	wfp = filep;
}
