/* trans_split.c */
/* sub functions for transform.c (divide clause into equivalence classes)*/

#include "include.h"
#define DEBUG 0

/*  values of cs->cs_status */
#define REMOVED 1
/* for CSTR_list */
#define UNTOUCHED 0
#define MODULAR_DEFINED 2
#define UNIT_DEFINED 3
/* for DEF_list */
#define DERIVATION 4
#define REGISTERED 5
#define FALSE_REGISTERED 6
#define REDUCED_DEF 7

struct vpair{			/* link between v1 and v2 */
	struct term *v1;
	struct term *v2;
};

struct compartment{
	struct clause *cmp_clause, *cmp_oldclause;
	struct term *cmp_vlist;
	struct vpair *cmp_vp;
	struct compartment *cmp_link;
	long int cmp_anum;
	unsigned short int cmp_vnum;
	unsigned short int cmp_vp_size;
};

/* this modulue uses global vars: CONST_literals, REST_literals
*
*split
*	clear_vconstraint
*	attach
*		attach_term
*			attach_arg
*				replace_terms
*	delete_constraint.
*	Ncomp(*)
*	Nvpair
*/

struct compartment *split(clist, vlist)
struct clause *clist;
struct term *vlist;
{
	register struct term *v;
	register struct compartment *cmp,*cmplast;
	struct clause *cnext, *remove_modular_literals();
	void divide_consts();
	int vn = 0;

	CONST_literals = REST_literals = NULL; /* global vars. */
	CONST_PST_literals = NULL;

	clist = remove_modular_literals(clist);
	if (clist==NULL) return(NULL);

	for (v = vlist; v != NULL; v = vlink(v))
	    vconstraint(v) = NULL;

	attach(clist, vlist);
	delete_constraint(vlist);

	for (cmplast = NULL; CONST_PST_literals != NULL; CONST_PST_literals = cnext) {
		cnext = CONST_PST_literals->c_link;
		CONST_PST_literals->c_link = NULL;
		cmp = Ncomp(CONST_PST_literals, (struct vpair *)NULL);
		cmp->cmp_link = cmplast;
		cmplast = cmp;
	}

	for (vn = 0, v = vlist; v != NULL; v = vlink(v))
	  vn++;

	for (v = vlist; v != NULL; v = vlink(v))
	{
		if (vconstraint(v) == NULL) continue;
		cmp = Ncomp(vconstraint(v),Nvpair(vlist,vn));
		cmp->cmp_vp_size = (unsigned short int)vn;
		cmp->cmp_link = cmplast;
		cmplast = cmp;
	}
	return(cmplast);
}

struct clause *remove_modular_literals(cl)
struct clause *cl;
{
	register struct clause *cnext;
	if (cl == NULL) return(NULL);
	if (is_modular_literal(cl->c_form)) {
		cnext = cl->c_link;
		cl->c_link = REST_literals;
		REST_literals = cl;
		return(remove_modular_literals(cnext));
		}
	else {
		cnext = cl->c_link;
		cl->c_link = remove_modular_literals(cnext);
		return(cl);
	}
}

void delete_constraint(vl)	/* vconstraint(v)=NULL for all vl */
struct term *vl;
{
	register struct term *v1, *v2;
	register struct clause *c;

	for (v1 = vl; v1 != NULL; v1 = vlink(v1))
	{
	  if (vconstraint(v1) == NULL) continue;
	  c = vconstraint(v1);
	  for (v2 = vlink(v1); v2 != NULL; v2 = vlink(v2))
	    if (vconstraint(v2) == c) vconstraint(v2) = NULL;
	}
}

int has_pst(t)
register struct term *t;
{
	register int i,a;
	struct term *tt;

	switch((int)t->type.ident) {
	case VAR_VOID_TYPE:
	case VAR_QNT_TYPE:
	case ATOMIC_TYPE: return(FALSE);
	case PST_TYPE: return(TRUE);
	case CLAUSE_TYPE:
	case LIST_TYPE:
	case CONST_LIST_TYPE:
		while ((t != NULL) && (t != NIL)) {
		if (has_pst(head_of_list(t))) return(TRUE);
		else t = tail_of_list(t);
		}
		return(FALSE);
	default:
		if (! is_functor(t)) return(FALSE);
		a = Pred(t)->f_arity;
		if (a < 0) a = -a;
		for (i = 0; i < a; i++) {
			tt = Arg(t,i);
			if (has_pst(tt)) return(TRUE);
		}
	}
	return(FALSE);
}

void divide_consts(cl)
struct clause *cl;
{
	register struct clause *c, *cnext;
	for (c = cl; c != NULL; c = cnext) {
		cnext = c->c_link;
		c->c_link = NULL;
		if (has_pst(c->c_form)) {
			c->c_link = CONST_PST_literals;
			CONST_PST_literals = c;
			}
		else {
			c->c_link = CONST_literals;
			CONST_literals = c;
		}
	}
}

int Attached;

void attach(c, vl)	/* split main */
register struct clause *c;
struct term *vl;
{
	struct clause *cnext;
	register struct term *t;
	register int i, j;
	void divide_consts();

  while (c != NULL) {
	cnext = c->c_link;
	c->c_link = NULL;

	t = c->c_form;

	if (Pred(t)==STAY_P) {
          struct pair *env=Nenv((int)(v_number+p_number));
		i = system_function(t,env,(struct node *)NULL);
		if (i==SUSPEND) {
			c->c_link = REST_literals;
			REST_literals = c;
		}
		else if (i==SYSFAIL) /* in case of FAIL */
			longjmp(split_fail,1); /* --> modular_form() */
	}
	else if (is_modular_literal(t)) {
		c->c_link = REST_literals;
		REST_literals = c;
	}
	else { /* attach_term(c,vl); */
		Attached = FALSE;
		j = (int)Pred(t)->f_arity;
		for (i = 0; i < j; i++) attach_arg(Arg(t,i),c,vl);
		if (Attached == FALSE) divide_consts(c);
	}
	c = cnext;
  }
}

void attach_arg(arg,c,vl)
struct term *arg,*vl;
struct clause *c;
{
  register int i;

  if ((arg == NULL) || (novar(arg))) return;

  if (isvar(arg)) {
    if (arg->type.ident == (long int)VAR_GLOBAL_TYPE) {
      if (vconstraint(arg) == NULL) vconstraint(arg) = c;
      else replace_terms(vconstraint(arg),c,vl);
      Attached = TRUE;
      return;
    }
    else return;
  }

  if (is_list(arg) || is_clause(arg)) {
    attach_arg(head_of_list(arg),c,vl);
    attach_arg(tail_of_list(arg),c,vl);
    return;
  }
  if (is_pst(arg)) {
    struct eclause *plists;
    plists = ((struct pst *)arg)->p_lists;
    while (plists != (struct eclause *)NULL) {
      attach_arg(Arg2(plists->c_form),c,vl);
      plists = plists->c_link;
    }
    return;
  }
  for (i = 0; i < Pred(arg)->f_arity; i++)
    attach_arg(Arg(arg,i),c,vl);
}


void replace_terms(c1,c2,vl)
struct clause *c1;
register struct clause *c2;
struct term *vl;
{
  register struct term *v;

  if (c1 == c2) return;
  for (v = vl; v != NULL; v = vlink(v))
    if (vconstraint(v) == c1) vconstraint(v) = c2;
  while (c2->c_link != NULL)
    c2 = c2->c_link;
  c2->c_link = c1;
}

/*
*Ncomp
*	copy_clause
*       sort_clause
*		copy_term
*			var_trans.
*/

struct compartment *Ncomp(cl,vp) /* alloc compartment */
register struct clause *cl;
struct vpair *vp;
{
	register struct compartment *cmp;
	register struct clause *c;
	struct pair *e1;
	int i;

#ifdef MAC
	cmp = (struct compartment *)alloc(7);	/* sizeof(comp..)=7 */
#else
	cmp = new(compartment);
#endif
	cmp->cmp_vp = vp;
	cmp->cmp_link = NULL;
	cmp->cmp_oldclause = cl;
	
 /* prepare for copy_clause */
	v_list = NULL; v_number = 0;
	pv_list = NULL; p_number = 0; qv_number = 0;

/* copy_clause */
	c = Nclause(copy_term(cl->c_form,vp,MEDIUM),
		    (struct clause *)NULL, MEDIUM);

/* heuristics for avoiding infinite loop in unfold/fold */
/* by restricting the number of variables used in compartment */
	if (v_number > MODULARMAX) {
#ifndef MAC
		FILE *f = wfp;
		wfp = stderr;
#endif
		ttyprint0("Warning: Transformation failure by exceeding the");
		ttyprint0("limit of the number of variables (cf) %%M command");
		ttynl;
		Pclause(cl,(struct pair *)NULL);
		ttynl;
#ifndef MAC
		wfp = f;
#endif
		longjmp(split_fail,1); /* --> modular_form() */
	}

	for (cl = cl->c_link; cl != NULL ; cl = cl->c_link ) {
	  c = Nclause(copy_term(cl->c_form,vp,MEDIUM),c, MEDIUM);
	}

	if (p_number != 0) {
	  renum_pvars((struct pstvar *)pv_list,v_number);
	  e1=Nenv(p_number);
	  i = p_number;
	  while (i > 0) {
	    i--;
	    e1[i].p_body = ((struct pstvar *)pv_list)->old_var;
	    pv_list = ((struct pstvar *)pv_list)->v_link;
	  }
	}
/*	c = sort_clause(c); */
	cmp->cmp_clause = c;
	cmp->cmp_vlist = v_list;
	cmp->cmp_vnum = (unsigned short int)(v_number - qv_number);
	cmp->cmp_anum = (long int)(v_number+p_number);
	return(cmp);
}

struct term *copy_term(t,vp,flag)	/* copy of t */
struct term *t;
struct vpair *vp;
int flag;
{
  struct term *ct, *copy_pst();
  register int i;
	
  if (t==NULL) return(t);

  switch((int)t->type.ident) {
   case VAR_VOID_TYPE:
	return(Anonymous_var);
  case VAR_QNT_TYPE: /* I'm not sure */
  case VAR_GLOBAL_TYPE:
    return(var_trans(t,vp,flag));
  case ATOMIC_TYPE: /* constant term */
  case CONST_LIST_TYPE:
    return(t);
  case LIST_TYPE:
    return((struct term *)
	   Nlist(copy_term(head_of_list(t),vp,flag),
		 (struct clause *)copy_term(tail_of_list(t),vp,flag),
		 flag));
  case CLAUSE_TYPE:
    return((struct term *)
	   Nclause(copy_term(head_of_list(t),vp,flag),
		   (struct clause *)copy_term(tail_of_list(t),vp,flag),
		   flag));
  case PST_TYPE:
    return(copy_pst((struct pst *)t,vp,flag));
  case ECLAUSE_TYPE: /* pst object */
    return((struct term *)
	 Npstobj(copy_term(((struct eclause *)t)->c_form,vp,flag),
		 (struct pair *)NULL,
		 (struct eclause *)
		   copy_term((struct term *)((struct eclause *)t)->c_link,
		   	    vp,flag),
		 flag));
  case VAR_PST_TYPE:
    error("System error occurrs at 'copy_term'");
  default:
    if (isconst_functor(t))
      return(up_const_functor(t,flag));
    ct = Nterm((int)t->t_arity,flag);
    Pred(ct) = Pred(t);
    for (i = 0; i < (int)t->t_arity; i++)
      {
	Arg(ct,i) = copy_term(Arg(t,i),vp,flag);
      }
    return(ct);
  }
}

struct term *copy_pst(pt,vp,flag)
struct pst *pt;
struct vpair *vp;
int flag;
{
  register struct pst *p;

  p = Npst(flag);
  ((struct pstvar *)(p->p_var))->old_var = pt->p_var;
  p->p_lists=(struct eclause *)
    copy_term(((struct term *)pt->p_lists),vp,flag);
  return((struct term *)p);
}


struct term *var_trans(v, vp, flag)	/* var that corresponds to v */
struct term *v;
struct vpair *vp;
int flag;
{
	register int n;
	register struct term *nv;

	n = vnumber(v);
	if (vp[n].v2 == NULL) {
		if (is_qntvar(v))
			sprintf(nbuf,"!V%d",v_number);
		else
			sprintf(nbuf,"V%d",v_number); /* V0,V1,... */
		nv = Nvar(nbuf,flag);
		vp[n].v2 = nv;
		return(nv);
	}
	else {
		nv = vp[n].v2;
		((struct var *)nv)->v_occurrence++;
		return(nv);
	}
}
