/* transform.c */

#include "include.h"
#define DEBUG 0

/*  values of cs->cs_status */
#define REMOVED 1
/* for CSTR_list */
#define UNTOUCHED 0
#define MODULAR_DEFINED 2
#define UNIT_DEFINED 3
/* for DEF_list */
#define DERIVATION 4
#define REGISTERED 5
#define FALSE_REGISTERED 6
#define REDUCED_DEF 7

#define LOWER_RATE (-30)

int ORDERING_FLAG = TRUE;

struct vpair{			/* link between v1 and v2 */
	struct term *v1;
	struct term *v2;
};

struct compartment{
	struct clause *cmp_clause, *cmp_oldclause;
	struct term *cmp_vlist;
	struct vpair *cmp_vp;
	struct compartment *cmp_link;
	long int cmp_anum;
	unsigned short int cmp_vnum;
	unsigned short int cmp_vp_size;
};

#define restore_head(Term,VP,VNUM) (\
    (Term == FAIL) ? MFAIL :\
	Nclause(restore_term(Term,VP,VNUM),(struct clause *)NULL,ETERNAL))

int check_INITDEF()		/* INITDEF_list is satisfiable ??*/
{
	register struct cset *cs;
	for(cs = INITDEF_list; cs != NULL; cs = cs->cs_link)
		if (cs->cs_status == FALSE_REGISTERED)
			return(FALSE);
	return(TRUE);
}

int check_Msolved()
{
	register struct cset *cs;
	for(cs = INITDEF_list; cs != NULL; cs = cs->cs_link)
		if (cs->cs_status != REGISTERED)
			return(FALSE);
	return(TRUE);
}

void remove_from_CSTR(f)	/* used in clear_up_DEF */
struct func *f;
{
	register struct cset *cs;
	register struct clause *c;

	for (cs = CSTR_list; cs != (struct cset *)NULL; cs = cs->cs_link)
		if ((cs->cs_status == UNTOUCHED) ||
                    (cs->cs_status == MODULAR_DEFINED))
			for(c = cs->cs_clause; c != (struct clause *)NULL;
			    c = c->c_link)
				if (Pred(c->c_form) == f) {
				  cs->cs_status = REMOVED;
				  Pred(cs->cs_clause->c_form)->f_setcount--;
				  break;
				}
        for (cs = MODULAR_list; cs != (struct cset *)NULL; cs = cs->cs_link)
          if (cs->cs_status == MODULAR_DEFINED)
			for(c = cs->cs_clause; c != (struct clause *)NULL;
			    c = c->c_link)
				if (Pred(c->c_form) == f) {
				  cs->cs_status = REMOVED;
				  Pred(cs->cs_clause->c_form)->f_setcount--;
				  break;
				}
}

void register_CSTR(f)
struct func *f;
{
	register struct cset *cs;
	register struct clause *c;

	for (cs = CSTR_list; cs != (struct cset *)NULL; cs = cs->cs_link)
		if ((cs->cs_status == UNTOUCHED) &&
			(Pred(cs->cs_clause->c_form) == f)) {
				cs->cs_status = REGISTERED;
				f->f_setcount++;
			}
}


void clear_up_DEF()		/* delete useless clauses */
{
	register struct cset *cs;
	register struct func *f;
	int changed = 1;
        void register_CSTR();

	while(changed == 1)
	{
		changed = 0;
		for (cs = DEF_list; cs != NULL; cs = cs->cs_link)
		{
		 if (cs->cs_status == REMOVED) {
				f = Pred(cs->cs_clause->c_form);
				if (f->f_unitcount > 0) {
					cs->cs_status = REGISTERED;
                                        if (Is_Msolvable)
                                          register_CSTR(f);
                                      }
				else if (f->f_setcount == 0)
				{
					changed = 1;
					cs->cs_status = FALSE_REGISTERED;
					f->f_integ->it_clause->c_form = FAIL;
					remove_from_CSTR(f);
				}
                                else if (M_SOLVED && Is_Msolvable)
                                  register_CSTR(f);
			}
                  else if ((Is_Msolvable) && (cs->cs_status==REGISTERED))
                          register_CSTR(Pred(cs->cs_clause->c_form));
		}
	}
        if (Is_Msolvable) M_SOLVED=FALSE;
}

void add_to_set()		/* register definition clauses */
{
	register struct cset *cs;
	register struct func *f;

	newf_list = index_newflist(newf_list,newfsave);
	for (cs = DEF_list; cs != NULL; cs = cs->cs_link)
	{
		f = Pred(cs->cs_clause->c_form);
		if (cs->cs_status == REGISTERED || 
		    cs->cs_status == REMOVED)
			index_func(f); /* register into global hash table */
		f->f_setcount = f->f_unitcount = 0; /* reset in add_cs_to_set*/
	}
	if (Is_Msolvable) {
          for (cs = CSTR_list; cs != NULL; cs = cs->cs_link) {
			if ((cs->cs_status==REGISTERED) ||
                            (cs->cs_status==MODULAR_DEFINED))
				add_cs_to_set(cs,'a');
		}
	}
        for (cs = MODULAR_list; cs != NULL; cs = cs->cs_link) {
          if (cs->cs_status != REMOVED) add_cs_to_set(cs,'a');
	}
}

/*
*startmodular
*       abandon_transformation
*       init_unfoldfold
*	modular_form
*	foldunfold
*	add_to_set
*       clear_up_DEF
*       end_unfoldfold
*modular_form
*	split(*)
*	satisfiable
*	new_constraint
*		need_trans
*		tyr_fold
*		restore_head
*			restore_term
*				var_reverse
*		new_pred_def
*		set_new_def
*			Ncset
*/
struct clause *startmodular(clist, vlist)	/* entry */
struct clause *clist;
struct term *vlist;
{
	int result;
	void simplify_defs();
	register struct clause *c;

	init_unfoldfold();	/* reset gloval vars */

	if (clist != NULL)
	  clist = modular_form(clist,vlist); /* set DEF_list */
	if (clist == NULL || clist == MFAIL ||DEF_list == NULL) 
	{
		end_unfoldfold();
		return(clist); /* no need for transformation */
	}
	INITDEF_list = DEF_list; /* initial derivation clauses */
	if (setjmp(trans_fail))	/* quit/abort transformation */
	{
		end_unfoldfold();
	/* if clist has defs  */
		for (c = clist; c != NULL; c = c->c_link) {
		  if (Pred(c->c_form)->def.f_set == (struct set *)NULL)
		    return(MFAIL);
		}
		return(clist);
	}
	ORDERING_FLAG = TRUE; /* hack */
	result = foldunfold();
	if (result == TRUE)	/* transformation success */
	{
		clear_up_DEF();
		add_to_set();
		end_unfoldfold();
		if (simplify_flag) simplify_defs(clist);
		return(clist);
	}
	else {			/* transformation failure */
		abandon_transformation();
		end_unfoldfold();
		return(MFAIL);
	}
}

/* define new predicates */
struct clause *modular_form(clist, vlist)
struct clause *clist;
struct term *vlist;
{
	struct compartment *cmp,*cm;
	struct clause *crest, *cc;
	register struct clause *c;

	if (setjmp(split_fail))	{/* quit/abort transformation */
	  return(MFAIL);
	}

	clist = surface_copy_clause(clist,TEMPORAL);
	cmp = split(clist, vlist);

	/* global vars */
	crest = surface_copy_clause(REST_literals,MEDIUM);

	if (CONST_literals != NULL)
		if (! satisfiable(CONST_literals,0)) return(MFAIL);

	for (cm = cmp; cm != NULL; cm = cm->cmp_link) {
	  cc = c = new_constraint(cm);
	  if (c == MFAIL) return(MFAIL);
	  while (c->c_link != NULL)
	    c = c->c_link;
	  c->c_link = crest;
	  crest = cc;
	}
	return(crest);
}

struct clause *new_constraint(cmp)
struct compartment *cmp;
{
	struct term *t;
	struct clause *c;
	
	c = cmp->cmp_clause;
	if (is_modular_clause(c))
	return(restore_head(c->c_form,cmp->cmp_vp,(int)cmp->cmp_vp_size));
/* here works in future */
/*	if (!need_trans(cmp))
	return(restore_head(c->c_form,cmp->cmp_vp,cmp->cmp_vp_size)); */
	t = try_fold(surface_copy_clause(c,TEMPORAL),
			(int)cmp->cmp_vnum, (int)cmp->cmp_anum);
	if (t != NULL)
	{
TTB
		{ FILE *filep = wfp;
		wfp = stdout;
		ttyprint0("#folding "); 
		Pclause(c,(struct pair *)NULL); ttyprint0(" ==> ");
		Pterm(t,(struct pair *)NULL);
		wfp = filep;
		}
TTE
		return(restore_head(t,cmp->cmp_vp,(int)cmp->cmp_vp_size));
	}
	c = new_pred_def(c, cmp->cmp_vlist, (int)cmp->cmp_vnum);
	set_new_def(c,cmp->cmp_vlist, (int)cmp->cmp_anum);
	return(restore_head(c->c_form,cmp->cmp_vp,(int)cmp->cmp_vp_size));
}

struct clause *new_pred_def(cl, vl,vnum)
struct clause *cl;
struct term *vl;
int vnum;
{
	register struct term *v,*t;
	register struct func *newfunc;
	struct clause *c;

	while (1) {
	  sprintf(nbuf, "%s%d", genname, GENSYM++);
	  if (exist_fname(nbuf) == NULL) break;
	}
	newfunc = Nfunc(TEMPFUN, nbuf, vnum);
	newpred(newfunc);
	t = Nterm(vnum,MEDIUM);
	t->type.t_func = newfunc;
	for (vnum = 0, v = vl; v != NULL; v = vlink(v))
		if (! is_qntvar((struct var *)v)) Arg(t,vnum++) = v;
	c = Nclause(t,cl,MEDIUM);
	recalc_voccurrence(c, vl);
	return(c);
}

void set_new_def(c,vl,anum)	/* add c to DEF_list */
struct clause *c;
struct term *vl;
int anum;
{
	register struct cset *s;
	s = Ncset(TEMPORAL);
	s->cs_status = DERIVATION;
	s->cs_clause = c;
	s->cs_link = DEF_list;
	s->cs_anumber = anum;
	s->cs_vlist = vl;
	DEF_list = s;		/* global var */
}

/*
int need_trans(cmp)
struct compartment *cmp;
{
	return(TRUE);
}
*/

/*
*restore_head
*     restore_term
*          restore_pst
*          var_reverse
*/

struct term *restore_term(t,vp,vnum)
struct term *t;
struct vpair *vp;
int vnum;
{
  register int i,n;
  register struct term *ct;
  struct term *restore_pst();

  if (t == NULL) return(NULL);

  switch ((int)t->type.ident) {
    case ATOMIC_TYPE:
    case CONST_LIST_TYPE:
      return(up_const(t,MEDIUM));
	case VAR_QNT_TYPE:
    case VAR_GLOBAL_TYPE:
      return(var_reverse(t,vp,vnum));
    case LIST_TYPE:
      return((struct term *)
	     Nlist(restore_term(head_of_list(t),vp,vnum),
		   (struct clause *)restore_term(tail_of_list(t),vp,vnum),
		   MEDIUM));
    case CLAUSE_TYPE:
      return((struct term *)
	     Nclause(restore_term(head_of_list(t),vp,vnum),
		   (struct clause *)restore_term(tail_of_list(t),vp,vnum),
		   MEDIUM));
    case PST_TYPE:
      return(restore_pst((struct pst *)t,vp,vnum));
    case ECLAUSE_TYPE:
      return((struct term *)
	     Npstobj(restore_term(((struct eclause *)t)->c_form,vp,vnum),
		   (struct pair *)NULL,
		   (struct eclause *)restore_term(
			(struct term *)((struct eclause *)t)->c_link,vp,vnum),
		   MEDIUM));
    case VAR_VOID_TYPE:
      return(Anonymous_var);
    case VAR_PST_TYPE:
      error("System error occurrs at 'restore_term'");
    default:
      if (isconst_functor(t)) return(up_const_functor(t,MEDIUM));
      n = Pred(t)->f_arity;
      ct = Nterm(n,MEDIUM);
      Pred(ct) = Pred(t);
      for(i = 0; i < n; i++)
	  Arg(ct,i) = restore_term(Arg(t,i),vp,vnum);
      return(ct);
    }
}

struct term *restore_pst(pt,vp,vnum) /* in restore_term */
struct pst *pt;
struct vpair *vp;
int vnum;
{
  register struct pst *p;

#ifdef MAC
  p = (struct pst *)challoc(3);	/* sizeof(pst) = 3 */
#else
  p = cnew(pst);
#endif

  p->type = PST_TYPE;
  p->p_var = vp[vnum + vnumber(pt->p_var)].v1;
  p->p_lists=
    (struct eclause *)restore_term(
		(struct term *)((struct pst *)pt)->p_lists,vp,vnum);
  return((struct term *)p);
}

struct term *var_reverse(v,vp,vnum) /* in restoer_term */
struct term *v;
struct vpair *vp;
int vnum;
{
	register int i;

	for (i = 0; i < vnum; i++)
		if (vp[i].v2 == v) return(vp[i].v1);
#ifndef MAC
	fprintf(stderr,"error in var_reverse\n");
#else
	ttyprint0("error in var_reverse\r");
#endif
	return(NULL);
}

/*		
*foldunfold
*	clear_up_DEF
*	check_INITDEF
*	unfold_derivation
*               reorder
*       unfold_cstr
*			energy.
*               apply
*                     apply_add_clause
*                          add_clause
*                     extend_apply
*		eclause_conc.
*		up_init.
*		up_eclause
*		up_restore.
*		add_clause
*			is_modular_clause
*			add_set
*		hornclause.
*		reduce_clause
*			eclause_conc
*			one_def_literal.
*			safe_unify.
*	register_newpred
*	add_cs_to_set
*/

int is_modular_head(t)		/* check head t is modular or not */
struct term *t;
{
	struct func *f;
	register int i;
	register struct term *arg;

	if (! is_functor(t))
	  error_detail(t,(struct pair *)NULL,
		"Only Functors can be used as Constraints");

	f = Pred(t);
	for (i = 0; i < f->f_arity; i++)
	{
		arg = Arg(t,i);
		if (isvar(arg)) 
		{
			if (vheadoccurrence(arg) > 1) /* double occurrence */
				return(FALSE); 
		}
		else return(FALSE);
	}
	return(TRUE);
}

void move_cstr_to_modular(cs,csback)
struct cset *cs,*csback;
{
  struct cset *temp = cs->cs_link;

  if (cs == CSTR_list) CSTR_list=temp;
  else csback->cs_link=temp;

  cs->cs_link=MODULAR_list;
  MODULAR_list=cs;
}

void remove_modular_from_cstr()
{
  struct cset *cs,*csback;

  for (csback=cs=CSTR_list; cs != (struct cset *)NULL;
       csback=cs, cs=cs->cs_link)
    if ((cs->cs_status == MODULAR_DEFINED) ||
        (cs->cs_status == UNIT_DEFINED))
      move_cstr_to_modular(cs,csback);
}

int foldunfold()		/* fold-unfold transformation main */
{
	register struct cset *cs, *csback;
	struct clause *body;
	register struct func *f;
#ifdef MAC
	EventRecord		myEvent;
#endif
	void unfold_derivation(),unfold_cstr(),quit_transformation(),
             move_cstr_to_modular(),remove_modular_from_cstr();
        int check_Msolved();

	for (;;)
	{
#ifdef MAC
	MaintainCursor();
	SystemTask();
	TEIdle(TEH);
	if (GetNextEvent(everyEvent, &myEvent)) {
	    switch (myEvent.what) {
   		case autoKey:
	    case keyDown: {
			register char	theChar;
			theChar = myEvent.message & charCodeMask;
			if ((myEvent.modifiers & cmdKey) != 0)
				if (theChar == '.') {
					SysBeep(10);
					interrupt_question();
					break;
				}
			}
		}
	}
#endif
		clear_up_DEF();
		if (check_INITDEF() == FALSE) return(FALSE);
		if ((Is_Msolvable) && (check_Msolved()==TRUE))
                  return(TRUE);
TTB
		P_status(FALSE);	/* print stack */
		if Is_ctstep 
			if (step_asking() != 0) { /* user's input */
				ORDERING_FLAG = FALSE;
				continue;
			}
TTE

	/* target def-clause */
		for (cs = DEF_list; cs != NULL; cs = cs->cs_link)
			if (cs->cs_status == DERIVATION) break;
		if (cs != NULL) /* unfold def-clause */
		{
			unfold_derivation(cs);
			ORDERING_FLAG = FALSE;
			continue;
		}
		/* get one clause from CSTR_list*/
		for (csback = cs = CSTR_list; cs != NULL;
                     csback = cs, cs = cs->cs_link)
			if (cs->cs_status == UNTOUCHED) break;

		if (cs == NULL) return(TRUE);
		f = Pred(cs->cs_clause->c_form);
		if (is_modular_head(cs->cs_clause->c_form))
		{
			unfold_cstr(cs);
			ORDERING_FLAG = FALSE;
                        remove_modular_from_cstr();
			continue;
		}
		body = modular_form(cs->cs_clause->c_link, cs->cs_vlist);
		cs->cs_clause->c_link = body;
		if (body == MFAIL) /* fail transformation */
		{
			cs->cs_status = REMOVED;
			f->f_setcount--;
		}
		else if (body == NULL) /* unit definition */
		{
			cs->cs_status = UNIT_DEFINED;
			f->f_unitcount++;
                        move_cstr_to_modular(cs,csback);
TTB
			ttyprint1("#reduce body <%d>",cs->cs_number);
TTE
		}
		else 
		{
			cs->cs_status = MODULAR_DEFINED;
                        move_cstr_to_modular(cs,csback);
TTB
			ttyprint1("#modularize <%d>",cs->cs_number);
TTE
		}
	ORDERING_FLAG = FALSE;
	}
}

void unfold_derivation(cs)	/* unfold derivation clause (in unfoldfold) */
struct cset *cs;	
{
	struct clause *tc, *ccopy, *eval_list;
	struct func *f;
	struct itrace *it;
	int res;
	struct clause *reorder();
	int macapply();

	ccopy = surface_copy_clause(cs->cs_clause,ETERNAL);
	eval_list = (struct clause *)NULL;
/* trick --- eval_list and cs->cs_clause->c_link is changed */
	tc = reorder(cs->cs_clause, &eval_list);
/* no need for transformation */
	if (tc == NULL) {
		if (eval_list == (struct clause *)NULL) {
			cs->cs_status = REGISTERED;
			return;
		}
	res = macapply(cs->cs_clause->c_form,
			(int)cs->cs_anumber,eval_list);
	}
	else {
	TTB /* print target literal */
		{
		FILE *filep = wfp;
		wfp = stdout;
		ttyprint1("#unfold-[%d] ",cs->cs_number);
		Pterm(tc->c_form,(struct pair *)NULL);
		wfp = filep;
		}
	TTE
	res = apply(tc->c_form,cs->cs_clause->c_form,
		cs->cs_clause->c_link,(int)cs->cs_anumber,eval_list);
	}

	f = Pred(cs->cs_clause->c_form);
#ifdef MAC
/* sizeof(itrace)=3 */
	f->f_integ = it = (struct itrace *)salloc(3);
#else
	f->f_integ = it = snew(itrace);
#endif
/* trick for tc and cs->cs_clause->c_link */
	if (tc != NULL) {
		if (eval_list != (struct clause *)NULL) {
			struct clause *temp = tc;
			tc = eval_list;
			while (eval_list->c_link != (struct clause *)NULL)
				eval_list=eval_list->c_link;
			eval_list->c_link=temp;
			temp->c_link = cs->cs_clause->c_link;
		}
		else tc->c_link=cs->cs_clause->c_link;
	}
	else tc=eval_list;
	cs->cs_clause->c_link=tc;
	it->it_clause = ccopy;
	it->it_anumber = cs->cs_anumber;
	it->it_cnumber = literalnumber(tc);
	it->it_link = newf_list; newf_list = it;
	if (res == FALSE)
	{
		it->it_clause->c_form = FAIL;
		cs->cs_status = FALSE_REGISTERED;
		remove_from_CSTR(f);
		TTB ttyprint0(" ->FAIL"); TTE
	}
	else
	{
		if (f->f_unitcount > 0L) {
			cs->cs_status = REGISTERED;
                      }
		else cs->cs_status = REMOVED;
		TTB ttyprint0(" =>TRUE"); TTE
	}
}

void insert_cs(cs,newcs)	/* used in unfold_cstr */
struct cset *cs, *newcs;	/* append newcs after cs */
{
	register struct cset *c;

	if (newcs == NULL) return;
	for (c = newcs; c->cs_link != NULL; c = c->cs_link);
	c->cs_link = cs->cs_link;
	cs->cs_link = newcs;
}

struct cset *from_to(s1,s2)	/* used in unfold_cstr */
struct cset *s1,*s2;		/* s1->..->c->s2 ===> s1->..->c->NULL*/
{
	struct cset *c;
	if (s1 == s2) return(NULL);
	for (c = s1; c->cs_link != s2; c= c->cs_link);
	c->cs_link = NULL;
	return(s1);
}

void unfold_cstr(cs)	/* unfold CSTR clause (in unfoldfold) */
struct cset *cs;	
{
	struct clause *tc, *eval_list;
	struct func *f;
	int res;
	struct cset *cstr_save;	/* old CSTR_list */
	struct clause *reorder();
	int macapply();

	eval_list = (struct clause *)NULL;
/* trick --- eval_list and cs->cs_clause->c_link is changed */
	tc = reorder(cs->cs_clause, &eval_list);
/* no need for transformation */
	if (tc == NULL) {
		if (eval_list ==(struct clause *)NULL) {
		cs->cs_status = MODULAR_DEFINED;
		return;
		}
	}
	else {
TTB /* print target literal */
	ttyprint1("#unfold=[%d] ",(int)cs->cs_number);
	{ FILE *filep = wfp;
	wfp = stdout;
	Pterm(tc->c_form,(struct pair *)NULL);
	wfp = filep;
	}
TTE
	}

	f = Pred(cs->cs_clause->c_form);
	f->f_setcount--;
	cs->cs_status = REMOVED;
	cstr_save = CSTR_list;
	if (tc == NULL)
		res = macapply(cs->cs_clause->c_form,(int)cs->cs_anumber,eval_list);
	else
		res = apply(tc->c_form,cs->cs_clause->c_form,
			cs->cs_clause->c_link,(int)cs->cs_anumber,eval_list);
	if (res == FALSE)
	{
		TTB ttyprint0(" ->FAIL"); TTE
	}
	else
	{
		struct cset *newcs;
		newcs = from_to(CSTR_list,cstr_save); /* new defs */
		CSTR_list = cstr_save;
		insert_cs(cs,newcs); /* put newcs after cs */
		TTB ttyprint0(" =>TRUE"); TTE
	}
}

int apply(target,head,rest,anum,ecl) /* head:-target,rest. */
struct term *target,*head;
struct clause *rest, *ecl;
int anum;
{
  struct pair *esave = ep;
  struct pair *e0 = Nenv(anum);
  struct func *f = Pred(target);
  struct node *dummy;
  struct eclause *ec;
  struct ustack *usave = usp;
  struct term *t;
  int extend_apply();

  dummy = Newnode((struct clause *)NULL,(struct eclause *)NULL,
	(struct pair *)NULL,(struct node *)NULL,(struct node *)NULL);
  while (ecl != (struct clause *)NULL) {
    t = ecl->c_form; ecl=ecl->c_link;
    if (system_function(t,e0,dummy) == SYSFAIL) {
      ep = esave;
      return(FALSE);
    }
  }

  if (issystem(f)) {
    if (isfunc(f)) {
      if (f == FORALL_P) {
      	return(forall_apply(target,head,rest,e0,dummy,esave,anum));
      	}
      else if (system_function(target,e0,dummy) == SYSFAIL) {
		ep = esave;
		return(FALSE);
	}
/* else */
      /* has solution */
      ec = reduce_clause(rest,e0);
      if (ec == (struct eclause *)MFAIL) 
      {
	      ep = esave; return(FALSE);
      }
      apply_add_clause(head,e0,ec);
      ep = esave;
      return(TRUE);
    }
    else  { /* isnonfunc */
     if (system_pred(target,e0,dummy,dummy,DOWN) == SYSFAIL)
	return(FALSE);
      /* has possibly many solutions */
      do {
	ec = reduce_clause(rest,e0);
	apply_add_clause(head,e0,ec);
	undo(usave);
	e0 = Nenv(anum);
      } while (system_pred(target,e0,dummy,dummy,BACKTRACK) == SYSTRUE);
      ep = esave;
      undo(usave);
      return(TRUE);
    }
  }
/* user predicate */
    return(extend_apply(target,head,rest,e0,f,f->def.f_set));
}

int extend_apply(target,head,rest,e0,f,s) /* in apply */
struct term *target,*head;
struct clause *rest;
struct pair *e0;
struct func *f;
register struct set *s;
{
  struct eclause *ec;
  struct ustack *usave = usp;
  long int *hsave;
  struct pair *e1;
  int cn;

  if (s == (struct set *)NULL) {
    if (Handle_Undefined == TRUE) {
      sprintf(nbuf,">>> %s <<< is UNDEFINED!",f->f_name);
      error(nbuf);
    }
    else return(FALSE);
  }

  for (cn = 0 ; s != NULL; s = s->s_link) {
    hsave = hp;
    e1 = Nenv((int)s->s_anumber);
    if (tunify(target,e0,s->s_clause->c_form,e1,1)==FALSE) /* safe unify */
    {
      undo(usave); hp = hsave;
      continue;
     }
    ec = eclause_conc(reduce_clause(rest,e0),
		eclause_conc(reduce_clause(s->s_clause->c_link, e1),
			reduce_clause(s->s_constraint,e1)));
    if (apply_add_clause(head,e0,ec)!=FALSE)
	    cn++;		/* # of new clauses */
    undo(usave); /* restore environments */
  }
  if (cn == 0) return(FALSE);
  else return(TRUE);
}

int apply_add_clause(head,e0,ec) /* in apply, extend_apply */
struct term *head;
struct pair *e0;
struct eclause *ec;
{
  struct clause *newbody;
  struct term *newhead;
  struct pair *e1;
  int i, empty_flag;

  if (ec == (struct eclause *)MFAIL) return(FALSE);
  up_init();
  newhead = termset(head,NULL, e0, MEDIUM);
  newbody = up_eclause(ec, MEDIUM);
  empty_flag = (newbody == (struct clause *)NULL);

  if (p_number != 0) {
      renum_pvars((struct pstvar *)pv_list,v_number);
      e1=Nenv(p_number);
      i = p_number;
      while (i > 0) {
	i--;
	e1[i].p_body = ((struct pstvar *)pv_list)->old_var;
	e1[i].p_env = e0;
	pv_list = ((struct pstvar *)pv_list)->v_link;
      }
    }
    newbody = up_restore(newbody,MEDIUM);

  add_clause(Nclause(newhead,newbody,MEDIUM), v_list, v_number+p_number,empty_flag);
  return(TRUE);
}

/*  select a target literal 
    energy
*/
#ifdef DEBUG
void Penergy(cl)
struct clause *cl;
{
	FILE *filep = wfp;
	register struct clause *c;
	wfp = stdout;
	for (c = cl; c != NULL; c = c->c_link)
	{
		Pterm(c->c_form,(struct pair *)NULL);
		ttyprint1("<%d>,",energy(c->c_form));
	}
	wfp = filep;
}
#endif

struct clause *reorder(cl,ecl)	/* used in unfold_derivation, _cstr */
struct clause *cl, **ecl;	/* cl:literals, tc:target literal */
{
	register struct clause *c, *cc, *ecc;
	register int cte, ce;
	struct clause *tcc;
	struct clause *tc = (struct clause *)NULL;

#if DEBUG == 1
	ttyprint0("ENERGY: ");
	Penergy(cl);
	ttynl;
#endif
	if (cl->c_link == NULL) return((struct clause *)NULL);
        cc = cl;
        ecc = (struct clause *)NULL;
        for (c = cc->c_link; c != NULL; c = cc->c_link) {
          if (Pred(c->c_form)==EQ2_P) {
		cc->c_link=c->c_link;
		c->c_link=ecc;
		ecc=c;
              }
	  else {
            if (tc == (struct clause *)NULL) {
		 if (ORDERING_FLAG) cte=energy(c->c_form);
		tc=c;
                tcc=cc;
              }
	    else if (ORDERING_FLAG) {
		ce = energy(c->c_form);
		if (ce > cte) {
			cte=ce;
			tc=c;
                        tcc=cc;
                      }
		}
            cc=cc->c_link;
	  }
     }
/* blush up */
  if (tc != NULL) tcc->c_link=tc->c_link;
  c = ecc;
  if (ecc != (struct clause *)NULL) {
    ecc=c->c_link;
    c->c_link=(struct clause *)NULL;

    while (ecc != (struct clause *)NULL) {
      cc = ecc->c_link;
      ecc->c_link=c;
      c=ecc;
      ecc=cc;
    }
  }
  *ecl = c;
  return(tc);
}

int energy(tm)			/* enegy function of literal t */
struct term *tm;
{
	int arity = 0, con = 0, vn = 0, funct = 0, rec = 0, 
	allunit = 0, defs = 0, units = 0;
	struct func *f;
	register struct term *t;
	register int i;

	f = Pred(tm);
	if (issystem(f)) return(LOWER_RATE);
	arity = (int)f->f_arity;
	for (i = 0; i < arity; i++) {
		t = Arg(tm,i);
		if (novar(t)) con++;
		else if (isvar(t)) vn+=(voccurrence(t) - 1);
		else funct++;
	}
	rec = isrecursive(f);
	allunit = isallunit(f);
	defs = f->f_setcount;
	units = (int)f->f_unitcount;
	return(con * 3 + funct * 2 + vn - defs + units
	       - rec * 2 + allunit * 3);
}

int macapply(head,anum,ecl)
struct term *head;
struct clause *ecl;
int anum;
{
	struct pair *esave = ep;
	struct pair *e0 = Nenv(anum);
	struct node *dummy = 
		Newnode((struct clause *)NULL,(struct eclause *)NULL,
		(struct pair *)NULL,(struct node *)NULL,(struct node *)NULL);
	struct term *t;
	struct pair *e1;
	int i;

	while (ecl != (struct clause *)NULL) {
		t = ecl->c_form; ecl=ecl->c_link;
		if (system_function(t,e0,dummy) == SYSFAIL) {
			ep = esave;
			return(FALSE);
		}
	}

	up_init();
	EVAL_PST_FLAG = TRUE;
	t = termset(head,NULL,e0,MEDIUM);
	if (p_number != 0) {
		renum_pvars((struct pstvar *)pv_list,v_number);
		e1 = Nenv(p_number);
		i = p_number;
		while (i > 0) {
			i--;
			e1[i].p_body = ((struct pstvar *)pv_list)->old_var;
			e1[i].p_env = e0;
			pv_list = ((struct pstvar *)pv_list)->v_link;
		}
	}
	up_restore(NULL,MEDIUM);
	add_clause(Nclause(t,(struct clause *)NULL,MEDIUM), v_list, p_number,TRUE);
	return(TRUE);
}

int forall_apply(target,head,rest,e0,dummy,esave,anum)
struct term *target,*head;
struct clause *rest;
struct pair *e0,*esave;
struct node *dummy;
int anum;
{
	struct term *one, *ante = Arg1(target);
	struct clause *c, *cons = (struct clause *)Arg2(target);
	struct eclause *ec, *ecl;
	struct func *f;
	struct pair *esave2 = ep;
	struct ustack *usave = usp;
	struct set *saves = (struct set *)NULL;
	char *emsg = "Constraint Transformation ERROR in FORALL";
	struct eclause *clause_eclause();
	struct set *save_forall_clause();
	void sort_adjust();

	if (is_clause(ante)) {
		c = ((struct clause *)ante)->c_link;
		ante = ((struct clause *)ante)->c_form;
	} else if (is_functor(ante)) c=(struct clause *)NULL;
	else {
		error_detail(target,e0,emsg);
	}
	if (! is_clause((struct term *)cons)) {
		if (is_functor((struct term *)cons))
			cons = Nclause((struct term *)cons,
					(struct clause *)NULL,MEDIUM);
		else error_detail(target,e0,emsg);
	}

	f = ante->type.t_func;
	if (issystem(f)) {
	     if (isfunc(f)) {
	       if (system_function(ante,e0,dummy) == SYSFAIL) {
		ec = reduce_clause(rest,e0);
		}
      /* has solution */
	       else if (c == (struct clause *)NULL) {
		      	c = cons;
		      	while (cons->c_link != (struct clause *)NULL)
				cons = cons->c_link;
			cons->c_link=rest;
		      	ec = reduce_clause(c,e0);
	      	}
	       else {
		ante = Nterm(2,MEDIUM);
		ante->type.t_func=FORALL_P;
		Arg1(ante)=(struct term *)c;
		Arg2(ante)=(struct term *)cons;
		rest = Nclause(ante,rest,MEDIUM);
		ec = reduce_clause(rest,e0);
		}

	     if (ec == (struct eclause *)MFAIL) {
	     apply_add_clause(head,e0,ec);
	     ep = esave;
	     return(TRUE);
	     }
	   }
	   else  { /* isnonfunc */
		ec = reduce_clause(rest,e0);
		saves = save_forall_clause(head,e0,ec,(struct set *)NULL);

	     if (system_pred(ante,e0,dummy,dummy,DOWN) != SYSFAIL) {
		do {  /* has possibly many solutions */
			if (c == (struct clause *)NULL) {
		ecl = clause_eclause(cons,e0,(struct eclause *)NULL,TEMPORAL);
		saves->s_link = save_forall_clause(head,e0,ecl,saves->s_link);
		      	}
			else {
		      		ante = Nterm(2,MEDIUM);
		      		ante->type.t_func=FORALL_P;
	      			Arg1(ante)=(struct term *)c;
				Arg2(ante)=(struct term *)cons;
			ecl = clause_eclause(ante,e0,(struct eclause *)NULL,MEDIUM);
			saves->s_link = save_forall_clause(head,e0,ecl,saves->s_link);
	     	}
		undo(usave);
		ep = esave;
		e0 = Nenv(anum);
	} while (system_pred(ante,e0,dummy,dummy,BACKTRACK) == SYSTRUE);
	}
    sort_adjust(saves);
    undo(usave);
    ep = esave;
    return(TRUE);
    }
  }

/* user predicate */
 {
	register struct set *s = f->def.f_set;
	struct pair *e1;
	struct set *ss;

	if (s == (struct set *)NULL) {
		if (Handle_Undefined == TRUE) {
			sprintf(nbuf,">>> %s <<< is UNDEFINED!",f->f_name);
			error_detail(target,e0,nbuf);
		}
		else return(FALSE);
	}

	ec = clause_eclause(rest,e0,(struct eclause *)NULL,TEMPORAL);
	saves = save_forall_clause(head,e0,ec,saves);

	for ( ; s != NULL; s = s->s_link) {
	e1 = Nenv((int)s->s_anumber);
	if (tunify(ante,e0,s->s_clause->c_form,e1,1)==FALSE) {
		undo(usave);
		continue;
	}
	if (s->s_clause->c_link == (struct clause *)NULL) {
	  if (c == (struct clause *)NULL) {
		ecl = clause_eclause(cons,e0,(struct eclause *)NULL,TEMPORAL);
		saves->s_link = save_forall_clause(head,e0, ecl,saves->s_link);
		}
	  else {
		ante = Nterm(2,MEDIUM);
		ante->type.t_func=FORALL_P;
		Arg1(ante)=(struct term *)c;
		Arg2(ante)=(struct term *)cons;
		ecl = clause_eclause(ante,e0,(struct eclause *)NULL,MEDIUM);
		saves->s_link = save_forall_clause(head,e0,ecl,saves->s_link);
		}
	} else {
	struct term *newhead;

	up_init(); EVAL_PST_FLAG = TRUE;
	ante = Nterm(2,MEDIUM);
	ante->type.t_func=FORALL_P;
	Arg1(ante)=termset((struct term *)s->s_clause->c_link,NULL,e1,TEMPORAL);
	Arg2(ante)=termset((struct term *)cons,NULL,e0,TEMPORAL);
	if (c != (struct clause *)NULL) {
	  c = (struct clause *)termset((struct term *)c,NULL,e0,TEMPORAL);
	  for (cons = c; cons->c_link != (struct clause *)NULL; )
		cons = cons->c_link;
	  cons->c_link = (struct clause *)Arg1(ante);
	  Arg1(ante) = (struct term *)c;
	}

	newhead = termset(head,NULL,e0,TEMPORAL);

  if (p_number != 0) {
      renum_pvars((struct pstvar *)pv_list,v_number);
    }
    up_restore(NULL,MEDIUM);

#ifdef MAC
	ss = (struct set *)challoc(5);	/* sizeof(set) = 5 */
#else
	ss = cnew(set);
#endif
	ss->s_bodynumber = 0; /* check mark in sort_adjust */
	ss->s_link = saves->s_link;
	ss->s_clause = Nclause(newhead,Nclause(ante,NULL,TEMPORAL),TEMPORAL);
	ss->s_anumber = (unsigned short int)(v_number+p_number);
	ss->s_vlist = v_list;
	saves->s_link = ss;
	}
	undo(usave);
	ep = esave2;
	}

    sort_adjust(saves);
    undo(usave);
    ep = esave;
    return(TRUE);
  }

}

struct eclause *clause_eclause(c,e,ec,flag)
register struct clause *c;
struct pair *e;
register struct eclause *ec;
int flag;
{
	while (c != (struct clause *)NULL) {
		ec = Neclause(c->c_form,e,ec,flag);
		c = c->c_link;
	}
	return(ec);
}

struct set *save_forall_clause(head,e0,ec,saves)
struct term *head;
struct pair *e0;
struct eclause *ec;
struct set *saves;
{
  struct clause *newbody;
  struct term *newhead;
  struct pair *e1;
  struct set *ss;
  int i;

  up_init();
  newhead = termset(head,NULL, e0, TEMPORAL);
  newbody = up_eclause(ec, TEMPORAL);

  if (p_number != 0) {
      renum_pvars((struct pstvar *)pv_list,v_number);
      e1=Nenv(p_number);
      i = p_number;
      while (i > 0) {
	i--;
	e1[i].p_body = ((struct pstvar *)pv_list)->old_var;
	e1[i].p_env = e0;
	pv_list = ((struct pstvar *)pv_list)->v_link;
      }
    }
    newbody = up_restore(newbody,TEMPORAL);

#ifdef MAC
	ss = (struct set *)challoc(5);	/* sizeof(set) = 5 */
#else
	ss = cnew(set);
#endif
	ss->s_link = saves;
	ss->s_bodynumber = 0; /* check mark */
	ss->s_clause = Nclause(newhead,newbody,TEMPORAL);
	ss->s_anumber = v_number+p_number;
	ss->s_vlist = v_list;
	return(ss);
}

void sort_adjust(s)
struct set *s;
{
struct set *ss;
struct pair *e1,*e2,*esave2, *esave = ep;
struct term *head;
struct eclause *body, *clause_eclause();
struct ustack *usave2, *usave = usp;
int loopflag = (s->s_link != (struct set *)NULL);

ss = s->s_link;
head = s->s_clause->c_form;
e1 = Nenv(s->s_anumber);
body = clause_eclause(s->s_clause->c_link,e1,(struct eclause *)NULL,TEMPORAL);
while (loopflag) {
	loopflag = FALSE;
	while(ss != (struct set *)NULL) {
	   if (ss->s_bodynumber == FALSE) {
		usave2 = usp; esave2 = ep;
		e2 = Nenv(ss->s_anumber);
		if (tunify(head,e1,ss->s_clause->c_form,e2,TRUE) == FALSE) {
			loopflag = TRUE;
			undo(usave2);
			ep = esave2;
		}
		else {
			if (s->s_bodynumber == FALSE) s->s_bodynumber = TRUE;
			ss->s_bodynumber = TRUE;
			body = clause_eclause(ss->s_clause->c_link,e2,
						body,TEMPORAL);
		}
	   }
	  ss=ss->s_link;
         }
	apply_add_clause(head,e1,body);
	undo(usave);
      }
if (s->s_bodynumber == FALSE) apply_add_clause(head,e1,body);
undo(usave);
ep = esave;
}
