/*
*
*		cu-Prolog (Constraint Unification Prolog)
*   Copyright: Institute for New Generation Computer Technology,Japan 1989
*		<<<< read.c >>>>		
*		function for input
*
*88/6/10
*88/6/12
*89/6/16-27 for CAHC
*90.4.1 ver3.0
*90.7.1 ver3.10
*/

#include "include.h"
#ifdef MAC
#include "macconst.h"

#define NextTRUE	3		/* for Reader control */
#endif

/* Classification of Characters */
#define BL  001  /* blank */
#define UC  002  /* Upper Character */
#define LC  003  /* Lower Character */
#define UL  004  /* UnderLine */
#define N   005  /* Numeric */
#define SG  006  /* sign, +- */
#define SP  007  /* special character */
#define Q   010  /* single/double quote */
#define CT  011  /* Cut */
#define CM  012  /* comment character */
#define BR  013  /* Brackets, Commas */
#define CO  014  /* Constraint Marker */

#define kanzi(CH)       ((CH > 128) || (CH < 0)) /* for EUC */
#define alpha   (kanzi(cbuf) || ((UC <= char_type[cbuf]) && \
				 (char_type[cbuf] <= N)))

/* special characters are #$%&*+-/:<=>?@\^|~ */
#define specialchar(C)	((! kanzi(C)) && ((char_type[C] == SG) || \
					  (char_type[C] == SP)))
#define delimitchar(C)  ((! kanzi(C)) && ((char_type[C] >= BR) || (C == '.')))
#define bracket(C)      ((! kanzi(C)) && (char_type[C] == BR))

#define quotesign       ((! kanzi(cbuf)) && (char_type[cbuf] == Q))
#define white           ((! kanzi(cbuf)) && (char_type[cbuf] == BL))

#define numeric(X)   ((X == '-') || ((! kanzi(X)) && (char_type[X]==N)))
#define isdigit(X)   ((! kanzi(X)) && (char_type[X]==N))
#define isxdigit(X)  ((! kanzi(X)) && ((char_type[X]==N) || \
		((char_type[X] == LC) && ('a' <= X) && (X <= 'f')) || \
		((char_type[X] == UC) && ('A' <= X) && (X <= 'F'))))
#define is_varname(X)  ((X == '_') || ((! kanzi(X)) && (char_type[X]==UC)))

#define notconst_list(L) (((struct clause *)L)->c_type != CONST_LIST_TYPE)
#define isconst_list(L) (((struct clause *)L)->c_type == CONST_LIST_TYPE)

#ifdef MAC
/* macread.c --- programs for Macintosh */

THPrint	hPrint = NULL;
int		tabWidth;


/* copies a pascal string from p1 to p2 */
void pStrCopy( p1, p2 )
register char *p1, *p2;
{
	register int len;
	
	len = *p2++ = *p1++;
	while (--len>=0) *p2++=*p1++;
}

/*
void pStrCopy2( p1, p2 )
register char *p1, *p2;
{
	register int len;
	
	len  = *p1++;
	while (--len>=0) *p2++=*p1++;
	*p2 = '\0';
}
*/

int size_item(i)
int i;
{
	switch (i) {
	case 9: return(Nine);
	case 10: return(Ten);
	case 12: return(Twelve);
	case 14: return(Fourteen);
	case 18: return(Eighteen);
	case 24: return(TwentyFour);
	case 36: return(ThirtySix);
	}
}

/*
int font_item(i)
int i;
{
	if (i<10) return(i-1);
	else if (i < 13) return(i-2);
	else if (i < 25) return(i-9);
#ifdef JAPANESE
	else if (i < 16386) return(i-16368);
	else return(i-16622);
#endif
}

int font_item_num(i)
int i;
{
	switch (i) {
	case newYork:
	case geneva:
	case monaco:
	case venice:
	case london:
	case athens:
	case sanFran:
	case toronto: return(i+1);
	case cairo:
	case losAngeles: return(i+2);
	case times:
	case helvetica:
	case courier:
	case symbol:
	case taliesin: return(i+9);
#ifdef JAPANESE
	case oosaka:
	case kyoto:	return(i+16368);
	case chu_gothic:
	case sai_mincho:	return(i+16622);
#endif
	}
}
*/

CheckPrintHandle()
{
	if (hPrint==NULL) 
		PrintDefault(hPrint = (TPrint **) NewHandle( sizeof( TPrint )));
}

DoPageSetUp()
{
	PrOpen();
	CheckPrintHandle();
	if (PrStlDialog(hPrint)) ;
	PrClose();
}

#define tabChar	((char)'\t')

MyDrawText(p, count)
char	*p;
int		count;
{
	register char	*p1, *p2;
	int				len;
	Point			pt;

	p1 = p;
	p2 = p+count;
	while (p<p2) {
		while ((p1<p2) && (*p1 !=tabChar)) *p1++;
		if ((len=p1-p)>0) DrawText( p, 0, p1-p );
		if (*p1==tabChar) {
			GetPen(&pt);
			Move((tabWidth-(pt.h-leftMargin)%tabWidth), 0);
			*p1++;
		}
		p = p1;
	}
}

PrDoc(hText, count, hPrint, font, size)
char		**hText;
long		count;
THPrint 	hPrint;
int			font;
int			size;
{
	register int 	line = 0;
	register int 	lastLineOnPage = 0;
	int				length;
	Rect 			printRect;
	int 			linesPerPage;
	int 			lineBase;
	int 			lineHeight;
	register char 	*ptr, *p1;
	FontInfo		info;
	TPPrPort		printPort;

	printPort = PrOpenDoc( hPrint, 0L, 0L );
	SetPort(printPort);
	TextFont(font);
	TextSize(size);
	printRect = (**hPrint).prInfo.rPage;
	GetFontInfo( &info );
	lineHeight = info.leading+info.ascent+info.descent;
	linesPerPage = 
	  (printRect.bottom-printRect.top-topMargin-bottomMargin)/lineHeight;
	HLock(hText);
	ptr = p1 = (*hText);
	do {
	  PrOpenPage( printPort, 0L );
	  lastLineOnPage += linesPerPage;
	  MoveTo( printRect.left+leftMargin, 
		 (lineBase = printRect.top+lineHeight) );
	  do {
	    /* PrintLine: */
	    while ((ptr<=(*hText)+count) && (*ptr++ != (char)'\r')) ;
	    if ((length=(int)(ptr-p1)-1)>0) MyDrawText(p1, length);
	    MoveTo( printRect.left+leftMargin, (lineBase += lineHeight));
	    p1 = ptr;
	  } while ((++line != lastLineOnPage) && (ptr<(*hText)+count));
	  PrClosePage( printPort );
	} while (ptr<(*hText)+count);
	HUnlock(hText);
	PrCloseDoc( printPort );
}

PrintText(hText, length, gp, tabPixels)
char	**hText;
long	length;
GrafPtr	gp;
int		tabPixels;
{
	TPPrPort	printPort;
	GrafPtr		savePort;
	TPrStatus	prStatus;
	int			copies;
	
    PrOpen();
	CheckPrintHandle();
	tabWidth = tabPixels;
	SetCursor( &arrow );
	if (PrJobDialog(hPrint) != 0) {
	  PleaseWait();
	  GetPort(&savePort);
	  for (copies=HowMany(); copies>0; copies--) {
	    PrDoc (hText, length, hPrint, (*gp).txFont, (*gp).txSize);
	    PrPicFile( hPrint, 0L, 0L, 0L, &prStatus );
	  }
	  SetPort(savePort);
	}
	PrClose();
}

PleaseWait()
{
	SetCursor( &waitCursor );
}

HowMany()
{
	return( ((**hPrint).prJob.bJDocLoop==bDraftLoop) ? 
				(**hPrint).prJob.iCopies : 1 );
}


AdjustText ()

{
	int		oldScroll, newScroll, delta;
	
	oldScroll = (**TEH).viewRect.top - (**TEH).destRect.top;
	newScroll = GetCtlValue(vScroll) * (**TEH).lineHeight;
	delta = oldScroll - newScroll;
	if (delta != 0)
	  TEScroll(0, delta, TEH);
}


SetVScroll()
{
	register int	n;
	
	n = (**TEH).nLines-linesInFolder;

	if ((**TEH).teLength > 0 && (*((**TEH).hText))[(**TEH).teLength-1]=='\r')
		n++;

	SetCtlMax(vScroll, n > 0 ? n : 0);
}

ShowSelect()

{
	register	int		topLine, bottomLine, theLine;

	if ( (**TEH).teLength > text_line_max ) {
		TESetSelect(0, (**TEH).lineStarts[cut_text_size],TEH);
		TEDelete(TEH);
		theLine = (**TEH).teLength;
		TESetSelect(theLine-1,theLine,TEH);
	}
	
	SetVScroll();
	AdjustText();
	
	topLine = GetCtlValue(vScroll);
	bottomLine = topLine + linesInFolder;
	if (bottomLine > (**TEH).nLines) bottomLine = (**TEH).nLines;
	
	if ((**TEH).selStart < (**TEH).lineStarts[topLine] ||
			(**TEH).selStart >= (**TEH).lineStarts[bottomLine]) {
	  for (theLine = 0; (**TEH).selStart >= (**TEH).lineStarts[theLine];
	       theLine++)
			;
		SetCtlValue(vScroll, theLine - linesInFolder / 2);
		AdjustText();
	}
}

SetView(w)
WindowPtr w;
{
	(**TEH).viewRect = w->portRect;
	(**TEH).viewRect.right -= SBarWidth;
	(**TEH).viewRect.bottom -= SBarWidth;
	InsetRect(&(**TEH).viewRect, 4, 4);
	linesInFolder = ((**TEH).viewRect.bottom-(**TEH).viewRect.top)/(**TEH).lineHeight;
	(**TEH).viewRect.bottom = (**TEH).viewRect.top + (**TEH).lineHeight*linesInFolder;
	(**TEH).destRect.right = (**TEH).viewRect.right;
	TECalText(TEH);
}

UpdateWindow(theWindow)
WindowPtr	theWindow;
{
	GrafPtr	savePort;
	
	GetPort( &savePort );
	SetPort( theWindow );
	BeginUpdate( theWindow );
	EraseRect(&theWindow->portRect);
	DrawControls( theWindow );
	DrawGrowIcon( theWindow );
	TEUpdate( &theWindow->portRect, TEH );
	EndUpdate( theWindow );
	SetPort( savePort );
}

pascal void ScrollProc(theControl, theCode)
ControlHandle	theControl;
int				theCode;
{
	int	pageSize;
	int	scrollAmt;
	
	if (theCode == 0)
		return ;
	
	pageSize = ((**TEH).viewRect.bottom-(**TEH).viewRect.top) / 
			(**TEH).lineHeight - 1;
			
	switch (theCode) {
		case inUpButton: 
			scrollAmt = -1;
			break;
		case inDownButton: 
			scrollAmt = 1;
			break;
		case inPageUp: 
			scrollAmt = -pageSize;
			break;
		case inPageDown: 
			scrollAmt = pageSize;
			break;
		}
	SetCtlValue( theControl, GetCtlValue(theControl)+scrollAmt );
	AdjustText();

}

DoContent(theWindow, theEvent)
WindowPtr	theWindow;
EventRecord	*theEvent;
{
	int				cntlCode;
	ControlHandle 	theControl;
	int				pageSize;
	GrafPtr			savePort;
	
	GetPort(&savePort);
	SetPort(theWindow);
	GlobalToLocal( &theEvent->where );
	if ((cntlCode = FindControl(theEvent->where, theWindow, &theControl)) == 0) {
		if (PtInRect( theEvent->where, &(**TEH).viewRect ))
			TEClick( theEvent->where, (theEvent->modifiers & shiftKey )!=0, TEH);
	}
	else if (cntlCode == inThumb) {
		TrackControl(theControl, theEvent->where, 0L);
		AdjustText();
	}
	else
		TrackControl(theControl, theEvent->where, &ScrollProc);

	SetPort(savePort);
}

MyGrowWindow( w, p )
WindowPtr w;
Point p;
{
	GrafPtr	savePort;
	long	theResult;
	int		oScroll;
	Rect 	r, oView;
	
	GetPort( &savePort );
	SetPort( w );

	SetRect(&r, 80, 80, screenBits.bounds.right, screenBits.bounds.bottom);
	theResult = GrowWindow( w, p, &r );
	if (theResult == 0)
	  return;
	SizeWindow( w, LoWord(theResult), HiWord(theResult), 1);

	InvalRect(&w->portRect);
	oView = (**TEH).viewRect;
	oScroll = GetCtlValue(vScroll);
	
	SetView(w);
	HidePen();
	MoveControl(vScroll, w->portRect.right - SBarWidth, w->portRect.top-1);
	SizeControl(vScroll, SBarWidth+1, w->portRect.bottom - w->portRect.top-(SBarWidth-2));
	ShowPen();


	SetVScroll();
	AdjustText();
	
	SetPort( savePort );
}

CloseMyWindow()
{
	HideWindow( myWindow );
	TESetSelect( 0, (**TEH).teLength, TEH );
	TEDelete( TEH );
	SetVScroll();
	SetUpFiles();
}

int DoFile( item )
int		item;

{
	int 	vRef, io;
	Str255	fn;

	switch (item) {
	case fmNew: 
		SetWTitle( myWindow, "\pUntitled");
		ShowWindow( myWindow );
		break;
	case fmOpen:
		if (OldFile(fn, &vRef )) {
			HiliteMenu(0);
			if (FSOpen(fn,vRef,&refNum) ==noErr) {
				long count;
				KEYIN = UP;
				count = NAME_MAX-1;
				PleaseWait();
				if ( FSRead(refNum, &count, &ibuf) != noErr) {
					FSClose(refNum);
					HiliteMenu(0);
					KEYIN = NextTRUE;
					}
				line_counter=1;
				*(ibuf+(int)count) = '\0';
				ibufpt = ibuf;
				return(cbuf = *ibufpt);
				}
			else FileError( "\pError opening ", fn );
			}
		break;
	case fmClose:
		CloseMyWindow();
		break;
	case fmSave:
		if (theFileName[0]==0) goto saveas;
		SaveFile(theFileName, theVRefNum);
		break;
	case fmSaveAs:
saveas:
		fn[0] = 0;
		if (SaveAs(fn, &vRef )) {
			pStrCopy(fn, theFileName);
			theVRefNum = vRef;
			SetWTitle(myWindow, theFileName);
		}
		break;
	case fmSavePred:
		save_program();
		break;
	case fmRevert:
		ParamText("\pRevert to last saved version of `",
				theFileName, "\p'?", "\p");
		switch (Alert(AdviseAlert, 0L)) {
		case aaSave:
			HidePen();
			TESetSelect( 0, (**TEH).teLength, TEH );
			ShowPen();
			TEDelete(TEH);
			if ((theFileName[0]!=0) &&
				(FSOpen(theFileName, theVRefNum, &refNum)==noErr)) {
				ReadFile( refNum, TEH ); 
				/* I don't check for bad read! */
				if (FSClose(refNum)==noErr) ;
			}
			ShowWindow( myWindow );
			UpdateWindow( myWindow );
 		case aaCancel:
 		case aaDiscard: return(0);;
 		}

		break;
	case fmPageSetUp:
		DoPageSetUp();
		break;
	case fmPrint:
		PrintText( (**TEH).hText, (long)(**TEH).teLength, (GrafPtr)myWindow,0L);
		break;
	case fmQuit:
		if (DoFile(fmClose)) quit_prolog();
	}
	HiliteMenu(0);
	return(1);
}

static Point SFGwhere = { 90, 82 };
static Point SFPwhere = { 106, 104 };
static SFReply reply;

SaveAs( fn, vRef )
Str255 	fn;
int		*vRef;
{
	int refNum;
	
	if (NewFile(fn, vRef)) 
		if (CreateFile(fn, vRef, &refNum)) {
			WriteFile(refNum, (*(**TEH).hText), (long)(**TEH).teLength);
			FSClose( refNum );
			return(1);
		}
		else {
			FileError("\pError creating file ", fn);
		}
	return(0);
}

SaveFile( fn, vrn )
Str255	fn;
int		vrn;
{
	int refNum;
	
	if (FSOpen( fn, vrn, &refNum )==noErr) {
		WriteFile(refNum, (*(**TEH).hText), (long)(**TEH).teLength);
		FSClose( refNum );
		return(1);
	}
	else FileError("\pError opening file ", fn);
	return(0);
}

NewFile( fn, vRef )
Str255	fn;
int		*vRef;
{
	SFPutFile(SFPwhere, "\p", fn, 0L, &reply);
	if (reply.good) {
		pStrCopy(reply.fName, fn);
		*vRef = reply.vRefNum;
		return(1);
	}
	else return(0);
}

OldFile( fn, vRef )
Str255	fn;
int		*vRef;
{
	SFTypeList	myTypes;
	char *pt;
	
	myTypes[0]='TEXT';
	SFGetFile( SFGwhere, "\p", 0L, 1, myTypes, 0L, &reply );
	if (reply.good) {
		pStrCopy( reply.fName, fn );
		*vRef = reply.vRefNum;
		return(1);
	}
	else return(0);
}

CreateFile( fn, vRef, theRef )
Str255	fn;
int		*vRef;
int		*theRef;
{
	int io;
	
	io=Create(fn, *vRef, 'HELO', 'TEXT');
	if ((io==noErr) || (io==dupFNErr)) io = FSOpen( fn, *vRef, theRef );
	return( (io==noErr) || (io=dupFNErr) );
}

WriteFile( refNum, p, num )
int		refNum;
char	*p;
long	num;
{
	int io;			/* 	a real application would want to check 
						this return code for failures */
	
	io=FSWrite( refNum, &num, p );
}

ReadFile( refNum, textH )
int		refNum;
TEHandle textH;
{
	char	buffer[256];
	long	count;
	int		io;
	
	TESetSelect(0, (**textH).teLength, textH);
	TEDelete( textH );
	do {
		count = 256;
		io = FSRead( refNum, &count, &buffer );
		TEInsert( &buffer, count, textH );
	} while (io==noErr);
	
	return( io==eofErr );
}

FileError( s, f )
Str255 s, f;
{
	ParamText(s, f,"\p", "\p");
	Alert( ErrorAlert, 0L );
}

int MainEvent() 
{
  EventRecord		myEvent;
  WindowPtr		whichWindow;
  Rect			r;
  int pos;
	
  *ibuf = '\0';
  cursor_position = (**TEH).nLines-1;
  *(*(**TEH).hText+(**TEH).teLength) ='\0';
  pos = (**TEH).teLength-(**TEH).lineStarts[cursor_position];

  while (1) {
  MaintainCursor();
  MaintainMenus();
  SystemTask();
  TEIdle(TEH);
  if (GetNextEvent(everyEvent, &myEvent)) {
    switch (myEvent.what) {
    case mouseDown:
      switch (FindWindow( myEvent.where, &whichWindow )) {
      case inDesk: 
	SysBeep(10);
	break;
      case inGoAway:
	if (ours(whichWindow))
	  if (TrackGoAway( myWindow, myEvent.where) )
	    DoFile(fmClose);
	break;
      case inMenuBar:
		 return(DoCommand( MenuSelect(myEvent.where) ));
      case inSysWindow:
	SystemClick( &myEvent, whichWindow );
	break;
      case inDrag:
	if (ours(whichWindow))
	  DragWindow( whichWindow, myEvent.where, &dragRect );
	break;
      case inGrow:
	if (ours(whichWindow))
	  MyGrowWindow( whichWindow, myEvent.where );
	break;
      case inContent:
	if (whichWindow != FrontWindow())
	  SelectWindow(whichWindow);
	else 
	  if (ours(whichWindow))
	    DoContent(whichWindow, &myEvent);
	break;
      default: ;
      } /* end switch FindWindow */
      break;
    case keyDown:
    case autoKey: 
      {
	register char	theChar;
	theChar = myEvent.message & charCodeMask;
	if ((myEvent.modifiers & cmdKey) != 0) {
		if (theChar == '.') interrupt_question();
	  	DoCommand( MenuKey( theChar ) );
	  	}
	else {
		switch (theChar) {
		case '\r':
		case '\n': {
	  		int i;
			TEKey(theChar,TEH);
			ShowSelect();
			if (cursor_position >= (**TEH).nLines)
				cursor_position = (**TEH).nLines-1;
			if ( (**TEH).teLength >
				 (pos + (**TEH).lineStarts[cursor_position])) {
				pos += (**TEH).lineStarts[cursor_position];
				i =  (**TEH).teLength-pos;
				}
			else {
				pos = (**TEH).lineStarts[cursor_position];
				i =  (**TEH).teLength-pos;
				}
			if (i < 0) {
				ParamText("\pInput Error", "\p","\p", "\p");
				Alert( ErrorAlert, 0L );
				ibuf[0]='\0';
				ibufpt = ibuf;
				return(0);
				}
				
			strncpy(ibuf, (*((**TEH).hText)+pos), i);
			ibuf[i]='\0';
			ibufpt = ibuf;
			ShowSelect();
	  		return(1);
	 	}
	  case tabChar: {
	  	TEInsert("    ",4,TEH);
	  	ShowSelect();
	  	}
	  	break;	
	  case '\b':
	  	if ( (**TEH).teLength <=
	  		 (**TEH).lineStarts[cursor_position]+pos) {
	  		 SysBeep(4);
	  		 break;
	  	}
	  default:
	  	TEKey(theChar,TEH);
	  	ShowSelect();
	  	}
	 }
    }
      break;
    case activateEvt:
      if (ours((WindowPtr)myEvent.message)) {
	r=(*myWindow).portRect;
	r.top = r.bottom - (SBarWidth+1);
	r.left = r.left - (SBarWidth+1);
	InvalRect(&r);
	if ( myEvent.modifiers & activeFlag ) {
	  TEActivate( TEH );
	  ShowControl( vScroll );
	  DisableItem( myMenus[editM], undoCommand );
	  TEFromScrap();
	}
	else {
	  TEDeactivate(TEH);
	  HideControl( vScroll );
	  ZeroScrap();
	  TEToScrap();
	}
      }
      break;
    case updateEvt: 
      if (ours((WindowPtr)myEvent.message)) UpdateWindow(myWindow);
      break;
    default: ;
    }
  }
 } 
}

void DoAbout()
{
	Alert( AboutAlert, 0L);
}

int DoCommand( mResult )
long mResult;
{
	int		theItem, temp;
	Str255	name;
	WindowPeek wPtr;
	void DoAbout();
	
	theItem = LoWord( mResult );
	switch (HiWord(mResult)) {
	case appleID:
	  switch (theItem) {
	  	case AboutItem: DoAbout(); break;
		default:
			GetItem(myMenus[appleM], theItem, &name);
			OpenDeskAcc( &name );
			SetPort( myWindow );
		}
		break;
	case fileID:
		return(DoFile(theItem));
	case editID:
		temp = (**TEH).nLines; 
		if (SystemEdit(theItem-1)==0) {
			wPtr = (WindowPeek) FrontWindow();
			switch (theItem) {
			case cutCommand:
				TECut( TEH );
				temp -= (**TEH).nLines;
				cursor_position -= temp;
				break;
			case copyCommand:
				TECopy( TEH );
				break;
			case pasteCommand:
				TEPaste( TEH );
				break;
			case clearCommand:
				TEDelete( TEH );
				temp -= (**TEH).nLines;
				cursor_position -= temp;
				break;
			default: ;
			}
			ShowSelect();
		}
		break;
	case commID:
		return( cupCommand(theItem) );
	case traceID:
		return( traceCommand(theItem) );
	case modeID:
		return( modeCommand(theItem) );
	case fontID:
		GetItem(myMenus[fontM], theItem, &name);
		if (name[0] != '\0') {
			GetFNum(name, &temp);
	  		CheckItem( myMenus[fontM], theItem, TRUE);
			if (font_item != 0)
				CheckItem( myMenus[fontM], font_item,FALSE);
			font_type = temp;
			font_item = theItem;
			(**TEH).txFont = font_type;
			}
		break;
	case sizeID:
	  switch (theItem) {
		case Nine:	temp = 9; break;
		case Ten:	temp = 10; break;
		case Twelve:	temp = 12; break;
		case Fourteen:	temp = 14; break;
		case Eighteen:	temp = 18; break;
		case TwentyFour:	temp = 24; break;
		case ThirtySix:		temp = 36; break;
		default: temp = 9;
		}
	  if (temp != font_size) {
	  	CheckItem( myMenus[sizeM], size_item(font_size), FALSE);
		font_size = temp;
	  	CheckItem( myMenus[sizeM], size_item(font_size), TRUE);
	  	(**TEH).lineHeight = (int)((float)temp*1.25);
	  	(**TEH).fontAscent = temp;
	  	(**TEH).txSize = temp;
	  }
	  break;
	}
	HiliteMenu(0);
	return(1);
}

HiliteButton(itemNo,myDialog)
int itemNo;
DialogPtr myDialog;
{
	GrafPtr	NowPort;
	Rect box;
	int itemType;
	Handle h;

	GetPort(&NowPort);
	SetPort(myDialog);
	GetDItem(myDialog,itemNo,&itemType,&h,&box);
	InsetRect(&box,-4,-4);
	PenSize(3,3);
	FrameRoundRect(&box,16,16);

	SetPort(NowPort);
}

HiliteBox(box,myDialog)
DialogPtr myDialog;
Rect box;
{
	GrafPtr	NowPort;

	GetPort(&NowPort);
	SetPort(myDialog);

	InsetRect(&box,-4,-4);
	PenSize(3,3);
	FrameRoundRect(&box,16,16);

	SetPort(NowPort);
}

doDisplayComm()
{
	DialogPtr	myDialog;
	int dialogDone = FALSE, selected = FALSE;
	int DialogItem, itemNo, itemType;
	Rect box;

	myDialog = GetNewDialog(DisplayPredDialog,0,(WindowPtr)-1);
	GetDItem(myDialog,OKItem,&itemType,&OKHandle,&box);
	GetDItem(myDialog,CancelItem,&itemType,&CancelHandle,&box);
	GetDItem(myDialog,AllItem,&itemType,&AllHandle,&box);
	GetDItem(myDialog,OtherItem,&itemType,&OtherHandle,&box);
	GetDItem(myDialog,InputTextItem,&itemType,&InputTextHandle,&box);
	SelIText(myDialog,InputTextItem,0,0);
	itemType = FALSE;
	while (dialogDone == FALSE) {
		ModalDialog(0, &itemNo);
		switch (itemNo) {
			case OKItem:
				if (GetCtlValue(OtherHandle) ==TRUE) {
						GetIText(InputTextHandle,nbuf);
						if (nbuf[(int)nbuf[0]]=='\r')
							nbuf[(int)nbuf[0]]='\0';
						PtoCstr(nbuf);
						if (nbuf[0]!='\0') {
							dialogDone = TRUE;
							selected = TRUE;
						}
						else SysBeep(3);
					}
				else if (GetCtlValue(AllHandle)==TRUE)
						dialogDone = TRUE;
				break;
			case CancelItem:
				selected = FALSE;
				dialogDone = TRUE;
				break;
			case InputTextItem:
				if (itemType == FALSE) {
						SetCtlValue(OtherHandle, TRUE);
						HiliteButton(InputTextItem,myDialog);
						itemType = TRUE;
				}
				SetCtlValue(AllHandle, FALSE);
				break;
			case AllItem:
				itemType = FALSE;
				selected = TRUE;
				SetCtlValue(AllHandle, TRUE);
				SetCtlValue(OtherHandle, FALSE);
				strcpy(nbuf,"?");
				break;
			case OtherItem:
				itemType = TRUE;
				SetCtlValue(OtherHandle, TRUE);
				SetCtlValue(AllHandle, FALSE);
				HiliteButton(InputTextItem,myDialog);
				break;
			}
		}
		DisposDialog(myDialog);
		if (selected == TRUE) showdef(nbuf);
}

doPreproComm()
{
	DialogPtr	myDialog;
	int dialogDone = FALSE, selected = FALSE;
	int DialogItem, itemNo, itemType;
	Rect box;

	myDialog = GetNewDialog(PreproDialog,0,(WindowPtr)-1);
	GetDItem(myDialog,OKItem,&itemType,&OKHandle,&box);
	GetDItem(myDialog,CancelItem,&itemType,&CancelHandle,&box);
	GetDItem(myDialog,AllItem,&itemType,&AllHandle,&box);
	GetDItem(myDialog,OtherItem,&itemType,&OtherHandle,&box);
	GetDItem(myDialog,InputTextItem,&itemType,&InputTextHandle,&box);
	GetDItem(myDialog,ShowItem,&itemType,&ShowHandle,&box);
	SelIText(myDialog,InputTextItem,0,0);
	itemType = FALSE;
	while (dialogDone == FALSE) {
		ModalDialog(0, &itemNo);
		switch (itemNo) {
			case OKItem:
				if (GetCtlValue(OtherHandle) ==TRUE) {
						GetIText(InputTextHandle,nbuf);
						if (nbuf[(int)nbuf[0]]=='\r')
							nbuf[(int)nbuf[0]]='\0';
						PtoCstr(nbuf);
						if (nbuf[0]!='\0') {
							dialogDone = TRUE;
							selected = TRUE;
						}
						else SysBeep(3);
					}
				else if (GetCtlValue(AllHandle)==TRUE)
						dialogDone = TRUE;
				break;
			case CancelItem:
				selected = FALSE;
				dialogDone = TRUE;
				break;
			case InputTextItem:
				if (itemType == FALSE) {
						SetCtlValue(OtherHandle, TRUE);
						HiliteButton(InputTextItem,myDialog);
						itemType = TRUE;
				}
				SetCtlValue(AllHandle, FALSE);
				break;
			case AllItem:
				itemType = FALSE;
				selected = TRUE;
				SetCtlValue(AllHandle, TRUE);
				SetCtlValue(OtherHandle, FALSE);
				strcpy(nbuf,"*");
				break;
			case OtherItem:
				itemType = TRUE;
				SetCtlValue(AllHandle, FALSE);
				SetCtlValue(OtherHandle, TRUE);
				HiliteButton(InputTextItem,myDialog);
				break;
			case ShowItem:
				SetCtlValue(AllHandle, FALSE);
				SetCtlValue(OtherHandle, FALSE);
				selected = TRUE;
				dialogDone = TRUE;
				strcpy(nbuf,"?");
				break;
			}
		}
		DisposDialog(myDialog);
		if (selected == TRUE) preprocess_constraints(nbuf);
}

doUsefulComm(which)
int which;
{
	DialogPtr	myDialog;
	int dialogDone = FALSE, selected = FALSE;
	int DialogItem, itemNo, itemType;
	long dummy;
	Rect box;
	
	switch (which) {
	case MaxComm:
		ParamText("\pMax # of Refutation is","\p","\p","\p");
		NumToString((long)Refcount,nbuf);
		break;
	case LevelComm:
		ParamText("\pMax Print Level is","\p","\p","\p");
		NumToString((long)Print_Depth,nbuf);
		break;
	case PredNameComm:
		strcpy(nbuf,genname);
		CtoPstr(nbuf);
		ParamText("\pGensym Name is","\p","\p","\p");
		break;
	case ModComm:
		NumToString(MODULARMAX,nbuf);
		ParamText("\pMax # of Variables in Unfold/fold is",
			"\p","\p","\p");
		break;
	};

	myDialog = GetNewDialog(UsefulDialog, 0, (WindowPtr)-1);
	GetDItem(myDialog,OKItem,&itemType,&OKHandle,&box);
	GetDItem(myDialog,CancelItem,&itemType,&CancelHandle,&box);
	GetDItem(myDialog,AllItem,&itemType,&AllHandle,&box);
	GetDItem(myDialog,OtherItem,&itemType,&OtherHandle,&box);
	SetIText(OtherHandle,nbuf);
	SelIText(myDialog,OtherItem,0,32767);
	while (dialogDone == FALSE) {
		ModalDialog(0, &itemNo);
		switch (itemNo) {
			case OKItem:
				GetIText(OtherHandle,nbuf);
				switch (which) {
				case MaxComm:
					StringToNum(nbuf,&dummy);
					if (dummy <= 0L) {
						SysBeep(3);
						Refcount = REFMAX;
						NumToString(Refcount,nbuf);
						SetIText(OtherHandle,nbuf);
						SelIText(myDialog,OtherItem,0,32767);
					}
					else {
						Refcount = (int)dummy;
						dialogDone = TRUE;
					}
							break;
				case LevelComm:
					StringToNum(nbuf,&dummy);
					Print_Depth = (int)dummy;
					dialogDone = TRUE;
					break;
				case PredNameComm:
					if (nbuf[(int)nbuf[0]] == '\r')
						nbuf[(int)nbuf[0]]='\0';
					PtoCstr(nbuf);
					strcpy(genname,nbuf);
					dialogDone = TRUE;
					break;
				case ModComm:
					StringToNum(nbuf,&dummy);
					if (dummy <= 0L) {
						SysBeep(3);
						MODULARMAX = Modmax_def;
						NumToString(MODULARMAX,nbuf);
						SetIText(OtherHandle,nbuf);
						SelIText(myDialog,OtherItem,0,32767);
						}
					else {
						MODULARMAX = (int)dummy;
						dialogDone = TRUE;
						}
					break;
				}
				break;
			case CancelItem:
				dialogDone = TRUE;
			default:
				break;
			}
	}
		DisposDialog(myDialog);
}	

int cupCommand(item)
int item;
{
	int 	vRef;
	char *on_off;

	switch(item) {
	case helpComm:
		Alert( HelpAlert, 0L);
		break;
	case displayComm:
		doDisplayComm();
		break;
	case logComm:
		nbuf[0] = '\0';
		if (NewFile(nbuf, &vRef)) 
			if (CreateFile(nbuf, &vRef, &refNum)) {
				lfp = refNum;
			}
			else {
				FileError("\pError creating file ", nbuf);
			}
		break;
	case preproComm:
		doPreproComm();
		break;
	case maxComm:
		doUsefulComm(MaxComm);
		break;
	case listComm:
		tprint0("\r +-- List new predicate --<vars, terms>--+\r");
		Shownewfunc();
		break;
	case resetComm:
		ParamText("\pDo you really want System Initialization?","\p","\p","\p");
		switch (Alert(AdviseAlert, 0L)) {
			case aaSave:
				tprint0("System initialized\r");
				prepare();
	 		case aaCancel: 
	 		case aaDiscard: break;
	 		}
		break;
	case undefComm:
		ParamText("\pUndefined Predicates causes Error or Fail:","\pNow is", 
			 ((Handle_Undefined == TRUE) ? "\pERROR" : "\pFAIL"), "\p");
		switch (Alert(AdviseAlert, 0L)) {
	 		case aaDiscard:
				Handle_Undefined = (Handle_Undefined == TRUE) ? FALSE : TRUE;
			case aaSave:
	 		case aaCancel: break;
	 		}
		break;
	case levelComm:
		doUsefulComm(LevelComm);
		break;
	case timerComm:
		if (timer_switch) {
			timer_switch = FALSE;
			on_off = "\pOff";
		}
		else {
			timer_switch = TRUE;
			on_off = "\pOn";
		}
		ParamText("\pNow Timer turns ",on_off,"\p","\p");
		Alert(ErrorAlert, 0L);
	 	break;
	case prednameComm:
		doUsefulComm(PredNameComm);
		break;
	case ModmaxComm:
		doUsefulComm(ModComm);
		break;
	}	
	HiliteMenu(0);
	NL
	putcursor();
	return(1);
}

exclusiveButtons(x,y,z,u)
Handle x,y,z,u;
{
	SetCtlValue(x, TRUE);
	SetCtlValue(y, FALSE);
	SetCtlValue(z, FALSE);
	SetCtlValue(u, FALSE);
}

doSpySetting()
{
	DialogPtr	myDialog;
	int dialogDone = FALSE, selected = FALSE;
	int DialogItem, itemNo, itemType;
	Rect box;

	myDialog = GetNewDialog(SpyDialog,0,(WindowPtr)-1);
	GetDItem(myDialog,OKItem,&itemType,&OKHandle,&box);
	GetDItem(myDialog,CancelItem,&itemType,&CancelHandle,&box);
	GetDItem(myDialog,AllItem,&itemType,&AllHandle,&box);
	GetDItem(myDialog,OtherItem,&itemType,&OtherHandle,&box);
	GetDItem(myDialog,InputTextItem,&itemType,&InputTextHandle,&box);
	GetDItem(myDialog,ShowItem,&itemType,&ShowHandle,&box);
	GetDItem(myDialog,UnfoldFoldItem,&itemType,&UnfoldFoldHandle,&box);
	GetDItem(myDialog,ResetItem,&itemType,&ResetHandle,&box);
	SelIText(myDialog,InputTextItem,0,32767);
	itemType = FALSE; /* TRUE if OtherItem selected */
	while (dialogDone == FALSE) {
		ModalDialog(0, &itemNo);
		switch (itemNo) {
			case OKItem:
				if (GetCtlValue(OtherHandle) ==TRUE) {
						GetIText(InputTextHandle,nbuf);
						if (nbuf[(int)nbuf[0]]=='\r')
							nbuf[(int)nbuf[0]]='\0';
						PtoCstr(nbuf);
						if (nbuf[0]!='\0') {
							dialogDone = TRUE;
							selected = TRUE;
						}
						else {
							SysBeep(3);
							selected = FALSE;
						}
					}
				else if (selected==TRUE) dialogDone = TRUE;
				break;
			case CancelItem:
				selected = FALSE;
				dialogDone = TRUE;
				break;
			case InputTextItem:
				if (itemType == FALSE) {
					exclusiveButtons(OtherHandle,AllHandle,
									ResetHandle,UnfoldFoldHandle);
					itemType = TRUE;
				}
				break;
			case AllItem:
				selected = TRUE;
				exclusiveButtons(AllHandle,OtherHandle,
								ResetHandle,UnfoldFoldHandle);
				strcpy(nbuf,"*");
				break;
			case OtherItem:
				exclusiveButtons(OtherHandle,AllHandle,
								ResetHandle,UnfoldFoldHandle);
				SelIText(myDialog,InputTextItem,0,32767);
				break;
			case ShowItem:
				selected = TRUE;
				dialogDone = TRUE;
				strcpy(nbuf,"?");
				break;
			case UnfoldFoldItem:
				selected = TRUE;
				exclusiveButtons(UnfoldFoldHandle,AllHandle,OtherHandle,
							ResetHandle);
				strcpy(nbuf,">");
				break;
			case ResetItem:
				selected = TRUE;
				exclusiveButtons(ResetHandle,AllHandle,OtherHandle,
							UnfoldFoldHandle);
				strcpy(nbuf,".");
				break;
			}
		}
		DisposDialog(myDialog);
		if (selected == TRUE) {
			spyswitch(nbuf);
		}
}

int traceCommand(item)
int item;
{
	switch (item) {
	case stepComm:
		EnableItem(myMenus[traceM],traceComm);
		DisableItem(myMenus[traceM],stepComm);
		EnableItem(myMenus[traceM],traceOffComm);
		stepswitch();
		break;
	case traceComm:
		EnableItem(myMenus[traceM],stepComm);
		DisableItem(myMenus[traceM],traceComm);
		EnableItem(myMenus[traceM],traceOffComm);
		traceswitch();
		break;
	case traceOffComm:
		EnableItem(myMenus[traceM],stepComm);
		EnableItem(myMenus[traceM],traceComm);
		DisableItem(myMenus[traceM],traceOffComm);
		Notrace_mode;		/* trace flag */
		break;		
	case spyComm:
		doSpySetting();
		break;
	default:
		break;
	}
	NL
	putcursor();
	HiliteMenu(0);
	return(1);
}

int modeCommand(item)
int item;
{
	switch (item) {
	case modularComm:
		EnableItem(myMenus[modeM],msolveComm);
		DisableItem(myMenus[modeM],modularComm);
		tprint0("\r___ all modular mode ___\r");
		Modular_mode;
		break;
	case msolveComm:
		DisableItem(myMenus[modeM],msolveComm);
		EnableItem(myMenus[modeM],modularComm);
		tprint0("\r___ M-solvable modular mode ___\r");
		Msolvable_mode;
	default:
		break;
	}
	HiliteMenu(0);
	NL
	putcursor();
	return(1);
}

MaintainCursor()
{
	Point		pt;
	WindowPeek	wPtr;
	GrafPtr		savePort;
	
	if (ours((WindowPtr)(wPtr=(WindowPeek)FrontWindow()))) {
		GetPort( &savePort );
		SetPort( (GrafPtr)wPtr );
		GetMouse(&pt);
		if ( PtInRect(pt, &(**TEH).viewRect )  )
			SetCursor( &editCursor);
		else SetCursor( &arrow );
		SetPort( savePort );
	}
}

MaintainMenus()
{
	CheckItem( myMenus[fontM], font_item, TRUE);
	CheckItem( myMenus[sizeM], size_item(font_size), TRUE);
	switch (tflag) {
	case 0:
		EnableItem(myMenus[traceM],stepComm);
		EnableItem(myMenus[traceM],traceComm);
		DisableItem(myMenus[traceM],traceOffComm);
		break;
	case 1:
		EnableItem(myMenus[traceM],stepComm);
		DisableItem(myMenus[traceM],traceComm);
		EnableItem(myMenus[traceM],traceOffComm);
		break;
	case 2:
		EnableItem(myMenus[traceM],traceComm);
		DisableItem(myMenus[traceM],stepComm);
		EnableItem(myMenus[traceM],traceOffComm);
	}
	
	if ( !(*(WindowPeek)myWindow).visible || 
			!ours(FrontWindow()) ) {
		EnableItem( myMenus[fileM], fmNew );
		EnableItem( myMenus[fileM], fmOpen );
		DisableItem( myMenus[fileM], fmClose );
		DisableItem( myMenus[fileM], fmSave );
		DisableItem( myMenus[fileM], fmSaveAs );
		DisableItem( myMenus[fileM], fmRevert );
		DisableItem( myMenus[fileM], fmPrint );
		EnableItem( myMenus[editM], undoCommand );
		EnableItem( myMenus[editM], cutCommand );
		EnableItem( myMenus[editM], copyCommand );
		EnableItem( myMenus[editM], clearCommand );
	}
	else {
		DisableItem( myMenus[fileM], fmNew );
		EnableItem( myMenus[fileM], fmOpen );
		EnableItem( myMenus[fileM], fmClose );
		EnableItem( myMenus[fileM], fmSaveAs );
		EnableItem( myMenus[fileM], fmPrint );
		DisableItem( myMenus[fileM], fmRevert );
		DisableItem( myMenus[fileM], fmSave );

		DisableItem( myMenus[editM], undoCommand );
		if ((**TEH).selStart==(**TEH).selEnd) {
			DisableItem( myMenus[editM], cutCommand );
			DisableItem( myMenus[editM], copyCommand );
			DisableItem( myMenus[editM], clearCommand );
		}
		else {
			EnableItem( myMenus[editM], cutCommand );
			EnableItem( myMenus[editM], copyCommand );
			EnableItem( myMenus[editM], clearCommand );
		}
	}
}

ours(w)
WindowPtr w;
{
	return( (myWindow!=NULL) && (w==myWindow) );
}

void readword(buf)
char *buf;
{
	if (KEYIN==TRUE) {
		if ( *ibufpt == '\0') MainEvent();
			if (*ibufpt == '\r') {
				*buf =  *ibufpt = '\0';
			}
			else {
			 sscanf(ibufpt,"%s",buf);
			}
		}
	else if (KEYIN==NextTRUE) {
		if (*ibufpt == '\0') {
			*buf = '?';
			*(buf+1) = '\0'; }
		else sscanf(ibufpt,"%s",buf);
		}
	else if (KEYIN == FALSE)
		fscanf(fp,"%s",buf);
	else { /* KEYIN == UP */
		ibufpt++;
		while (*ibufpt != '\r') {
			if (*ibufpt != '\0'){
				*buf = *ibufpt;
				buf++; ibufpt++;
			}
			else next();
		}
	}
}
#endif

char errmsg[300];

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++
  Rterm(num,flag)           
          general read routine entry
    num:  operator strength
    flag: heap mode (TEMPORAL,ETERNAL,...)
+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
struct term *Rterm(n,flag)
int n,flag;
{
  int m = 0;
  struct term *Rterm_half(),*Rterm_leftover();
  struct term *t = Rterm_half(n,flag,&m);

  if (cbuf == EOF) {
  	tokentype = EOF_MARK; return(NULL);
  	}
  else t = Rterm_leftover(n,m,flag,t);
  if (cbuf == EOF) {
  	tokentype = EOF_MARK; return(NULL);
  	}
  
  if ((is_clause(t)) && (((struct clause *)t)->c_link == NULL))
    return(((struct clause *)t)->c_form);
  return(t);
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++
  next()
    get next char into cbuf (global char register)
+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#ifdef MAC
void next()
{
	long dummy;
	if ((*ibufpt == '\0') && (KEYIN ==NextTRUE)) {
		KEYIN=TRUE; line_counter=0;
		SysBeep(10); NL /* notify */
		putcursor();
		while (*ibufpt == '\0') MainEvent();
		cbuf = *ibufpt++;
		}
	else if (KEYIN==TRUE) {
	    if ( *ibufpt == '\0') {
			while (*ibufpt == '\0') MainEvent();
		if ((KEYIN==TRUE) && (lfp != 0)) {
			dummy = (long)strlen(ibufpt);
			FSWrite(lfp,&dummy,ibufpt);
			}
		}
		cbuf = *ibufpt++;
		}
	else if (KEYIN == FALSE){
		if (feof(fp)) { clearerr(fp); SetCursor(&editCursor);
			cbuf = EOF;  line_counter=0; /*  KEYIN = TRUE; */
			return; }
		if (ferror(fp)) { clearerr(fp);
			SetCursor(&editCursor); error("Input error!"); return; }
		cbuf = getc(fp);
		if (ECHO_BACK == TRUE) {
			if (cbuf == '\n') { TEKey('\r',TEH); cbuf='\r'; }
			else if (cbuf == '\t') TEInsert("    ",4,TEH);
			else TEKey(cbuf,TEH);
		if (cbuf=='\r') {
			ttyprint1("#%d:",line_counter+1);
			ShowSelect();
			}
		}
	}
	else { /* KEYIN == UP */
		if ( *ibufpt == '\0' ) {
			long count = NAME_MAX-1;
			if ( FSRead(refNum, &count, &ibuf) != noErr) {
				FSClose(refNum);
				KEYIN = NextTRUE;
				SetCursor(&editCursor);
			}
			*(ibuf+(int)count) = '\0';
			ibufpt = ibuf;
			cbuf = *ibufpt++;
		}
		else cbuf = *ibufpt++;
		}
	if ((KEYIN != TRUE) && (cbuf=='\r'))
		line_counter++;
}
#else
void next()
{
	if (feof(fp)) 
	{
		clearerr(fp);
		cbuf = EOF;
		return;
	}
	if (ferror(fp))
	{
		clearerr(fp);
		error("input error !");
	}
	cbuf = getc(fp);
	if (lfp) putc(cbuf,lfp);	/* log file */
	if (ECHO_BACK) putc(cbuf, wfp);
	if (cbuf=='\n') {
			if (fp != stdin) line_counter++;
			if (ECHO_BACK) ttyprint1("#%d:",line_counter);
                      }
}
#endif

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++
  int check(c)
  check whether next input is c
+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int check(c)		/*  check if c is cbuf	*/
char c;
{
        if(cbuf == c) {
                advance;
                return(TRUE);
        } else
                return(FALSE);
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++
  int keyread(a)
    check whether user's input is 'a....\n'
+++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int keyread(a)
char a;
#ifdef MAC
{
	next();
	if (KEYIN==TRUE) {
		*ibufpt = '\0';
		if (cbuf == a) return(1);
		}
	return(FALSE);
}
#else
{
	int c,c1;

	c = c1 = getchar();
	while (c1 != '\n') c1 = getchar();
	if (lfp) fprintf(lfp,"\n");
	if (c == a) return(TRUE);
	else return(FALSE);
}
#endif

void adv()		/*  skip white and set the next char into cbuf  */
{
	while(white)
		next();
}

int skip(c)		/*	skip c	*/
char c;
{
	if(cbuf != c){
		if (line_counter)
			sprintf(errmsg,"Line# %d: Illegal Character %c\0", line_counter,cbuf);
		else sprintf(errmsg,"Illegal Character: '%c' <-> '%c'\0", cbuf, c);
		error(errmsg);
	}
	advance;
	return(cbuf);
}

#ifdef MAC
void skipline()
{
/*	if (KEYIN != FALSE) */
	if ((*ibufpt == '\0') && (KEYIN == TRUE)) return;
	while ((cbuf != '\n') && (cbuf != '\r')) next();
}
#endif

int alldigit(c)
register int *c;
{
	 if (! numeric(*c)) return(FALSE);
	 for( c++ ; *c!='\0' ; c++ )
		if (! isdigit(*c)) return(FALSE);
	 return(TRUE);
}

void read_hexa(i)
register int i;
{
  for(i=0; isxdigit(cbuf); next())
    if (i < NAME_MAX) nbuf[i++]=cbuf;
  nbuf[i]='\0';
}

void read_digits(i)
register int i;
{
  for( ; isdigit(cbuf); next())
    if (i < NAME_MAX) nbuf[i++] = cbuf;
  if (cbuf=='.')
    do
      { nbuf[i++] = cbuf;
	next();
      } while((isdigit(cbuf)) && (i < NAME_MAX));
  if ((cbuf == 'e') || (cbuf == 'E')) {
    nbuf[i++] = 'E';
    next();
    if ((cbuf == '-') || isdigit(cbuf))
      do
	{ nbuf[i++] = cbuf;
	  next();
	} while((isdigit(cbuf)) && (i < NAME_MAX));
  }
  if ((nbuf[i-1]=='.') && white) {
    nbuf[i-1]='\0';
    cbuf='.';
    reread=TRUE;
    tokentype=FULLSTOP;
  }
  else nbuf[i]='\0';
}

void read_comments()
{
  while (1) {
    next();
    if (cbuf == '*') {
      next();
      if (cbuf == '/') {advance; return;}
    }
  }
}

void read_spechar(i)
register int i;
{
  while (specialchar(cbuf) && (i < NAME_MAX)) {
    nbuf[i++] = cbuf;
    next();
  } 
  nbuf[i]='\0';
}

int Rtoken()	/* read name into nbuf[]  */
{
  if (reread) {
    reread = FALSE;
    return(tokentype);
  }

  adv();
  if (cbuf==EOF) {
    if (is_user_input == FALSE)
    	return(tokentype = EOF_MARK);
    else {
     fclose(fp);
#ifndef MAC
      READ_FILE = fp = stdin;
#endif
	 longjmp(read_eof,0); 
     }
  }
  if (bracket(cbuf))   /* ()[]{}|, */
    {
      if (cbuf==',') return(tokentype = COMMA);
      nbuf[0] = cbuf;
      nbuf[1] = '\0';
      return(tokentype = BRACKET);
    }
  if (! kanzi(cbuf)) {
   /* if (char_type[cbuf] == CO) return(tokentype = CONST_MARK); */
      if (char_type[cbuf] == CM) {
	SKIPLINE;
	return(Rtoken());
      }
  }

  tokentype = NAME;
  if (isdigit(cbuf))
    {
      read_digits(0);
      return(tokentype = NUMBER);
    }

  if (alpha) {
    register int i = 0;
    if (is_varname(cbuf)) tokentype = VARNAME;
    while(alpha && (i < NAME_MAX)){
      if (kanzi(cbuf)) {
	nbuf[i++] = cbuf;
	next();
      }
      nbuf[i++] = cbuf;
      next();
    }
    nbuf[i]='\0';
    return(tokentype);
  }

  if (quotesign) {
    register char temp = cbuf;
    register int i;
    if (temp == '\"') tokentype = STRING;
    next();
    for (i = 0; i < NAME_MAX; next()) {
      if (cbuf != temp) nbuf[i++]=cbuf;
      else {
	next();
	if (cbuf == temp) nbuf[i++]=cbuf;
	else break;
      }
    }
    if (i >= NAME_MAX) {
      nbuf[i]='\0';
#ifndef MAC
	wfp = stderr;
#endif
	if (line_counter) sprintf(errmsg,"Line # %d: input is too long\0",line_counter);
     else sprintf(errmsg,">>%s<< is too long\0",nbuf);
      error(errmsg);
    }
    nbuf[i]='\0';
    return(tokentype);
  }

  if (cbuf == '!') { /* cut or QUANT var */
    register int i=0;
    nbuf[i++] = cbuf;
    next();
    if (alpha) {
      tokentype = VARNAME;
      while(alpha && (i < NAME_MAX)){
        if (kanzi(cbuf)) {
          nbuf[i++] = cbuf;
          next();
        }
	nbuf[i++] = cbuf;
	next();
      }
    }
    nbuf[i] = '\0';
    return(tokentype);
  }

  if (char_type[cbuf] == CO) {
    nbuf[0] = cbuf;
    nbuf[1] = '\0';
    next();
    return(tokentype);
  }

  if (specialchar(cbuf)) {
    register int i = 0;

    nbuf[i++] = cbuf;
    next();

    switch (nbuf[0]) {
    case '-':
      if (isdigit(cbuf)) {
	tokentype = NUMBER;
	read_digits(i);
      }
      else read_spechar(i);
      break;
    case '/':
      if (cbuf == '*') {
	read_comments();
	return(Rtoken());
      }
      else read_spechar(i);
      break;
    case '#':
      if (isxdigit(cbuf)) {
	tokentype = FILE_TYPE;
	read_hexa(i);
      }
      else read_spechar(i);
      break;
    case '.':
      if (white) tokentype = FULLSTOP;
      else read_spechar(i);
      break;
    default:
      read_spechar(i);
    }
  }
  else {
    if (line_counter)
    	 sprintf(errmsg,"Line # %d:Illegal Character %c\0",line_counter,cbuf);
    else sprintf(errmsg,"Illegal Character:`%c'\0",cbuf); 
    error(errmsg);
  }
    
 return(tokentype);
}

struct term *Rlist(flag)	/* read list */
int flag;
{
	register struct term *v;
	register struct clause *c;

	advance;	/* skip [ */
	if (cbuf == ']') {	/*  []  */
		return(NIL);
	      }
	/* read the first argument */
	v = Rterm(999,flag);
	if (tokentype == EOF_MARK) {
		if (line_counter) {
			sprintf(errmsg, "Line # %d: Illega List notation\0",line_counter);
			error(errmsg);
			}
		else error("Illegal List notation");
			}
	c = Nlist(v,(struct clause *)NIL,flag);
	switch (Rtoken()) {
	  case COMMA:
		c->c_link = (struct clause *)Rlist(flag);
		if (notconst_list(c->c_link)) c->c_type = LIST_TYPE;
		return((struct term *)c);
	  case BRACKET:
	      if (nbuf[0]=='|') {
		advance;
		v = Rterm(999,flag);
		if (tokentype == EOF_MARK) {
			if (line_counter) {
				sprintf(errmsg,"Line # %d: Illegal List notation\0",line_counter);
				error(errmsg);
				}
			else error("Illegal List notation");
			}	
		c->c_link = (struct clause *)v;
		if (isvar(v) || notconst_list(v))
		  c->c_type = LIST_TYPE;
 		return((struct term *)c);
	      }
	      else {
		reread = TRUE;
		return((struct term *)c);
	      }
	  default:
	  	if (line_counter) {
	  		sprintf(errmsg,"Line # %d: Illegal List\0",line_counter);
	  		error(errmsg);
	  		}
	  	else error("Illegal list : ? ");
	}
}

struct term *Rpst(flag)		/* pst */
int flag;
{
   struct term *p = (struct term *)Npst(flag);
   struct term *t;
   struct eclause *pobj = (struct eclause *)NULL;

   while (1) {
     advance;
     if (cbuf == '}')  return(p);
     t = Rterm(999, flag);
     if ((tokentype == EOF_MARK) || (Pred(t) != PNAME_P)) {
		if (line_counter) {
			sprintf(errmsg,"LIne # %d: Illegal PST\0",line_counter);
			}
		else sprintf(errmsg,"Illegal PST: Delimiter of PST should be '/'\0");
        error_detail(t,(struct pair *)NULL,errmsg);
     }
     if ((! is_functor(Arg1(t)) || (Arg1(t)->t_arity != 0L))) {
     	if (line_counter) {
     		sprintf(errmsg,"Line # %d: Illegal PST\0",line_counter);
     		}
     	else sprintf(errmsg,"Illegal PST: PNAME of PST should be ATOM");
       error_detail(t,(struct pair *)NULL,errmsg);
     }
      pobj = insert_pstobj(t,pobj,flag);
     switch (Rtoken()) {
      case COMMA:
	  break;
      case BRACKET:
	  reread = TRUE;
	  ((struct pst *)p)->p_lists = pobj;
          return(p);
      default:
	 	if (line_counter) {
	 		sprintf(errmsg,"Line # %d: Illegal pst\0",line_counter);
	 		}
	 	else sprintf(errmsg,"Illegal pst:`%c'\0",cbuf);
	  error(errmsg);
	}
   }
}

struct eclause *insert_pstobj(val,tail,flag)
struct term *val;
struct eclause *tail;
int flag;
{
  struct eclause *pre, *ptop = tail;
  register int f,i;
  if (! is_functor(Arg1(val))) {
  	if (line_counter)
  		sprintf(errmsg,"Line # %d: Illegal Property name for PST\0",line_counter);
  	else sprintf(errmsg,"Illegal Property name for PST\0");
    error_detail(Arg1(val),(struct pair *)NULL,errmsg);	
  }
  if (tail == (struct eclause *)NULL)
    return(Npstobj(val,(struct pair *)NULL,tail,flag));

  pre = tail;
  f = Pred(Arg1(val))->f_number;

  while (tail != (struct eclause *)NULL) {
    i = Pred(Arg1(tail->c_form))->f_number - f;
    if (i > 0) {
      if (pre == tail) return(Npstobj(val,(struct pair *)NULL,tail,flag));
      else break;
    }
    if (i==0) {
	wfp = stderr;
      if (line_counter) sprintf(errmsg,"Line # %d: same Pnames in PST\0",line_counter);
      else sprintf(errmsg,"There are same PNAMES in PST\0");
      Pterm(Arg1(tail->c_form),(struct pair *)NULL); NL;
      Pterm(Arg1(val),(struct pair *)NULL);
      error(errmsg);
    }
    pre = tail;
    tail = tail->c_link;
  }
  pre->c_link = Npstobj(val,(struct pair *)NULL,tail,flag);
  return(ptop);
 }

int is_term_end(c)
register char c;
{
  switch(c) {
    case '.':
    case ')':
    case '|' :
    case ',':
    case ';':
    case ']': return(TRUE);
    default:  return(FALSE);
    }
}

int prefix_is_atom(m)
int m;
{
  switch(tokentype) {
    case FULLSTOP: return(TRUE);
    case COMMA:
    case BRACKET:
      return(is_term_end(nbuf[0]));
    case NAME: {
      register struct operator *o;
      if ((o = op_search(nbuf,INFIX)) != NULL)
	if ((o->o_prec - ((o->o_type & 0010) != 0)) >= m) return(TRUE);
      if ((o = op_search(nbuf,POSTFIX)) != NULL)
	if ((o->o_prec - ((o->o_type & 0010) != 0)) >= m) return(TRUE);
      }
    default:  return(FALSE);
    }
}

struct term *bracket_process(n,flag,m)
int n, flag, *m;
{
	register struct term *t;

      switch (nbuf[0]) {
        case '[':
		  t = ((struct term *)Rlist(flag));
	 	  if ((Rtoken() != BRACKET) || nbuf[0] != ']') {
	 	  	if (line_counter)
	 	  		sprintf(errmsg,"Line # %d: Syntax error --- ] missing\0",line_counter);
	 	  	else sprintf(errmsg,"Syntax error --- ] missing\0");
	   		 error_detail(t,(struct pair *)NULL,errmsg);
	   		 }
	  	  advance;
	  	  return(t);
		case '(': 
	  		advance;
	  		t = Rterm(1200,flag);
	 		if ((Rtoken() != BRACKET) || nbuf[0] != ')') {
	 			if (line_counter)
	 				sprintf(errmsg,"Line # %d: Syntax error --- ) missing\0",line_counter);
	 			else sprintf(errmsg,"Syntax error --- ) missing\0");
	    		error_detail(t,(struct pair *)NULL,errmsg);
	    	}
			advance;
	  		if (is_clause(t)) {
	    		struct clause *c = (struct clause *)t;
	    		return((c->c_link == NULL) ? c->c_form : t);
	   		}
	  		else return(t);
		case '{':
	 		t = (struct term *)Rpst(flag);
	  		if ((Rtoken() != BRACKET) || nbuf[0] != '}') {
	  			if (line_counter) 
	 				sprintf(errmsg,"Line # %d: Syntax error --- } missing\0",line_counter);
	 			else sprintf(errmsg,"Syntax error --- } missing\0");
	    		error_detail(t,(struct pair *)NULL,errmsg);
	    		}
			advance;
	  		return(t);
		default :
      		cbuf = nbuf[0];
      		if (line_counter)
      			sprintf(errmsg,"Line # %d: unexpected %c\0",line_counter,cbuf);
      		else 	sprintf(errmsg,"Error:Unexpected `%c'\0",cbuf);
	  		error(errmsg);
		}
}

struct term *Rterm_half(n,flag,m)
int n, flag, *m;
{
  register struct term *t;
  char tempname[NAME_MAX];
  int ac = CONSTANT_TERM;

  switch (Rtoken()) {
    case BRACKET:
    	return(bracket_process(n,flag,m));
    case VARNAME: /* variable */
      if (streq(nbuf, "_"))	{ /* Anonymous var */
      		sprintf(nbuf,"_%d",(v_number+1));
      		return(Nvar(nbuf,flag));
      		}
      if((t = varsearch(nbuf))==NULL)
	  	return(Nvar(nbuf,flag));
      else return(t);
    case NUMBER:  /* number */
      return(Nnum(nbuf,flag));
    case STRING:  /* string */
      return(Nstr(nbuf,flag));
 /* file pointer */
    case FILE_TYPE: {
		int pt;
		sscanf(nbuf,"%x",&pt);
#ifdef MAC
	MEMORY_ALLOC(t,term,flag,3);
#else
	MEMORY_ALLOC(t,term,flag);
#endif
		t->type.ident = (long int)ATOMIC_TYPE;
		t->t_arity = (long int)FILE_TYPE;
		fnum_value(t) = (long int)pt;
      	return(t);
     }
    case NAME: /* name */
    	strcpy(tempname,nbuf); /* tempname <- nbuf */ 
     
      /* constant or functor */
      	if (check('(')) {
			register int i,arity = 0;
			struct clause *temp, *argstack;

			argstack = temp 
	  			= Nclause((struct term *)NULL,
	  					(struct clause *)NULL,TEMPORAL);

		while(1) {
	 		reread = FALSE; /* read term */
	 		t = Rterm(999,flag);
	 		if (tokentype == EOF_MARK) error("Unexpected EOF");
	 		if (notconst(t)) ac = NOT_CONSTANT_TERM;
			temp->c_link = Nclause(t,(struct clause *)NULL,TEMPORAL);
	  		temp = temp->c_link;
	 		arity++;
	  		if (tokentype != COMMA) break;
	  		advance;
			} 
		skip(')');
		t = Nterm(arity,flag);
		if (ac==CONSTANT_TERM) t->t_arity = (long int)(-arity);
		t->type.t_func = Predicate(tempname,arity);
		temp = argstack;
		for(i=0; i < arity; i++) {
	  		temp = temp->c_link;
	  		t->tag.t_arg[i] = temp->c_form;
			}
		return(t);
      }

      {
		struct operator *o;

		if ((o = op_search(tempname, PREFIX)) == NULL) {
	  		t = Nterm(0,flag);
	  		t->type.t_func = Predicate(tempname,0);	  
	  		return(t);
		}

		if (o->o_prec > n) {
			if (line_counter) 
				sprintf(errmsg,"Line # %d: error --- %s\0",line_counter,tempname);
			else sprintf(errmsg,"Error:>>> %s <<<\0",tempname);
	  		error(errmsg);
		}
		Rtoken();
		reread=TRUE;
		if (prefix_is_atom(o->o_prec)) {
	  		if (*m > n) {
	  			if (line_counter) sprintf(errmsg,"Line # %d: Syntax error\0",line_counter);
	  			else sprintf(errmsg,"Syntax error\0");
	  			error(errmsg);
	  		}
	  		t=Nterm(0,flag);
	  		t->type.t_func = Predicate(tempname,0);
	  		return(t);
		}

		(t = Nterm(1,flag))->type.t_func = o->o_func;
		Arg1(t) = Rterm((o->o_prec - o->o_type + PREFIX),flag);
		if (tokentype == EOF_MARK) error("Unexpected EOF");
		*m = o->o_prec;
		if (isconst(Arg1(t))) t->t_arity = -t->t_arity;
		return(t);
      }
    case EOF_MARK: /* end of file */
    	return(NULL);
    default: /* else */
    	if (line_counter) sprintf(errmsg,"Line # %d: unexpected %c\0", line_counter,cbuf);
    	else sprintf(errmsg,"Error: Unexpected `%c'\0",cbuf);
      error(errmsg);
   }
}

struct term *Rterm_leftover(n,m,flag,t)
register int n,flag,m;
struct term *t;
{
  struct operator *o;
  int ac = (notconst(t)) ? NOT_CONSTANT_TERM : CONSTANT_TERM;

  switch(Rtoken()) {
    case NAME:
      reread=FALSE;
      if ((o = op_search(nbuf,INFIX)) != NULL) {
		if ((o->o_prec <= n) && 
	   		((o->o_prec - ((o->o_type & 0010) ? 1 : 0)) >= m)) {
	  		struct term *tt = Nterm(2,flag);
	  		tt->type.t_func = o->o_func;
	  		Arg1(tt) = t;
	  		Arg2(tt) = Rterm(o->o_prec - (o->o_type & 0001), flag);
	  		if ((ac == CONSTANT_TERM) && (isconst(Arg2(tt))))
	    		tt->t_arity = -tt->t_arity;
	  		return(Rterm_leftover(n,o->o_prec,flag,tt));
		}
      }
      if ((o = op_search(nbuf,POSTFIX)) != NULL) {
		if ((o->o_prec <= n) &&
	    	(o->o_prec >= (m + ((o->o_type & 0010) ? 1 : 0)))) {
	  		struct term *tt = Nterm(1,flag);
	  		tt->type.t_func = o->o_func;
	  		Arg1(tt) = t;
	  		if (ac == CONSTANT_TERM) tt->t_arity = -tt->t_arity;
	  		return(Rterm_leftover(n,o->o_prec,flag,tt));
		}
      }
    case FULLSTOP:
      reread = TRUE;
      return(t);
    case BRACKET:
      switch(nbuf[0]) {
        case '(':
        case '[':
	  		cbuf = nbuf[0];
	  		wfp = stderr;  
	  		Pterm(t,(struct pair *)NULL);
	  		if (line_counter)
	  			sprintf(errmsg,"Line # %d: unexpected %c\0",line_counter,cbuf);
	  		else sprintf(errmsg,"Error: Unexpected `%c'\0",cbuf);
	  		error(errmsg);
		}
      return(t);
    case COMMA:
      if ((n >= 1000) && (m < 1000)) {
			struct term *tt;

			advance;
			tt = Rterm(1000,flag);
			if (tokentype == EOF_MARK)	error("Unexpected EOF");
    		reread = TRUE;
			if (! is_clause(tt))
	  			tt=(struct term *)Nclause(tt,(struct clause *)NULL,flag);
			t = (struct term *)Nclause(t,(struct clause *)tt,flag);
			if (n > 1000)
	  			return(Rterm_leftover(n,1000,flag,t));
      }
      return(t);
    case EOF:
      error("Unexpected EOF");
    default:
      return(t);
    }
}
