/*
*
*		cu-Prolog (Constraint Unification Prolog)
*   Copyright: Institute for New Generation Computer Technology,Japan 1989
*	    <<<< print.c >>>>>>
*
* 88/6/12
*89.6.16 CAHC, 89.7.19 Pconstraint()
*90.6.13 ver3.02
*90.7.1  ver3.10
*/

#define DEBUG 0
#include "include.h"

void Pterm_core(), Peclause_core(), Pclause_core(), Pcahc_core();
void init_pp(), scanpst_term(), scanpst_clause(), scanpst_eclause(), print_pp();
int pp_number();

/* global vars */
long int PST_PRINT_NUM;		/* # of different psts */

/* Classification of Characters */
#define BL  001  /* blank */
#define UC  002  /* Upper Character */
#define LC  003  /* Lower Character */
#define UL  004  /* UnderLine */
#define N   005  /* Numeric */
#define SG  006  /* sign, +- */
#define SP  007  /* special character */
#define Q   010  /* single/double quote */
#define CT  011  /* Cut */
#define CM  012  /* comment character */
#define BR  013  /* Brackets, Commas */
#define CO  014  /* Constraint Marker */

#define kanzi(CH)       (CH < 0) /* for EUC */
#define alphabet(CH)   ((char_type[CH] <= N) && (char_type[CH] >= UC))
#define is_lower(CH)   ((kanzi(CH)) || (char_type[CH] == LC))
#define specialchar(C)	((! kanzi(C)) && ((char_type[C] == SG) || \
					  (char_type[C] == SP)))
#define quotesign(C)    (char_type[C] == Q)

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*    print basic structures:
* Pterm(t,e)
* Peclause(ec) : print eclause
* Pclause(c,e): print clause with delimiter ','
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void Pterm(t,e)			/* print term */
struct term *t;
struct pair *e;
{
	init_pp();
        scanpst_term(t,e);
	Pterm_core(t,e,Print_Depth);
	if (PST_PRINT_NUM > 1L) {
		tputc(';');
		print_pp(Print_Depth); /* $1={...},$2={...},.. */
	}
}

void Peclause(ec)		/* print eclause */
struct eclause *ec;
{
	init_pp();
	scanpst_eclause(ec);
	Peclause_core(ec,Print_Depth);
	if (PST_PRINT_NUM > 1L) {
		tputc(';');
		print_pp(Print_Depth);
	}
}

void Pclause(c,e)		/* print clause */
struct clause *c;
struct pair *e;
{
	init_pp();
	scanpst_clause(c,e);
	Pclause_core(c,e);
	if (PST_PRINT_NUM > 1L) {
		tputc(';');
		print_pp(Print_Depth);
	}
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
* showhorn(body,constraint,env): print CAHC
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void Showhorn(c,cst,e)	/* Show horn clause */
register struct clause *c,*cst;
register struct pair *e;
{
	void P_hclause();

	if (cst == (struct clause *)NULL) P_hclause(c,e);
	else {
		init_pp();
		scanpst_clause(c,e);
		scanpst_clause(cst,e);
		Pcahc_core(c,cst,e);	/* H:-Body;Constraint */
		if (PST_PRINT_NUM > 1L) {
			tputc(',');
			print_pp(Print_Depth);
		}
		tputc('.');
	}
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
* Pgoal(n) : print goal in refutation
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void Pgoal(n)		/* print goal in refute() */
struct node *n;
{
	init_pp();
	scanpst_clause(n->n_clause, n->n_env);
	scanpst_eclause(n->n_constraint);
	Psequence(n->n_clause,n->n_env,Print_Depth);
	if (n->n_constraint != (struct eclause *)NULL) {
		tputc(';');
		Peclause_core(n->n_constraint,Print_Depth);
		if (PST_PRINT_NUM > 1L) {
			tputc(',');
			print_pp(Print_Depth);
		}
	}
	else if (PST_PRINT_NUM > 1L) {
		tputc(';');
		print_pp(Print_Depth);
	}
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
* Showfunc(func): print definition of a predicate
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void Showfunc(f)   /*  Show definitions of function *f  */
register struct func *f;
{
	register struct set *ts;

	if (isuser(f)) {
		for (ts = f->def.f_set; ts != NULL; ts = ts->s_link) {
		Showhorn(ts->s_clause, ts->s_constraint, (struct pair *)NULL);
#if DEBUG == 1
		tprint2("(an=%d bn=%d)",ts->s_anumber,ts->s_bodynumber);
#endif		
		NL;
		}
	}
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
* P_hclause(cl,e): print Horn clause
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void P_hclause_sub(cl,e)	/* H:-C1,C2,...Cn */
struct clause *cl;
struct pair *e;
{
	register struct clause *c;

	Pterm_core(cl->c_form,e,Print_Depth);
	c = cl->c_link;
	if (c != NULL) {
		tprint0(" :- ");
		Pclause_core(c,e);
	}
}

void P_hclause(cl,e)
struct clause *cl;
struct pair *e;
{
	init_pp();
	scanpst_clause(cl,e);
	P_hclause_sub(cl,e);
	if (PST_PRINT_NUM > 1L) {
		tputc(';');
		print_pp(Print_Depth);
	}
	tputc('.');
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
* P_dclause(cl,e): print derivation clause of unfold/fold trans.
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void P_dclause(cl,e)
register struct clause *cl;
struct pair *e;
{
	init_pp();
	scanpst_clause(cl,e);
	Pterm_core(cl->c_form,e,Print_Depth);
	cl = cl->c_link;
	if (cl != NULL)
	{
		tprint0(" <=> ");
		Pclause_core(cl,e);
	}
	if (PST_PRINT_NUM > 1L) {
		tputc(',');
		print_pp(Print_Depth);
	}
	tputc('.');
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
* Shownewfunc(): print itrace
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void Shownewfunc()   /*  Show def of new functions constructed in integrate  */
{
	register struct itrace *it;

	for (it = newf_list; it != NULL; it = it->it_link){
		tprint2("<%d,%d> ",it->it_anumber,it->it_cnumber);
		P_dclause(it->it_clause,(struct pair *)NULL);
		NL;
	}
}

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
* writenewfunc(): print itrace to file
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void writenewfunc()
{
	register struct itrace *it;
	register struct func *f;

	if (newf_list == NULL) return;

	for (it = newf_list; it != NULL; it = it->it_link){
		f = it->it_clause->c_form->type.t_func;
		if (isnoreduced(f) && (f->def.f_set != NULL))
		{
			tprint0("$ ");
			P_dclause(it->it_clause,(struct pair *)NULL);
#ifdef MAC
			tputc('\r');
#else
			tputc('\n');
#endif
		}
	}
}

/* ------------------ local functions  ---------------------- */
int quote_needed(f)		/* need quote? */
struct func *f;
{
	register char *n = f->f_name;

	if (f == CUT_P) return(FALSE);

	if (! is_lower(*n)) {
		for ( ; *n != '\0'; n++) {
			if (! specialchar(*n)) return(TRUE);
		}
		return(FALSE);
	}
	for ( ; *n != '\0'; n++) {	  if (kanzi(*n)) n++;
	  else if (! alphabet(*n)) return(TRUE);
	}
	return(FALSE);
}

void Pvar(t, n)	/* print var with env, as "t_n" */
register struct term *t;
int n;
{
     if (((struct var *)t)->v_type==VAR_VOID_TYPE) tputc('_') 
     else if (((struct var *)t)->v_type==VAR_QNT_TYPE)
	tprint2("%s_%u",vname(t),n)
     else if (streq(vname(t),"_")) tprint1("_%u",n)
     else {
		tprint2("%s_%u",vname(t),n);
#if DEBUG == 1
		tprint2("<h%db%d>",vheadoccurrence(t),voccurrence(t));  
#endif
	}
}

void Pclause_core(c,e)		/* print clause main */
struct clause *c;
struct pair *e;
{
	if (c == NULL) return;
	for (;;) {
		Pterm_core(c->c_form,e,Print_Depth);
		c = c->c_link;
		if (c == NULL) return;
		tprint0(", ");
	}
}

void Peclause_core(ec,d)	/* print eclause main */
struct eclause *ec;
int d;
{
	if (ec == NULL) return;
	while (1) {
		Pterm_core(ec->c_form, ec->c_env,d);
		ec = ec->c_link;
		if (ec == NULL) return;
		tputc(',');
	}
}

void Pcahc_core(c,cst,e)	/* print CAHC main */
register struct clause *c,*cst;
register struct pair *e;
{
	Pterm_core(c->c_form,e,Print_Depth);	/* print head */
	if (c->c_link != NULL) {	/* print body */
		tprint0(":-");
		Psequence(c->c_link,e,0); /* 0 means infinity */
	}
	if (cst != NULL){	/* print constraint */
		tprint0("; ");
		Psequence(cst,e,0);
	}
}

int String_quote_needed(n)
char *n;
{
	for (; *n != '\0'; n++) {
		if (*n=='"') return(TRUE);
	}
	return(FALSE);
}

void Pterm_core(t,e,d)	/* print term main */
register struct term *t;
register struct pair *e;
int d;
{
  register struct pair *p;
  int String_quote_needed();
#ifdef MAC
	EventRecord		myEvent;
	void interrupt_question();

	MaintainCursor();
	SystemTask();
	TEIdle(TEH);
	if (GetNextEvent(everyEvent, &myEvent)) {
	    switch (myEvent.what) {
   		case autoKey:
	    case keyDown: {
			register char	theChar;
			theChar = myEvent.message & charCodeMask;
			if ((myEvent.modifiers & cmdKey) != 0)
				if (theChar == '.') {
					SysBeep(10);
					interrupt_question();
					break;
				}
			}
		}
	}
#endif

  if (t == NULL) {
    if (e == NULL) {
	tprint0("nil");
	}
    return;	/* print nothing */
  }

  if (isvar(t)) {
    if (e == NULL) {
      Pvar(t, (int)vnumber(t));
      return;
    }
    down(p,t,e);
    if(p != NULL) {	/* if t is not var */
      Pvar(t, (int)(p - eheap)); /* print its name with env */
      return;
    }
  }

  /* print literal */
  if (t == NIL) {		/* if t is NIL list ([]) */
    tprint0("[]");
    return;
  }

  if (!(--d)) {
    tprint0("???");
    return;
  }

#if DEBUG == 1
  if (isatom(t)) {
	tprint0("~");
  }
  else
  {
	  if(t->type.ident < 100L) {
		tprint3("<t=%x e=%x y=%d>",t,e,(int)t->type.ident);
		}
	  else {
		tprint2("<t=%x e=%x>",t,e);
	}
  }
#endif

  switch ((int)t->type.ident) {
    /*	case VAR_VOID_TYPE:
	case VAR_QNT_TYPE:
	case VAR_PST_TYPE:
	case VAR_GLOBAL_TYPE: */ /* already checked in the above */
	case ATOMIC_TYPE: /* atomic */
      switch ((int)t->t_arity) {
	case FLOAT_NUM : {
		tprint1("%f",num_value(t)); /* float */
		return;
		}
	case INT_NUM  : {
		tprint1("%ld",(long int)(num_value(t))); /* int */
		return;
		}
	case STRING : {
		char *n = str_value(t);
		if (String_quote_needed(n)) {
			tprint0("\"");
			for ( ; *n != '\0'; n++) {
				tprint1("%c",*n);
				if (*n == '"') tprint0("\"");
			}
			tprint0("\"");
		}
		else tprint1("\"%s\"", n); /* string */
		return;
		}
	default : {
		tprint1("#%x", (int)fnum_value(t)); /* file */
		return;
		}
	}
    case PST_TYPE: { /* pst */
		Ppst(t,e,d);
		return;
	}
    case CLAUSE_TYPE: { /* clause */
		tputc('(');
		Psequence((struct clause *)t,e,d);
		tputc(')');
		return;
		}
    case ECLAUSE_TYPE: /* eclaues */
	Peclause_core((struct eclause *)t,d);
	return;
    case LIST_TYPE:
    case CONST_LIST_TYPE: { /* list */
		tputc('[');
		Psequence((struct clause *)t,e,d);
		tputc(']');
		return;
		}
    default:			/* complex term */
		Pfunctor(t,e,d);
		return;
    }
}

void Pfunctor(t,e,d)  /* print complex term */
register struct term *t;
register struct pair *e;
int d;
{
  register struct func *f = t->type.t_func; /* f is functor of t */
  register int i, arity = f->f_arity;
  struct operator *o;

  if ((arity == 2) || (arity == 1)) {
    for(o = o_list; o != NULL; o=o->o_link)
      if (o->o_func == f) {
	switch (o->o_type & INFIX) {
	case INFIX: {
		Pterm_core(Arg(t,0),e,d);
		tprint1(" %s ",f->f_name);
		Pterm_core(Arg(t,1),e,d);
		return;
		}
	case PREFIX: {
		tprint1("%s ",f->f_name);
		Pterm_core(Arg(t,0),e,d);
		return;
		}
	case POSTFIX: {
		Pterm_core(Arg(t,0),e,d);
		tprint1(" %s",f->f_name);
		return;
		}
	}
      }
  }

  /* print functor name */
  if (quote_needed(f)) {
	char *n = f->f_name;
	tprint0("\'");
	for (; *n != '\0'; n++) {
		if (kanzi(*n)) tprint2("%c%c", *n,*(++n))
		else if (quotesign(*n)) tprint0("\'\'")
		else tprint1("%c",*n);
	}
	tprint0("\'");
	}
  else 
    tprint1("%s", f->f_name);
  if(t->t_arity==0L) return;	/* if t is const */

  tputc('(');		/* print args */
  i=0;
  while (1) {
    Pterm_core(Arg(t,i), e,d);	/* print one arg */
    if(++i >= arity) {
      tputc(')');
      break;
    }
    tprint0(", ");
  }
}

void Ppst_content(ptt,d)	/* {l1/v1,l2/v2,...} temporal PST*/
struct eclause *ptt;
int d;
{
	tputc('{');
	while (ptt->c_link != (struct eclause *)NULL) {
		Pterm_core(ptt->c_form,ptt->c_env,d);
		tprint0(", ");
		ptt = ptt->c_link;
	}
	Pterm_core(ptt->c_form,ptt->c_env,d);
	tputc('}');
}

				/* patch 92/1/22 by H.Tsuda */
void Ppst_content2(ptt,env,d)	/* {l1/v1,l2/v2,...} static PST with env */
struct eclause *ptt;
struct pair *env;
int d;
{
	tputc('{');
	while (ptt->c_link != (struct eclause *)NULL) {
		Pterm_core(ptt->c_form,env,d);
		tprint0(", ");
		ptt = ptt->c_link;
	}
	Pterm_core(ptt->c_form,env,d);
	tputc('}');
}

void Ppst(t,e,d)		/* print pst (in Pterm_core) */
struct term *t;			/* actually, (struct pst *) */
struct pair *e;
int d;
{
  register struct eclause *ptt = ((struct pst *)t)->p_lists;
  struct pst_item *target;
  int n;

  target = find_pstitem(t,e);
  if (target != (struct pst_item *)NULL) {
    ptt = target->p_lists;
    if (ptt == (struct eclause *)NULL) {
	tprint0("{}");
	return;
	}
#if DEBUG == 1
    tprint1("<pl=%x>",ptt);
#endif
    n = pp_number(ptt);
    if (n > 0) {		/* called more than once!! */
	tprint1("_p%d",n);
	return;
    }
    Ppst_content(ptt,d);	/* print temporal PST */
  }
  else {			/* print (static) PST in program */
    if (ptt == (struct eclause *)NULL) {
	tprint0("{}");
	return;
	}
#if DEBUG == 1
    tprint1("<pl=%x>",ptt);
#endif
    n = pp_number(ptt);
    if (n > 0) {		/* called more than once!! */
	tprint1("_p%d",n);
	return;
	}
    Ppst_content2(ptt,e,d);	/* print static PST with env */
   }
}

void Psequence(t,e,d)	/* print content of list t */
struct clause *t;
register struct pair *e;
int d;
{
  register struct pair *p;
  register struct term *tt = (struct term *)t;

  if ((tt == NULL) || (tt == NIL)) return;

  while (1) {
    Pterm_core(t->c_form,e,d);	/* print the first argument */
    t = t->c_link;
    tt = (struct term *)t;

    if (tt == NULL) return;
    if (isvar(tt)) {
      if (e == NULL) {
	tprint0(" | ");
	Pvar(tt, (int)vnumber(tt));
	return;
      }
      down(p, tt, e);
      if (p != NULL) { /* if tt is variable */
	tprint0(" | ");
	Pvar(tt, (int)(p - eheap));
	return;
      }
    }
    if (! (is_list(tt) || is_clause(tt))) {
      if (tt == NIL) return;
      tprint0(" | ");
      Pterm_core(tt,e,d);
      return;
    }
    tputc(',');
    t = (struct clause *)tt;
      }
}

/* ------------- functions for PST pretty print --------------- */
struct pstprint
{
	struct eclause *pp_ec;
	struct pstprint *pp_link;
	long int pp_num;
};

struct pstprint *PST_PRINT_LIST;	/* pst save entry */

void init_pp()
{
	PST_PRINT_LIST = (struct pstprint *)NULL;
	PST_PRINT_NUM = 1L;
}

void print_pp(d)		/* $1={...},$2={...},... */
int d;				/* printing depth */
{
	register struct pstprint *pp;
	int printed = FALSE;

	for (pp = PST_PRINT_LIST; pp != (struct pstprint *)NULL; pp = pp->pp_link) {
		if (pp->pp_num != 0L) {
			if (printed != FALSE) {
				tputc(',')
			}
			else printed = TRUE;
			tprint1("_p%d=", (int)pp->pp_num);
			Ppst_content(pp->pp_ec,d);
		}
	}
}

int pp_number(ec)	/* return PST number */
struct eclause *ec;
{
	register struct pstprint *pp;

	for (pp = PST_PRINT_LIST; pp != (struct pstprint *)NULL; pp = pp->pp_link)
		if (pp->pp_ec == ec) return((int)pp->pp_num);
	return(0);
}

void scanpst_term(t,e)	/* scan PST in a term */
register struct term *t;
register struct pair *e;
{
	register struct pair *p;
	void addpst(),scanpst_functor();

	if (t == NULL) return;
	if (isvar(t)) {
		if (e == (struct pair *)NULL) return;
		down(p,t,e);
		if (p != (struct pair *)NULL) return;
	}

	if (t == NIL) return; /* if t is NIL list ([]) */
	switch ((int)t->type.ident) {
		case ATOMIC_TYPE: /* atomic */
			return;
		case PST_TYPE: /* pst */
			addpst(t,e);
			return;
		case LIST_TYPE:
		case CONST_LIST_TYPE: /* list */
		case CLAUSE_TYPE: /* clause */
			scanpst_clause((struct clause *)t,e);
			return;
		case ECLAUSE_TYPE: /* eclause */
			scanpst_eclause((struct eclause *)t);
			return;
		default:			/* complex term */
			scanpst_functor(t,e);
			return;
	}
}

void scanpst_clause(t,e)	/* modify Psequence() */
struct clause *t;
struct pair *e;
{
  register struct pair *p;
  register struct term *tt = (struct term *)t;

  if ((tt == NULL) || (tt == NIL)) return;

  while (1) {
	scanpst_term(t->c_form,e);	/* scan the first argument */
	t = t->c_link;
	tt = (struct term *)t;

	if (tt == NULL) return;
	if (isvar(tt)) {
		if (e == NULL)  return;
		down(p, tt, e);
		if (p != NULL) return;
	}
	if (! (is_list(tt) || is_clause(tt))) {
		if (tt == NIL) return;
		scanpst_term(tt,e);
		return;
	}
	t = (struct clause *)tt;
	}
}

void scanpst_eclause(ec)
struct eclause *ec;
{
	if (ec == (struct eclause *)NULL) return;
	scanpst_term(ec->c_form,ec->c_env);
	scanpst_eclause(ec->c_link);
}

void scanpst_functor(t,e)
struct term *t;
struct pair *e;
{
	int i,arity;
	arity = (int)t->t_arity;
	for (i = 0; i < arity; i++)
		scanpst_term(Arg(t,i),e);
}

void addpst(t,e)
struct term *t;
struct pair *e;
{
	register struct eclause *ptt;
	struct pst_item *target;
	struct pstprint *pp,*ppnew;

	target = find_pstitem(t,e);
	if (target == (struct pst_item *)NULL)
          target = record_pstobjects((struct pst *)t,e);
	ptt = target->p_lists;

	if (ptt == (struct eclause *)NULL) return;
	for (pp = PST_PRINT_LIST; pp != (struct pstprint *)NULL; pp = pp->pp_link)
		if (pp->pp_ec == ptt) {
			if (pp->pp_num == 0L)
				pp->pp_num = PST_PRINT_NUM++;
			return;
		}
	ppnew = (struct pstprint *)alloc(3);	/* sizeof(pstprint)=3 */
	ppnew->pp_ec = ptt;
	ppnew->pp_num = 0L;
	ppnew->pp_link = PST_PRINT_LIST;
	PST_PRINT_LIST = ppnew;
}

/* ------------- functions for debug ------------------- */
#ifdef DEBUG
void P_var(vlist)
struct term *vlist;
{
	register struct term *v;

	for (v = vlist; v != NULL; v = vlink(v))
	{
		tprint2("%s-(%d)-",vname(v),(int)v->type.ident);
		Pclause_core(vconstraint(v),(struct pair *)NULL);
		NL;
	}
}

void showvar(v)			/* show variable (for debug) */
struct term *v;
{
	tprint0("(");
	while (v != NULL) {
		tprint1("%s ",vname(v));
		v = vlink(v);
	}
	tprint0(")");
}
#endif
