/*
*
*		cu-Prolog (Constraint Unification Prolog)
*  Copyright: Institute for New Generation Computer Technology,Japan 1989
*		<<<< new.c >>>>
*
*		memory management
*
* 88/6/9
* 90.4.1 ver3.0
* 90.7.1 ver3.10
*/

#define DEBUG  0		/* if Debug 1 else 0 */
#define	NEW    1

#include "include.h"

/* struct allocation macro   int a:arity  */
int TERM_SIZE = (sizeof(struct term) / sizeof(long int));
int FUNC_SIZE = (sizeof(struct func) / sizeof(long int));
int POINTER_SIZE = (sizeof(struct term *) / sizeof(long int));

#ifndef CPUTIME /* SUN4 or MAC */
#define Termalloc(a)	(struct term *)salloc(TERM_SIZE + a * POINTER_SIZE)
#define tempterm(a)	(struct term *)alloc(TERM_SIZE + a * POINTER_SIZE)
#define mediterm(a)     (struct term *)challoc(TERM_SIZE + a * POINTER_SIZE)
#else
#define Termalloc(a)  (struct term *)salloc(TERM_SIZE + (a-1) * POINTER_SIZE)
#define tempterm(a)   (struct term *)alloc(TERM_SIZE + (a-1) * POINTER_SIZE)
#define mediterm(a)   (struct term *)challoc(TERM_SIZE + (a-1) * POINTER_SIZE)
#endif

#ifdef MAC
#define funcalloc(a)    (struct func *)salloc(FUNC_SIZE + 1 + (int)(a/32))
#else
#define funcalloc(a)  (struct func *)salloc(FUNC_SIZE + (int)(a/32))
#endif

	
void print_hash_table()		/* for debug */
{
	register int i;
	register struct func *f;
	
	for (i = 0; i < HASH_SIZE; i++)
	{
		ttyprint1("[%d>",i);
		for (f = hash_list[i]; f != NULL; f = f->f_link)
			ttyprint2("%s/%d  ",f->f_name,f->f_arity)
		ttynl;
	}
}
		
int hash(fname)
char *fname;
{
	register int h = 0, factor;

	for (factor = strlen(fname) + 1; *fname != '\0'; fname++, factor--)
		h+= ((*fname) * factor);
	if (h < 0) return(0);
	return(h % HASH_SIZE);
}

long int *salloc(n)		/* system heap allocation */
register int n;
{
        register long int *p;
#if DEBUG == 1
	if (shp < sheap)
		error("system heap underflow");
#endif
        p = shp;
        shp += n;
        if (shp < SHEAPTOP)
                return(p);
        else
                error("system heap overflow");
}

long int *alloc(n)	/* user heap allocation */
register int n;
{
        register long int *p;
	/* -	hp */


        p = hp;
        hp += n;
#if DEBUG == 1
	if (hp < heap){
		sprintf(nbuf,"hp = %d  : user heap underflow",hp);
		error(nbuf);
	}
#endif
	if (hp > Heap_Max) Heap_Max = hp; 
        if (hp < HEAPTOP)
                return(p);
        else
                error("user heap overflow");
}

long int *challoc(n)	/* constraints/pst heap allocation */
register int n;
{
        register long int *p;

        p = chp;
        chp += n;
#if DEBUG == 1
	if (chp < cheap){
		sprintf(nbuf,"chp = %d  : constraints heap underflow",chp);
		error(nbuf);
	}
#endif
	if (chp > Cheap_Max) Cheap_Max = chp;
        if (chp < CHEAPTOP)
                return(p);
        else
                error("constraints heap overflow");
}

struct pair *ealloc(n)	/* envionment stack allocation */
register int n;
{
        register struct pair *p;

        p = ep;
        ep += n;
#if DEBUG == 1
	if (ep < eheap){
		sprintf(nbuf,"ep = %d  : environment stack underflow",ep);
		error(nbuf);
	}
#endif
	if (ep > Esp_Max) Esp_Max = ep;
        if (ep < ESPTOP)
                return(p);
        else
                error("environment stack overflow");
}


char *nalloc(n,flag)	/* name string heap allocation */
register char *n;
int flag;
{
        register char *p;
	register int q;
	register struct func *f;

	if ((nheap <= n) && (n <= nhp)) return(n);
	if ((f = exist_fname(n)) != NULL)  return(f->f_name); 

	/* - nhp */
        switch (flag) {
	  case ETERNAL:
 	  case MEDIUM:
		q = strlen(n)+1;
		p = nhp;
		nhp += q;
		if(nhp > NHEAPTOP) error("name heap overflow");
		break;
	  default : /* TEMPORAL or STINGY */
		q = strlen(n)+4;
#ifdef MAC
		p = (char *)alloc(q / 4);
#else
		p = (char *)alloc(q / sizeof(long int));
#endif
	      }
	strcpy(p,n);
	return(p);
      }


struct term *Nnum(nbuf,flag) /* make number */
char *nbuf;
int flag;
{
      register struct term *n;
      float x;
      double atof();

#ifdef MAC
      MEMORY_ALLOC(n,term,flag,3);
#else
      MEMORY_ALLOC(n,term,flag);
#endif
      n->type.ident = (long int)ATOMIC_TYPE;
      sscanf(nbuf,"%f",&x);
      n->tag.n_value = x;
      if (x == ((float)((long int)x))) n->t_arity = (long int)INT_NUM;
      else n->t_arity = (long int)FLOAT_NUM;
      return(n);
}

struct term *Nnum_val(x,flag)	/* make a term representing x */
register float x;
int flag;
{
      register struct term *n;

#ifdef MAC
      MEMORY_ALLOC(n,term,flag,3);
#else
      MEMORY_ALLOC(n,term,flag);
#endif
      n->type.ident = (long int)ATOMIC_TYPE;
      if (x == ((float)((long int)x))) n->t_arity = (long int)INT_NUM;
      else n->t_arity = (long int)FLOAT_NUM;
      n->tag.n_value = x;
      return(n);
}

struct term *Nstr(x, flag)	/* make a term representing x */
char *x;
int flag;
{
  register struct term *s;

#ifdef MAC
      MEMORY_ALLOC(s,term,flag,3);
#else
      MEMORY_ALLOC(s,term,flag);
#endif
  s->type.ident = (long int)ATOMIC_TYPE;
  s->t_arity = (long int)STRING;
  if (flag==STINGY) flag=ETERNAL;
  s->tag.s_value = nalloc(x,flag);
  return(s);
}

struct pst *Npst(flag)
int flag;
{
  register struct pst *p;
  struct pstvar *pv;

 switch (flag) {
	case TEMPORAL:
		p = (struct pst *)alloc(3);	/* sizeof(pst) = 3 */
		pv = (struct pstvar *)alloc(5); /* sizeof(pstvar) = 5 */
		break;
	case MEDIUM:
		p = (struct pst *)challoc(3);
		pv = (struct pstvar *)challoc(5);
		break;
	default:
		p = (struct pst *)salloc(3);
		pv = (struct pstvar *)salloc(5);
	}

  p->type = PST_TYPE;
  pv->v_type = VAR_PST_TYPE;
  pv->v_name = vname(Anonymous_var);
  pv->v_number = p_number++;
  pv->v_link = pv_list;
  pv->old_var = NULL;
  p->p_var = pv_list = (struct term *)pv;

  p->p_lists = (struct eclause *)NULL;
  return(p);
}

struct eclause *Neclause(val,env,tail,flag)
struct term *val;
struct pair *env;
struct eclause *tail;
int flag;
{
  struct eclause *obj;

#ifdef MAC
  MEMORY_ALLOC(obj,eclause,flag,4);
#else
  MEMORY_ALLOC(obj,eclause,flag);
#endif
  obj->c_type = ECLAUSE_TYPE;
  obj->c_env = env;
  obj->c_form = val;
  obj->c_link = tail;
  return(obj);
}

struct term *Npst_item(p,pobj,next)
struct pair *p;
struct eclause *pobj;
struct pst_item *next;
{
  struct pst_item *t;
#ifdef MAC
	t = (struct pst_item *)challoc(3);
#else
	t = cnew(pst_item);
#endif
  t->p_var = p;
  t->p_lists = pobj;
  t->p_link = next;
  return((struct term *)t);
}

struct pst_item *find_pstitem(t,e)
struct term *t;
struct pair *e;
{
  register struct pair *p;
  register struct pst_item *table = psttable->p_link;

  if (e==(struct pair *)NULL)
    return((struct pst_item *)NULL);

  t = ((struct pst *)t)->p_var;
  down(p,t,e);
  while (table != (struct pst_item *)NULL) {
    if (table->p_var == p) return(table);
    table = table->p_link;
  }
  return(table);
}

struct term *Nvar(nbuf,flag)	/* make new var */
char *nbuf;
int flag;
{
        register struct var *v;
	/* +	nbuf		 	*/
	/* - 	v_number, v_list, shp	*/

#ifdef MAC
       MEMORY_ALLOC(v,var,flag,6);
#else
       MEMORY_ALLOC(v,var,flag);
#endif
	if (nbuf[0] == '!') {
	        v->v_type = VAR_QNT_TYPE;
		qv_number++;
	}
	else v->v_type = VAR_GLOBAL_TYPE;

        v->v_number = v_number++;
        v->v_name = (nbuf==Anonymous_VarName) ? Anonymous_VarName : 
	            nalloc(nbuf,flag);
        v->v_link = (struct var *)v_list;
        v_list = (struct term *)v;
        v->v_constraint = NULL;	/* for CAHC 89.6.16 */
	v->v_occurrence = 1;	/* var occurrence */
        return(v_list);
}

struct term *varsearch(varname)	/* search varname in v_list */
char *varname;
{
  register struct term *v;
  for (v = v_list; v != NULL; v = vlink(v))
    if (streq(varname, vname(v))) {
	    ((struct var *)v)->v_occurrence++;
	    return(v);
    }
  return(NULL);
}

void reset_voccurrence(v)		/* all v_occurrence = 0 */
register struct term *v;
{
  while (v != NULL) {
    ((struct var *)v)->v_head_occur = ((struct var *)v)->v_occurrence;
    ((struct var *)v)->v_occurrence = 0;
    v = vlink(v);
  }
}

void recalc_voccur_sub(t,v)
struct term *t,*v;
{
  if (t == NULL) return;
  switch ((int)t->type.ident) {
  /* var */
    case VAR_GLOBAL_TYPE:
          ((struct var *)t)->v_occurrence++;
    case VAR_VOID_TYPE:
    case VAR_QNT_TYPE:
    case VAR_PST_TYPE:
    case ATOMIC_TYPE:
          return;
    case PST_TYPE:
          recalc_voccur_sub((struct term *)((struct pst *)t)->p_lists,v);
	  return;
    case ECLAUSE_TYPE: /* for pst objects */
          recalc_voccur_sub(Arg2(((struct eclause *)t)->c_form),v);
	  recalc_voccur_sub((struct term *)((struct eclause *)t)->c_link,v);
	  return;
    case CLAUSE_TYPE: 
    case LIST_TYPE:
          recalc_voccur_sub(head_of_list(t),v);
          recalc_voccur_sub(tail_of_list(t),v);
    case CONST_LIST_TYPE: 
          return;
    default:
	     {
	       register int i, j=Pred(t)->f_arity;
	       for (i = 0; i < j; i++)
		 recalc_voccur_sub(Arg(t,i),v);
	     }
	   }
}


void recalc_voccurrence(cl,v)	/* cl <-  H :- C. */
struct clause *cl;
struct term *v;
{
	register struct clause *c;
	
	if (cl == NULL) return;
	if (v == NULL) return;
	reset_voccurrence(v);
	recalc_voccur_sub(cl->c_form,v); /* check head */
	reset_voccurrence(v);
	for (c = cl->c_link; c != NULL; c = c->c_link) /* check body */
		recalc_voccur_sub(c->c_form,v);
/*	while (v!=NULL) {
	  if ((((struct var *)v)->v_head_occur +
	       ((struct var *)v)->v_occurrence) <= 1)
	    ((struct var *)v)->v_type = VAR_VOID_TYPE;
	  v = (struct term *)(((struct var *)v)->v_link);
	} */
}

	
struct func *exist_fname(fname)	/* search predicate name */
char *fname;
{
	register struct func *f;
	
	for (f = hash_list[hash(fname)]; f != NULL; f = f->f_link)
		if (streq(fname,f->f_name)) return(f);
	return(NULL);
}

struct func *Predicate(fname, arity) /* search fname/arity */
char *fname;			/* if not exist, make Nfunc */
int arity;
{
	register struct func *f;

	f = funcsearch(fname,arity);
	if (f == NULL) return(Nfunc(USERFUN,fname,arity));
	else return(f);
}

struct func *funcsearch(fname, arity) /* search fname/arity */
char *fname;
int arity;
{
	register struct func *f;
	register int compare;

	for (f = hash_list[hash(fname)]; f != NULL; f = f->f_link)
	{
		if ((compare = strcmp(fname,f->f_name)) > 0)
			return(NULL);
		if ((compare == 0) && (f->f_arity == arity)) 
			return(f);
	}
	return(NULL);
}

int pred_compare(f1,f2)	/* pred compare -1 <, 0: =, 1 > */
struct func *f1,*f2;
{
	register int cmp;
	
	cmp = strcmp(f1->f_name,f2->f_name);
	if (cmp != 0) return(cmp);
	return(f2->f_arity - f1->f_arity);
}

void index_func(fnew)	/* store predicate fnew into hash-table */
struct func *fnew;
{
	struct func *flist;
	register struct func *f, *flast;
	int pred_compare();
	int i = hash(fnew->f_name);

	flist = hash_list[i];
	if ((flist == NULL) || (pred_compare(fnew,flist) > 0))
	{ 
		hash_list[i] = fnew; 
		fnew->f_link = flist; 
		return; 
	}
	for (flast=flist, f=flist->f_link; f != NULL; flast = f, f = f->f_link)
	{
		i = pred_compare(fnew,f);
		if (i > 0) break;
		if (i==0) {
/*	  sprintf(nbuf,"function `%s' is already used",fnew->f_name);
	  error(nbuf); */
		  return;
		}
	}
	flast->f_link = fnew;
	fnew->f_link = f;
	return;
}

struct itrace *index_newflist(fl,it)
struct itrace *fl,*it;
{
  register struct itrace *t, *top, *s, *temp;
  if (fl==it) return(fl);

#ifdef MAC
  top = temp = (struct itrace *)alloc(3);
#else
  top = temp = new(itrace);
#endif
  for (t=fl; t != it; t=t->it_link) {
    if (in_sheap(t)) {
      temp->it_link = t;
      temp = t;
    }
    else {
#ifdef MAC
      temp->it_link = s = (struct itrace *)salloc(3);
#else
      temp->it_link = s = snew(itrace);
#endif
      s->it_anumber = t->it_anumber;
      s->it_cnumber = t->it_cnumber;
      temp = s;
    }
    temp->it_clause = up_itrace_clause(t->it_clause,(int)t->it_anumber);
  }
  temp->it_link=it;
  return(top->it_link);
}

struct operator *op_search(fname,otype)
char *fname;
register int otype;
{
  register struct operator *o;
  register struct func *f;

  f = (otype != INFIX) ? funcsearch(fname,1) : funcsearch(fname,2);
  if (f == NULL) return(NULL);
  for (o=o_list; o != NULL; o=o->o_link)
    if ((f == o->o_func) && (otype == (o->o_type & INFIX)))
      return(o);
  return(NULL);
}

int FNUMBER = 0; /* function number  (used in term compare ) */

struct func *Nfunc(ftype, n, a)	/* make new function */
int ftype;			/* predicate type in include.h */
char *n;			/* functor name */
int a;				/* arity */
{
        register struct func *f, *ff;
	int i;
	
	/* -	FNUMBER, const_list,f_list, shp  */
	f = funcalloc(a);
        f->f_arity = a;
        f->f_name = nalloc(n,ETERNAL);
	f->f_setcount = 0;	/* number of def clauses */
	f->f_unitcount = 0L;	/* number of unit clauses */
        f->def.f_set = NULL;
	f->f_number = FNUMBER++;
	f->f_integ = NULL;
	if (ftype != TEMPFUN)
	{ f->f_mark = (a > 0) ? (ftype | VACUITY_NOCHECK) : ftype;
	  index_func(f);
        }
	else
	  { f->f_mark = (a > 0) ? (USERFUN | VACUITY_NOCHECK) :
	      USERFUN;
	    ff = f_list;
	    f_list = f;
	    f->f_link = ff;
	  }
	for (i = (a / INTEGER_SIZE); i >= 0; i--) f->f_roles[i] = 0;
        return(f);
}

struct term *Nterm(n,flag)
int n;		/* arity */
int flag;
{
	struct term *t;	/* alloc term in sheap */

/*	if (n > VMAX) error("Too many arguments"); */
	switch (flag) {
	  case TEMPORAL:
	    t = tempterm(n); break;
	  case ETERNAL:
	  case STINGY:
	    t = Termalloc(n); break;
	  default: /* MEDIUM */
	    t = mediterm(n);
	  }
	t->t_arity = (long int)n;
        return(t);
}

struct pair *Nenv(n)	/*  new environment for n vars    */
register int n;
{
        register struct pair *p;
        register int i;

	p = ealloc(n);

        for(i = 0;  i < n;  i++)
	{
                p[i].p_body = NULL;
		p[i].p_env = NULL;
	}
        return(p);
}

struct clause *Nlist(head,body,flag)
struct term *head;
struct clause *body;
int flag;
{
  register struct clause *c;

#ifdef MAC
  MEMORY_ALLOC(c,clause,flag,3);
#else
  MEMORY_ALLOC(c,clause,flag);
#endif

  if (head == NIL) c->c_type = LIST_TYPE;  /* dummy list */
  else {
    c->c_type =  (novar(head) && 
		((body == (struct clause *)NIL) ||
		 (body->c_type == CONST_LIST_TYPE))) ?
    CONST_LIST_TYPE : LIST_TYPE;
  }
  c->c_form = head;
  c->c_link = body;
  return(c);
}

struct clause *Nclause(head,body,flag)
struct term *head;
struct clause *body;
int flag;
{
  register struct clause *c;

#ifdef MAC
  MEMORY_ALLOC(c,clause,flag,3);
#else
  MEMORY_ALLOC(c,clause,flag);
#endif

  c->c_type = CLAUSE_TYPE;
  c->c_form = head;
  c->c_link = body;
  return(c);
}

struct set *setconcat(slist, s)		/*  add s to the end of slist */
struct set *slist,*s;
{
	register struct set *ss;

	if (slist == NULL) return(s);

	for(ss = slist; ss->s_link != NULL; ss = ss->s_link) ;
	ss->s_link = s;
	return(slist);
}

int literalnumber(c)		/* number of literals in c */
register struct clause *c;
{
	register int i;

	for (i = 0; c != NULL; c = c->c_link, i++);
	return(i);
}

void index_set(chead,con,flag)
struct clause *chead, *con;
int flag;
{
  struct set *s;
  
  if (issystem(Pred(chead->c_form))) {
    sprintf(nbuf,"Caution!! : %s is a system predicate.",
	Pred(chead->c_form)->f_name);
    error(nbuf);
  }

#ifdef MAC
  s = (struct set *)salloc(5);
#else
  s = snew(set);
#endif

  s->s_clause = chead;

  recalc_voccurrence(chead, v_list);
  s->s_vlist = v_list;
  s->s_anumber = (unsigned short int)(v_number+p_number);
  s->s_constraint = con;
  s->s_link = NULL;

  add_set(s,flag);
}


void add_set(s,flag)		/* add definition s to the end */
struct set *s;
int flag;			/* ASSERT_? (TOP,LAST,NEW) */
{
	register struct func *f = s->s_clause->c_form->type.t_func;
	int literalnumber();
	struct set *setconcat();

	/* check set_bodynumber */
	s->s_bodynumber = literalnumber(s->s_clause->c_link);
	
	switch (flag) {
	case ASSERT_TOP: /* put s to the top */
		s->s_link = f->def.f_set;
		f->def.f_set = s;
		break;
	case ASSERT_NEW: /* 'n' means consult/reconsult files */
		if is_oldpred(f) {
			reset_oldpred(f);
			f->f_setcount = f->f_unitcount = 0;
			f->def.f_set = s;
			break;
		}
	case ASSERT_LAST: /* default */
		f->def.f_set = setconcat(f->def.f_set, s);
	}

	f->f_setcount++;
	if is_unitclause(s) f->f_unitcount++;
	Def_Modified = 1;	/* def modified flag (global v.) */
}


void upush(p)
register long int *p;
{
	/* -	usp 	*/

	if (p == NULL) return;
	usp->u_addr = (long int *)p;
        (usp++)->u_val = *p;

#if DEBUG == 1
	if (p < heap || p > HEAPTOP) 
		error("out of range in upush");
	if (usp < ustack)
		error("user stack underflow");
#endif
	if (usp > Stack_Max) Stack_Max = usp; 

        if (usp > STACKTOP)
                error("user stack overflow");
}

void undo(u)
register struct ustack *u;
{
	/* - 	usp	*/
#if DEBUG == 1
	if (u < ustack)
		error("user stack underpop");
#endif
	if (u > usp)
		error("user stack overpop");
        while(usp > u) {
                --usp;
       		if (usp->u_addr == NULL) return;
		*(usp->u_addr) = usp->u_val;
        }
}
