/*
*
*		cu-Prolog (Constraint Unification Prolog)
*   Copyright: Institute for New Generation Computer Technology,Japan 1989
*		<<<< modular.c >>>>
*
*			modularize
*90.11.1 cu-PrologV3
*/

#include "include.h"

#if SUN4 == 1
#include <sys/time.h>
long clock();
#elif MAC == 1
#include <time.h>
#else
#include <sys/types.h>
#include <sys/times.h>
#endif

#define in_cheap(X) (( &cheap[0] <= ((long int *)X)) && \
					 (((long int *)X) < chp))
#define in_upper_heap(X,Y) ( in_sheap(X) || ( (Y==MEDIUM) && in_cheap(X)) )

unsigned long int CONSTRAINT_OLD_TIME;

struct ustack *ustack_save_up;	/* save old ups */
struct up_log  *UP_log;		/* up log list */

void modular(c)	/* constraint trans. from top level (@) */
struct clause *c;
{
	struct clause *sol;

	sol = startmodular(c, v_list); /* tranformation */
	ttyprint0("solution = ");
	if (sol == MFAIL){	/* fail transformation */
		ttyprint0("fail."); ttynl;
	}
	else if (sol == NULL){	/* nil constraint */
		ttyprint0("nil (true)."); ttynl;
	}
	else			/* c.t. success */
	{ FILE *filep = wfp;
	  wfp = stdout;
		Pclause(sol, (struct pair *)NULL); ttynl;
		show_newdefs();	/* print DEF_list */
	  wfp = filep;
	}
}


/* constraint transformation embedded in Prolog  : unify() pred. */
int cu(t,e)		/*  0: cu fail  1: success   */
struct term *t;
struct pair *e;
{
	register struct pair *p, *q;
	struct pair *ee;
	struct term *tt;
	struct clause *c, *clist;
#if MAC == 1
	long int TIMES;
#elif MSDOS == 1
	unsigned long int TIMES;
#elif CPUTIME != 0
	struct tms TIMES;
#endif

	if (t == NULL) return(TRUE);

	if (! isvar(Arg2(t))) return(FALSE);	/* second arg = var */
	p = &e[vnumber(Arg2(t))];
	if (p->p_body != NULL) return(FALSE);	/* second arg-->var */

#if SUN4 == 1
	CONSTRAINT_OLD_TIME = clock();
#elif MAC == 1
	CONSTRAINT_OLD_TIME=TickCount();
#elif MSDOS == 1
	time(&TIMES);
	CONSTRAINT_OLD_TIME =  TIMES;
#elif CPUTIME != 0
	times(&TIMES);
	CONSTRAINT_OLD_TIME =  TIMES.tms_stime + TIMES.tms_utime;
#endif
	p->p_env = Nenv(0);	/*  cf. 'q' in termset()  */
	up_init(); /* EVAL_PST_FLAG = TRUE; */
	tt = Arg1(t);
	ee = e;
	down(q,tt,ee);
	if (tt == NIL){
	  p->p_body = NIL;
	  p->p_env = NULL;
#if SUN4 == 1
	  CONSTRAINT_HANDLING_TIME += clock()-CONSTRAINT_OLD_TIME;
#elif MAC == 1
	TIMES = TickCount();
	 CONSTRAINT_HANDLING_TIME += TIMES-CONSTRAINT_OLD_TIME;
#elif MSDOS == 1
	time(&TIMES);
	CONSTRAINT_HANDLING_TIME += TIMES - CONSTRAINT_OLD_TIME;
#elif CPUTIME != 0
	  times(&TIMES);
	  CONSTRAINT_HANDLING_TIME += TIMES.tms_stime + TIMES.tms_utime -
	    CONSTRAINT_OLD_TIME;
#endif
	  return(TRUE);
	}

	clist = c = Nclause(NIL,(struct clause *)NULL,TEMPORAL);
	head_of_list(c) =
		termset(head_of_list(tt),NULL,ee,TEMPORAL);
	while (1) {
	  tt = tail_of_list(tt);
	if (tt == NULL) break;
	  down(q,tt,ee);
	  if ((tt == NIL) || (! (is_list(tt) || is_clause(tt)) )) break;
	  c->c_link = Nclause(NIL, (struct clause *)NULL,TEMPORAL);
	  head_of_list(c->c_link) =
		termset(head_of_list(tt),NULL,ee,TEMPORAL),
	  c = c->c_link;
	}

	if ((tt != NIL) && (tt != NULL)) {
		up_restore(NULL,TEMPORAL);
		p->p_env = NULL;
		error("Illegal form of constraint list.");
	}

	if (p_number != 0) {
	  renum_pvars((struct pstvar *)pv_list,v_number);
	  q=Nenv(p_number);
	}
	clist = up_restore(clist,TEMPORAL);

 /* transformation */

	c = startmodular(clist,v_list);

	if (c == MFAIL){	/* fail transformation */
		p->p_env = NULL;
#if SUN4 == 1
		CONSTRAINT_HANDLING_TIME += clock()-CONSTRAINT_OLD_TIME;
#elif MAC == 1
	TIMES = TickCount();
	 CONSTRAINT_HANDLING_TIME += TIMES-CONSTRAINT_OLD_TIME;
#elif MSDOS == 1
	time(&TIMES);
	CONSTRAINT_HANDLING_TIME += TIMES - CONSTRAINT_OLD_TIME;
#elif CPUTIME != 0
		times(&TIMES);
		CONSTRAINT_HANDLING_TIME += TIMES.tms_stime + TIMES.tms_utime -
		  CONSTRAINT_OLD_TIME;
#endif
		return(FALSE);	/* fail */
	}
	else if (c == NULL)
	{
		p->p_body = NIL;
		p->p_env = NULL;
#if SUN4 == 1
		CONSTRAINT_HANDLING_TIME += clock()-CONSTRAINT_OLD_TIME;
#elif MAC == 1
	TIMES = TickCount();
	 CONSTRAINT_HANDLING_TIME += TIMES-CONSTRAINT_OLD_TIME;
#elif MSDOS == 1
	time(&TIMES);
	CONSTRAINT_HANDLING_TIME += TIMES - CONSTRAINT_OLD_TIME;
#elif CPUTIME != 0
		times(&TIMES);
		CONSTRAINT_HANDLING_TIME += TIMES.tms_stime + TIMES.tms_utime -
		  CONSTRAINT_OLD_TIME;
#endif
		return(TRUE);
	}
	else
	{
		p->p_body = tolist(c,STINGY);
TTB
		ttyprint0("   ====> ");
		{ FILE *filep = wfp;
		  wfp = stdout;
		Pterm(p->p_body, p->p_env);
                  wfp = filep;
		}
TTE
#if SUN4 == 1
		CONSTRAINT_HANDLING_TIME += clock()-CONSTRAINT_OLD_TIME;
#elif MAC == 1
	TIMES = TickCount();
	 CONSTRAINT_HANDLING_TIME += TIMES-CONSTRAINT_OLD_TIME;
#elif MSDOS == 1
	time(&TIMES);
	CONSTRAINT_HANDLING_TIME += TIMES - CONSTRAINT_OLD_TIME;
#elif CPUTIME != 0
		times(&TIMES);
		CONSTRAINT_HANDLING_TIME += TIMES.tms_stime + TIMES.tms_utime -
		  CONSTRAINT_OLD_TIME;
#endif
	        return(TRUE);	/* success */
	}
}

/*  change clause(t1,t2,t3)  to list([t1,t2,t3])   */
struct term *tolist(c,flag)
struct clause *c;
int flag;
{
  register struct clause *cc, *croot;

  if (c == NULL) return(NIL);
  
  switch (flag) {
    case STINGY:
       for (cc = c; cc->c_link != NULL; cc=cc->c_link)
	   cc->c_type = LIST_TYPE;
       cc->c_link = (struct clause *)NIL;
       return((struct term *)c);
    default:
       croot=cc=Nlist(head_of_list(c),(struct clause *)NIL,flag);
       while (c->c_link != NULL) {
	  c=c->c_link;
          cc->c_link=Nlist(head_of_list(c),(struct clause *)NIL,flag);
	  cc = cc->c_link;
	}
       return((struct term *)croot);
     }
}

int constant_check_flag = CONSTANT_TERM; /* 1991-03-03 */

/*  ---------  term set -------------  */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  struct term *termset(t,e,flag)
  struct clause *up_eclause(ec,flag)
   make variant of terms with an environment
   Before termset, up_init() and after termset,  up_restore().
   Before termset, set p=Nenv(0), then p will be a unifier.
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void up_init()
{
	ustack_save_up = usp;
	v_number = 0; v_list = NULL;
	p_number = 0; pv_list = NULL; qv_number = 0;
	UP_log = UP_pstlog = (struct up_log *)NULL;
	PSTLISTS = (struct clause *)NULL;
	EVAL_PST_FLAG = FALSE;
}

struct clause *up_restore(clist,flag)
struct clause *clist;
int flag;
{
	UP_log = (struct up_log *)NULL;
	undo(ustack_save_up);

	if (PSTLISTS != (struct clause *)NULL) {
          struct clause *c, *cc, *copy_append();

          cc = c = remove_redundant_pst(PSTLISTS);

          if (c != (struct clause *)NULL) {
            if (flag == TEMPORAL) {
              while (c->c_link != (struct clause *)NULL)
                c = c->c_link;
              c->c_link = clist;
              return(cc);
            }
            else
              return(copy_append(c,clist,flag));
          }
        }
/* else */
        return(clist);
}

struct clause *copy_append(c,clist,flag)
struct clause *c,*clist;
int flag;
{
  if (c==(struct clause *)NULL) return(clist);
  return(Nclause(c->c_form,
                 copy_append(c->c_link,clist,flag),
                 flag));
}

void push_pstlog(oldp,oldenv,newt)
struct pst *oldp, *newt;
struct pair *oldenv;
{
	struct up_log *u;
	u=(struct up_log *)alloc(5);	/* sizeof(up_log) = 5 */
	u->u_old = (struct term *)oldp;
	u->u_new = (struct term *)newt;
	u->u_oldenv = oldenv;
	u->u_link = UP_pstlog;
	u->u_count = 0L;
	UP_pstlog = u;
}

struct term *search_pstlog(t,e)	/* search (t,e) in UP_log */
struct term *t;
struct pair *e;
{
	register struct up_log *u;
	for (u = UP_pstlog; u != (struct up_log *)NULL; u = u->u_link)
		if (u->u_old == t && u->u_oldenv == e) {
			u->u_count++;
			return(u->u_new);
			}
	return(NULL);
}

/*
void push_log(oldp,oldenv,newt)
struct term *oldp, *newt;
struct pair *oldenv;
{
	struct up_log *u;

	u = new(up_log);
	u->u_old = oldp;
	u->u_new = newt;
	u->u_oldenv = oldenv;
	u->u_link = UP_log;
	u->u_count = 0L;
	UP_log = u;
}

struct term *search_log(t,e)
struct term *t;
struct pair *e;
{
	register struct up_log *u;
	for (u = UP_log; u != (struct up_log *)NULL; u = u->u_link)
		if (u->u_old == t && u->u_oldenv == e)
			return(u->u_new);
	return(NULL);
}
*/

/* term prepare for cu() : v_list and v_number are changed */
struct term *termset(t,tt,e,flag)
register struct term *t, **tt;
register struct pair *e;
int flag;
{
  struct term *nt, *termset_sub(), *termset_var();
  struct term *vl;
  struct pair *q;

  if (t == NULL) return(t);

  if (isvar(t)) {
      vl = v_list;
      nt=termset_var(t,tt,e,flag);
      if (isvar(nt)) {
        if (vl != v_list) {
          q = Nenv(1);
          q->p_body = t;
          q->p_env  = e;
        }
        else ((struct var *)nt)->v_occurrence++;
      }
      return(nt);
    }
  else {
    vl = v_list;
    nt=termset_sub(t,tt,e,flag);
    if (isvar(nt) && (vl != v_list)) {
      q = Nenv(1);
      q->p_body = t;
      q->p_env  = e;
    }
    return(nt);
  }
}

struct term *termset_var(t,tt,e,flag)
register struct term *t, **tt;
register struct pair *e;
int flag;
{
  struct pair *p,*q;

  down(p,t,e);
  if (p != NULL)	{	/*	if t is var 	*/
    constant_check_flag =  NOT_CONSTANT_TERM;
    if (p == Anonymous_env)
      return(Anonymous_var);
    if (p->p_env == NULL)	{/*	if t is new var */
      /* use p->p_env as work area */
      upush(&(p->p_env));
      Nvar(vname(t),flag);
      p->p_env = (struct pair *)v_list;
      return(v_list);
    }
    else{
      return( (struct term *)p->p_env );
    }
  }
  return(termset_sub(t,tt,e,flag));
}

struct term *termset_sub(t,tt,e,flag)
register struct term *t, **tt;
register struct pair *e;
int flag;
{
  struct term *nt;
  int cc_flag_save = constant_check_flag; /* 1991-03-03 */
  
  switch ((int)t->type.ident) {
  case ATOMIC_TYPE:
    return(up_atomic(t,flag)); /* constant term */
  case CLAUSE_TYPE:
    nt = (struct term *)Nclause(NIL,(struct clause *)NULL,flag);
/* special case for TOPLEVEL */
    head_of_list(nt)=
	termset(head_of_list(t),NULL,e,flag);
    ((struct clause *)nt)->c_link = (struct clause *)
    	termset((struct term *)tail_of_list(t),NULL,e,flag);
    return(nt);
  case LIST_TYPE:
  case CONST_LIST_TYPE:
    constant_check_flag = CONSTANT_TERM;

    nt = (struct term *)Nlist(NIL,(struct clause *)NULL,flag);
    head_of_list(nt)=
	termset(head_of_list(t),&head_of_list(nt),e,flag);
    ((struct clause *)nt)->c_link = (struct clause *)
    	termset((struct term *)tail_of_list(t),
    		&(((struct clause *)nt)->c_link),e,flag);
    if (constant_check_flag == CONSTANT_TERM) {
      nt->type.ident = CONST_LIST_TYPE;
      constant_check_flag = cc_flag_save;
    }
    /* else nt->type.ident = LIST_TYPE; */ /* useless */
     return(nt);
  case PST_TYPE: 
    constant_check_flag = NOT_CONSTANT_TERM; /* 1991-03-03 */
    return(up_pst(t,tt,e,flag));
    
  default:
    if (isconst_functor(t))
      return(up_const_functor(t,flag));

    constant_check_flag = CONSTANT_TERM;
    nt = Nterm((int)t->t_arity,flag);
    nt->type.t_func =t->type.t_func;
    {
      register int i;
      for (i = 0; i < (int)t->t_arity; i++)
	Arg(nt,i) = termset(Arg(t,i),&Arg(nt,i),e, flag);
    }
    if (constant_check_flag == CONSTANT_TERM) { /* 1991-03-03 */
      nt->t_arity = -nt->t_arity;
      constant_check_flag = cc_flag_save;
    }
    return(nt);
  }
}

struct term *up_pst(pt,pl,e,flag)
struct pst *pt;
struct term **pl;
struct pair *e;
int flag;
{
  struct pst_item *target;
  struct pst *nt;
  struct pstvar *pv;
  struct eclause *targetobj;
  struct pair *e0;
  struct term *oldt;

  if ((target = find_pstitem((struct term *)pt,e)) != (struct pst_item *)NULL)
  {
	e0 = (struct pair *)NULL;
	if ((oldt = search_pstlog((struct term *)pt,e0)) != NULL)
		return(oldt);
	targetobj = termset_pstobj(target->p_lists,flag);
  }
  else {
	e0 = e;
	if ((oldt = search_pstlog((struct term *)pt,e0)) != NULL)
		return(oldt);
	targetobj = termset_pstobj_sub(pt->p_lists,e,flag);
	}

  if ((EVAL_PST_FLAG == FALSE)) {
	oldt = Nterm(2,flag);
	Pred(oldt)=EQ2_P;
	oldt->tag.t_arg[1]=Nvar("PST",flag);
	}

 switch (flag) {
	case TEMPORAL:
		nt = (struct pst *)alloc(3);	/* sizeof(pst) = 3 */
		pv = (struct pstvar *)alloc(5); /* sizeof(pstvar) = 5 */
		break;
	case MEDIUM:
		nt = (struct pst *)challoc(3);
		pv = (struct pstvar *)challoc(5);
		break;
	default:
		nt = (struct pst *)salloc(3);
		pv = (struct pstvar *)salloc(5);
	}

  nt->type = PST_TYPE;
  pv->v_type = VAR_PST_TYPE;
  pv->v_name = vname(Anonymous_var);
  pv->v_number = p_number++;
  pv->v_link = pv_list;
  pv->old_var = pt->p_var;
  nt->p_var = pv_list = (struct term *)pv;
  nt->p_lists = targetobj;

  if ((EVAL_PST_FLAG == FALSE)) {
	struct logpair *mm;
        oldt->tag.t_arg[0] = (struct term *)nt;
	mm=(struct logpair *)alloc(2);	/* sizeof(logpair)=2 */
	mm->obj = oldt;
	mm->place = pl;
	PSTLISTS = Nclause((struct term *)mm,PSTLISTS,TEMPORAL);
	oldt = oldt->tag.t_arg[1];
	push_pstlog(pt,e0,oldt);
    return(oldt);
  }
/* else */
  push_pstlog(pt,e0,(struct term *)nt);
  return((struct term *)nt);
}


struct eclause *termset_pstobj(pobj,flag)
struct eclause *pobj;
int flag;
{
  if (pobj==(struct eclause *)NULL) return(pobj);
  else {
    struct eclause *nt = Npstobj(NIL,
    		   (struct pair *)NULL,
    		   termset_pstobj(pobj->c_link,flag),
    		   flag);
	nt->c_form = termset(pobj->c_form,&nt->c_form,pobj->c_env,flag);
   return(nt);
  }
}

struct eclause *termset_pstobj_sub(pobj,e,flag)
struct eclause *pobj;
struct pair *e;
int flag;
{
  struct eclause *pl, *ptop;

  if (pobj == (struct eclause *)NULL)
    return(pobj);
  ptop = pl = Npstobj(NIL, (struct pair *)NULL,(struct eclause *)NULL,flag);
  pl->c_form = termset(pobj->c_form,&pl->c_form,e,flag);
  while (pobj->c_link != (struct eclause *)NULL) {
    pl->c_link= Npstobj(NIL,(struct pair *)NULL,(struct eclause *)NULL,flag);
    pl->c_link->c_form =
      termset(pobj->c_link->c_form,&pl->c_link->c_form,e,flag);
    pobj = pobj->c_link;
    pl = pl->c_link;
  }
  return(ptop);
}

struct term *up_const(t,flag)
register struct term *t;
int flag;
{
  struct term *up_atomic(), *up_const_functor();

  switch ((int)t->type.ident) {
    case ATOMIC_TYPE:
      return(up_atomic(t,flag));
    case CONST_LIST_TYPE:
     return((struct term *)Nlist(up_const(head_of_list(t),flag),
			       (struct clause *)up_const((struct term *)tail_of_list(t),flag),
			       flag));
    default: /* functor */
      return(up_const_functor(t,flag));
    }
}

struct term *up_atomic(t,flag)
register struct term *t;
int flag;
{
  register struct term *tt;

  if (in_upper_heap(t,flag)) return(t);
  tt = Nterm(0,flag);
  tt->type.ident = t->type.ident;
  tt->t_arity = t->t_arity;
  if (is_int(t)) num_value(tt) = num_value(t);
  else if (! is_string(t)) num_value(tt) = num_value(t);
  else str_value(tt) = nalloc(str_value(t),flag);
  return(tt);
}

struct term *up_const_functor(t,flag)
register struct term *t;
int flag;
{
     register struct term *tt;
     register int i;

     i = -(int)(t->t_arity);
     if (i == 0) 	/* constant */
     {
       if (in_upper_heap(t,flag)) return(t);
       tt = Nterm(0,flag);
       Pred(tt) = Pred(t);
       return(tt);
     }
     tt = Nterm(i,flag);

     Pred(tt) = Pred(t);
     tt->t_arity = (long int)(-i);

     while (i > 0) {
	  i--;
          Arg(tt,i) = up_const(Arg(t,i),flag);
      }
     return(tt);
}

struct clause *up_eclause(ec,flag)
struct eclause *ec;
int flag;
{
  struct clause *c;
  if (ec == NULL) return(NULL);
  c = Nclause(NIL,up_eclause(ec->c_link,flag), flag);
  head_of_list(c)=termset(ec->c_form, NULL,ec->c_env,flag);
  return(c);
}

struct clause *up_itrace_clause(cl,anum)
struct clause *cl;
int anum;
{
  up_init(); EVAL_PST_FLAG = TRUE;
  cl = sort_clause((struct clause *)termset((struct term *)cl,NULL,Nenv(anum),ETERNAL));
  if (p_number != 0)
    renum_pvars((struct pstvar *)pv_list,v_number);
  return(cl);
}

void add_cs_to_set(cs,flag)
struct cset *cs;
int flag;
{
  register struct set *s;
  struct term *vsave = v_list;
  struct term *pvsave = pv_list;
  struct ustack *usave;
  struct pair *e, *esave;
  int vn = v_number;
  int pn = p_number;

  esave=ep; usave=usp;
  e = Nenv((int)cs->cs_anumber);

  up_init(); 	EVAL_PST_FLAG = TRUE;

#ifdef MAC
  s = (struct set *)salloc(5);	/* sizeof(set) = 5 */
#else
  s = snew(set);
#endif
  s->s_clause = (struct clause *)
    termset((struct term *)cs->cs_clause,NULL,e,ETERNAL);
  s->s_anumber = (unsigned short int)(v_number + p_number);
  s->s_vlist = v_list;
  s->s_link = NULL;
  s->s_constraint = NULL;
  s->s_bodynumber = 0;	/* set in add_set */
  if (p_number != 0)
    renum_pvars((struct pstvar *)pv_list,v_number);
  add_set(s,ASSERT_TOP);

  ep=esave; usp=usave;
  v_list = vsave;  v_number = vn;
  pv_list = pvsave; p_number = pn;
}

/* if c is occurred in the integrate trace (newf_list), return its solution */
/*	else return NULL 	*/
struct term *try_fold(c,vn,n)	/* occur check for CU (fold trasform) */
struct clause *c;		/* target clause */
int	vn,n;			/* vn : the number of vars contained in c */
				/* n : v_number + p_number */
{
  register struct itrace *it;
  struct ustack *usave;
  struct term *t;
  struct pair *e;
  struct pair *esave;
  int j, count;

  if (c == NULL) return(NULL);
  if (newf_list == NULL) return(NULL);

  c = sort_clause(c);
  count = literalnumber(c);  /* number of terms in c */
  usave = usp;
  esave = ep;
  e = Nenv(n);

  for (it = newf_list; it != NULL; it = it->it_link ) {
	if ((it->it_anumber == n) && (it->it_cnumber == count) ) 
		if (match(c, it->it_clause->c_link, e) == FALSE)
		{
		  undo(usave);
		  ep = esave;
		  continue;
		}
		 else{
		  if (it->it_clause->c_form == FAIL) {
			  undo(usave); ep = esave;
			  return(FAIL);
		  }
		  t = Nterm(vn,MEDIUM);
		  Pred(t) = Pred(it->it_clause->c_form);
		  for (j = 0; j < Pred(t)->f_arity ; j++) {
		    Arg(t,j) = e[vnumber(Arg(it->it_clause->c_form,j))].p_body;
			/* patch for PST var 1991-03-02 */
			if (Arg(t,j)==NULL) Arg(t,j)=Anonymous_var;
		  }
		  undo(usave); ep = esave;
		  return(t);	/*  found something  */
		}
  }
  return(NULL);
}

jmp_buf eqfail;		/* clause unification fail  */

int match(clo,clt,e)		/*  clause matcher  */
struct clause *clo,*clt;
struct pair *e;
{
	register struct clause *c1,*c2;

	for (c1 = clo,c2 = clt; c1 != NULL ; c1 = c1->c_link,c2 = c2->c_link)
		if (Pred(c1->c_form) != Pred(c2->c_form))
			return(FALSE); /* fail */

	if (setjmp(eqfail)) return(FALSE);	/* if match_term() fails */

	for (c1 = clo, c2 = clt; c1 != NULL; c1 = c1->c_link, c2 = c2->c_link)
		match_term(c1->c_form , c2->c_form , e);
	return(TRUE);		/* success */
}


void match_term(t1,t2,e)	/*  term unification (t1,e) = (t2,e) */
struct term *t1,*t2;
struct pair *e;			/*  return envs */
{
	register struct pair *p;

	if (isvar(t2)) {
		if (!isvar(t1)) longjmp(eqfail,1);
		p = &e[vnumber(t2)];
		if (p->p_body == NULL) {
			p->p_body = t1;
			return;
		}
		else if(p->p_body == t1) return;
		else longjmp(eqfail,1);
	}
	else if (isvar(t1)) longjmp(eqfail,1);

	if (Pred(t1) != Pred(t2)) longjmp(eqfail,1);
	switch ((int)t1->type.ident) {
	case ATOMIC_TYPE:
	  if ((t1==t2) ||(atomic_equal(t1,t2))) return;
	  else longjmp(eqfail,1);
	case LIST_TYPE:
	case CONST_LIST_TYPE:
	  match_term(head_of_list(t1),head_of_list(t2),e);
	  match_term(tail_of_list(t1),tail_of_list(t2),e);
	  return;
	case CLAUSE_TYPE:
	  while ((t1!=NULL) && (t2!=NULL)) {
	    match_term(head_of_list(t1),head_of_list(t2),e);
	    t1=tail_of_list(t1);
	    t2=tail_of_list(t2);
	  }
	  if (t1==t2) return;
	  else longjmp(eqfail,1);
	case PST_TYPE:
	  t1=(struct term *)((struct pst *)t1)->p_lists;
	  t2=(struct term *)((struct pst *)t2)->p_lists;
	case ECLAUSE_TYPE: /* pst_objects */
	  while ((t1!=NULL) && (t2!=NULL)) {
	    match_term(((struct eclause *)t1)->c_form,
		 ((struct eclause *)t2)->c_form,e);
	    t1=(struct term *)((struct eclause *)t1)->c_link;
	    t2=(struct term *)((struct eclause *)t2)->c_link;
	  }
	  if (t1==t2) return;
	  else longjmp(eqfail,1);
	default: {
	  register int i,j = (int)t1->t_arity;
	  if (j < 0) j = -j;
	  for(i = 0 ; i<j ; i++)
	    match_term(Arg(t1,i), Arg(t2,i), e);
	}
      }
}

/* constraint transformation entry <- resolve() */
struct eclause *transform(precond, newc, newenv)
struct eclause *precond;
struct clause *newc;
struct pair *newenv;
{
    struct eclause *eclause_append();
   	struct eclause *cond;
	struct clause *c,*clist;
	struct pair *env, *q;
#if CPUTIME != 0
	struct tms TIMES;
#elif MAC == 1
	long TIMES;
#elif MSDOS == 1
	unsigned long int TIMES;
#endif

	if (precond == NULL && newc == NULL) return(NULL);	

#if SUN4 == 1
	CONSTRAINT_OLD_TIME = clock();
#elif MAC == 1
	CONSTRAINT_OLD_TIME = TickCount();
#elif MSDOS == 1
	time(&TIMES);
	CONSTRAINT_OLD_TIME = TIMES;
#elif CPUTIME != 0
	times(&TIMES);
	CONSTRAINT_OLD_TIME =  TIMES.tms_stime + TIMES.tms_utime;
#endif
  cond = eclause_append(precond, reduce_clause(newc,newenv));
    if (cond == (struct eclause *)MFAIL) /* reduce_clause failure */
    {
	    TTB ttyprint0("fail (reducetion)"); TTE
	    return((struct eclause *)MFAIL);
    }
  env = Nenv(0);
  up_init(); /* EVAL_PST_FLAG = TRUE; */
  clist = up_eclause(cond,MEDIUM); /* set clause */
  clist = up_restore(clist,MEDIUM);
  if (p_number != 0) {
    renum_pvars((struct pstvar *)pv_list,v_number);
    q=Nenv(p_number);  /* 1991-03-10 */
  }

  if (clist == NULL) {
#if SUN4 == 1
	  CONSTRAINT_HANDLING_TIME += clock()-CONSTRAINT_OLD_TIME;
#elif MAC == 1
	TIMES = TickCount();
	CONSTRAINT_HANDLING_TIME += (TIMES-CONSTRAINT_OLD_TIME);
#elif MSDOS == 1
	time(&TIMES);
	CONSTRAINT_HANDLING_TIME += TIMES - CONSTRAINT_OLD_TIME;
#elif CPUTIME != 0
	  times(&TIMES);
	  CONSTRAINT_HANDLING_TIME += TIMES.tms_stime + TIMES.tms_utime -
	    CONSTRAINT_OLD_TIME;
#endif
	  return(NULL); /* no constraint */
	}
TTB
  { FILE *filep = wfp;
  ttyprint0(">>transform: ");
    wfp = stdout;
  Peclause(cond);
    wfp = filep;
  ttyprint0(" ==> "); Pterm(clist,(struct pair *)NULL);
  }
TTE

	c = startmodular(clist,v_list);

  if (c == MFAIL) {	/* constraint transformation failure */
TTB
  ttyprint0("fail");
TTE
#if SUN4 == 1
	  CONSTRAINT_HANDLING_TIME += clock()-CONSTRAINT_OLD_TIME;
#elif MAC == 1
	TIMES = TickCount();
	CONSTRAINT_HANDLING_TIME += TIMES-CONSTRAINT_OLD_TIME;
#elif MSDOS == 1
	time(&TIMES);
	CONSTRAINT_HANDLING_TIME += TIMES - CONSTRAINT_OLD_TIME;
#elif CPUTIME != 0
	  times(&TIMES);
	  CONSTRAINT_HANDLING_TIME += TIMES.tms_stime + TIMES.tms_utime -
	    CONSTRAINT_OLD_TIME;
#endif
 	return((struct eclause *)MFAIL);
  }

  cond = reduce_clause(c,env);
  if (cond == (struct eclause *)NULL) {
TTB	ttyprint0("null"); TTE
  }
  else if (cond == (struct eclause *)MFAIL)
  {
	  TTB ttyprint0("fail (reduction)"); TTE
  }
  else	{
	TTB { FILE *filep = wfp; wfp = stdout;
		Peclause(cond); wfp = filep; }
	TTE
  }
#if SUN4 == 1
    CONSTRAINT_HANDLING_TIME += clock()-CONSTRAINT_OLD_TIME;
#elif MAC == 1
	TIMES = TickCount();
	CONSTRAINT_HANDLING_TIME += TIMES-CONSTRAINT_OLD_TIME;
#elif MSDOS == 1
	time(&TIMES);
	CONSTRAINT_HANDLING_TIME += TIMES - CONSTRAINT_OLD_TIME;
#elif CPUTIME != 0
    times(&TIMES);
    CONSTRAINT_HANDLING_TIME += TIMES.tms_stime + TIMES.tms_utime -
      CONSTRAINT_OLD_TIME;
#endif
  return(cond);
}

struct eclause *eclause_append(head,tail)
register struct eclause *head, *tail;
{
  if (head == (struct eclause *)MFAIL || 
      tail == (struct eclause *)MFAIL) 
	  return((struct eclause *)MFAIL);
  while (head != (struct eclause *)NULL) {
    tail = Neclause(head->c_form,head->c_env,tail,TEMPORAL);
    head = head->c_link;
  }
  return(tail);
}

struct clause *remove_redundant_pst(pl)
struct clause *pl;
{
  struct logpair *m;
  struct term *t;

  while (pl != (struct clause *)NULL) {
  m = (struct logpair *)head_of_list(pl);
  t = m->obj;
  if ((m->place == NULL)|| (search_pstlog_mod(Arg2(t))==TRUE))
	return(Nclause(t,remove_redundant_pst(pl->c_link),TEMPORAL));
  *(m->place)=Arg1(t);
  pl=pl->c_link;
  }
  return(pl);
}

int search_pstlog_mod(p)	/* search (t,e) in UP_log */
struct term *p;
{
	register struct up_log *u;
	for (u = UP_pstlog; u != (struct up_log *)NULL; u = u->u_link)
		if (u->u_new == p) {
			if (u->u_count > 0L) return(TRUE);
			else return(FALSE);
		}
	return(FALSE);
}

struct term *subst_qnt_top(t,e,flag)
struct term *t;
struct pair *e;
int flag;
{
	UP_pstlog = (struct up_log *)NULL;
        return(subst_qnt(t,e,flag));
}

struct term *subst_qnt(t,e,flag)
register struct term *t;
register struct pair *e;
int flag;
{
	struct pair *p;
	int cc_flag_save = constant_check_flag;
	register struct term *nt = t;

	if (nt == NULL) return(nt);

        while (TRUE) {
            if (isvar(nt)) {
              if (is_voidvar(nt)) {
		   p=Anonymous_env; break; }
	      else if (! is_qntvar(nt))	t = nt;
              p = &e[vnumber(nt)];
              if(p->p_body == NULL) break;
	      nt = p->p_body;
              e = p->p_env;
             }
	    else { p = NULL; break; } }

	switch ((int)nt->type.ident) {
	case VAR_QNT_TYPE:
		if (is_qntvar(t)) {
			error("Constraint Transformation has troubles in QNT");
                      }
		return(t);
	case VAR_VOID_TYPE:
	case VAR_GLOBAL_TYPE:
		constant_check_flag =  NOT_CONSTANT_TERM;
	case ATOMIC_TYPE:
	case CONST_LIST_TYPE:
		return(nt);
	case CLAUSE_TYPE:
	return((struct term *)
		Nclause(subst_qnt(head_of_list(nt),e),
		(struct clause *)subst_qnt((struct term *)tail_of_list(nt),e),
		flag));
	case LIST_TYPE:
		constant_check_flag = CONSTANT_TERM;
		t = (struct term *)Nlist(
			subst_qnt(head_of_list(nt),e,flag),
			(struct clause *)NULL,flag);
		((struct clause *)t)->c_link = (struct clause *)
				subst_qnt((struct term *)tail_of_list(nt),e);
		if (constant_check_flag == CONSTANT_TERM) {
			t->type.ident = CONST_LIST_TYPE;
			constant_check_flag = cc_flag_save;
			}
		return(t);
	case PST_TYPE:
		constant_check_flag = NOT_CONSTANT_TERM;
		return(subst_qnt_pst(nt,e,flag));
	default:
		if (isconst_functor(nt)) return(nt);
		constant_check_flag = CONSTANT_TERM;
		t = Nterm((int)nt->t_arity,flag);
		t->type.t_func =nt->type.t_func;
		{
		register int i;
		for (i = 0; i < (int)nt->t_arity; i++)
			Arg(t,i) = subst_qnt(Arg(nt,i),e, flag);
		}
		if (constant_check_flag == CONSTANT_TERM) {
			t->t_arity = -t->t_arity;
			constant_check_flag = cc_flag_save;
		}
		return(t);
	}
}

struct term *subst_qnt_pst(pt,e,flag)
struct pst *pt;
struct pair *e;
int flag;
{
  struct pst_item *target;
  struct pst *nt;
  struct pstvar *pv;
  struct eclause *targetobj;
  struct pair *e0;
  struct term *oldt;

  if ((target = find_pstitem((struct term *)pt,e)) != (struct pst_item *)NULL)
  {
	e0 = (struct pair *)NULL;
	if ((oldt = search_pstlog((struct term *)pt,e0)) != NULL)
		return(oldt);
	targetobj = subst_qnt_pstobj(target->p_lists,flag);
  }
  else {
	e0 = e;
	if ((oldt = search_pstlog((struct term *)pt,e0)) != NULL)
		return(oldt);
	targetobj = subst_qnt_pstobj_sub(pt->p_lists,e,flag);
	}

 switch (flag) {
	case TEMPORAL:
		nt = (struct pst *)alloc(3);	/* sizeof(pst) = 3 */
		pv = (struct pstvar *)alloc(5);	/* sizeof(pstvar) = 5 */
		break;
	case MEDIUM:
		nt = (struct pst *)challoc(3);
		pv = (struct pstvar *)challoc(5);
		break;
	default:
		nt = (struct pst *)salloc(3);
		pv = (struct pstvar *)salloc(5);
	}

  nt->type = PST_TYPE;
  pv->v_type = VAR_PST_TYPE;
  pv->v_name = vname(Anonymous_var);
  pv->v_number = 0;
  pv->v_link = NULL;
  pv->old_var = NULL;
  nt->p_var = NULL;
  nt->p_lists = targetobj;

  push_pstlog(pt,e0,(struct term *)nt);
  return((struct term *)nt);
}


struct eclause *subst_qnt_pstobj(pobj,flag)
struct eclause *pobj;
int flag;
{
  if (pobj==(struct eclause *)NULL) return(pobj);
  else {
    struct eclause *nt = Npstobj(NIL,
    		   (struct pair *)NULL,
    		   subst_qnt_pstobj(pobj->c_link,flag),
    		   flag);
	nt->c_form = subst_qnt(pobj->c_form,pobj->c_env,flag);
   return(nt);
  }
}

struct eclause *subst_qnt_pstobj_sub(pobj,e,flag)
struct eclause *pobj;
struct pair *e;
int flag;
{
  struct eclause *pl, *ptop;

  if (pobj == (struct eclause *)NULL)
    return(pobj);
  ptop = pl = Npstobj(NIL, (struct pair *)NULL,(struct eclause *)NULL,flag);
  pl->c_form = subst_qnt(pobj->c_form,e,flag);
  while (pobj->c_link != (struct eclause *)NULL) {
    pl->c_link= Npstobj(NIL,(struct pair *)NULL,(struct eclause *)NULL,flag);
    pl->c_link->c_form =
      subst_qnt(pobj->c_link->c_form,e,flag);
    pobj = pobj->c_link;
    pl = pl->c_link;
  }
  return(ptop);
}
