/*
*
*		cu-Prolog (Constraint Unification Prolog)
*   Copyright: Institute for New Generation Computer Technology,Japan 1989
*		<<<< menu.c >>>>
*
*		menu command
*
*	92.02.28 ver 3.61
*/

#include "include.h"

void traceswitch () {
    if (Is_Normaltrace) {
	Notrace_mode;
	ttynl; ttyprint0 (" +++ normal trace off +++"); ttynl;
    }
    else {
	Normaltrace_mode;
	ttynl; ttyprint0 (" +++ normal trace on +++"); ttynl;
    }
}

void stepswitch () {
    if (Is_Steptrace) {
	Notrace_mode;
	ttynl; ttyprint0 (" +++ step trace off +++"); ttynl;
    }
    else {
	Steptrace_mode;
	ttynl; ttyprint0 (" +++ step trace on +++"); ttynl;
    }
}

int decode_pname(fname)		/* 'member/2' --> 'member', return 2 */
char *fname;
{
	for (; *fname != '\0'; fname++)
		if (*fname == '/') {
			*fname = '\0';
			return(atoi(fname + 1));
		}
	return(-1);
}

void spyswitch (fname)
char   *fname;
{
    struct func *f;
    int i,arity;

    if (strcmp (fname, "*") == 0) {
	ttyprint0 ("--- set all spy flag ---");
	ttynl;
	allspy(1);		/* set all spy flag */
	return;
    }
    if (strcmp (fname, ".") == 0) {
	ttyprint0 ("--- reset all spy flag ---");
	ttynl;
	allspy(0);		/* reset all spy flag */
	return;
    }
    if (strcmp (fname, "?") == 0) {/* list spyed predicates */
	ttyprint0 ("+++ list spyed predicates +++"); ttynl;
	for (i=0; i < HASH_SIZE; i++)
	  for (f = hash_list[i]; f != NULL; f = f -> f_link) {
	    if isspy(f) ttyprint2 ("%s(%u)  ", f -> f_name, f -> f_arity);
	}
	ttynl;
	return;
    }
    if (strcmp (fname, ">") == 0) /* spy fold/unfold */
    {
	    ttyprint0(" +++ ");
	    if  isspy(MODULAR_P) ttyprint0("no");
	    ttyprint0("spy fold/unfold transformation"); ttynl;
	    spychange(MODULAR_P);
	    return;
    }
    arity = decode_pname(fname);
    if (!exist_fname(fname))
    {
	    ttyprint1(" '%s' does not exist.", fname); ttynl;
	    return;
    }
    if (arity == -1)		/* spy switch fname/?? */
    {
	    for(f = hash_list[hash(fname)]; f != NULL; f = f->f_link)
		    if (streq(fname,f->f_name)) {
			    ttyprint0 ("+++ ");
			    if isspy(f) ttyprint0 ("no");
			    ttyprint2("spy %s/%d", f->f_name, f->f_arity); ttynl;
			    spychange(f);
		    }
    }
    else 
    {
	    f = funcsearch(fname, arity);
	    if (f != NULL) {
		    ttyprint0 (" +++");
		    if isspy(f) ttyprint0 ("no");
		    ttyprint2("spy %s/%d", f->f_name,f->f_arity); ttynl;
		    spychange(f);		/*  switch spy flag on/off */
	    }
	    else {
		ttyprint2(" '%s/%d' does not exist.", fname,arity);
		ttynl;
		}
    }
}

void allspy (n)	 /* if n == 1: set all spy flag, else resetall flag */
int     n;
{
    struct func *f;
    int i;

    if (n == 1)
    {
	    for (i = 0; i < HASH_SIZE; i++)
		    for (f = hash_list[i]; f != NULL; f = f -> f_link)
			    spyfun(f);
    }
    else
    {
	    for (i = 0; i < HASH_SIZE; i++)
		    for (f = hash_list[i]; f != NULL; f = f -> f_link)
			    nospyfun(f);
    }
}

void show_pred_roles(f)
struct func *f;
{
  int i, j, arity;

  for (i = j = 0, arity = (int)f->f_arity; arity > 0; i++, arity--) {
    if (i==INTEGER_SIZE) { j++; i = 0; }
    ttyprint1("%c",(f->f_roles[j] & (1 << i)) ? 'o' : 'x');
  }
}

/* the number of pred names printed in one line */
#define PRED_IN_LINE 5

void show_syspred_name()
{
	int i, j = 0;
	register struct func *f;

	ttyprint0("   +------<system>---------[ +:recursive, ^:functor ]--");
	ttynl;
	for (i = 0; i < HASH_SIZE; i++)	/* print system predicates */
	for (f = hash_list[i]; f != NULL; f = f -> f_link)
	    if issystem(f) {
	      ttyprint2 ("%s/%u", f -> f_name, f -> f_arity);
	      if isrecursive(f) ttyprint0 ("+");
	      if (f->def.f_sysfunc == NULL) ttyprint0("^");
	      ttyputc('\t');
	      if (++j >= PRED_IN_LINE) {j = 0; ttynl;}
	    };
	ttynl;
}

void show_userpred_name()
{
	int i, j = 0;
	register struct func *f;

	ttyprint0("   +-------<user>------");
	ttyprint0("--[ *:spy, -:reduced, +:recursive, #:new ]--"); ttynl;
	for (i = 0; i < HASH_SIZE; i++)	/* print user predicates */
		for (f = hash_list[i]; f != NULL; f = f -> f_link) {
/*			if (f->f_arity < 0) continue; */
			if (f->def.f_sysfunc == NULL) 
				continue;	/* cut constant. */
			if issystem(f) continue;
			ttyprint2 ("%s/%u", f -> f_name, f -> f_arity);
			if isspy(f) ttyprint0 ("*");
			if isreduced(f) ttyprint0 ("-");
			if isrecursive(f) ttyprint0 ("+");
			if isnewpred(f) ttyprint0("#");
			ttyputc('\t');
			if (++j >= PRED_IN_LINE) {j = 0; ttynl;}
		}
	ttynl;
}

void show_syspred_status(f)
struct func *f;
{
  ttyprint0("--<system>---[");
  show_pred_roles(f);
  ttyprint1("]--<%s>---+",
	  ((is_funcsys(f)) ? "functional" : "multi-valued"));
  ttynl;
}		
	
void show_pred_def(f)		/* show def of each pred */
struct func *f;
{
  void show_pred_roles();

	if (f->def.f_set == NULL) return; /* constant */
	ttyprint2 (" +----------( %s/%u )--------", f->f_name, f->f_arity);
	if issystem(f)
	{
		show_syspred_status(f);
		return;
	}
	if is_nofuncsys(f)
	{
		ttyprint0("--<system>---<multi-valued>-+"); ttynl;
		return;
	}
	if isspy(f) ttyprint0 ("-<spy>-");
	if isreduced(f) ttyprint0 ("-<reduced>-");
	if isrecursive(f) ttyprint0("-<recursive>-");
	if isnewpred(f) ttyprint0("-<new>-");
	ttyprint0("["); 
	if (f->f_mark & VACUITY_NOCHECK) { ttyprint0("-unchecked-"); }
          else show_pred_roles(f);
	ttyprint2("]--%d/%d---+",f->f_unitcount,f->f_setcount); ttynl;
	if (f -> f_integ != NULL) {
	    ttyprint0 ("<def> ");
	    P_dclause (f -> f_integ -> it_clause,(struct pair *)NULL);
	    ttynl; ttynl;
	}
	Showfunc(f);
}
	
void showdef (fname)		/* list definition   (%d command)   */
char   *fname;
{
    register struct func *f;
    int i,arity;

    check_recursion();
    if (streq(fname, "/")) {
	ttyprint0 (" +-- List all predicates ---+"); ttynl;
	for (i = 0; i < HASH_SIZE; i++)
		for (f = hash_list[i]; f != NULL; f = f -> f_link)
			Showfunc (f);
	return;
    }
    if (streq(fname, "*")){
	ttyprint0 (" +-- List predicates ---+") ttynl;
	for ( i=0; i < HASH_SIZE; i++)
	    for (f = hash_list[i]; f != NULL; f = f -> f_link) {
	    if isnoreduced(f) Showfunc (f);
	}
	return;
    }
    if (streq(fname, "?")){
	    show_syspred_name();
	    show_userpred_name();
	    return;
    }
    if (streq(fname, "-"))
    {
	    show_userpred_name();
	    return;
    }
    arity = decode_pname(fname);
    if (exist_fname(fname) == NULL) { 
	    ttyprint1 ("'%s' does not exist.", fname); ttynl;
	    return;
    }
    if (arity == -1)		/* show fname/?? */
    {
	    for (f =  hash_list[hash(fname)]; f != NULL; f = f->f_link)
		    if (streq(f->f_name,fname))
			    show_pred_def(f);
    }
    else
    {
	    f = funcsearch(fname,arity);
	    if (f != NULL)
		    show_pred_def(f);
	    else {
		ttyprint2("'%s/%d' does not exist.",fname,arity); ttynl;
		}
    }
}

void disp_func_def (f_from, f_to)/* show defs of f_from--->f_to  */
struct func *f_from,
           *f_to;
{
    if (f_from == NULL)
	return;
    if (f_from == f_to)
	return;
    disp_func_def (f_from -> f_link, f_to);
    if (isuser (f_from) && isnoreduced (f_from))
	Showfunc (f_from);
}

void set_inputfile (n)
char   *n;			/* file name */
{
    fp = fopen (n, "r");
    if (fp == NULL) {		/* open error */
	fp = stdin;
	ttyprint1 ("%s  ", n);
	error ("can't open !");
    }
    else {
      ttyprint1 ("=== open '%s'", n);
	ttynl;
    }
#ifdef MAC
	KEYIN = FALSE; SetCursor(&waitCursor);
#endif
  }

void readfile () {		/*  "file name" or "file name?"	 */
    int     i;

/*
#ifdef MAC
	if (KEYIN != TRUE)
		error ("file already opened");
#endif
*/
	adv();
    for (i = 0; ((cbuf != '"') && (cbuf != '?') && (cbuf != '\n')); next() )
		nbuf[i++] = cbuf;
    nbuf[i] = '\0';		/* n[] <- file name */
    if (cbuf == '?')
	ECHO_BACK = TRUE;		/* echo back on */
    SKIPLINE;
    line_counter=1;
	upush(&fp);
	utop = usp;
    set_inputfile (nbuf);	/* set file pointer */
#ifndef MAC
    if (ECHO_BACK == TRUE)    wfp = stdout;	/* echo back on */
#endif
}


void set_eof () {		/* file EOF */

	clearerr(fp);	/* clear eof */
#ifdef MAC
	if ((KEYIN != TRUE) && (fp != stdin)) fclose(fp);
#else
/* from keyboard */
	if (! (tty && KEYIN)){	/* EOF (^D in UNIX)  */
		fclose (fp);
	}
	if (wfp == NULL)
		wfp = stdout;		/* echo back on */
#endif
	if (utop != &ustack[0]) {
		utop -= 1;
		undo(utop);
#ifdef MAC
    if (fp == stdin) KEYIN = TRUE;
#endif
	}
	else {
#ifdef MAC
		KEYIN = KEYOUT = TRUE;
#else
		fp = stdin;
		ttynl; ttyprint0 (" ****** end of file *******"); ttynl;
#endif
	}
	ECHO_BACK = FALSE;
}

#ifndef MAC
void increase_area(str)
char *str;
{
  int size;
  static char *workname[4]={"Work","Heap","Stack","Env"},
	  *emsg = "Eroor:use ---%%I {c,h,u,e}/<number>\n";;

  size = decode_pname(str);
  if (size < 0) {
	ttyprint0(emsg);
        return;
      }
  size *= 1000;
  switch(*str) {
  case 'c':
  case 'C':
    cfree((char *)cheap);
    size += CHEAPTOP-cheap;
    cheap = (long int *)calloc(size,sizeof(long int));
    CHEAPTOP = &cheap[size];
    Cheap_Max=cheap;
    str=workname[0];
   break;
  case 'u':
  case 'U':
    cfree((char *)ustack);
    size += STACKTOP-ustack;
    ustack = (struct ustack *)calloc(size,sizeof(struct ustack));
    STACKTOP = &ustack[size];
    Stack_Max = ustack;
    str=workname[2];
    break;
  case 'h':
  case 'H':
    cfree((char *)heap);
    size += HEAPTOP - heap;
    heap = (long int *)calloc(size,sizeof(long int));
    HEAPTOP = &heap[size];
    Heap_Max = heap;
    str=workname[1];
    break;
  case 'E':
  case 'e':
    cfree((char *)eheap);
    size += ESPTOP-eheap;
    eheap = (struct pair *)calloc(size,sizeof(struct pair));
    ESPTOP = &eheap[size];
    Esp_Max = eheap;
    str=workname[3];
    break;
  default:
	ttyprint0(emsg);
    return;
  }
  ttyprint2("The size of %s is now %dK\n",str,(int)(size/1000));
}
#endif
