/*
*
*		cu-Prolog (Constraint Unification Prolog)
*   Copyright: Institute for New Generation Computer Technology,Japan 1989
*
*		<<<<<< main.c >>>>>
*
*	88.11.23 Ver.2.00	OS command 
*	88.11.25 Garbage Collection, save status(Ver.2.01)
*       89.6.29 support cpu-time, CAHC, constraint term (Ver.2.2)
*	90.4.1 rewrite refute, syspred (ver.3.0) 
*	90.7.1  support operator (ver.3.10)
*	90.12.11 support Partially Specified Term (ver 3.20)
*	91. 5.22 MacCup 0.1 version
*/

#define	 MAIN	1

#include "include.h"
#include <signal.h>
#include <ctype.h>
#include "cupsize.h"

#ifdef MAC
#define COPYRIGHT "sirai@sccs.chukyo-u.ac.jp"
#define VERSION "0.8.0d"
#else
#define COPYRIGHT "Institute for New Generation Computer Technology, \
 Japan 1989-93\nin Cooperation with SIRAI@sccs.chukyo-u.ac.jp"
#define VERSION	"3.80d"
#endif

#ifdef MAC
/* ------------------------------------------------------------ */
/* for Macintosh */
#define SYSTEM_OFFSET	200000L

#include "macconst.h"
#define NextTRUE	3	/* for Reader Control */

SetUpFiles()
{
	pStrCopy("\p", theFileName);
	theVRefNum = 0;
}

SetUpMenus()
{
	int		i;
	
	myMenus[appleM] = NewMenu( appleID, "\p\024" );
	AppendMenu( myMenus[appleM], "\pAbout MacCup;-");
	AddResMenu( myMenus[appleM], 'DRVR' );
	myMenus[fileM] = GetMenu(fileID);
	myMenus[editM] = GetMenu(editID);
	myMenus[commM] = GetMenu(commID);
	myMenus[traceM] = GetMenu(traceID);
	myMenus[modeM] = GetMenu(modeID);
	myMenus[fontM] = NewMenu(fontID,"\pFont");
	AddResMenu( myMenus[fontM], 'FONT');
	myMenus[sizeM] = GetMenu(sizeID);
	for ( (i=appleM); (i<=sizeM); i++ ) InsertMenu(myMenus[i], 0) ;
	DrawMenuBar();
}

SetUpCursors()
{
	CursHandle	hCurs;

	hCurs = GetCursor(1);
	editCursor = **hCurs;
	hCurs = GetCursor(watchCursor);
	waitCursor = **hCurs;
}

SetUpWindows()
{
	Rect	destRect, viewRect;
	Rect	vScrollRect;
	FontInfo	myInfo;
	int		height,h,w;

	SetPort((myWindow = GetNewWindow( windowID, &wRecord, (WindowPtr)-1)));
	w=screenBits.bounds.right-15;
	h=screenBits.bounds.bottom-40;	/* addjust the window size */
	SizeWindow(myWindow, w,h, TRUE);
	TextFont(font_type);
	TextSize(font_size);
	vScrollRect = (*myWindow).portRect;
	vScrollRect.left = vScrollRect.right-15;
	vScrollRect.right += 1;
	vScrollRect.bottom -= 14;
	vScrollRect.top -= 1;
	vScroll = NewControl( myWindow, &vScrollRect, "\p", 1, 0, 0, 0,
		scrollBarProc, 0L);

	viewRect = thePort->portRect;
	viewRect.right -= SBarWidth;
	viewRect.bottom -= SBarWidth;
	InsetRect(&viewRect, 4, 4);
	TEH = TENew( &viewRect, &viewRect );
	SetView(thePort);
}

void ClosePointers()
{
	DisposPtr((Ptr)nheap);
	DisposPtr((Ptr)heap);
	DisposPtr((Ptr)eheap);
	DisposPtr((Ptr)cheap);
	DisposPtr((Ptr)sheap);
	DisposPtr((Ptr)ustack);
}

/* ------------------------------------------------------------ */

void main()
{
	void prolog_top(),load_initfile();
	long s,u;

	InitGraf(&thePort);
	InitFonts();
	FlushEvents( everyEvent, 0 );
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(0L);
	InitCursor();

	SetUpFiles();
	SetUpCursors();
	SetUpMenus();
	SetUpWindows();

	MaxMem(&u);
	s = 1 * NAME_SIZE + 		/* sizeof(char) = 1 */
		4 * SHEAP_SIZE +	/* sizeof(long int) = 4 */
		4 * CHEAP_SIZE +
		8 * USTACK_SIZE +	/* sizeof(struct ustack) = 8 */
		8 * ESP_SIZE +		/* sizeof(struct pair) = 8 */
		4 * HEAP_SIZE;
	u = ((u - s - SYSTEM_OFFSET)/400)*4; /* for memory expansion */

	s = (long)NAME_SIZE+NAME_INC*u;
	nheap = (char *)NewPtr(s);
	NHEAPTOP = &nheap[s];
	s = (4L) * SHEAP_SIZE+SHEAP_INC*u; /* sizeof(long int) = 4 */
	sheap = (long int *)NewPtr(s);
	SHEAPTOP = &sheap[s/4];
	s = (4L) * CHEAP_SIZE+CHEAP_INC*u; /* sizeof(long int) = 4 */
	cheap = (long int *)NewPtr(s);
	CHEAPTOP = &cheap[s/4];
	s = (8L) * USTACK_SIZE+USTACK_INC*u; /* sizeof(struct ustack)=8 */
	ustack = (struct ustack *)NewPtr(s);
	STACKTOP = &ustack[s/8];
	s = (8L) * ESP_SIZE+ESP_INC*u;	/* sizeof(struct pair) = 8 */
	eheap = (struct pair *)NewPtr(s);
	ESPTOP = &eheap[s/8];
	s = (4L) * HEAP_SIZE+HEAP_INC*u; /* sizeof(long int) = 4 */
	heap = (long int *)NewPtr(s);
	HEAPTOP = &heap[s/4];

	if (((long int)sheap == 0) || (nheap >= NHEAPTOP) ||
		((long int)eheap ==0) || (sheap >= SHEAPTOP) ||
		((long int)ustack == 0) || (cheap >= CHEAPTOP) ||
		((long int)nheap == 0) || (eheap >= ESPTOP) ||
		(heap >= HEAPTOP) || ((long int)heap == 0) ||
		((long int)cheap == 0)) {
			ParamText("\pOut of Memory", "\p","\p", "\p");
			Alert( ErrorAlert, 0L );
			CloseMyWindow();
			ExitToShell();			/* end */
			}

	lfp = 0;
#else
int compute_value(argc,argv)
int argc;
char *argv[];
{
	if ((argc > 0) && ismydigit(*argv))
		return(atoi(*argv)*1000);
        else return(0);
}

void main(argc,argv)
int argc;
char *argv[];
{
  int i,compute_value();
  void on_interrupt(), prolog_top(),load_initfile();
        {
	  int nh=NAME_SIZE, sh=SHEAP_SIZE, ch=CHEAP_SIZE,
		 eh=ESP_SIZE, hh=HEAP_SIZE, uh=USTACK_SIZE;
	  char *option;
	  argc--; argv++;
	  while ((argc > 0) && (*argv[0] == '-')) {
		option = argv[0];
		argc--; argv++;
		switch (*(++option)) {
		case 'n':
		case 'N':
			i=compute_value(argc,argv);
			if (i > 0) nh=i;
			break;
		case 'h':
		case 'H':
			i=compute_value(argc,argv);
			if (i > 0) hh=i;
			break;
		case 's':
		case 'S':
			i=compute_value(argc,argv);
			if (i > 0) sh=i;
			break;
		case 'u':
		case 'U':
			i=compute_value(argc,argv);
			if (i > 0) uh=i;
			break;
		case 'e':
		case 'E':
			i=compute_value(argc,argv);
			if (i > 0) eh=i;
			break;
		case 'c':
		case 'C':
			i=compute_value(argc,argv);
			if (i > 0) ch=i;
			break;
                case '?':
		default:
		fprintf(stderr,"Usage:cup [-s <n>] [-h <n>] [-c <n>] ");
		fprintf(stderr,"[-e <n>] [-u <n>] [-n <n>] [file]\n");
		fprintf(stderr,"s : sheap, h : heap, c : const/pst, ");
		fprintf(stderr,"e : env., u : ustack, n : name/strings\n");
			fprintf(stderr,"Default: s=%d, h=%d, c=%d, ",
		(int)(SHEAP_SIZE / 1000), (int)(HEAP_SIZE / 1000), (int)(CHEAP_SIZE / 1000));
			fprintf(stderr,"e=%d, u=%d, n=%d\n",
		(int)(ESP_SIZE / 1000), (int)(USTACK_SIZE / 1000),(int)(NAME_SIZE / 1000));
			exit(2);
		}
		argc--; argv++;
	  }
	nheap = (char *)malloc(nh);
	NHEAPTOP = &nheap[nh];
	sheap = (long int *)calloc(sh,sizeof(long int));
	SHEAPTOP = &sheap[sh];
	cheap = (long int *)calloc(ch,sizeof(long int));
	CHEAPTOP = &cheap[ch];
	ustack = (struct ustack *)calloc(uh,sizeof(struct ustack));
	STACKTOP = &ustack[uh];
	eheap = (struct pair *)calloc(eh,sizeof(struct pair));
	ESPTOP = &eheap[eh];
	heap = (long int *)calloc(hh,sizeof(long int));
	HEAPTOP = &heap[hh];
        }
	if ((nheap == (char *)NULL) || (sheap == (long int *)NULL) ||
	(cheap == (long int *)NULL) || (ustack == (struct ustack *)NULL) ||
	(eheap == (struct pair *)NULL) || (heap == (long int *)NULL)) {
		free_memory();
		fprintf(stderr,">>> Memory Allocation Error\n");
		exit(1);
	}

#endif
	{int i;
	for (i = 0; i < FOPEN_MAX; OPEN_FILES[i++] = (FILE *)NULL);
			/* initialize openfiles table */
	}
	prepare();		/* set flag   etc. */
	load_initfile();	/* load initialization file */

#ifndef MAC
	if (argc > 0) {
		if ((fp = fopen(*argv,"r")) == NULL)  {
			printf(">>>  %s : can't open \n",*argv);
			fp = stdin;
		}
		else {
			printf(">>> open %s \n",*argv);
			settimer();
		}
	}
	else fp = stdin;	/* standard input */

	signal(SIGINT, on_interrupt);
#endif
	setjmp(reset); NL;
	setjmp(unbreak_reset);
#ifdef MAC
	KEYIN = KEYOUT = TRUE;
	ibufpt = ibuf;
	*ibuf = '\0';
#endif
	while(1){
		prolog_top();
	}
}

/* read the initialization file */
void load_initfile()
{
		struct ustack *uspsave = utop;
		usp = utop;

		upush(&fp);
		utop = usp;

#ifdef MAC
		strcpy(nbuf,"cup.ini");		
#elif  MSDOS == 1
		strcpy(nbuf,"cup.ini");
#else
		strcpy(nbuf,getenv("HOME"));
		strcat(nbuf,"/.cuprc");
#endif

		if (setjmp(reset)) {
			ttyprint0("Error occurs in loading Initialization file");
			ttynl;
			return;
		}

		if ((fp = fopen(nbuf,"r"))!=NULL) {
#ifdef MAC
			KEYIN = FALSE;
#endif		
			while (uspsave < usp) {
				prolog_top();
			}
		}
		else {
			ttyprint1("There is no initialization file '%s'",nbuf);
			ttynl;
			undo(uspsave);
			utop=usp;
		}
	}


void prolog_top()
{
		f_list = NULL;
		usp = utop;
		chp = cheap; /* save constraints heap pointer */
		hp = heap; /* save user heap pointer */
		ep = eheap;  /* save user stack pointer */
		newflist_save = newf_list; /* save old c.t. trace */
		psttable->p_link = (struct pst_item *)NULL;

		prolog_execution();
}

int ismydigit(c)
register char *c;
{
	 while( *c!='\0' )
		if (! isdigit(*c++)) return(FALSE);
	 return(TRUE);
}

void error(s)
char *s;
{
 int garbage_flag = FALSE;

#ifdef MAC
	char em[255];

	if (KEYIN==UP) FSClose(refNum);
	else if (KEYIN==FALSE) set_eof();

	KEYIN = KEYOUT = TRUE;

	strcpy(em,s);
	CtoPstr(em);
	ParamText(em,"\p\0","\p\0","\p\0");
	Alert( ErrorAlert,0L);
	*ibufpt='\0';

	if ((long)shp >= (long)SHEAPTOP - 100) {
			ParamText("\pNo more space","\pPlease RESET or QUIT",
				"\p", "\p");
			Alert( ErrorAlert, 0L );
		}

#else
	is_user_input = FALSE;

	reset_oldpred_flag();	/* in case of reconsult */
	if ((wfp != stdout) && (wfp != stderr)) {
		if (wfp != (FILE *)NULL) fclose(wfp);	/* in %w command */
		wfp = stderr;
	}
#endif

	if (fp != stdin) {
#ifndef MAC
		ttyprint0(nbuf);
		ttynl;
#endif
	  if (fp != (FILE *)NULL) {
		fclose(fp);
		{
			int i;
			for(i=0; i<FOPEN_MAX; i++) {
				if (OPEN_FILES[i]==fp) {
					OPEN_FILES[i] = (FILE *)NULL;
					break;
				}
			}
		}
		strcpy(SEEING_FILE, STANDARD_INPUT);
		}
	  ttynl; ttyprint0("**** error in reading file ****"); ttynl;
	}
#ifndef MAC
	tprint1("\n%s\n",s);

	if ((shp -sheap) >= ((SHEAPTOP - sheap) * 0.99)) {
          garbage_flag = TRUE;
	  garbagecollect();
              }
#endif
	while (utop != &ustack[0]) {
	  if (fp != stdin) fclose(fp);
	  utop -= 1;
	  undo(utop);
	}

	wfp = stdout;
        if (! garbage_flag) fp = stdin;
	if (timer_switch) { printtime(); NL;}	/* print execution time */
	newf_list = newflist_save;  /* c.t. trace */
        longjmp(reset, 1); /* in main() */
}

void prolog_execution()
{
#ifdef MAC
	if ((KEYIN==TRUE) || (KEYIN==NextTRUE))
		putcursor();
#else
	if(tty && KEYIN) putcursor();		/* print cursor */
#endif
	advance;		/* read next one char into cbuf */

	switch (cbuf) {
	  case '"': {	/* read file */
	    advance;
	    if (timer_switch) settimer();	/* set timer */
	    readfile();
	    break;
	  }
	  case EOF: {	/* file end */
	    set_eof();
	    line_counter=0;
	    if (timer_switch) printtime();	/* print execution time */
	    break;
	  }
	  case '%': {		/* flag statement */
	    next();
	    systemcommand(cbuf);
	    break;
	  }
#ifndef MAC
	  case '#': {	/* os command interpreter */
	    advance;
	    oscommand();
	    break;
	  }
#endif
	  case ':':
	  case '?': {	/*  question clause */
	    check_recursion();
	    questionclause();
	    break;
	  }
	  case '@':{		/* modularize clause */
	    advance;
	    check_recursion();
	    trans_routine();
	    break;
	  }
	  case '$':	 /* define new predicate */
	    advance;
	    defnewfunc();
	    break;
	  case '.':
	    SKIPLINE;
	    break;
	  default :
	    defclause(); /* definition clause */
	  }
}

#ifndef MAC
void on_interrupt()
{
  fprintf(stderr,"\nInterrupt --- Input <T(race),C(ontinue),A(bort)>? ");
  while (1) {
	switch (getchar()) {
	case 'T':
	case 't':
/*		allspy(1);	*/
		Steptrace_mode;
		if (! isspy(MODULAR_P)) spychange(MODULAR_P);
	case 'C':
	case 'c':
		return;
	case 'A':
	case 'a':
		error("\nExecution Aborted\n");
	}
  }
}
#endif

void error_detail(t,e,s)
struct term *t;
struct pair *e;
char *s;
{
#ifndef MAC
	if ((wfp != stdout) && (wfp != stderr)) fclose(wfp);
	wfp = stderr;
#endif
	Pterm(t,e);
	error(s);
}

void prepare()			/*  system preparation */
{
#ifdef MAC
	KEYIN = KEYOUT = TRUE;
	ibufpt = ibuf;
	*ibuf = '\0';
#else
    tty = isatty(0);
	lfp = NULL;			/* no log file  */
	if (READ_FILE != stdin) {
		fclose(READ_FILE);
		READ_FILE = stdin;
	}
	if (WRITE_FILE != stdout) {
		fclose(WRITE_FILE);
		WRITE_FILE = stdout;
	}
#endif
	fp = stdin;
	wfp = stdout;			/* with echo back */
	init_heap_max();
	init_status();
	ECHO_BACK = FALSE;
	is_user_input = FALSE;

#ifdef MAC
	psttable = (struct pst_item *)salloc(3);
#else
	psttable = snew(pst_item);
#endif
	timer_switch = TRUE;
	simplify_flag = TRUE;
	strcpy(user_prompt,"? ");
	GENSYM = 0;
	open_title();			/* opening title	*/
}

void open_title()		/* opening title */
{
#ifdef MAC
	ttyprint1("\r\r*****  MacCup  Ver. %s  *****\r",VERSION);
#else
	ttyprint1("\n\n\t*****  CUP   Ver. %s  *****\n",VERSION);
#endif
	ttyprint1("\t%s mode",(Is_Msolvable ? "M-solvable" : "All Modular"));
	ttyprint0("\t(help ->  %%h)"); ttynl; ttynl;
#ifdef MAC
	ShowSelect();
#endif
}

void init_status()		/* initialize global vars */
{
	int i;
	FILE *filep;

	Msolvable_mode;		/* solution flag */
	Notrace_mode;		/* trace flag */
	refute_node_count = -1;	/* refute node counter*/
	MODULARMAX = Modmax_def;
	Refcount = REFMAX;
#ifdef MAC
	EnableItem(myMenus[modeM],msolveComm);
	DisableItem(myMenus[modeM],modularComm);
	EnableItem(myMenus[traceM],stepComm);
	EnableItem(myMenus[traceM],traceComm);
	DisableItem(myMenus[traceM],traceOffComm);
#endif

	f_list = NULL;
	newf_list = NULL;
	o_list = NULL;
	shp = sheap;
    nhp = nheap;
	utop = ustack;
	line_counter=0;
/* initialize openfiles table */
	for (i = 0; i < FOPEN_MAX; i++) {
		filep = OPEN_FILES[i];
		if ((filep != stdin) && (filep != stdout) && (filep != (FILE *)NULL))
				fclose(filep);
		OPEN_FILES[i] = (FILE *)NULL;
	}
        for(i = 0; i < HASH_SIZE; hash_list[i++] = NULL)
		;		/* initialize hash table */
	strcpy(SEEING_FILE, STANDARD_INPUT);
	strcpy(TELLING_FILE, STANDARD_OUTPUT);
	init_syspred();			/* initialize system predicates */
}

void print_constant()		/* print constant list */
{
	struct func *f;
	int i;

	for (i = 0; i < HASH_SIZE; i++)
		for (f = hash_list[i]; f != NULL; f = f->f_link)
		if (f->f_arity == 0L)
			ttyprint2("%s/%x  ",f->f_name,f);
	ttynl;
}

void systemcommand(c)   /*  % command */
int c;
{
  void print_constant();
#ifndef MAC
  void increase_area();
#endif

  switch(c)
	{
        case 'C':		/* change cat() functor */
		set_category();
		break;
        case 'D':	/* maximum of print depth */
		readword(nbuf);
		Print_Depth = atoi(nbuf);
		break;
#ifndef MAC
	case 'G':		/* garbage collection */
		garbagecollect();
		return;
	case 'i':
	case 'I':	/* increase working area */
		readword(nbuf);
		increase_area(nbuf);
		break;
#endif
	case 'H':		/* for debug */
		print_hash_table();
				break;
	case 'L': 		/*  list trace definition */
		ttynl;
		ttyprint0(" +-- List new predicate --<vars, terms>--+");
		ttynl;
		Shownewfunc();
		break;
	case 'M':	/* maximum of variables in transformation */
		readword(nbuf);
		MODULARMAX = atoi(nbuf);
		if (MODULARMAX < 0)
		  MODULARMAX = Modmax_def;
		break;
	case 'B':
	case 'b':
		longjmp(unbreak_reset,1);
	case 'P':		/* Preprocess Constraints */
		readword(nbuf);
		preprocess_constraints(nbuf);
		break;
	case 'Q':		/* QUIT cu-prolog */
		quit_prolog();
		return;
        case 'R': /* system reset */
		ttyprint0("System initialized"); ttynl;
		prepare();
		break;
        case 'S':
                simplify_flag = (simplify_flag) ? FALSE : TRUE;
                ttyprint1("\tSimplifier is now %s",
			(simplify_flag) ? "ON" : "OFF");          
		ttynl;
                break;
	case 'T':
		timer_switch=  (timer_switch) ? FALSE : TRUE;
		ttyprint1("\tTimer is now %s",
			(timer_switch) ? "ON" : "OFF");
		ttynl;
		break;
	case 'X':		/* print constant (for debug) */
		ttyprint0("+++++ print constants +++++"); ttynl;
		print_constant();
		break;
#ifndef MAC
	case 'Y':		/* edit predicates (for debug) */
		ttyprint0("+++++ edit predicates +++++\n");
		edit_predicate();
		break;
#endif
 	case 'a': 			/*   all modular mode   */
		ttynl; ttyprint0("  ___ all modular mode  ___"); ttynl;
		Modular_mode;
		break;
	case 'c':		/* maximum of refute counter	*/
		readword(nbuf);
		Refcount = atoi(nbuf);
		if (Refcount <= 0) Refcount = REFMAX; /* default */
		break;
	case 'd':	 		/*  list definition */
		readword(nbuf);
		showdef(nbuf);
		break;
	case 'f':			/*  free space  */
		ttyprint0("show the status of memory allocation"); ttynl;
		freeheap();
		break;
	case 'h':			/*  help menu */
		ttyprint1("** %% command menu  ver.%s ****",VERSION);
		ttyprint0(" (prompt _:normal, $:trace, >:step)"); ttynl;
		helpmenu();
		break;
	case 'l':			/*  log file */
#ifdef MAC
		loghandle();
#else
		readword(nbuf);
		loghandle(nbuf);
#endif
		break;
	case 'n':		/* change genfunc name */
		readword(genname);
		break;
	case 'o': 	 		/*   M-Solvable mode  */
		ttynl; ttyprint0("  ___ M-solvable mode ___"); ttynl;
		Msolvable_mode;
		break;
	case 'p':			/*  set/reset spy flag */
		readword(nbuf);
		spyswitch(nbuf);
		break;
	case 's':			/*  step trace on/off */
		stepswitch();
		break;
	case 't': 			/*  trace on */
		traceswitch();
		break;
	case 'u': /* undefined predicate handling */
		Handle_Undefined = (Handle_Undefined == TRUE) ?
		  FALSE : TRUE;
		ttyprint1("Undefined Predicates causes %s",
			((Handle_Undefined == TRUE) ? "ERROR" : "FAIL"));
		ttynl; break;
	case 'w':			/*  write file */
		save_program();
		break;
	default:		/* else */
		break;
	}
	SKIPLINE;		/* skip one line */
}

#ifndef MAC
void garbagecollect()		/* garbage collection */
{
  int sh;
	if (fp != stdin) fclose(fp);
	if ((wfp != stdout) && (wfp != stderr)) fclose(wfp);
	ttyprint0("====== Garbage Collection ======\n");
	strcpy(nbuf, "TEMPF.###");		/* temporary file */
	delete_tmp();			/* delete old temp file */
	ttyprint0("--->");
	filewrite(nbuf);	/* save program to nbuf */

        cfree((char *)sheap);
        sh = SHEAPTOP-sheap + 200000;
	sheap = (long int *)calloc(sh,sizeof(long int));
	SHEAPTOP = &sheap[sh];
        free(nheap);
        sh = NHEAPTOP-nheap + 50000;
	nheap = (char *)malloc(sh);
	NHEAPTOP = &nheap[sh];

	init_status();
	ttyprint0("--->");
	set_inputfile(nbuf);
	/* wfp = NULL; no echo back */
}

void edit_predicate()		/* edit predicate */
{
	ttyprint0("++++++++ Garbage Collection +++++++++\n");
	strcpy(nbuf, "TEMPF.prd");		/* temporary file */
	system("rm -f TEMPF.prd");       	/* delete old temp file */
	ttyprint0("++++++++ Step 1: write file \n");
	filewrite(nbuf);	/* save program */
/*	pop_status();	*/ /* initialize shp, f_list, etc. */
	system("$EDITOR TEMPF.prd"); /* edit */
	ttyprint0("++++++++ Step 2: read file \n");
	set_inputfile(nbuf);
}
#endif

void trans_routine()	/* modular translation routine (@ C1,C2,...,Cn.) */
{
	register struct term *t;
	struct clause *c;

	if (Is_Steptrace && isspy(MODULAR_P)) CTstep;
	else if (Is_Normaltrace && isspy(MODULAR_P)) CTnormal;
	else CTnotrace;
	v_number = 0; v_list = NULL;
	p_number = 0; pv_list = NULL;
	reread = FALSE;

	t = Rterm(1000,TEMPORAL);          /* read constraints */
	if (tokentype != FULLSTOP) error("Syntax error --- . missing");
	SKIPLINE;
	ttynl;

	if (timer_switch) settimer();	/* set timer */
	if (is_clause(t))
		c = (struct clause *)t;
	else 
		c = Nclause(t, (struct clause *)NULL, TEMPORAL);
	modular(c);
#ifndef MAC
	if (fp == stdin)
#endif
	if (timer_switch) { ttynl; printtime();}	/* print execution time */
        undo(utop);	/* pop user stack  ( u : static var ) */
}


void questionclause()	/*  ?-g1,g2,...gm;c1,c2...cn.	*/
{
  register struct term *q;
  struct eclause *co;
  struct pair *e;
  struct node *Last_Node, *Initial_Goal;
  struct term *initial_vlist;
  struct clause *c;
  int Status, refute();

  if (Is_Steptrace && isspy(MODULAR_P)) CTstep;
  else if (Is_Normaltrace && isspy(MODULAR_P)) CTnormal;
  else CTnotrace;

  v_number = 0;	v_list = NULL;
  p_number = 0; pv_list = NULL;

  reread = FALSE;
  q  = Rterm(1200,TEMPORAL);	        /* read goal */
  if (tokentype!=FULLSTOP) {
  	if (line_counter) {
  		sprintf(nbuf,"Line # %d: Syntax error --- . expected\0",line_counter);
  		error(nbuf);
  		}
  	else error("Syntax error --- . expected");
  	}

#ifdef MAC
	if ((KEYIN != TRUE) || (*ibufpt != '\0'))
#endif
		SKIPLINE;		/* skip CR */
  
  renum_pvars((struct pstvar *)pv_list,v_number);
  e = Nenv(v_number+p_number);	/* initial environments */

  if (timer_switch) settimer();

  if ((Pred(q) == CONSTRAINT_P) || (Pred(q) == CONSTRAINT2_P)) {
    c = (is_clause(Arg2(q))) ? (struct clause *)Arg2(q) :
      Nclause(Arg2(q),(struct clause *)NULL,TEMPORAL);
    co = transform((struct eclause *)NULL,c,e);
    if (co == (struct eclause *)MFAIL)
    {
      ttyprint0("no (unsatisfied constraints)"); ttynl;
#ifndef MAC
	if (fp == stdin)
#endif
	if (timer_switch) {ttynl; printtime();}
      refute_node_count = -1;
      undo(utop);
      return;
    }
    q = Arg1(q);
  }
  else {
     co = (struct eclause *)NULL;
  }

  if ((Pred(q) != QUERY1_P) && (Pred(q) != QUERY2_P))
    error("Syntax error --- Query Predicate was expected");
  f_list = NULL;		/* temp. pred list */
  c = (is_clause(Arg1(q))) ? (struct clause *)Arg1(q) :
      Nclause(Arg1(q),(struct clause *)NULL,TEMPORAL);
  Initial_Goal = Last_Node 
    = Newnode(c,co,e,(struct node *)NULL,(struct node *)NULL);
  Last_BT = NULL; Last_SKIP = NULL;
  Status = DOWN;
  initial_vlist = v_list;

  /* refutation */
  while (1) {
    if (refute(Initial_Goal,Last_Node,Status) == FALSE)
      { ttyprint0("no."); ttynl; break; }
    else if (initial_vlist == NULL) { ttyprint0("true."); break; }
    else
#ifndef MAC
	if ((fp != stdin) ||
             (Panswer(Initial_Goal,initial_vlist) == FALSE)) break;
#else
	if (Panswer(Initial_Goal,initial_vlist) == FALSE) break;
#endif

    Status = BACKTRACK;
    Last_BT = Last_Node = backtrack_node(Last_BT);
  }
#ifndef MAC
	if (fp == stdin)
#endif
	if (timer_switch) { ttynl; printtime(); }
  ttynl;
  refute_node_count = -1;	/* refute node counter */
#ifdef MAC
	ShowSelect();
#endif
  undo(utop);		/* pop user stack ( u : static var ) */
}


void defclause()	/* definition clause read & set */
{
  register struct term *t;
  register struct clause *c, *cstr;

  v_number = 0; v_list = NULL;
  p_number = 0; pv_list = NULL;

  reread = FALSE;
  t = Rterm(1200,STINGY);
  if (tokentype == EOF_MARK) {
  	set_eof();
  	return;
  }
  else if (tokentype != FULLSTOP) {
	wfp = stderr; Pterm(t,(struct pair *)NULL);
 	if (line_counter) {
  		sprintf(nbuf,"Line # %d: Syntax error --- . expected\0",line_counter);
  		error(nbuf);
  		}
  	else error("Syntax error --- . was expected");
	}
  SKIPLINE;
  if (isvar(t)) {
  	if (line_counter) {
  		sprintf(nbuf,"Line # %d: Variables cannot be asserted\0",line_counter);
  		error(nbuf);
  		}
  	else error("Syntax error --- Variables cannot be asserted");
  	}
  rename_var_names((struct var *)v_list); /* STINGY -> ETERNAL */
  if (Pred(t) == Pred(END_OF_FILE)) {
  	set_eof();
  	return;
  }
  if ((Pred(t) == CONSTRAINT_P) || (Pred(t) == CONSTRAINT2_P)) {
    cstr = (is_clause(Arg2(t))) ? (struct clause *)Arg2(t) :
           Nclause(Arg2(t),(struct clause *)NULL,ETERNAL);
    t = Arg1(t);
  }
  else  cstr = NULL;
  if (Pred(t) == DEF_P) {
    if (isvar(Arg1(t))) {
    	if (line_counter) {
    		sprintf(nbuf,"Line # %d: Variables cannot be asserted\0",line_counter);
    		error_detail(t,(struct pair *)NULL,nbuf);
    		}
      else error_detail(t,(struct pair *)NULL,
		"Syntax error --- Variables cannot be asserted");
    }
    if (is_clause(Arg2(t)))
      c = Nclause(Arg1(t),(struct clause *)Arg2(t),ETERNAL);
    else
      c = Nclause(Arg1(t), 
		  Nclause(Arg2(t),(struct clause *)NULL,ETERNAL), ETERNAL);
  }
  else if (is_functor(t))
    c = Nclause(t,(struct clause *)NULL,ETERNAL);
  else error("Illegal definition");

  if (p_number != 0) {
    renum_pvars((struct pstvar *)pv_list,v_number);
  }
  index_set(c, cstr, ASSERT_NEW);
}

void rename_var_names(v)
struct var *v;
{
  while (v != (struct var *)NULL) {
    truncate_varname(v->v_name,nbuf);
    v->v_name = nalloc(nbuf,ETERNAL);
    v = v->v_link;
  }
}

void truncate_varname(n,nbuf)
char n[], nbuf[];
{
  register int i = 0;
  while ((n[i] != '\0') && (i < 7)) {
    if (n[i] == '_') break;
    nbuf[i] = n[i];
    i++;
  }
  nbuf[i] = '\0';
}

void renum_pvars(pvs,vnum)
struct pstvar *pvs;
int vnum;
{
  while (pvs != (struct pstvar *)NULL) {
    pvs->v_number += (long int)vnum;
    pvs = (struct pstvar *)pvs->v_link;
   }
}

void defnewfunc()	/* definition clause read & set */
{
  register struct term *t;
  register struct itrace *it;
  struct clause *c;

  v_number = 0; v_list = NULL;
  p_number = 0; pv_list = NULL;

  reread = FALSE;
  t = Rterm(1200,STINGY);
  if (tokentype != FULLSTOP) error("Syntax error --- . was expected");
  SKIPLINE;
  if (Pred(t) != EQSIGN_P) error("Illegal itrace definition");

  rename_var_names((struct var *)v_list); /* STINGY -> ETERNAL */  

  c =  (is_clause(Arg2(t))) ? (struct clause *)Arg2(t) :
  Nclause(Arg2(t),(struct clause *)NULL,ETERNAL);

#ifdef MAC
  it = (struct itrace *)salloc(3);
#else
  it = snew(itrace);
#endif
  it->it_clause = Nclause(Arg1(t),c,ETERNAL);
  it->it_anumber = v_number+p_number;
  it->it_cnumber = literalnumber(c);
  it->it_link = newf_list;
  newf_list = it;
  Pred(Arg1(t))->f_integ = it;
}
