/*
*
*		cu-Prolog (Constraint Unification Prolog)
*   Copyright: Institute for New Generation Computer Technology,Japan 1989
*			<< include.h >>
*     (define structures, macros, etc)
*
*88/11/23	for Ver.2.00
*89/6/15-27     support CAHC
*89.6.20 dubug timer
*90.4.1 ver.3.0
*90.7.1 ver.3.10 support operator
*90.12.10 ver.3.20 support pst
*90.5.1  ver. MacV3 for Macintosh
*/

#include <stdio.h>
#include <math.h>
#include <string.h>

/*	CPUTIME : print CPU time for UNIX 4.2 BSD
*	if your system is Macintosh		#defime MAC 1
*	else if your system is SUN4		#define SUN4 1
*	else if UNIX system with times()	#define CPUTIME 60
*	otherwise it should be MSDOS		#define MSDOS 1
*/

#define SUN4 1

#ifdef MAC
/* ------------------------------------------------------------------ */
/* for Macintosh */
/* if you want a Japanese version of MacCup
 * Japanese OS takes Oosaka font as default
 */
#include <unix.h>
#include <QuickDraw.h>
#include <Types.h>
#include <Fonts.h>
#include <Windows.h>
#include <Menus.h>
#include <TextEdit.h>
#include <Dialogs.h>
#include <Events.h>
#include <Desk.h>
#include <Files.h>
#include <ToolUtils.h>
#include <Controls.h>
#include <StandardFile.h>
#include <PrintTraps.h>

#define SBarWidth	15

#define topMargin 20
#define leftMargin 20
#define bottomMargin 20

#define INTEGER_SIZE 16

/* Tee print macro */
#define ttyputc(X)	{ TEKey(X,TEH);\
  if (lfp) {wbuf[0]=X; wbuf[1]='\0'; WriteFile(lfp,wbuf,1L); } }
#define ttyprint0(X)	{ sprintf(wbuf,X);  TEInsert(wbuf,strlen(wbuf),TEH);\
			if (lfp)  WriteFile(lfp,wbuf,(long)strlen(wbuf)); }
#define ttyprint1(X,V)	{ sprintf(wbuf,X,V); TEInsert(wbuf,strlen(wbuf),TEH);\
		if (lfp)  WriteFile(lfp,wbuf,(long)strlen(wbuf)); }
#define ttyprint2(X,V1,V2) { sprintf(wbuf,X,V1,V2);\
		TEInsert(wbuf,strlen(wbuf),TEH);\
		if (lfp)  WriteFile(lfp,wbuf,(long)strlen(wbuf)); }
#define ttyprint3(X,V1,V2,V3) { sprintf(wbuf,X,V1,V2,V3);\
		if (KEYOUT==TRUE) TEInsert(wbuf,strlen(wbuf),TEH); \
		if (lfp)  WriteFile(lfp,wbuf,(long)strlen(wbuf)); }
#define ttynl	 { TEKey('\r',TEH); ShowSelect();\
	if (lfp) {wbuf[0]='\r'; wbuf[1]='\0'; WriteFile(lfp,wbuf,1L);} }

#define tputc(X)	{ switch (KEYOUT) {\
	case FALSE: putc(X,wfp); break;\
	case TRUE: TEKey(X,TEH);\
	default: if (lfp) {wbuf[0]=X; wbuf[1]='\0'; WriteFile(lfp,wbuf,1L); } } }
#define tprint0(X)	{ if (KEYOUT==FALSE) fprintf(wfp,X);\
	else  { sprintf(wbuf,X);\
			if (KEYOUT==TRUE) TEInsert(wbuf,strlen(wbuf),TEH); \
			if (lfp)  WriteFile(lfp,wbuf,(long)strlen(wbuf)); } }
#define tprint1(X,V) { if (KEYOUT==FALSE) fprintf(wfp,X,V);\
	else  { sprintf(wbuf,X,V);\
		if (KEYOUT==TRUE) TEInsert(wbuf,strlen(wbuf),TEH); \
		if (lfp)  WriteFile(lfp,wbuf,(long)strlen(wbuf)); } }
#define tprint2(X,V1,V2) {  if (KEYOUT==FALSE) fprintf(wfp,X,V1,V2);\
	else { sprintf(wbuf,X,V1,V2);\
		if (KEYOUT==TRUE) TEInsert(wbuf,strlen(wbuf),TEH);\
		if (lfp)  WriteFile(lfp,wbuf,(long)strlen(wbuf)); }}
#define tprint3(X,V1,V2,V3) { if (KEYOUT==FALSE) fprintf(wfp,X,V1,V2,V3);\
	else { sprintf(wbuf,X,V1,V2,V3);\
		if (KEYOUT==TRUE) TEInsert(wbuf,strlen(wbuf),TEH); \
		if (lfp)  WriteFile(lfp,wbuf,(long)strlen(wbuf)); } }
#define tprint4(X,V1,V2,V3,V4)	{if (KEYOUT==FALSE) fprintf(wfp,X,V1,V2,V3,V4);\
	else { sprintf(wbuf,X,V1,V2,V3,V4);\
		if (KEYOUT==TRUE)  TEInsert(wbuf,strlen(wbuf),TEH); \
		if (lfp)  WriteFile(lfp,wbuf,(long)strlen(wbuf)); } }

#define NL	\
	{ switch (KEYOUT) {\
	case FALSE: putc('\r',wfp); break;\
	case TRUE: TEKey('\r',TEH); ShowSelect();\
	default: if (lfp) {wbuf[0]='\r'; wbuf[1]='\0'; WriteFile(lfp,wbuf,1L);} } }

#define SKIPLINE skipline()

#else
/* ------------------------------------------------------------ */
/* for UNIX machine */
#define INTEGER_SIZE 32

#define is_readable(FP) (FP->_flag & _IOREAD)
#define is_writable(FP) (FP->_flag & _IOWRT)

/* Tee print macro */
#define ttyputc(X)	{ putchar(X); if (lfp) putc(X,lfp);}
#define ttyprint0(X)	{ printf(X); if (lfp) fprintf(lfp,X);}
#define ttyprint1(X,V)	{ printf(X,V); if (lfp) fprintf(lfp,X,V);}
#define ttyprint2(X,V1,V2)\
       	{ printf(X,V1,V2);	if (lfp) fprintf(lfp,X,V1,V2);}
#define ttyprint3(X,V1,V2,V3) \
	{ printf(X,V1,V2,V3); if (lfp) fprintf(lfp,X,V1,V2,V3);}
#define ttynl		{ putchar('\n');  if (lfp) putc('\n',lfp); }

#define tputc(X)	{if (wfp) putc(X,wfp);if (lfp) putc(X,lfp);}
#define tprint0(X)	{if (wfp) fprintf(wfp,X);if (lfp) fprintf(lfp,X);}
#define tprint1(X,V)	{if (wfp) fprintf(wfp,X,V);if (lfp) fprintf(lfp,X,V);}
#define tprint2(X,V1,V2)       	{if (wfp) fprintf(wfp,X,V1,V2);\
			 	if (lfp) fprintf(lfp,X,V1,V2);}
#define tprint3(X,V1,V2,V3)	{if (wfp) fprintf(wfp,X,V1,V2,V3);\
				if (lfp) fprintf(lfp,X,V1,V2,V3);}
#define tprint4(X,V1,V2,V3,V4)	{if (wfp) fprintf(wfp,X,V1,V2,V3,V4);\
				if (lfp) fprintf(lfp,X,V1,V2,V3,V4);}
#define NL		tputc('\n')

#define readword(S)	fscanf(fp,"%s",S);if (lfp) fprintf(lfp,"%s",S);
#define skipline	while (cbuf != '\n') next()
#define KEYIN		(fp == stdin)

#define SKIPLINE	skipline
#endif
/* ------------------------------------------------------------ */

#define advance         (next(), adv())

/* string equal */
#define streq(p,q)      (*(p) == *(q) && strcmp(p,q) == 0)

/* type of token */
#define NAME           0 
#define NUMBER         1
#define STRING         2
#define FILE_TYPE      3
#define VARNAME        4
#define BRACKET        5   /* ()[]| */
#define COMMA          6   /* , */
#define FULLSTOP       7   /* . */
#define CONST_MARK     8   /* ; */
#define EOF_MARK	   9

/* VT-100 Escape Sequence */
#define C_HIGHLIGHT "\033[01m"
#define C_UNDER   "\033[04m"
#define C_BLINK   "\033[05m"
#define C_REVERSE   "\033[07m"
#define C_NORMAL    "\033[0m"
#define C_SAVE	"\033[s"
#define C_LOAD	"\033[u"
#define C_CLS	"\033[2J"

/* storage type */
#define TEMPORAL      0
#define MEDIUM        1
#define ETERNAL       2
#define STINGY        3

/* flag for checking constant term used in Rterm and termset */
#define CONSTANT_TERM  1
#define NOT_CONSTANT_TERM 0

/* discrimination of term */
#define VAR_VOID_TYPE   1
#define VAR_QNT_TYPE  2
#define VAR_PST_TYPE  3
#define VAR_GLOBAL_TYPE 4
#define ATOMIC_TYPE     5
#define PST_TYPE        6
#define PST_ITEM_TYPE   7
#define CLAUSE_TYPE     8
#define ECLAUSE_TYPE    9
#define LIST_TYPE       10
#define CONST_LIST_TYPE 11

struct term {			/* atomic formula (literal) */
        union {
            unsigned long int ident;	/* type identifier */
            struct func *t_func;	/* pointer to functor(predicate) */
          } type;
	long int t_arity;		/* arity. when < 0 complex const  */
        union {
          struct term *t_arg[1];	/* args */
          float n_value;
          char *s_value;
	  long int f_value;
        } tag;
};

#define FLOAT_NUM   0
#define INT_NUM     1
/* #define STRING      2 */
#define FILE_POINTER 3

 /* num,string,file */
#define is_atomic(Term)   (Term->type.ident == (long int)ATOMIC_TYPE)

#define is_num(Term)      (is_atomic(Term) && (Term->t_arity <= (long int)INT_NUM))
#define is_string(Term)   (is_atomic(Term) && (Term->t_arity == (long int)STRING))
#define is_int(Term)      (is_atomic(Term) && (Term->t_arity == (long int)INT_NUM))
#define is_file(Term)     (is_atomic(Term) && (Term->t_arity == (long int)FILE_POINTER))
#define is_pst(Term)	  ((Term)->type.ident == (long int)PST_TYPE)
#define is_pstitem(Term)  ((Term)->type.ident == (long int)PST_ITEM_TYPE)
#define is_list(Term)     (((Term)->type.ident == (long int)LIST_TYPE)||\
			   ((Term)->type.ident == (long int)CONST_LIST_TYPE))
#define is_clause(Term)   ((Term)->type.ident == (long int)CLAUSE_TYPE)
#define is_eclause(Term)   ((Term)->type.ident == (long int)ECLAUSE_TYPE)
#define fnum_value(Term)	((Term)->tag.f_value)

#define num_value(Term)   ((Term)->tag.n_value)
#define str_value(Term)   ((Term)->tag.s_value)
#define filep_value(Term) OPEN_FILES[(int)((Term)->tag.f_value)]
#define head_of_list(Term) (((struct clause *)Term)->c_form)
#define tail_of_list(Term) ((struct term *)((struct clause *)Term)->c_link)

#define is_functor(Term) ((Term)->type.ident > (long int)CONST_LIST_TYPE)
#define isconst_functor(Term)  ((Term)->t_arity <= 0L)  
#define isconst(Term)   (is_atomic(Term) || \
			 (is_functor(Term) && (isconst_functor(Term))))
#define notconst(Term)  (isvar(Term) || \
			 ((! is_atomic(Term)) && (Term->t_arity > 0L)))
#define isatom(Term)    (is_atomic(Term) || (Term->t_arity == 0L))

#define Arg(T,N)   (T)->tag.t_arg[N] /* N+1 th argument of term T */
#define Arg1(T)    Arg(T,0)
#define Arg2(T)    Arg(T,1)
#define Arg3(T)    Arg(T,2)
#define Pred(T)    (T)->type.t_func  /* predicate symbol */
#define Predname(T)    (T)->type.t_func->f_name  /* predicate symbol name */

#ifdef MAC
#define FLT_EPSILON	1.19209E-7
#elif SUN4 == 1
#define FLT_EPSILON	1.19209290E-07
#else
#define FLT_EPSILON	2e-07
#endif

#define atomic_equal(u,t) \
	(is_atomic(t) && (t->t_arity == u->t_arity) &&\
	 ( (is_int(t) && ((int)num_value(t) == (int)num_value(u))) || \
	   (is_num(t) && \
	     ((float)fabs(num_value(t)-num_value(u)) \
	      <= FLT_EPSILON*fabs(num_value(t)))) ||\
	   (is_string(t) && (strcmp(str_value(t),str_value(u)) == 0)) ||\
		(is_file(t) && (filep_value(t) == filep_value(u)))))

struct var {
        unsigned long int v_type;		/*  v_type = VAR_TYPE */
        long int v_number;
	char *v_name;
        struct var *v_link;
	struct clause *v_constraint; /* constraint of CAHC */
	short int v_head_occur;	/* var occurrence in head */
	short int v_occurrence;	/* var occurrence */
};

#define isvar(t)     ( ((struct var *)t)->v_type <= (long int)VAR_GLOBAL_TYPE \
		      && ((struct var *)t)->v_type >= (long int)VAR_VOID_TYPE )
#define novar(Term)   (is_atomic(Term) ||\
			 (Term->type.ident == (long int)CONST_LIST_TYPE) ||\
			 ((! isvar(Term)) && (Term->t_arity <= 0L)))
#define is_voidvar(t)   (((struct var *)t)->v_type == (long int)VAR_VOID_TYPE)
#define is_qntvar(t)	(((struct var *)t)->v_type == (long int)VAR_QNT_TYPE)
#define vname(t)        (((struct var *)t)->v_name)
#define vnumber(t)	((long int)(((struct var *)t)->v_number))
#define voccurrence(t)   (((struct var *)t)->v_occurrence)
#define vheadoccurrence(t)   (((struct var *)t)->v_head_occur)
#define vincriment(t)   ((struct var *)t)->v_occurrence++ 
#define vconstraint(t)        (((struct var *)t)->v_constraint)
#define vlink(t)        ((struct term *)(((struct var *)t)->v_link))

typedef int (*SYSFUNC)();	/* for system predicate */

struct func {			/* predicate (functor) */
        unsigned short int f_arity, f_number, f_mark;
	unsigned short int f_setcount;	/* number of definitions */
        char *f_name;
        union {
          struct set *f_set;	/* definition clauses */
          SYSFUNC f_sysfunc;   /* system function */
        } def;
        struct func *f_link;	
	struct itrace *f_integ;	/* integrate() history  */
	long int f_unitcount;	/* number of unit defs */
	unsigned int f_roles[1];	/* bit patterns for vacuity check */
};

/* for index_set */
#define ASSERT_TOP	1
#define ASSERT_LAST	2
#define ASSERT_NEW	3

/*  predicate(functor) type definition  */
#define USERFUN         0       /*  user function, default value */
#define	SYSFUN		1	/*  system pred */
#define SPYFUN		2       /*  spy fun. or not */
#define REDUCEDFUN	4       /*  reduced fun. or not	*/
#define FINITEFUN	8	/*  finete fun. or not */
#define TEMPFUN        16       /*  temporary func */
#define NEWPRED        32	/*  new predicate */
#define NONFUNC        64	/*  non-functional (many solutions) */
#define TYPE1SYS        9	/*  system (functional) pred */
#define TYPE1SYS_REDUCED 13 /* reduced # of arguments system pred */
#define TYPE2SYS       65	/*  system (non-functional) pred */
#define TYPE2SYS_REDUCED 69 /* reduced # of arguments system non-functional */
#define SIMPLIFIED  128
#define VACUITY_NOCHECK 512     /*  vacuity non check flag */
#define RECONSULT_CHECK 1024	/* reconsult check flag */

/* #define	systemfun(F)	(F->f_mark) != SYSFUN
#define userfun(F)	(F->f_mark) &= (^SYSFUN)  */

#define issystem(F)	( ((F->f_mark) & SYSFUN) != 0 )
#define isuser(F)	( ((F->f_mark) & SYSFUN) == 0 )
#define isnonfunc(F)	( ((F->f_mark) & NONFUNC) != 0 )

#define isfunc(F)	( ((F->f_mark) & NONFUNC) == 0 )
#define is_funcsys(F)   (issystem(F) && isfunc(F))
#define is_nofuncsys(F) (issystem(F) && isnonfunc(F))
#define spyfun(F)	(F->f_mark) |= SPYFUN
#define nospyfun(F)	(F->f_mark) &= (~SPYFUN)
#define spychange(F)	(F->f_mark) ^= SPYFUN
#define isspy(F)	( ((F->f_mark) & SPYFUN) != 0 )
#define isnospy(F)	( ((F->f_mark) & SPYFUN) == 0 )
#define reducedfun(F)	(F->f_mark) |= REDUCEDFUN
#define isreduced(F)	( ((F->f_mark) & REDUCEDFUN) != 0)
#define isnoreduced(F)	( ((F->f_mark) & REDUCEDFUN) == 0)
#define finitefun(F)	(F->f_mark) |= FINITEFUN
#define recursivefun(F)	(F->f_mark) &= (~FINITEFUN)
#define isfinite(F)	( ((F->f_mark) & FINITEFUN) != 0)
#define isrecursive(F)	( ((F->f_mark) & FINITEFUN) == 0)
#define newpred(F)	(F->f_mark) |= NEWPRED
#define isnewpred(F)	( ((F->f_mark) & NEWPRED) != 0)
#define isnotnewpred(F)	( ((F->f_mark) & FINITEFUN) == 0)
#define isallunit(F)    (F->f_setcount == F->f_unitcount)
#define isnot_simplified(F)  (((F->f_mark) & SIMPLIFIED) == 0)
#define set_simplified(F)  ((F->f_mark) |= SIMPLIFIED)
#define set_oldpred(F) ((F->f_mark) |= RECONSULT_CHECK)
#define is_oldpred(F)  ((F->f_mark) & RECONSULT_CHECK)
#define reset_oldpred(F) ((F->f_mark) &= (~RECONSULT_CHECK))

/* type of operator */
#define PREFIX  0100
#define POSTFIX 0200
#define INFIX   0300

struct operator {
  struct func *o_func;
  short int o_prec; /* precedence of operator 0-1200 */
  short int o_type; /* type of operator: xf,yf,fx,fy,xfy,yfx,xfx */
     /*   bit pattern of o_type is: PREFIX=0100, POSTFIX=0200, INFIX=0300,
	  leftdown = 0010, rifgtdown = 0001
          xf -- 0210, yf -- 0200, fx -- 0101, fy -- 0100,
	  xfy -- 0310, yfx -- 0301, xfx -- 0311 */
  struct operator *o_link;  /* link to another operator */
};

struct clause {			/* sequence of atomic formula */
        unsigned long int c_type; /* CLAUSE_TYPE or LIST_TYPE */
        struct term *c_form;	/* atomic formula */
        struct clause *c_link;
};

struct set {			/* definition horn clause */
        unsigned short int s_anumber;
	unsigned short int s_bodynumber;	/* number of body literals */
        struct clause *s_clause; /* Horn clause */
        struct set *s_link;
	struct term *s_vlist;
	struct clause *s_constraint; /* constraint clause */
};

struct cset{			/* clause stack */
	struct clause *cs_clause;
        struct term *cs_vlist;
	unsigned short int cs_anumber;	/* v_number + p_number */
	unsigned short int cs_status;   /* 0: not unfolded	1: unfolded */
	unsigned short int cs_cnum; /* the number of literals in the body */
        unsigned short int cs_number;	/* set number */
/*	long int cs_satisfiable;*/	/* satisfiability */
	struct cset *cs_link;
};

#define is_unitclause(Set)  (Set->s_bodynumber == 0)
/* dummy definition (for non-functional system predicate) */
#define DUMMY_DEF (struct set *)1

struct pair {				/* environment for SS */
        struct term *p_body;	/* term */
        struct pair *p_env;	/* environment */
};

struct ustack {			/* user stack */
        long int *u_addr;		/* address */
        long int u_val;		/* content */
};

struct node {			/* node for Prolog refutation */
        struct clause *n_clause; /* goal */
        struct pair *n_env;	/* variable environment */
        struct set *n_set;	/* OR-program clauses */
        struct node *n_link, *n_last;
	struct eclause *n_constraint; /* constraint of CAHC */
	unsigned short int n_count, n_spy, n_tmp, n_scount;
	long int *n_hp;
	struct pair *n_ep;
        struct ustack *n_usp;
};

struct eclause {	/*  environment + clause(copy) */
        unsigned long int c_type;
	struct term	*c_form;	/* atomic formula */
	struct eclause	*c_link;	/* equiv eclause link */
	struct pair	*c_env;		/* formular environment */
};

struct itrace{		/* integrate trace */
	unsigned short int it_anumber, it_cnumber; /* #of var,literals (key) */
	struct clause	*it_clause; /* Horn clause (history) */
	struct itrace	*it_link;
};

struct pst {		/* Partial Specified Term */
	unsigned long int type;	/* PST_TYPE */
	struct term *p_var; /* var comes here */
	struct eclause *p_lists; /* property lists */
	};

struct pstvar {
        unsigned long int v_type;		/*  v_type = VAR_PST_TYPE */
        long int v_number;
	char *v_name;
        struct term *v_link;
	struct term *old_var;
};

struct pst_item {
	struct pair *p_var;  /* PST var */
	struct eclause *p_lists; /* property lists */
	struct pst_item *p_link; /* link to other items */
      };

struct up_log
{
	struct term *u_old, *u_new;
	struct pair *u_oldenv;
	struct up_log *u_link;
	long int u_count;
};

struct logpair {
	struct term *obj;
	struct term **place;
};

#define Npstobj(Head,Env,Tail,Flag)  Neclause(Head,Env,Tail,Flag)

/*  if (t,e) is var ,then p != NULL, else p == NULL  */
/*  t,p,e must be variables !!!!  */
#define down(p, t, e)\
        while(1){ \
            if(isvar(t)) {\
              if (is_voidvar(t)) {\
		   p=Anonymous_env; break; }\
		   if (e == (struct pair *)NULL) break;\
              p = &e[vnumber(t)];\
              if(p->p_body == NULL) break;\
	      t = p->p_body;\
              e = p->p_env;\
             }\
	    else { p = NULL; break; } }

/* various modes of cu-Prolog */
#define Notrace_mode      tflag = 0
#define Normaltrace_mode  tflag = 1
#define Steptrace_mode    tflag = 2
#define Leap_mode	  tflag = 3
#define Is_Notrace        (tflag == 0)
#define Is_Normaltrace    (tflag == 1)
#define Is_Steptrace    (tflag == 2)
#define Is_Leap		(tflag == 3)
#define Is_Trace        (tflag != 0)
#define Msolvable_mode sflag = 0
#define Modular_mode   sflag = 1
#define Is_Msolvable     (sflag == 0)
#define Is_Modular     (sflag == 1)

#define Is_ctnotrace (CTmode == 0)
#define Is_ctnormal (CTmode == 1)
#define Is_ctstep (CTmode == 2)
#define CTnotrace CTmode = 0
#define CTnormal CTmode = 1
#define CTstep CTmode = 2
/* c.t. trace(normal, step) begin&end */
#define TTB   if (CTmode != 0){
#define TTE   TE
/* c.t. step trace begin&end */
#define TSTB  if Is_ctstep {
#define TSTE  TE	
/* c.t. normal trace begin&end */
#define TNTB  if Is_ctnormal {
#define TNTE  TE	


/* trace begin & end */
#define TB		if (Is_Trace) {
#define STB(F)		if (Is_Trace && isspy(F) ) {
#define TE		NL; }
#define STE             TE

/* modularize fail */
/* #define MFAIL		(struct clause *)1 */

/* return value of the execution of system predicate */
#define SYSFAIL 0		/*	system pred. fail	*/
#define	SYSTRUE	1		/*	system pred. success 	*/
#define SUSPEND 2

#define TRUE 1
#define FALSE 0

/* refutation search staus flag  used in syspred.c, refute.c */
#define DOWN 1 
#define UP   2
#define BACKTRACK 3

/* predicate symbol hash table size */
#define HASH_SIZE 253

#define NAME_MAX  256		/* size of name buffer */
#define REFMAX  10000		/* refutation max (Refcount) default */
#define Modmax_def  50	/* modularize max (MODULAR_MAX) default */

/* struct allocation macro   s:struct name */
#ifndef MAC
#define snew(s)     (struct s *)salloc(sizeof (struct s) / sizeof (long int))
#define cnew(s)     (struct s *)challoc(sizeof (struct s) / sizeof (long int))
#define new(s)      (struct s *)alloc(sizeof (struct s) / sizeof (long int))

#define MEMORY_ALLOC(X,Y,F) \
        switch (F) { \
	    case TEMPORAL: \
	      X=new(Y); break;\
	    case MEDIUM: \
	      X=cnew(Y); break; \
	    default:\
	      X=snew(Y); }
#else
#define MEMORY_ALLOC(X,Y,F,Z) \
	switch (F) { \
	case TEMPORAL: \
	  X = (struct Y *)alloc(Z); break;\
	case MEDIUM: \
	  X = (struct Y *)challoc(Z); break;\
	default: \
	  X = (struct Y *)salloc(Z); break; }
#endif

#define in_sheap(X) (( &sheap[0] <= ((long int *)X)) && \
			(((long int *)X) < shp))

/*   the maximum number of variables   */
#define VMAX 30

/* maximum number of  open files */
#ifndef FOPEN_MAX
#define FOPEN_MAX	20
#endif

#ifndef FILENAME_MAX
#define FILENAME_MAX  256
#endif
/****************  global functions  *************/
#include "funclist.h"

/****************  global vars  ******************/
#if	MAIN == 1
#include "varset.h"
#else
#include "globalv.h"
#endif

/***************  system predicate  *************/
#if	SYSPRED == 1
#include "syspdef.h"
#else
#include "sysp.h"
#endif

/***************  heap, stack  ******************/
#if	NEW == 1
	long int *sheap;	/* system heap */
	long int *shp;
	long int *heap;	/* user heap */
	long int *hp;
	long int *cheap;  /* constraints/pst heap */
	long int *chp;
	struct pair *eheap;  /* environment heap */
	struct pair *ep;						  
	struct ustack *ustack;	/* user stack */
	struct ustack *usp;
	char *nheap;   /* name string heap */
	char *nhp;
	struct func *hash_list[HASH_SIZE]; /* predicate hash table */
#else
	extern long int *sheap, *shp;		/* system heap */
	extern long int *heap, *hp;			/* local heap */
	extern long int *cheap, *chp;               /* constrains heap */
	extern struct pair *eheap, *ep;
	extern struct ustack *ustack, *usp;	/* user stack */
	extern char *nheap, *nhp;
	extern struct func *hash_list[];
#endif
