%
% XWIP debugging functions
%

qconn(C) :-
	xQueryConnection(C, [xNetworkDescriptor(A00),
			     xProtocolVersion(A01),
			     xProtocolRevision(A02),
			     xServerVendor(A03),
			     xImageByteOrder(A04),
			     xImageUnit(A05),
			     xImagePad(A06),
			     xImageBitOrder(A07),
			     xVendorRelease(A08),
			     xQueueLength(A09),
			     xLastEvent(A10),
			     xLastRequest(A11),
			     xConnectionName(A12),
			     xMotionBuffer(A16),
			     xDefaultScreen(A13),
			     xScreens(A14),
			     xFormats(A141)]),

	xConnections(A15), 
        format("connection: ~d~n", [C]),
	format("	net fd: 		~d~n", [A00]),
	format("	protocol version:	~d~n", [A01]),
	format("	protocol revision:	~d~n", [A02]),
	format("	server vendor:		~a~n", [A03]),
	format("	image byte order:	~a~n", [A04]),
	format("	image unit:		~d~n", [A05]),
	format("	image pad unit:		~d~n", [A06]),
	format("	image bit order:	~a~n", [A07]),
	format("	vendor release:		~d~n", [A08]),
	format("	queue length:		~d~n", [A09]),
	format("	last event:		~d~n", [A10]),
	format("	last request:		~d~n", [A11]),
	format("	connection name:	~a~n", [A12]),
	format("	motion buffer size:	~d~n", [A16]),
	format("	default screen:		~d~n", [A13]), 
	format("	connection screens:	~w~n", [A14]),
	format("	connection formats:	~w~n", [A141]),
	format("connections: ~w~n", [A15]).

qformat(F) :-
	xQueryFormat(F, [xConnection(A00),
	                 xDepth(A01),
			 xFormatBits(A02),
			 xFormatPad(A03)]),
	xFormats(A04),
	format("format ~d~n", F),
	format("	connection:	~d~n", [A00]),
    	format("	depth:		~d~n", [A01]),
	format("	format bits:	~d~n", [A02]),
	format("	format pad:	~d~n", [A03]),
	format("formats: ~w~n", [A04]).


qscreen(S) :-
	xQueryScreen(S, [xConnection(A00),
			 xRootWindow(A01),
			 xWidth(A02),
			 xHeight(A03),
			 xPhysicalWidth(A04),
			 xPhysicalHeight(A05),
			 xRootDepth(A06),
			 xRootVisual(A07),
			 xDefaultGC(A08),
			 xDefaultColormap(A09),
			 xWhitePixel(A10),
			 xBlackPixel(A11),
			 xMaxColormaps(A12),
			 xMinColormaps(A13),
			 xBackingStore(A14),
			 xSaveUnders(A15),
			 xRootEventMask(A16),
			 xDepths(A17)]),
	xScreens(A18),
	format("screen ~d~n", S),
	format("	connection: 		~d~n", [A00]),
	format("	root window:		~d~n", [A01]),
	format("	width:			~d~n", [A02]),
	format("	height:			~d~n", [A03]),
	format("	physical width:		~d~n", [A04]),
	format("	physical height:	~d~n", [A05]),
	format("	root depth:		~d~n", [A06]),
	format("	root visual:		~d~n", [A07]),
	format("	default GC:		~d~n", [A08]),
	format("	default colormap:	~d~n", [A09]),
	format("	white pixel:		~d~n", [A10]),
	format("	black pixel:		~d~n", [A11]),
	format("	max colormaps:		~d~n", [A12]),
	format("	min colormaps:		~d~n", [A13]),
	format("	backing store:		~a~n", [A14]),
	format("	save unders:		~a~n", [A15]),
	format("	root event mask:	~w~n", [A16]),
	format("	screen depths:		~w~n", [A17]),
	format("screens: ~w~n", [A18]).

qdepths :-
	xDepths(D),
	qdepth(D).
qdepth([]).
qdepth([D | DL]) :-
	xQueryDepth(D, [xDepth(DV), xVisuals(VL)]),
	format("depth ~d, value ~d, visuals ~w~n", [D, DV, VL]),
	qdepth(DL).

qvisual(V) :-
	xQueryVisual(V, [xClass(A00),
			 xRedMask(A01),
			 xGreenMask(A02),
			 xBlueMask(A03),
			 xColormapBits(A04),
			 xColormapEntries(A05)]),
	xVisuals(A06),
	format("visual ~d~n", V),
	format("	class:			~a~n", [A00]),
	format("	red mask:		0x~16R~n", [A01]),
	format("	green mask:		0x~16R~n", [A02]),
	format("	blue mask:		0x~16R~n", [A03]),
	format("	colormap bits:		~d~n", [A04]),
	format("	colormap entries:	~d~n", [A05]),
	format("visuals: ~w~n", [A06]).

qwindow(C, W) :-
	xQueryWindow(C, W, [xX(A00),
	                    xY(A01),
			    xWidth(A02),
			    xHeight(A03),
			    xBorderWidth(A04),
			    xDepth(A05),
			    xRootWindow(A06),
			    xScreen(A07),
			    xVisual(A08),
			    xClass(A09),
			    xUnionEventMask(A10),
			    xBitGravity(A11),
			    xWinGravity(A12),
			    xBackingStore(A13),
			    xBackingPlanes(A14),
			    xBackingPixel(A15),
			    xOverrideRedirect(A16),
			    xSaveUnder(A17),
			    xEventMask(A18),
			    xDontPropagate(A19),
			    xColormap(A20),
			    xColormapLoaded(A21),
			    xState(A22)]),
	format("window ~d~n", W),
	format("	X			~d~n", [A00]),
	format("	Y			~d~n", [A01]),
	format("	width			~d~n", [A02]),
	format("	height			~d~n", [A03]),
	format("	border width		~d~n", [A04]),
	format("	depth			~d~n", [A05]),
	format("	root window		~d~n", [A06]),
	format("	screen			~d~n", [A07]),
	format("	visual			~d~n", [A08]),
	format("	class			~a~n", [A09]),
	format("	union event mask	~w~n", [A10]),
	format("	bit gravity		~a~n", [A11]),
	format("	window gravity		~a~n", [A12]),
	format("	backing store		~a~n", [A13]),
	format("	backing planes		~d~n", [A14]),
	format("	backing pixel		~d~n", [A15]),
	format("	override redirect	~a~n", [A16]),
	format("	save under		~a~n", [A17]),
	format("	event mask		~w~n", [A18]),
	format("	dont propagate		~w~n", [A19]),
	format("	colormap		~d~n", [A20]),
	format("	colormap loaded		~a~n", [A21]),
	format("	state			~a~n", [A22]).

qpixmap(C, P) :-
	xQueryPixmap(C, P, [xWidth(A00),
			    xHeight(A01),
			    xBorderWidth(A02),
			    xDepth(A03),
			    xScreen(A04)]),
	format("pixmap ~d~n", P),
	format("	width:		~d~n", [A00]),
	format("	height:		~d~n", [A01]),
	format("	border width:	~d~n", [A02]),
	format("	depth:		~d~n", [A03]),
	format("	screen:		~d~n", [A04]).

qgc(G) :-
	xQueryGC(G, [xFunction(A00),
		     xPlaneMask(A01),
		     xForeground(A02),
		     xBackground(A03),
		     xLineWidth(A04),
		     xLineStyle(A05),
		     xCapStyle(A06),
		     xJoinStyle(A07),
		     xFillStyle(A08),
		     xFillRule(A09),
		     xTile(A10),
		     xStipple(A11),
		     xTileStipXOrigin(A12),
		     xTileStipYOrigin(A13),
		     xFont(A14),
		     xSubwindowMode(A15),
		     xGraphicsExposures(A16),
		     xClipXOrigin(A17),
		     xClipYOrigin(A18),
		     xClipMask(A19),
		     xDashOffset(A20),
		     xDashLength(A21),
		     xArcMode(A22),
		     xClipList(A23),
		     xDashList(A24)]),
	format("GC ~d~n", G),
	format("	function		~a~n", [A00]),
	format("	plane mask		~d~n", [A01]),
	format("	foreground		~d~n", [A02]),
	format("	background		~d~n", [A03]),
 	format("	line width		~w~n", [A04]),
	format("	line style		~a~n", [A05]),
	format("	cap style		~a~n", [A06]),
	format("	join style		~a~n", [A07]),
	format("	fill style		~a~n", [A08]),
	format("	fill rule		~a~n", [A09]),
	format("	tile			~d~n", [A10]),
	format("	stipple			~d~n", [A11]),
	format("	tile/stipple X origin	~d~n", [A12]),
	format("	tile/stipple Y origin	~d~n", [A13]),
	format("	font			~d~n", [A14]),
	format("	subwindow mode		~a~n", [A15]),
	format("	graphics exposures	~a~n", [A16]),
	format("	clip X origin		~d~n", [A17]),
	format("	clip Y origin		~d~n", [A18]),
	format("	clip mask		~d~n", [A19]),
	format("	dash offset		~d~n", [A20]),
	format("	dash length		~d~n", [A21]),
	format("	arc mode		~a~n", [A22]),
	format("	clip list		~a~n", [A23]),
	format("	dashlist		~a~n", [A24]).

qimage(I) :-
	xQueryImage(I, [xWidth(A00),
			xHeight(A01),
			xOffset(A02),
			xFormat(A03),
			xImageByteOrder(A04),
			xImageUnit(A05),
			xImagePad(A06),
			xImageBitOrder(A07),
			xDepth(A08),
			xLineBytes(A09),
			xPixelBits(A10),
			xRedMask(A11),
			xGreenMask(A12),
			xBlueMask(A13)]),
	format("image ~d~n", [I]),
	format("	width			~d~n", [A00]),
	format("	height			~d~n", [A01]),
	format("	offset			~d~n", [A02]),
	format("	format			~a~n", [A03]),
	format("	byte order		~a~n", [A04]),
	format("	image unit		~d~n", [A05]),
	format("	image pad		~d~n", [A06]),
	format("	image bit order		~a~n", [A07]),
	format("	depth			~d~n", [A08]),
	format("	line bytes		~d~n", [A09]),
	format("	pixel bits		~d~n", [A10]),
	format("	red mask		~d~n", [A11]),
	format("	green mask		~d~n", [A12]),
	format("	blue mask 		~d~n", [A13]).
	
openconn(N, C) :- 
	xOpenConnection(N, C),
	xSynchronize(C, xTrue).

root(C,RW) :-
	xQueryConnection(C, [xDefaultScreen(S)]),
	xQueryScreen(S, [xRootWindow(RW)]).
			 
openwin(C, 0, Width, Height, AL, W) :-
	!,
	xQueryConnection(C, [xDefaultScreen(S)]),
	xQueryScreen(S, [xRootWindow(RW)]), 
	xCreateWindow(C, RW, 
	              100, 100, Width, Height, 
		      1, xCopyFromParent,
		      xCopyFromParent, xCopyFromParent,
		      AL, W),
	xMapWindow(C, W), 
	xFlush(C).
openwin(C, P, Width, Height, AL, W) :-
	xCreateWindow(C, P, 
	              100, 100, Width, Height, 
		      1, xCopyFromParent,
		      xCopyFromParent, xCopyFromParent,
		      AL, W),
	xMapWindow(C, W), 
	xFlush(C).

stdwin(C, W) :- openwin(C,0,200,200,[xBackPixel(1),xBorderPixel(0)], W).

getprop(C, W, P, Type, Remain, Value) :-
	xGetProperty(C, W, P, 0, 100, xFalse, xAny, xTrue, Type, Remain, Value).

clrwin(C, W) :-
	xClearArea(C, W, 0, 0, 0, 0, 0).

colors(C) :-
	xQueryConnection(C, [xDefaultScreen(DS)]),
	xQueryScreen(DS, [xDefaultColormap(DC)]),
	xGetColors(C, DC, [xCell(0,ZERO),
			   xCell(1,ONE),
			   xCell(2,TWO),
			   xCell(3,THREE),
			   xCell(4,FOUR),
			   xCell(5,FIVE),
			   xCell(6,SIX),
			   xCell(7,SEVEN),
			   xCell(8,EIGHT),
			   xCell(9,NINE),
			   xCell(10,TEN),
			   xCell(11,ELEVEN),
			   xCell(12,TWELVE),
			   xCell(13,THIRTEEN),
			   xCell(14,FOURTEEN),
			   xCell(15,FIFTEEN)]),
	format("connection ~d, colormap ~d~n", [C,DC]),
	format("	 0:	~w~n", [ZERO]),
	format("	 1:	~w~n", [ONE]),
	format("	 2:	~w~n", [TWO]),
	format("	 3:	~w~n", [THREE]),
	format("	 4:	~w~n", [FOUR]),
	format("	 5:	~w~n", [FIVE]),
	format("	 6:	~w~n", [SIX]),
	format("	 7:	~w~n", [SEVEN]),
	format("	 8:	~w~n", [EIGHT]),
	format("	 9:	~w~n", [NINE]),
	format("	10:	~w~n", [TEN]),
	format("	11:	~w~n", [ELEVEN]),
	format("	12:	~w~n", [TWELVE]),
	format("	13:	~w~n", [THIRTEEN]),
	format("	14:	~w~n", [FOURTEEN]),
	format("	15:	~w~n", [FIFTEEN]).

qfont(F) :-
	xQueryFont(F, [xConnection(Z00),
		       xFont(Z01),
                       xDirection(A00),
		       xMinColumn(A01),
		       xMaxColumn(A02),
		       xMinRow(A03),
		       xMaxRow(A04),
		       xAllExist(A05),
		       xDefaultChar(A06),
		       xMinLeft(A07),
		       xMinRight(A08),
		       xMinWidth(A09),
		       xMinAscent(A10),
		       xMinDescent(A11),
		       xMinAttribute(A12),
		       xMaxLeft(A13),
		       xMaxRight(A14),
		       xMaxWidth(A15),
		       xMaxAscent(A16),
		       xMaxDescent(A17),
		       xMaxAttribute(A18),
		       xAscent(A19),
		       xDescent(A20),
		       xProperties(PL)]),
	format("font ~d~n", F),
	format("	connection	~d~n", [Z00]),
	format("	font XID	~d~n", [Z01]),
	format("	direction	~a~n", [A00]),
	format("	min column	~d~n", [A01]),
	format("	max column	~d~n", [A02]),
	format("	min row		~d~n", [A03]),
	format("	max row		~d~n", [A04]),
	format("	all exist	~a~n", [A05]),
	format("	default char	~d~n", [A06]),
	format("	min left	~d~n", [A07]),
	format("	min right	~d~n", [A08]),
	format("	min width	~d~n", [A09]),
	format("	min ascent	~d~n", [A10]),
	format("	min descent	~d~n", [A11]),
	format("	min attribute	0x~16R~n", [A12]),
	format("	max left	~d~n", [A13]),
	format("	max right	~d~n", [A14]),
	format("	max width	~d~n", [A15]),
	format("	max ascent	~d~n", [A16]),
	format("	max descent	~d~n", [A17]),
	format("	max attribute	0x~16R~n", [A18]),
	format("	font ascent	~d~n", [A19]),
	format("	font descent	~d~n", [A20]),
	format("	font properties	~w~n", [PL]).

stdmap(C, P) :-
	xQueryConnection(C, [xDefaultScreen(S)]),
	xQueryScreen(S, [xRootWindow(RW)]),
	xGetProperty(0, RW, P, 0, 8, 0, 24, 0, 24, 0, V),
	format("map ~d: ~w~n", [P, V]).

qpointer(C) :-
	xQueryPointer(C, [xNumerator(N),
			  xDenominator(D),
			  xThreshold(T)]),
	xGetPointerMapping(C, 3, M),
	format("pointer with connection ~d~n", [C]),
	format("	numerator	~d~n", [N]),
	format("	denominator	~d~n", [D]),
	format("	threshold	~d~n", [T]),
	format("	mapping		~w~n", [M]).

qkeyboard(C) :-
	xQueryKeyboard(C, [xKeyClickPercent(A00),
			   xBellPercent(A01),
			   xBellPitch(A02),
			   xBellDuration(A03),
			   xLed(A04),
			   xAutoRepeatMode(A05),
			   xRepeatKeymap(A07)]),
	xDownKeymap(C, A06),
	format("keyboard with connection ~d~n", [C]),
	format("	key click %	~d~n", [A00]),
    	format("	bell %		~d~n", [A01]),
    	format("	bell pitch	~d~n", [A02]),
	format("	bell duration	~d~n", [A03]),
	format("	LEDs		~d~n", [A04]),
	format("	auto repeat	~a~n", [A05]),
	format("	down keymap	~w~n", [A06]),
	format("	repeat keymap	~w~n", [A07]).

grabp(C, GW, EM, CW, CUR, S) :-
	xGrabPointer(C, GW, xFalse, EM, xFalse, xFalse,
	             CW, CUR, xCurrentTime, S).

setmask(C, W) :- xSetWindow(C, W, [xEventMask([xKeyPress, xKeyRelease,
		xButtonPress, xButtonRelease,
		xEnterWindow, xLeaveWindow,
		xPointerMotion, xPointerMotionHint, xButtonMotion,
		xButton1Motion, xButton2Motion, xButton3Motion, xButton4Motion,
			xButton5Motion, 
		xKeymapState, xFocusChange, xOwnerGrabButton,
		xExposure, xVisibilityChange, xColormapChange, 
		xPropertyChange,
		xStructureNotify, xSubstructureNotify, xSubstructureRedirect,
		xResizeRedirect])]).

setmask1(C, W) :- xSetWindow(C, W, [xEventMask([xKeyPress, xKeyRelease,
		xButtonPress, xButtonRelease,
		xEnterWindow, xLeaveWindow,
		xKeymapState, xFocusChange, xOwnerGrabButton,
		xExposure, xVisibilityChange, xColormapChange, 
		xPropertyChange,
		xStructureNotify, xSubstructureNotify, xSubstructureRedirect,
		xResizeRedirect])]).

nextevent(C, E) :-
	xGetEvent(C, xAny, [], xAny, xTrue, xFalse, E).

senddw(C, W) :-
	xAtom(C, 'WM_PROTOCOLS', WM_PROTOCOLS),
	xAtom(C, 'WM_DELETE_WINDOW', WM_DELETE_WINDOW),
	xSendEvent(C, W, xFalse, [],
		xEvent(xClientMessage, 0, xTrue, 0,
			W, WM_PROTOCOLS, 32, WM_DELETE_WINDOW, 0,
			0, 0, 0)).

rdb(A, I, Cl, F) :-
	xOpenConnection([],C),
	xOpenResourceDatabase(C, big, 'Big',
		[xResource(source, options),
		 xResource('Type', options),
		 xResource(opt, on),
		 xResource('Customization', new),
		 xLanguage(latin_pig),
	         xResource('*iconName', 'RealBig')], 
		[xResource('*type', application_class),
		 xResource('*source', fallback_resources),
		 xResource('*ac', on)],
		R, A),
	xQueryResourceDatabase(R, [source, big], ['Source', 'Big'], I),
	xQueryResourceDatabase(R, [type, big], ['Type', 'Big'], Cl),
	xQueryResourceDatabase(R, [ac, big], ['Ac', 'Big'], F).	

appOptions(xMoo, xFalse, cow).
appOptions(xInactive, xTrue, iconic).
appOptions(xSelectionTimeout, xFalse, timeout).

po(CN, OPTS, OTHER, R, AN) :-
	xParseOptions([xMoo(red), xInactive(on), xSelectionTimeout(5), 
		       xBackground(green), xResource('*wood', teak), 
		       xConnection('penzance:0.0'), switch(k)],
		      [], appOptions, CN, OPTS, OTHER),
		      xOpenConnection(CN, C),
		      xOpenResourceDatabase(C, ogive, 'Ogive', OPTS, [], R, AN).

dpo(CN, OPTS, OTHER, R, AN) :-
	xParseOptions([xMoo(red), xInactive(on), xSelectionTimeout(5), 
		       xBackground(green), xResource('*wood', teak), 
		       xConnection('penzance:0.0'), switch(k)],
		      [], [], CN, OPTS, OTHER),
		      xOpenConnection(CN, C),
		      xOpenResourceDatabase(C, ogive, 'Ogive', OPTS, [], R, AN).
		      

%
% eof
%
