/*
 * Copyright (C) 1990 by Ted Kim.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * preprocessor for predefined atoms table
 */

#include <stdio.h>

#define SKIPLINES (7)

static char lastatom[] = "LAST_PREDEFINED";

main()
{
  char buf[256];
  int value, i;

  for (i = 0; i < SKIPLINES; i++) { /* move up to first atom */
    scanf("%*[^\n]");
    getchar();
  }

  while (scanf(" #define XA_%s", buf) == 1) {
    if (!strncmp(buf, lastatom, sizeof(lastatom)))
      exit(0); 
    scanf(" ((Atom) %d)\n", &value);
    if ((buf[0] >= 'A') && (buf[0] <= 'Z'))
      printf("pxAtom('%s', %d).\n", buf, value);
    else
      printf("pxAtom(%s, %d).\n", buf, value);
  }
  exit(0);
}

/*
 * eof
 */

