/*
 * Copyright (C) 1989 by The Regents of the University of California.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * wm.c - window manager functions
 *
 * pxSetSaveSet
 * pxReparentWindow
 * pxSetCloseDownMode
 * pxKillClient
 *
 * pxGetInputFocus
 * pxSetInputFocus
 *
 * pxGrabPointer
 * pxUngrabPointer
 * pxSetActivePointer
 * pxGrabButton
 * pxUngrabButton
 *
 * pxGrabKeyboard
 * pxUngrabKeyboard
 * pxGrabKey
 * pxUngrabKey
 *
 * pxAllowEvents
 *
 * pxGrabServer
 * pxUngrabServer
 *
 * pxGetScreenSaver
 * pxSetScreenSaver
 * pxScreenSaver
 *
 * pxQueryAccess
 * pxSetAccess
 * pxSetHostAccess
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <X11/Xlib.h>

#include "dl.h"
#include "conn.h"
#include "ff.h"

/*
 * pxSetSaveSet(+Connection, +Window, +Delete, 0)
 *	integer: Connection, Window, Delete
 */
FFInteger
pxSetSaveSet(pc, pw, pd)
     FFInteger pc, pw, pd;
{
  PxConnection *pcp;

  PX_ErrorInit("xSetSaveSet/3");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XChangeSaveSet(pcp->xDisplay, pw, pd);
  return FF_Ok;
}

/*
 * pxReparentWindow(+Connection, +Window, +Parent, +X, +Y, 0)
 * 	integer: Connection, Window, Parent, X, Y
 */
FFInteger
pxReparentWindow(pc, pw, pp, px, py)
     FFInteger pc, pw, pp, px, py;
{
  PxConnection *pcp;

  PX_ErrorInit("xReparentWindow/5");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;
  
  XReparentWindow(pcp->xDisplay, pw, pp, px, py);
  return FF_Ok;
}

/*
 * pxSetCloseDownMode(+Connection, +Mode, 0)
 *	integer: Connection, Mode
 */
FFInteger
pxSetCloseDownMode(pc, pm)
     FFInteger pc, pm;
{
  PxConnection *pcp;

  PX_ErrorInit("xSetCloseDownMode/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XSetCloseDownMode(pcp->xDisplay, pm);
  return FF_Ok;
}

/*
 * pxKillClient(+Connection, +Resource, 0)
 *	integer: Connection, Resource
 */
FFInteger
pxKillClient(pc, pr)
     FFInteger pc, pr;
{
  PxConnection *pcp;

  PX_ErrorInit("xKillClient/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XKillClient(pcp->xDisplay, pr);
  return FF_Ok;
}

/* 
 * pxGetInputFocus(+Connection, -Window, -Revert, 0)
 *	integer: Connection, Window, Revert
 */
FFInteger
pxGetInputFocus(pc, pw, pr)
     FFInteger pc, *pw, *pr;
{
  PxConnection *pcp;
  
  PX_ErrorInit("xGetInputFocus/3");
  *pw = *pr = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XGetInputFocus(pcp->xDisplay, pw, pr);
  return FF_Ok;
}

/*
 * pxSetInputFocus(+Connection, +Window, +Revert, 0)
 *	integer: Connection, Window, Revert
 */
FFInteger
pxSetInputFocus(pc, pw, pr)
     FFInteger pc, pw, pr;
{
  PxConnection *pcp;

  PX_ErrorInit("xSetInputFocus/4");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XSetInputFocus(pcp->xDisplay, pw, pr, pxUnsignedArg1);
  return FF_Ok;
}

/*
 * pxGrabPointer(+Connection, +GrabWindow, +NormalEvents, +EventMask,
 *	+PointerDefer, +KeyboardDefer, +ConfineWindow, +Cursor, -Status, 0)
 *
 *	integer: Connection, GrabWindow, NormalEvents, EventMask, PointerDefer,
 *		KeyboardDefer, ConfineWindow, Cursor, Status
 */
FFInteger
pxGrabPointer(pc, pgw, pne, pem, ppd, pkd, pcw, pcur, pstat)
     FFInteger pc, pgw, pne, pem, ppd, pkd, pcw, pcur, *pstat;
{
  PxConnection *pcp;

  PX_ErrorInit("xGrabPointer/10");
  *pstat = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  *pstat = XGrabPointer(pcp->xDisplay, pgw, pne, pem, ppd, pkd, pcw, pcur,
			pxUnsignedArg1);
  return FF_Ok;
}

/*
 * pxUngrabPointer(+Connection, 0)
 *	integer: Connection
 */
FFInteger
pxUngrabPointer(pc)
     FFInteger pc;
{
  PxConnection *pcp;

  PX_ErrorInit("xUngrabPointer/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XUngrabPointer(pcp->xDisplay, pxUnsignedArg1);
  return FF_Ok;
}

/*
 * pxSetActivePointer(+Connection, +EventMask, +Cursor, 0)
 *	integer: Connection, EventMask, Cursor
 */
FFInteger
pxSetActivePointer(pc, pem, pcur)
     FFInteger pc, pem, pcur;
{
  PxConnection  *pcp;

  PX_ErrorInit("xChangeActivePointerGrab/4");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XChangeActivePointerGrab(pcp->xDisplay, pem, pcur, pxUnsignedArg1);
  return FF_Ok;
}

/*
 * pxGrabButton(+Connection, +Button, +Modifiers, +GrabWindow, +NormalEvents,
 *	+EventMask, +PointerDefer, +KeyboardDefer, +ConfineWindow, +Cursor, 0)
 *
 *	integer: Connection, Button, Modifiers, GrabWindow, NormalEvents,
 *		EventMask, PointerDefer, KeyboardDefer, ConfineWindow, Cursor
 */
FFInteger
pxGrabButton(pc, pb, pm, pgw, pne, pem, ppd, pkd, pcw, pcur)
     FFInteger pc, pb, pm, pgw, pne, pem, ppd, pkd, pcw, pcur;
{
  PxConnection *pcp;

  PX_ErrorInit("xGrabButton/10");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XGrabButton(pcp->xDisplay, pb, pm, pgw, pne, pem, ppd, pkd, pcw, pcur);
  return FF_Ok;
}

/*
 * pxUngrabButton(+Connection, +Button, +Modifiers, +GrabWindow, 0)
 *	integer: Connection, Button, Modifiers, GrabWindow
 */
FFInteger
pxUngrabButton(pc, pb, pm, pgw)
     FFInteger pc, pb, pm, pgw;
{
  PxConnection *pcp;

  PX_ErrorInit("xUngrabButton/4");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XUngrabButton(pcp->xDisplay, pb, pm, pgw);
  return FF_Ok;
}

/*
 * pxGrabKeyboard(+Connection, +GrabWindow, +NormalEvents, +PointerDefer,
 *	+KeyboardDefer, -Status, 0)
 *
 *	integer: Connection, GrabWindow, NormalEvents, PointerDefer,
 *		KeyboardDefer, Status
 */
FFInteger
pxGrabKeyboard(pc, pgw, pne, ppd, pkd, pstat)
     FFInteger pc, pgw, pne, ppd, pkd, *pstat;
{
  PxConnection *pcp;

  PX_ErrorInit("xGrabKeyboard/7");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  *pstat = XGrabKeyboard(pcp->xDisplay, pgw, pne, ppd, pkd, pxUnsignedArg1);
  return FF_Ok;
}

/*
 * pxUngrabKeyboard(+Connection, 0)
 *	integer: Connection
 */
FFInteger
pxUngrabKeyboard(pc)
     FFInteger pc;
{
  PxConnection *pcp;

  PX_ErrorInit("xUngrabKeyboard/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XUngrabKeyboard(pcp->xDisplay, pxUnsignedArg1);
  return FF_Ok;
}

/*
 * pxGrabKey(+Connection, +Keycode, +Modifiers, +GrabWindow, +NormalEvents,
 *	+PointerDefer, +KeyboardDefer, 0)
 *
 *	integer: Connection, Keycode, Modifiers, GrabWindow, NormalEvents,
 *		PointerDefer, KeyboardDefer
 */
FFInteger
pxGrabKey(pc, pk, pm, pgw, pne, ppd, pkd)
     FFInteger pc, pk, pm, pgw, pne, ppd, pkd;
{
  PxConnection *pcp;

  PX_ErrorInit("xGrabKey/7");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XGrabKey(pcp->xDisplay, pk, pm, pgw, pne, ppd, pkd);
  return FF_Ok;
}

/*
 * pxUngrabKey(+Connection, +Keycode, +Modifiers, +GrabWindow, 0)
 *	integer: Connection, Keycode, Modifiers, GrabWindow
 */
FFInteger
pxUngrabKey(pc, pk, pm, pgw)
     FFInteger pc, pk, pm, pgw;
{
  PxConnection *pcp;

  PX_ErrorInit("xUngrabKey/4");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XUngrabKey(pcp->xDisplay, pk, pm, pgw);
  return FF_Ok;
}

/*
 * pxAllowEevents(+Connection, +Mode, 0)
 *	integer: Connection, Mode
 */
FFInteger
pxAllowEvents(pc, pm)
     FFInteger pc, pm;
{
  PxConnection *pcp;

  PX_ErrorInit("xAllowEvents/3");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XAllowEvents(pcp->xDisplay, pm, pxUnsignedArg1);
  return FF_Ok;
}

/*
 * pxGrabServer(+Connection, 0)
 *	integer: Connection
 */
FFInteger
pxGrabServer(pc)
     FFInteger pc;
{
  PxConnection *pcp;

  PX_ErrorInit("xGrabServer/1");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XGrabServer(pcp->xDisplay);
  return FF_Ok;
}

/*
 * pxUngrabServer(+Connection, 0)
 *	integer: Connection
 */
FFInteger
pxUngrabServer(pc)
     FFInteger pc;
{
  PxConnection *pcp;

  PX_ErrorInit("xUngrabServer/1");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XUngrabServer(pcp->xDisplay);
  return FF_Ok;
}

/*
 * pxGetScreenSaver(+Connection, -Timeout, -Interval, -Blanking, -Exposures, 0)
 *	integer: Connection, Timeout, Interval, Blanking, Exposures
 */
FFInteger
pxGetScreenSaver(pc, pt, pi, pb, pe)
     FFInteger pc, *pt, *pi, *pb, *pe;
{
  PxConnection *pcp;

  PX_ErrorInit("xGetScreenSaver/5");
  *pt = *pi = *pb = *pe = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XGetScreenSaver(pcp->xDisplay, pt, pi, pb, pe);
  return FF_Ok;
}

/*
 * pxSetScreenSaver(+Connection, +Timeout, +Interval, +Blanking, +Exposures, 0)
 *	integer: Connection, Timeout, Interval, Blanking, Exposures
 */
FFInteger
pxSetScreenSaver(pc, pt, pi, pb, pe)
     FFInteger pc, pt, pi, pb, pe;
{
  PxConnection *pcp;

  PX_ErrorInit("xSetScreenSaver/5");
  
  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XSetScreenSaver(pcp->xDisplay, pt, pi, pb, pe);
  return FF_Ok;
}

/*
 * pxScreenSaver(+Connection, +Activate, 0)
 *	integer: Connection, Activate
 */
FFInteger
pxScreenSaver(pc, pa)
     FFInteger pc, pa;
{
  PxConnection *pcp;

  PX_ErrorInit("xScreenSaver/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XForceScreenSaver(pcp->xDisplay, pa);
  return FF_Ok;
}

/*
 * pxQueryAccess(+Connection, -Control, -Next, 0)
 *	integer: Connection, Control, Next
 */
FFInteger
pxQueryAccess(pc, pctrl, pn)
     FFInteger pc, *pctrl, *pn;
{
  PxConnection *pcp;

  PX_ErrorInit("xQueryAccess/3");
  *pctrl = *pn = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  pxElements = 1;
  pxMallocBlock = (char *)XListHosts(pcp->xDisplay, &pxElements, pctrl);
  if (pxElements) {
    if (pxMallocBlock == NULL)
      return FF_Fail;
    pxHostAddress = (XHostAddress *)pxMallocBlock;
    pxType = PX_HostAddress;
    *pn = PX_Cont;
  } else 
    *pn = PX_End;
  return FF_Ok;
}

/*
 * pxSetAccess(+Connection, +Enable, 0)
 *	integer: Connection, Enable
 */
FFInteger
pxSetAccess(pc, pe)
     FFInteger pc, pe;
{
  PxConnection *pcp;

  PX_ErrorInit("xSetAccessControl/2");
  
  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XSetAccessControl(pcp->xDisplay, pe);
  return FF_Ok;
}

/*
 * pxSetHostAccess(+Connection, +Insert, +Name, 0)
 *	integer: Connection, Insert, Name
 */
FFInteger
pxSetHostAccess(pc, pi, pn)
     FFInteger pc, pi;
     FFString pn;
{
  PxConnection *pcp;
  XHostAddress xha;
  struct hostent *hep;

  PX_ErrorInit("xSetHostAccess/3");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  if ((hep = gethostbyname(pn)) == NULL)
    PX_Error("unknown host");
  if (hep->h_addrtype == AF_INET)
    xha.family = FamilyInternet;
  else
    PX_Error("unsupported address family");
  xha.length = hep->h_length;
  xha.address = hep->h_addr;
  switch (pi) {
  case 0:
    XRemoveHost(pcp->xDisplay, &xha);
    break;
  case 1:
    XAddHost(pcp->xDisplay, &xha);
    break;
  default: PX_Error(bad_request);
  }
  return FF_Ok;
}

/*
 * eof
 */
