%
% Copyright (C) 1989 by The Regents of the University of California.
%
% This software work was developed at UCLA with support in part from
% DARPA Contract F29601-87-C-0072.
%

%
% table.pl
% X Window Interface for Prolog (XWIP)
% Tables
%

% boolean
pxcBoolean(0, xFalse).
pxcBoolean(1, xTrue).

% can be any
pxcAny(0, xAny) :- !.
pxcAny(N, N).

% can be none
pxcNone(0, xNone) :- !.
pxcNone(N, N).

% default
pxcDefault(0, xDefault) :- !.
pxcDefault(N, N).

% parent
pxcParent(0, xCopyFromParent) :- !.
pxcParent(N, N).

% time
pxcTime(0, xCurrentTime) :- !.
pxcTime(N, N).

% connection attributes (xQueryConnection)
pxcConnectionAttribute(xNetworkDescriptor, C, V) :-
	pxGetConnectionAttribute(C, 0, _, _, V, 0).
pxcConnectionAttribute(xProtocolVersion, C, V) :-
	pxGetConnectionAttribute(C, 1, _, _, V, 0).
pxcConnectionAttribute(xProtocolRevision, C, V) :-
	pxGetConnectionAttribute(C, 2, _, _, V, 0).
pxcConnectionAttribute(xServerVendor, C, V) :-
	pxGetConnectionAttribute(C, 3, V, _, _, 0).
pxcConnectionAttribute(xImageByteOrder, C, V) :-
	pxGetConnectionAttribute(C, 4, _, _, R, 0), pxcBoolean(R, V).
pxcConnectionAttribute(xImageUnit, C, V) :-
	pxGetConnectionAttribute(C, 5, _, _, V, 0).
pxcConnectionAttribute(xImagePad, C, V) :-
	pxGetConnectionAttribute(C, 6, _, _, V, 0).
pxcConnectionAttribute(xImageBitOrder, C, V) :-
	pxGetConnectionAttribute(C, 7, _, _, R, 0), pxcBoolean(R, V).
pxcConnectionAttribute(xVendorRelease, C, V) :-
	pxGetConnectionAttribute(C, 8, _, _, V, 0).
pxcConnectionAttribute(xQueueLength, C, V) :-
	pxGetConnectionAttribute(C, 9, _, _, V, 0).
pxcConnectionAttribute(xLastEvent, C, V) :-
	pxGetConnectionAttribute(C, 10, _, U, L, 0), pxSelectValue(U, L, V).
pxcConnectionAttribute(xLastRequest, C, V) :-
	pxGetConnectionAttribute(C, 11, _, U, L, 0), pxSelectValue(U, L, V).
pxcConnectionAttribute(xConnectionName, C, V) :-
	pxGetConnectionAttribute(C, 12, V, _, _, 0).
pxcConnectionAttribute(xDefaultScreen, C, V) :-
	pxGetConnectionAttribute(C, 13, _, _, V, 0).
pxcConnectionAttribute(xMinKeycode, C, V) :-
	pxGetConnectionAttribute(C, 14, _, _, V, 0).
pxcConnectionAttribute(xMaxKeycode, C, V) :-
	pxGetConnectionAttribute(C, 15, _, _, V, 0).
pxcConnectionAttribute(xScreens, C, V) :-
	pxGetConnectionAttribute(C, 16, _, _, N, 0), pxListGet(N, V).
pxcConnectionAttribute(xMotionBuffer, C, V) :-
	pxGetConnectionAttribute(C, 17, _, _, V, 0).

% screen attributes (xQueryScreen)
pxcScreenAttribute(xConnection, S, V) :- pxGetScreenAttribute(S, 0, V, 0).
pxcScreenAttribute(xRootWindow, S, V) :- pxGetScreenAttribute(S, 1, V, 0).
pxcScreenAttribute(xWidth, S, V) :- pxGetScreenAttribute(S, 2, V, 0).
pxcScreenAttribute(xHeight, S, V) :- pxGetScreenAttribute(S, 3, V, 0).
pxcScreenAttribute(xPhysicalWidth, S, V) :- pxGetScreenAttribute(S, 4, V, 0).
pxcScreenAttribute(xPhysicalHeight, S, V) :- pxGetScreenAttribute(S, 5, V, 0).
pxcScreenAttribute(xRootDepth, S, V) :- pxGetScreenAttribute(S, 6, V, 0).
pxcScreenAttribute(xRootVisual, S, V) :- pxGetScreenAttribute(S, 7, V, 0).
pxcScreenAttribute(xDefaultGC, S, V) :- pxGetScreenAttribute(S, 8, V, 0).
pxcScreenAttribute(xDefaultColormap, S, V) :- pxGetScreenAttribute(S, 9, V, 0).
pxcScreenAttribute(xWhitePixel, S, V) :- pxGetScreenAttribute(S, 10, V, 0).
pxcScreenAttribute(xBlackPixel, S, V) :- pxGetScreenAttribute(S, 11, V, 0).
pxcScreenAttribute(xMaxColormaps, S, V) :- pxGetScreenAttribute(S, 12, V, 0).
pxcScreenAttribute(xMinColormaps, S, V) :- pxGetScreenAttribute(S, 13, V, 0).
pxcScreenAttribute(xBackingStore, S, V) :- 
	pxGetScreenAttribute(S, 14, R, 0), pxcBackingStore(R, V).
pxcScreenAttribute(xSaveUnders, S, V) :-
	pxGetScreenAttribute(S, 15, R, 0), pxcBoolean(R, V).
pxcScreenAttribute(xRootEventMask, S, V) :-
	pxGetScreenAttribute(S, 16, R, 0), pxMaskToBits(R, V, pxmEvent).
pxcScreenAttribute(xDepths, S, V) :-
	pxGetScreenAttribute(S, 17, N, 0), pxListGet(N, V).

% backing store
pxcBackingStore(0, xNotUseful).
pxcBackingStore(1, xWhenMapped).
pxcBackingStore(2, xAlways).

% depth attributes (xQueryDepth)
pxcDepthAttribute(xDepth, D, V) :- pxGetDepthAttribute(D, 0, V, 0).
pxcDepthAttribute(xVisuals, D, V) :-
	pxGetDepthAttribute(D, 1, N, 0), pxListGet(N, V).

% visual attribute (xQueryVisual)
pxcVisualAttribute(xClass, Vis, V) :-
	pxGetVisualAttribute(Vis, 0, R, 0), pxcVisualClass(R, V).
pxcVisualAttribute(xRedMask, Vis, V) :- pxGetVisualAttribute(Vis, 1, V, 0).
pxcVisualAttribute(xGreenMask, Vis, V) :- pxGetVisualAttribute(Vis, 2, V, 0).
pxcVisualAttribute(xBlueMask, Vis, V) :- pxGetVisualAttribute(Vis, 3, V, 0).
pxcVisualAttribute(xColormapBits, Vis, V) :- pxGetVisualAttribute(Vis, 4, V, 0).
pxcVisualAttribute(xColormapEntries, Vis, V) :-
	pxGetVisualAttribute(Vis, 5, V, 0).

% visual class
pxcVisualClass(0, xStaticGray).
pxcVisualClass(1, xGrayScale).
pxcVisualClass(2, xStaticColor).
pxcVisualClass(3, xPseudoColor).
pxcVisualClass(4, xTrueColor).
pxcVisualClass(5, xDirectColor).

% window class (xCreateWindow)
pxcWindowClass(0, xCopyFromParent).		
pxcWindowClass(1, xInputOutput).
pxcWindowClass(2, xInputOnly).

% window depth (xCreateWindow)
pxcWindowDepth(0, xNone) :- !.
pxcWindowDepth(0, xCopyFromParent) :- !.
pxcWindowDepth(N, N).

% get window attribute (xQueryWindow)
pxcGetWindowAttribute(xX, V) :- pxGetWindowAttribute(0, V, 0).
pxcGetWindowAttribute(xY, V) :- pxGetWindowAttribute(1, V, 0).
pxcGetWindowAttribute(xWidth, V) :- pxGetWindowAttribute(2, V, 0).
pxcGetWindowAttribute(xHeight, V) :- pxGetWindowAttribute(3, V, 0).
pxcGetWindowAttribute(xBorderWidth, V) :- pxGetWindowAttribute(4, V, 0).
pxcGetWindowAttribute(xDepth, V) :- pxGetWindowAttribute(5, V, 0).
pxcGetWindowAttribute(xRootWindow, V) :- pxGetWindowAttribute(6, V, 0).
pxcGetWindowAttribute(xScreen, V) :- pxGetWindowAttribute(7, V, 0).
pxcGetWindowAttribute(xVisual, V) :- pxGetWindowAttribute(8, V, 0).
pxcGetWindowAttribute(xClass, V) :-
	pxGetWindowAttribute(9, R, 0), pxcWindowClass(R, V).
pxcGetWindowAttribute(xUnionEventMask, V) :-
	pxGetWindowAttribute(10, R, 0), pxMaskToBits(R, V, pxmEvent).
pxcGetWindowAttribute(xBitGravity, V) :-
	pxGetWindowAttribute(11, R, 0), pxcBitGravity(R, V).
pxcGetWindowAttribute(xWinGravity, V) :-
	pxGetWindowAttribute(12, R, 0), pxcWindowGravity(R, V).
pxcGetWindowAttribute(xBackingStore, V) :-
	pxGetWindowAttribute(13, R, 0), pxcBackingStore(R, V).
pxcGetWindowAttribute(xBackingPlanes, V) :- pxGetWindowAttribute(14, V, 0).
pxcGetWindowAttribute(xBackingPixel, V) :- pxGetWindowAttribute(15, V, 0).
pxcGetWindowAttribute(xOverrideRedirect, V) :-
	pxGetWindowAttribute(16, R, 0), pxcBoolean(R, V).
pxcGetWindowAttribute(xSaveUnder, V) :-
	pxGetWindowAttribute(17, R, 0), pxcBoolean(R, V).
pxcGetWindowAttribute(xEventMask, V) :-
	pxGetWindowAttribute(18, R, 0), pxMaskToBits(R, V, pxmEvent).
pxcGetWindowAttribute(xDontPropagate, V) :-
	pxGetWindowAttribute(19, R, 0), pxMaskToBits(R, V, pxmEvent).
pxcGetWindowAttribute(xColormap, V) :- pxGetWindowAttribute(20, V, 0).
pxcGetWindowAttribute(xColormapLoaded, V) :-
	pxGetWindowAttribute(21, R, 0), pxcBoolean(R, V).
pxcGetWindowAttribute(xState, V) :-
	pxGetWindowAttribute(22, R, 0), pxcWindowState(R, V).

% set window attribute (xSetWindow)
pxcSetWindowAttribute(xX, V) :- pxSetWindowAttribute(0, V, 0).
pxcSetWindowAttribute(xY, V) :- pxSetWindowAttribute(1, V, 0).
pxcSetWindowAttribute(xWidth, V) :- pxSetWindowAttribute(2, V, 0).
pxcSetWindowAttribute(xHeight, V) :- pxSetWindowAttribute(3, V, 0).
pxcSetWindowAttribute(xBorderWidth, V) :- pxSetWindowAttribute(4, V, 0).
pxcSetWindowAttribute(xBitGravity, V) :-
	pxcBitGravity(R, V), pxSetWindowAttribute(11, R, 0).
pxcSetWindowAttribute(xWinGravity, V) :-
	pxcWindowGravity(R, V), pxSetWindowAttribute(12, R, 0).
pxcSetWindowAttribute(xBackingStore, V) :-
	pxcBackingStore(R, V), pxSetWindowAttribute(13, R, 0).
pxcSetWindowAttribute(xBackingPlanes, V) :- pxSetWindowAttribute(14, V, 0).
pxcSetWindowAttribute(xBackingPixel, V) :- pxSetWindowAttribute(15, V, 0).
pxcSetWindowAttribute(xOverrideRedirect, V) :-
	pxcBoolean(R, V), pxSetWindowAttribute(16, R, 0).
pxcSetWindowAttribute(xSaveUnder, V) :-
	pxcBoolean(R, V), pxSetWindowAttribute(17, R, 0).
pxcSetWindowAttribute(xEventMask, V) :-
	pxMaskFromBits(R, V, pxmEvent), pxSetWindowAttribute(18, R, 0).
pxcSetWindowAttribute(xDontPropagate, V) :-
	pxMaskFromBits(R, V, pxmEvent), pxSetWindowAttribute(19, R, 0).
pxcSetWindowAttribute(xColormap, V) :- pxSetWindowAttribute(20, V, 0).
pxcSetWindowAttribute(xSibling, V) :- pxSetWindowAttribute(23, V, 0).
pxcSetWindowAttribute(xStackMode, V) :-
	pxcStackMode(R, V), pxSetWindowAttribute(24, R, 0).
pxcSetWindowAttribute(xBackPixmap, V) :-
	pxcBackPixmap(R, V), pxSetWindowAttribute(25, R, 0).
pxcSetWindowAttribute(xBackPixel, V) :- pxSetWindowAttribute(26, V, 0).
pxcSetWindowAttribute(xBorderPixmap, V) :-
	pxcParent(R,V), pxSetWindowAttribute(27, R, 0).
pxcSetWindowAttribute(xBorderPixel, V) :- pxSetWindowAttribute(28, V, 0).
pxcSetWindowAttribute(xCursor, V) :- pxSetWindowAttribute(29, V, 0).

% bit gravity
pxcBitGravity(0, xForget).
pxcBitGravity(1, xNorthWest).
pxcBitGravity(2, xNorth).
pxcBitGravity(3, xNorthEast).
pxcBitGravity(4, xWest).
pxcBitGravity(5, xCenter).
pxcBitGravity(6, xEast).
pxcBitGravity(7, xSouthWest).
pxcBitGravity(8, xSouth).
pxcBitGravity(9, xSouthEast).
pxcBitGravity(10, xStatic).

% window gravity
pxcWindowGravity(0, xUnmap).
pxcWindowGravity(1, xNorthWest).
pxcWindowGravity(2, xNorth).
pxcWindowGravity(3, xNorthEast).
pxcWindowGravity(4, xWest).
pxcWindowGravity(5, xCenter).
pxcWindowGravity(6, xEast).
pxcWindowGravity(7, xSouthWest).
pxcWindowGravity(8, xSouth).
pxcWindowGravity(9, xSouthEast).
pxcWindowGravity(10, xStatic).

% window state
pxcWindowState(0, xUnmapped).
pxcWindowState(1, xUnviewable).
pxcWindowState(2, xViewable).

% stack mode
pxcStackMode(0, xAbove).
pxcStackMode(1, xBelow).
pxcStackMode(2, xTopIf).
pxcStackMode(3, xBottomIf).
pxcStackMode(4, xOpposite).

% back pixmap
pxcBackPixmap(0, xNone) :- !.
pxcBackPixmap(1, xParentRelative) :- !.
pxcBackPixmap(N, N).

% property mode (xSetProperty)
pxcPropertyMode(0, xReplace).
pxcPropertyMode(1, xPrepend).
pxcPropertyMode(2, xAppend).

% pixmap attributes (xQueryPixmap)
pxcPixmapAttribute(xWidth, V) :- pxGetPixmapAttribute(0, V, 0).
pxcPixmapAttribute(xHeight, V) :- pxGetPixmapAttribute(1, V, 0).
pxcPixmapAttribute(xBorderWidth, V) :- pxGetPixmapAttribute(2, V, 0).
pxcPixmapAttribute(xDepth, V) :- pxGetPixmapAttribute(3, V, 0).
pxcPixmapAttribute(xScreen, V) :- pxGetPixmapAttribute(4, V, 0).

% GC mask (xCopyGC)
pxmGC(xFunction, 0).
pxmGC(xPlaneMask, 1).
pxmGC(xForeground, 2).
pxmGC(xBackground, 3).
pxmGC(xLineWidth, 4).
pxmGC(xLineStyle, 5).
pxmGC(xCapStyle, 6).
pxmGC(xJoinStyle, 7).
pxmGC(xFillStyle, 8).
pxmGC(xFillRule, 9).
pxmGC(xTile, 10).
pxmGC(xStipple, 11).
pxmGC(xTileStipXOrigin, 12).
pxmGC(xTileStipYOrigin, 13).
pxmGC(xFont, 14).
pxmGC(xSubwindowMode, 15).
pxmGC(xGraphicsExposures, 16).
pxmGC(xClipXOrigin, 17).
pxmGC(xClipYOrigin, 18).
pxmGC(xClipMask, 19).
pxmGC(xDashOffset, 20).
pxmGC(xDashLength, 21).
pxmGC(xArcMode, 22).

% get GC attributes (xQueryGC)
pxcGetGCAttribute(xFunction, GC, V) :-
	pxGetGCAttribute(GC, 0, R, 0), pxcFunction(R, V).
pxcGetGCAttribute(xPlaneMask, GC, V) :- pxGetGCAttribute(GC, 1, V, 0).
pxcGetGCAttribute(xForeground, GC, V) :- pxGetGCAttribute(GC, 2, V, 0).
pxcGetGCAttribute(xBackground, GC, V) :- pxGetGCAttribute(GC, 3, V, 0).
pxcGetGCAttribute(xLineWidth, GC, V) :-
	pxGetGCAttribute(GC, 4, R, 0), pxcLineWidth(R, V).
pxcGetGCAttribute(xLineStyle, GC, V) :-
	pxGetGCAttribute(GC, 5, R, 0), pxcLineStyle(R, V).
pxcGetGCAttribute(xCapStyle, GC, V) :-
	pxGetGCAttribute(GC, 6, R, 0), pxcCapStyle(R, V).
pxcGetGCAttribute(xJoinStyle, GC, V) :-
	pxGetGCAttribute(GC, 7, R, 0), pxcJoinStyle(R, V).
pxcGetGCAttribute(xFillStyle, GC, V) :-
	pxGetGCAttribute(GC, 8, R, 0), pxcFillStyle(R, V).
pxcGetGCAttribute(xFillRule, GC, V) :-
	pxGetGCAttribute(GC, 9, R, 0), pxcBoolean(R, V).
pxcGetGCAttribute(xTile, GC, V) :- pxGetGCAttribute(GC, 10, V, 0).
pxcGetGCAttribute(xStipple, GC, V) :- pxGetGCAttribute(GC, 11, V, 0).
pxcGetGCAttribute(xTileStipXOrigin, GC, V) :- pxGetGCAttribute(GC, 12, V, 0).
pxcGetGCAttribute(xTileStipYOrigin, GC, V) :- pxGetGCAttribute(GC, 13, V, 0).
pxcGetGCAttribute(xFont, GC, V) :- pxGetGCAttribute(GC, 14, V, 0).
pxcGetGCAttribute(xSubwindowMode, GC, V) :-
	pxGetGCAttribute(GC, 15, R, 0), pxcBoolean(R, V).
pxcGetGCAttribute(xGraphicsExposures, GC, V) :-
	pxGetGCAttribute(GC, 16, R, 0), pxcBoolean(R, V).
pxcGetGCAttribute(xClipXOrigin, GC, V) :- pxGetGCAttribute(GC, 17, V, 0).
pxcGetGCAttribute(xClipYOrigin, GC, V) :- pxGetGCAttribute(GC, 18, V, 0).
pxcGetGCAttribute(xClipMask, GC, V) :- pxGetGCAttribute(GC, 19, V, 0).
pxcGetGCAttribute(xDashOffset, GC, V) :- pxGetGCAttribute(GC, 20, V, 0).
pxcGetGCAttribute(xDashLength, GC, V) :- pxGetGCAttribute(GC, 21, V, 0).
pxcGetGCAttribute(xArcMode, GC, V) :-
	pxGetGCAttribute(GC, 22, R, 0), pxcBoolean(R, V).
pxcGetGCAttribute(xClipList, GC, V) :-
	pxGetGCAttribute(GC, 23, R, 0), pxcBoolean(R, V).
pxcGetGCAttribute(xDashList, GC, V) :-
	pxGetGCAttribute(GC, 24, R, 0), pxcBoolean(R, V).

% set GC attributes (xSetGC)
pxcSetGCAttribute(xFunction, V) :-
	pxcFunction(R, V), pxSetGCAttribute(0, R, 0).
pxcSetGCAttribute(xPlaneMask, V) :- pxSetGCAttribute(1, V, 0).
pxcSetGCAttribute(xForeground, V) :- pxSetGCAttribute(2, V, 0).
pxcSetGCAttribute(xBackground, V) :- pxSetGCAttribute(3, V, 0).
pxcSetGCAttribute(xLineWidth, V) :-
	pxcLineWidth(R, V), pxSetGCAttribute(4, R, 0).
pxcSetGCAttribute(xLineStyle, V) :-
	pxcLineStyle(R, V), pxSetGCAttribute(5, R, 0).
pxcSetGCAttribute(xCapStyle, V) :-
	pxcCapStyle(R, V), pxSetGCAttribute(6, R, 0).
pxcSetGCAttribute(xJoinStyle, V) :-
	pxcJoinStyle(R, V), pxSetGCAttribute(7, R, 0).
pxcSetGCAttribute(xFillStyle, V) :-
	pxcFillStyle(R, V), pxSetGCAttribute(8, R, 0).
pxcSetGCAttribute(xFillRule, V) :-
	pxcBoolean(R, V), pxSetGCAttribute(9, R, 0).
pxcSetGCAttribute(xTile, V) :- pxSetGCAttribute(10, V, 0).
pxcSetGCAttribute(xStipple, V) :- pxSetGCAttribute(11, V, 0).
pxcSetGCAttribute(xTileStipXOrigin, V) :- pxSetGCAttribute(12, V, 0).
pxcSetGCAttribute(xTileStipYOrigin, V) :- pxSetGCAttribute(13, V, 0).
pxcSetGCAttribute(xFont, V) :- pxSetGCAttribute(14, V, 0).
pxcSetGCAttribute(xSubwindowMode, V) :-
	pxcBoolean(R, V), pxSetGCAttribute(15, R, 0).
pxcSetGCAttribute(xGraphicsExposures, V) :-
	pxcBoolean(R, V), pxSetGCAttribute(16, R, 0).
pxcSetGCAttribute(xClipXOrigin, V) :- pxSetGCAttribute(17, V, 0).
pxcSetGCAttribute(xClipYOrigin, V) :- pxSetGCAttribute(18, V, 0).
pxcSetGCAttribute(xClipMask, V) :- pxSetGCAttribute(19, V, 0).
pxcSetGCAttribute(xDashOffset, V) :- pxSetGCAttribute(20, V, 0).
pxcSetGCAttribute(xDashLength, V) :- pxSetGCAttribute(21, V, 0).
pxcSetGCAttribute(xArcMode, V) :-
	pxcBoolean(R, V), pxSetGCAttribute(22, R, 0).

% GC function
pxcFunction(0, xClear).
pxcFunction(1, xAnd).
pxcFunction(2, xAndReverse).
pxcFunction(3, xCopy).
pxcFunction(4, xAndInverted).
pxcFunction(5, xNoop).
pxcFunction(6, xXor).
pxcFunction(7, xOr).
pxcFunction(8, xNor).
pxcFunction(9, xEquiv).
pxcFunction(10, xInvert).
pxcFunction(11, xOrReverse).
pxcFunction(12, xCopyInverted).
pxcFunction(13, xOrInverted).
pxcFunction(14, xNand).
pxcFunction(15, xSet).

% line width
pxcLineWidth(0, xThinLine) :- !.
pxcLineWidth(N, N).

% line style
pxcLineStyle(0, xSolid).
pxcLineStyle(1, xOnOffDash).
pxcLineStyle(2, xDoubleDash).

% cap style
pxcCapStyle(0, xNotLast).
pxcCapStyle(1, xButt).
pxcCapStyle(2, xRound).
pxcCapStyle(3, xProjecting).

% join style
pxcJoinStyle(0, xMiter).
pxcJoinStyle(1, xRound).
pxcJoinStyle(2, xBevel).

% fill style
pxcFillStyle(0, xSolid).
pxcFillStyle(1, xTiled).
pxcFillStyle(2, xStippled).
pxcFillStyle(3, xOpaqueStippled).

% size query (xQueryBestSize)
pxcSizeQuery(0, xCursor).
pxcSizeQuery(1, xTile).
pxcSizeQuery(2, xStipple).

% clip ordering (xSetClips)
pxcClipOrdering(0, xUnsorted).
pxcClipOrdering(1, xYSorted).
pxcClipOrdering(2, xYXSorted).
pxcClipOrdering(3, xYXBanded).

% polygon shape (xFillPolygon)
pxcPolygonShape(0, xComplex).
pxcPolygonShape(1, xNonconvex).
pxcPolygonShape(2, xConvex).

% image format (xCreateImage)
pxcImageFormat(1, xXYPixmap).
pxcImageFormat(2, xZPixmap).

% image attributes (xQueryImage)
pxcImageAttribute(xWidth, I, V) :- pxGetImageAttribute(I, 0, V, 0).
pxcImageAttribute(xHeight, I, V) :- pxGetImageAttribute(I, 1, V, 0).
pxcImageAttribute(xOffset, I, V) :- pxGetImageAttribute(I, 2, V, 0).
pxcImageAttribute(xFormat, I, V) :-
	pxGetImageAttribute(I, 3, R, 0), pxcImageFormat(R, V).
pxcImageAttribute(xImageByteOrder, I, V) :-
	pxGetImageAttribute(I, 4, R, 0), pxcBoolean(R, V).
pxcImageAttribute(xImageUnit, I, V) :- pxGetImageAttribute(I, 5, V, 0).
pxcImageAttribute(xImagePad, I, V) :- pxGetImageAttribute(I, 6, V, 0).
pxcImageAttribute(xImageBitOrder, I, V) :-
	pxGetImageAttribute(I, 7, R, 0), pxcBoolean(R, V).
pxcImageAttribute(xDepth, I, V) :- pxGetImageAttribute(I, 8, V, 0).
pxcImageAttribute(xLineBytes, I, V) :- pxGetImageAttribute(I, 9, V, 0).
pxcImageAttribute(xPixelBits, I, V) :- pxGetImageAttribute(I, 10, V, 0).
pxcImageAttribute(xRedMask, I, V) :- pxGetImageAttribute(I, 11, V, 0).
pxcImageAttribute(xGreenMask, I, V) :- pxGetImageAttribute(I, 12, V, 0).
pxcImageAttribute(xBlueMask, I, V) :- pxGetImageAttribute(I, 13, V, 0).

% font attributes (xQueryFont)
pxcFontAttribute(xDirection, F, V) :-
	pxGetFontAttribute(F, 0, R, 0), pxcBoolean(R, V).
pxcFontAttribute(xMinColumn, F, V) :- pxGetFontAttribute(F, 1, V, 0).
pxcFontAttribute(xMaxColumn, F, V) :- pxGetFontAttribute(F, 2, V, 0).
pxcFontAttribute(xMinRow, F, V) :- pxGetFontAttribute(F, 3, V, 0).
pxcFontAttribute(xMaxRow, F, V) :- pxGetFontAttribute(F, 4, V, 0).
pxcFontAttribute(xAllExist, F, V) :-
	pxGetFontAttribute(F, 5, R, 0), pxcBoolean(R, V).
pxcFontAttribute(xDefaultChar, F, V) :- pxGetFontAttribute(F, 6, V, 0).
pxcFontAttribute(xMinLeft, F, V) :- pxGetFontAttribute(F, 7, V, 0).
pxcFontAttribute(xMinRight, F, V) :- pxGetFontAttribute(F, 8, V, 0).
pxcFontAttribute(xMinWidth, F, V) :- pxGetFontAttribute(F, 9, V, 0).
pxcFontAttribute(xMinAscent, F, V) :- pxGetFontAttribute(F, 10, V, 0).
pxcFontAttribute(xMinDescent, F, V) :- pxGetFontAttribute(F, 11, V, 0).
pxcFontAttribute(xMinAttribute, F, V) :- pxGetFontAttribute(F, 12, V, 0).
pxcFontAttribute(xMaxLeft, F, V) :- pxGetFontAttribute(F, 13, V, 0).
pxcFontAttribute(xMaxRight, F, V) :- pxGetFontAttribute(F, 14, V, 0).
pxcFontAttribute(xMaxWidth, F, V) :- pxGetFontAttribute(F, 15, V, 0).
pxcFontAttribute(xMaxAscent, F, V) :- pxGetFontAttribute(F, 16, V, 0).
pxcFontAttribute(xMaxDescent, F, V) :- pxGetFontAttribute(F, 17, V, 0).
pxcFontAttribute(xMaxAttribute, F, V) :- pxGetFontAttribute(F, 18, V, 0).
pxcFontAttribute(xAscent, F, V) :- pxGetFontAttribute(F, 19, V, 0).
pxcFontAttribute(xDescent, F, V) :- pxGetFontAttribute(F, 20, V, 0).
pxcFontAttribute(xConnection, F, V) :- pxGetFontAttribute(F, 21, V, 0).
pxcFontAttribute(xFont, F, V) :- pxGetFontAttribute(F, 22, V, 0).
pxcFontAttribute(xProperties, F, V) :-
	pxGetFontAttribute(F, 23, N, 0), pxVectorGet(N, V).

% key masks (xPointerState, xGrabButton, xUngrabButton, xGrabKey, xUngrabKey)
pxmKey(xShift, 0).
pxmKey(xLock, 1).
pxmKey(xControl, 2).
pxmKey(xMod1, 3).
pxmKey(xMod2, 4).
pxmKey(xMod3, 5).
pxmKey(xMod4, 6).
pxmKey(xMod5, 7).
pxmKey(xButton1, 8).
pxmKey(xButton2, 9).
pxmKey(xButton3, 10).
pxmKey(xButton4, 11).
pxmKey(xButton5, 12).
pxmKey(xAny, 15).
pxmKey(maxindex, 16).

% get pointer attributes (xQueryPointer)
pxcGetPointerAttribute(xNumerator, V) :- pxGetPointerAttribute(0, V, 0).
pxcGetPointerAttribute(xDenominator, V) :- pxGetPointerAttribute(1, V, 0).
pxcGetPointerAttribute(xThreshold, V) :- pxGetPointerAttribute(2, V, 0).

% set pointer attributes (xSetPointer)
pxcSetPointerAttribute(xNumerator, V) :- pxSetPointerAttribute(0, V, 0).
pxcSetPointerAttribute(xDenominator, V) :- pxSetPointerAttribute(1, V, 0).
pxcSetPointerAttribute(xThreshold, V) :- pxSetPointerAttribute(2, V, 0).

% get keyboard attributes (xQueryKeyboard)
pxcGetKeyboardAttribute(xKeyClickPercent, V) :- pxGetKeyboardAttribute(0, V, 0).
pxcGetKeyboardAttribute(xBellPercent, V) :- pxGetKeyboardAttribute(1, V, 0).
pxcGetKeyboardAttribute(xBellPitch, V) :- pxGetKeyboardAttribute(2, V, 0).
pxcGetKeyboardAttribute(xBellDuration, V) :- pxGetKeyboardAttribute(3, V, 0).
pxcGetKeyboardAttribute(xLed, V) :- pxGetKeyboardAttribute(4, V, 0).
pxcGetKeyboardAttribute(xAutoRepeatMode, V) :-
	pxGetKeyboardAttribute(7, R, 0), pxcBoolean(R, V).
pxcGetKeyboardAttribute(xRepeatKeymap, V) :-
	pxGetKeyboardAttribute(8, N, 0),
	pxVectorGet(N, R), pxKeymapToCodes(R,V).

% set keyboard attributes (xSetKeyboard)
pxcSetKeyboardAttribute(xKeyClickPercent, V) :-
	pxcKeyboardDefault(R, V), pxSetKeyboardAttribute(0, R, 0).
pxcSetKeyboardAttribute(xBellPercent, V) :-
	pxcKeyboardDefault(R, V), pxSetKeyboardAttribute(1, R, 0).
pxcSetKeyboardAttribute(xBellPitch, V) :-
	pxcKeyboardDefault(R, V), pxSetKeyboardAttribute(2, R, 0).
pxcSetKeyboardAttribute(xBellDuration, V) :-
	pxcKeyboardDefault(R, V), pxSetKeyboardAttribute(3, R, 0).
pxcSetKeyboardAttribute(xLed, V) :- pxSetKeyboardAttribute(4, V, 0).
pxcSetKeyboardAttribute(xLedMode, V) :-
	pxcBoolean(R, V), pxSetKeyboardAttribute(5, R, 0).
pxcSetKeyboardAttribute(xKey, V) :- pxSetKeyboardAttribute(6, V, 0).
pxcSetKeyboardAttribute(xAutoRepeatMode, V) :-
	pxcAutoRepeat(R, V), pxSetKeyboardAttribute(7, R, 0).

% keyboard settings
pxcKeyboardDefault(-1, xDefault) :- !.
pxcKeyboardDefault(N, N).

% auto repeat mode
pxcAutoRepeat(0, xFalse).
pxcAutoRepeat(1, xTrue).
pxcAutoRepeat(2, xDefault).

% no symbol
pxcNoSymbol(0, xNoSymbol) :- !.
pxcNoSymbol(N, N).

% close down mode (xSetCloseDown)
pxcCloseDown(0, xDestroy).
pxcCloseDown(1, xPermanent).
pxcCloseDown(2, xTemporary).

% kill client resource (xKillClient)
pxcKillResource(0, xAllTemporary) :- !.
pxcKillResource(N, N).

% focus window (xGetInputFocus, xSetInputFocus)
pxcFocusWindow(0, xNone) :- !.
pxcFocusWindow(1, xPointerRoot) :- !.
pxcFocusWindow(N, N).

% revert state (xGetInputFocus, xSetInputFocus)
pxcRevertState(0, xNone).
pxcRevertState(1, xPointerRoot).
pxcRevertState(2, xParent).

% event masks (xGrabPointer, xSetActivePointer, xGrabButton, xGetEvent,
%	       xSendEvent)
pxmEvent(xKeyPress, 0).
pxmEvent(xKeyRelease, 1).
pxmEvent(xButtonPress, 2).
pxmEvent(xButtonRelease, 3).
pxmEvent(xEnterWindow, 4).
pxmEvent(xLeaveWindow, 5).
pxmEvent(xPointerMotion, 6).
pxmEvent(xPointerMotionHint, 7).
pxmEvent(xButton1Motion, 8).
pxmEvent(xButton2Motion, 9).
pxmEvent(xButton3Motion, 10).
pxmEvent(xButton4Motion, 11).
pxmEvent(xButton5Motion, 12).
pxmEvent(xButtonMotion, 13).
pxmEvent(xKeymapState, 14).
pxmEvent(xExposure, 15).
pxmEvent(xVisibilityChange, 16).
pxmEvent(xStructureNotify, 17).
pxmEvent(xResizeRedirect, 18).
pxmEvent(xSubstructureNotify, 19).
pxmEvent(xSubstructureRedirect, 20).
pxmEvent(xFocusChange, 21).
pxmEvent(xPropertyChange, 22).
pxmEvent(xColormapChange, 23).
pxmEvent(xOwnerGrabButton, 24).
pxmEvent(maxindex, 25).

% grab status (xGrabPointer, xGrabKeyboard)
pxcGrabStatus(0, xSucess).
pxcGrabStatus(1, xAlreadyGrabbed).
pxcGrabStatus(2, xInvalidTime).
pxcGrabStatus(3, xNotViewable).
pxcGrabStatus(4, xFrozen).

% event mode (xAllowEvents)
pxcEventMode(0, xAsyncPointer).
pxcEventMode(1, xSyncPointer).
pxcEventMode(2, xReplayPointer).
pxcEventMode(3, xAsyncKeyboard).
pxcEventMode(4, xSyncKeyboard).
pxcEventMode(5, xReplayKeyboard).
pxcEventMode(6, xAsyncBoth).
pxcEventMode(7, xSyncBoth).

% blanking (xGetScreenSaver, xSetScreenSaver)
pxcBlanking(0, xNoBlanking).
pxcBlanking(1, xBlanking).
pxcBlanking(2, xDefault).

% exposures (xGetScreenSaver, xSetScreenSaver)
pxcExposures(0, xNoExposures).
pxcExposures(1, xExposures).
pxcExposures(2, xDefault).

% screen saver timeout (xSetScreenSaver)
pxcTimeout(-1, xDefault) :- !.
pxcTimeout(0, xDisable) :- !.
pxcTimeout(N, N).

% screen saver change interval (xSetScreenSaver)
pxcInterval(0, xDisable) :- !.
pxcInterval(N, N).

%
% Copyright (C) 1989 by The Regents of the University of California.
%
% This software work was developed at UCLA with support in part from
% DARPA Contract F29601-87-C-0072.
%

% event queue (xEventsQueued)
pxcEventQueue(0, xAlready).
pxcEventQueue(1, xAfterReading).
pxcEventQueue(2, xAfterFlush).

% event types (xGetEvent, pxEventGet, pxEventPut)
pxcEventType(xAny, 0, xAny).			% struct should fail
pxcEventType(xKeyPress, 2, xInput).
pxcEventType(xKeyRelease, 3, xInput).
pxcEventType(xButtonPress, 4, xInput).
pxcEventType(xButtonRelease, 5, xInput).
pxcEventType(xMotionNotify, 6, xMotionNotify).
pxcEventType(xEnterNotify, 7, xCrossing).
pxcEventType(xLeaveNotify, 8, xCrossing).
pxcEventType(xFocusIn, 9, xFocus).
pxcEventType(xFocusOut, 10, xFocus).
pxcEventType(xKeymapNotify, 11, xKeymapNotify).
pxcEventType(xExpose, 12, xRequest10).
pxcEventType(xGraphicsExpose, 13, xRequest12).
pxcEventType(xNoExpose, 14, xRequest7).
pxcEventType(xVisibilityNotify, 15, xVisibilityNotify).
pxcEventType(xCreateNotify, 16, xCreateNotify).
pxcEventType(xDestroyNotify, 17, xRequest6).
pxcEventType(xUnmapNotify, 18, xNotify7).
pxcEventType(xMapNotify, 19, xNotify7).
pxcEventType(xMapRequest, 20, xRequest6).
pxcEventType(xReparentNotify, 21, xReparentNotify).
pxcEventType(xConfigureNotify, 22, xConfigureNotify).
pxcEventType(xConfigureRequest, 23, xConfigureRequest).
pxcEventType(xGravityNotify, 24, xRequest8).
pxcEventType(xResizeRequest, 25, xRequest7).
pxcEventType(xCirculateNotify, 26, xNotify7).
pxcEventType(xCirculateRequest, 27, xNotify7).
pxcEventType(xPropertyNotify, 28, xPropertyNotify).
pxcEventType(xSelectionClear, 29, xSelectionClear).
pxcEventType(xSelectionRequest, 30, xSelectionRequest).
pxcEventType(xSelectionNotify, 31, xSelectionNotify).
pxcEventType(xColormapNotify, 32, xColormapNotify).
pxcEventType(xClientMessage, 33, xClientMessage).
pxcEventType(xMappingNotify, 34, xMappingNotify).

% get event (pxEventGet)
pxcGetEvent(xRequest6, E, 6) :-
	pxSplitGetOne(Six), arg(6, E, Six).
pxcGetEvent(xRequest7, E, 7) :- 
	pxSplitGetOne(Six), arg(6, E, Six),
	pxSplitGetOne(Seven), arg(7, E, Seven).
pxcGetEvent(xRequest8, E, 8) :-
	pxSplitGetOne(Six), arg(6, E, Six),
	pxSplitGetOne(Seven), arg(7, E, Seven),
	pxSplitGetOne(Eight), arg(8, E, Eight).
pxcGetEvent(xRequest10, E, 10) :- pxStructGetOne(6, 11, E).
pxcGetEvent(xRequest12, E, 12) :- pxStructGetOne(6, 13, E).
pxcGetEvent(xNotify7, E, 7) :-
	pxSplitGetOne(I), arg(6, E, I),
	pxSplitGetOne(B), pxcBoolean(B, Boolean), arg(7, E, Boolean).
pxcGetEvent(xInput, E, 15) :-
	pxSplitGetOne(R), arg(6, E, R),
	pxSplitGetOne(W), arg(7, E, W),
	pxSplitGetOne(T), pxcTime(T, Time), arg(8, E, Time),
	pxStructGetOne(9, 13, E),
	pxSplitGetOne(S), pxMaskToBits(S, State, pxmKey), arg(13, E, State),
	pxSplitGetOne(IV), arg(14, E, IV),
	pxSplitGetOne(SS), pxcBoolean(SS, Same), arg(15, E, Same).
pxcGetEvent(xMotionNotify, E, 15) :-
	pxSplitGetOne(R), arg(6, E, R),
	pxSplitGetOne(Sub), arg(7, E, Sub),
	pxSplitGetOne(T), pxcTime(T, Time), arg(8, E, Time),
	pxStructGetOne(9, 13, E),
	pxSplitGetOne(S), pxMaskToBits(S, State, pxmKey), arg(13, E, State),
	pxSplitGetOne(IH), pxcBoolean(IH, IsHint), arg(14, E, IsHint),
	pxSplitGetOne(SS), pxcBoolean(SS, Same), arg(15, E, Same).
pxcGetEvent(xCrossing, E, 17) :-
	pxSplitGetOne(R), arg(6, E, R),
	pxSplitGetOne(Sub), arg(7, E, Sub),
	pxSplitGetOne(T), pxcTime(T, Time), arg(8, E, Time),
	pxStructGetOne(9, 13, E),
	pxSplitGetOne(M), pxcNotifyMode(M, Mode), arg(13, E, Mode),
	pxSplitGetOne(D), pxcNotifyDetail(D, Detail), arg(14, E, Detail),
	pxSplitGetOne(SS), pxcBoolean(SS, Same), arg(15, E, Same),
	pxSplitGetOne(F), pxcBoolean(F, Focus), arg(16, E, Focus),
	pxSplitGetOne(S), pxMaskToBits(S, State, pxmKey), arg(17, E, State).
pxcGetEvent(xFocus, E, 7) :- 
	pxSplitGetOne(M), pxcNotifyMode(M, Mode), arg(6, E, Mode),
	pxSplitGetOne(D), pxcNotifyDetail(D, Detail), arg(7, E, Detail).
pxcGetEvent(xKeymapNotify, E, 6) :-
	pxVectorGet(0, BL), pxKeymapToCodes(BL, KM), arg(6, E, KM).
pxcGetEvent(xVisibilityNotify, E, 6) :-
	pxSplitGetOne(S), pxcVisibility(S, State), arg(6, E, State).
pxcGetEvent(xCreateNotify, E, 12) :-
	pxStructGetOne(6, 12, E),
	pxSplitGetOne(OR), pxcBoolean(OR, Override), arg(12, E, Override).
pxcGetEvent(xReparentNotify, E, 10) :-
	pxStructGetOne(6, 10, E),
	pxSplitGetOne(OR), pxcBoolean(OR, Override), arg(10, E, Override).
pxcGetEvent(xConfigureNotify, E, 13) :-
	pxStructGetOne(6, 12, E),
	pxSplitGetOne(A), pxcNone(A, Above), arg(12, E, Above),
	pxSplitGetOne(OR), pxcBoolean(OR, Override), arg(13, E, Override).
pxcGetEvent(xConfigureRequest, E, 14) :-
	pxStructGetOne(6, 12, E),
	pxSplitGetOne(A), pxcNone(A, Above), arg(12, E, Above),
	pxSplitGetOne(D), pxcStackMode(D, Detail), arg(13, E, Detail),
	pxSplitGetOne(VM), pxMaskToBits(VM, V, pxmConfigure), arg(14, E, V).
pxcGetEvent(xPropertyNotify, E, 8) :-
	pxSplitGetOne(A), arg(6, E, A), 
	pxSplitGetOne(T), pxcTime(T, Time), arg(7, E, Time),
	pxSplitGetOne(D), pxcBoolean(D, Delete), arg(8, E, Delete).
pxcGetEvent(xSelectionClear, E, 7) :- 
	pxSplitGetOne(S), arg(6, E, S), 
	pxSplitGetOne(T), pxcTime(T, Time), arg(7, E, Time).
pxcGetEvent(xSelectionRequest, E, 10) :-
	pxStructGetOne(6, 9, E),
	pxSplitGetOne(P), pxcNone(P, Property), arg(9, E, Property),
	pxSplitGetOne(T), pxcTime(T, Time), arg(10, E, Time).
pxcGetEvent(xSelectionNotify, E, 9) :-
	pxStructGetOne(6, 8, E),
	pxSplitGetOne(P), pxcNone(P, Property), arg(8, E, Property),
	pxSplitGetOne(T), pxcTime(T, Time), arg(9, E, Time).
pxcGetEvent(xColormapNotify, E, 8) :-
	pxSplitGetOne(CM), pxcNone(CM, Colormap), arg(6, E, Colormap),
	pxSplitGetOne(M), pxcBoolean(M, Modified), arg(7, E, Modified),
	pxSplitGetOne(L), pxcBoolean(L, Load), arg(8, E, Load).
pxcGetEvent(xClientMessage, E, 12) :-
	pxSplitGetOne(MT), arg(6, E, MT),
	pxSplitGetOne(32), arg(7, E, 32),
	pxStructGetOne(8, 13, E).
pxcGetEvent(xClientMessage, E, 17) :-
	pxSplitGetOne(MT), arg(6, E, MT),
	pxSplitGetOne(16), arg(7, E, 16),
	pxStructGetOne(8, 18, E).
pxcGetEvent(xClientMessage, E, 27) :-
	pxSplitGetOne(MT), arg(6, E, MT),
	pxSplitGetOne(8), arg(7, E, 8),
	pxStructGetOne(8, 28, E).
pxcGetEvent(xMappingNotify, E, 8) :-
	pxSplitGetOne(R), pxcMapping(R, Request), arg(6, E, Request),
	pxSplitGetOne(F), arg(7, E, F),
	pxSplitGetOne(C), arg(8, E, C).

% put event (pxEventPut)
pxcPutEvent(xRequest6, E, 6) :-
	arg(6, E, Six), pxSplitPutOne(Six). 
pxcPutEvent(xRequest7, E, 7) :- 
	arg(6, E, Six), pxSplitPutOne(Six), 
	arg(7, E, Seven), pxSplitPutOne(Seven).
pxcPutEvent(xRequest8, E, 8) :-
	arg(6, E, Six), pxSplitPutOne(Six), 
	arg(7, E, Seven), pxSplitPutOne(Seven), 
	arg(8, E, Eight), pxSplitPutOne(Eight).
pxcPutEvent(xRequest10, E, 10) :- pxStructPutOne(6, 11, E).
pxcPutEvent(xRequest12, E, 12) :- pxStructPutOne(6, 13, E).
pxcPutEvent(xNotify7, E, 7) :-
	arg(6, E, I), pxSplitPutOne(I), 
	arg(7, E, Boolean), pxcBoolean(B, Boolean), pxSplitPutOne(B).
pxcPutEvent(xInput, E, 15) :-
	arg(6, E, R), pxSplitPutOne(R),
	arg(7, E, Sub), pxSplitPutOne(Sub),
	arg(8, E, Time), pxcTime(RTime, Time), pxSplitPutOne(RTime),
	pxStructPutOne(9, 13, E),
	arg(13, E, State), pxMaskFromBits(S, State, pxmKey), pxSplitPutOne(S), 
	arg(14, E, IV), pxSplitPutOne(IV), 
	arg(15, E, Same), pxcBoolean(SS, Same), pxSplitPutOne(SS).
pxcPutEvent(xMotionNotify, E, 15) :-
	arg(6, E, R), pxSplitPutOne(R),
	arg(7, E, Sub), pxSplitPutOne(Sub),
	arg(8, E, Time), pxcTime(RTime, Time), pxSplitPutOne(RTime),
	pxStructPutOne(9, 13, E),
	arg(13, E, State), pxMaskFromBits(S, State, pxmKey), pxSplitPutOne(S), 
	arg(14, E, IsHint), pxcBoolean(IH, IsHint), pxSplitPutOne(IH), 
	arg(15, E, Same), pxcBoolean(SS, Same), pxSplitPutOne(SS).
pxcPutEvent(xCrossing, E, 17) :-
	arg(6, E, R), pxSplitPutOne(R),
	arg(7, E, Sub), pxSplitPutOne(Sub),
	arg(8, E, Time), pxcTime(RTime, Time), pxSplitPutOne(RTime),
	pxStructPutOne(9, 13, E),
	arg(13, E, Mode), pxcNotifyMode(M, Mode), pxSplitPutOne(M), 
	arg(14, E, Detail), pxcNotifyDetail(D, Detail), pxSplitPutOne(D), 
	arg(15, E, Same), pxcBoolean(SS, Same), pxSplitPutOne(SS), 
	arg(16, E, Focus), pxcBoolean(F, Focus), pxSplitPutOne(F), 
	arg(17, E, State), pxMaskFromBits(S, State, pxmKey), pxSplitPutOne(S).
pxcPutEvent(xFocus, E, 7) :- 
	arg(6, E, Mode), pxcNotifyMode(M, Mode), pxSplitPutOne(M),
	arg(7, E, Detail), pxcNotifyDetail(D, Detail), pxSplitPutOne(D).
pxcPutEvent(xKeymapNotify, E, 6) :-
	arg(6, E, KM), pxKeymapFromCodes(BL, KM), pxVectorPut(BL).
pxcPutEvent(xVisibilityNotify, E, 6) :-
	arg(6, E, State), pxcVisibility(S, State), pxSplitPutOne(S).
pxcPutEvent(xCreateNotify, E, 12) :-
	pxStructPutOne(6, 12, E),
	arg(12, E, Override), pxcBoolean(OR, Override), pxSplitPutOne(OR).
pxcPutEvent(xReparentNotify, E, 10) :-
	pxStructPutOne(6, 10, E),
	arg(10, E, Override), pxcBoolean(OR, Override), pxSplitPutOne(OR).
pxcPutEvent(xConfigureNotify, E, 13) :-
	pxStructPutOne(6, 12, E),
	arg(12, E, Above), pxcNone(A, Above), pxSplitPutOne(A),
	arg(13, E, Override), pxcBoolean(OR, Override), pxSplitPutOne(OR).
pxcPutEvent(xConfigureRequest, E, 14) :-
	pxStructPutOne(6, 12, E),
	arg(12, E, Above), pxcNone(A, Above), pxSplitPutOne(A),
	arg(13, E, Detail), pxcStackMode(D, Detail), pxSplitPutOne(D),
	arg(14, E, V), pxMaskFromBits(VM, V, pxmConfigure), pxSplitPutOne(VM).
pxcPutEvent(xPropertyNotify, E, 8) :-
	arg(6, E, A), pxSplitPutOne(A), 
	arg(7, E, Time), pxcTime(T, Time), pxSplitPutOne(T),
	arg(8, E, Delete), pxcBoolean(D, Delete), pxSplitPutOne(D).
pxcPutEvent(xSelectionClear, E, 7) :- 
	arg(6, E, S), pxSplitPutOne(S), 
	arg(7, E, Time), pxcTime(T, Time), pxSplitPutOne(T).
pxcPutEvent(xSelectionRequest, E, 10) :-
	pxStructPutOne(6, 9, E),
	arg(9, E, Property), pxcNone(P, Property), pxSplitPutOne(P),
	arg(10, E, Time), pxcTime(T, Time), pxSplitPutOne(T).
pxcPutEvent(xSelectionNotify, E, 9) :-
	pxStructPutOne(6, 8, E),
	arg(8, E, Property), pxcNone(P, Property), pxSplitPutOne(P),
	arg(9, E, Time), pxcTime(T, Time), pxSplitPutOne(T).
pxcPutEvent(xColormapNotify, E, 8) :-
	arg(6, E, Colormap), pxcNone(CM, Colormap), pxSplitPutOne(CM),
	arg(7, E, Modified), pxcBoolean(M, Modified), pxSplitPutOne(M),
	arg(8, E, Load), pxcBoolean(L, Load), pxSplitPutOne(L).
pxcPutEvent(xClientMessage, E, 12) :-
	arg(6, E, MT), pxSplitPutOne(MT),
	arg(7, E, 32), pxSplitPutOne(32),
	pxStructPutOne(8, 13, E).
pxcPutEvent(xClientMessage, E, 17) :-
	arg(6, E, MT), pxSplitPutOne(MT),
	arg(7, E, 16), pxSplitPutOne(16), 
	pxStructPutOne(8, 18, E).
pxcPutEvent(xClientMessage, E, 27) :-
	arg(6, E, MT), pxSplitPutOne(MT), 
	arg(7, E, 8), pxSplitPutOne(8), 
	pxStructPutOne(8, 28, E).
pxcPutEvent(xMappingNotify, E, 8) :-
	arg(6, E, Request), pxcMapping(R, Request), pxSplitPutOne(R),
	arg(7, E, F), pxSplitPutOne(F), 
	arg(8, E, C), pxSplitPutOne(C).

% notify mode
pxcNotifyMode(0, xNormal). 
pxcNotifyMode(1, xGrab).
pxcNotifyMode(2, xUngrab).
pxcNotifyMode(3, xWhileGrabbed).

% notify detail
pxcNotifyDetail(0, xAncestor).
pxcNotifyDetail(1, xVirtual).
pxcNotifyDetail(2, xInferior).
pxcNotifyDetail(3, xNonlinear).
pxcNotifyDetail(4, xNonlinearVirtual).
pxcNotifyDetail(5, xPointer).
pxcNotifyDetail(6, xPointerRoot).
pxcNotifyDetail(7, xNone).

% visibility
pxcVisibility(0, xUnobscured).
pxcVisibility(1, xPartial).
pxcVisibility(2, xObscured).

% configure masks
pxmConfigure(xX, 0).
pxmConfigure(xY, 1).
pxmConfigure(xWidth, 2).
pxmConfigure(xHeight, 3).
pxmConfigure(xBorderWidth, 4).
pxmConfigure(xSibling, 5).
pxmConfigure(xStackMode, 6).
pxmConfigure(maxindex, 7).

% mapping request type
pxcMapping(0, xModifier).
pxcMapping(1, xKeyboard).
pxcMapping(2, xPointer).

% send event window (xSendEvent)
pxcSendWindow(0, xPointerWindow) :- !.
pxcSendWindow(1, xInputFocus) :- !.
pxcSendWindow(N, N).

% WM_HINTS (xSetWMHints)
pxp_WM_HINTS(xInput, V, 2, 1, R) :- pxcBoolean(R, V).
pxp_WM_HINTS(xInitialState, V, 3, 2, R) :- pxcInitialState(R, V).
pxp_WM_HINTS(xIconPixmap, V, 4, 4, V).
pxp_WM_HINTS(xIconWindow, V, 5, 8, V).
pxp_WM_HINTS(xIconX, V, 6, 16, V).
pxp_WM_HINTS(xIconY, V, 7, 16, V).
pxp_WM_HINTS(xIconMask, V, 8, 32, V).
pxp_WM_HINTS(xWindowGroup, V, 9, 64, V).

% WM_HINTS Initial State
pxcInitialState(0, xDontCare).
pxcInitialState(1, xNormal).
pxcInitialState(2, xZoom).
pxcInitialState(3, xIconic).
pxcInitialState(4, xInactive).

% WM_NORMAL_HINTS (xSetNormalHints)
pxp_WM_NORMAL_HINTS(xUserX, V, 2, 1, V).
pxp_WM_NORMAL_HINTS(xUserY, V, 3, 1, V).
pxp_WM_NORMAL_HINTS(xUserWidth, V, 4, 2, V).
pxp_WM_NORMAL_HINTS(xUserHeight, V, 5, 2, V).
pxp_WM_NORMAL_HINTS(xProgramX, V, 2, 4, V).
pxp_WM_NORMAL_HINTS(xProgramY, V, 3, 4, V).
pxp_WM_NORMAL_HINTS(xProgramWidth, V, 4, 8, V).
pxp_WM_NORMAL_HINTS(xProgramHeight, V, 5, 8, V).
pxp_WM_NORMAL_HINTS(xMinWidth, V, 6, 16, V).
pxp_WM_NORMAL_HINTS(xMinHeight, V, 7, 16, V).
pxp_WM_NORMAL_HINTS(xMaxWidth, V, 8, 32, V).
pxp_WM_NORMAL_HINTS(xMaxHeight, V, 9, 32, V).
pxp_WM_NORMAL_HINTS(xWidthIncrement, V, 10, 64, V).
pxp_WM_NORMAL_HINTS(xHeightIncrement, V, 11, 64, V).
pxp_WM_NORMAL_HINTS(xMinAspectNumerator, V, 12, 128, V).
pxp_WM_NORMAL_HINTS(xMinAspectDenominator, V, 13, 128, V).
pxp_WM_NORMAL_HINTS(xMaxAspectNumerator, V, 14, 128, V).
pxp_WM_NORMAL_HINTS(xMaxAspectDenominator, V, 15, 128, V).

% 
% eof
%
