/*
 * Copyright (C) 1989 by The Regents of the University of California.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * ff.h - definitions for XWIP foreign function interface
 */

typedef int bool;		/* booleans */
#define true	(1)
#define false	(0)

typedef char PxVector8;		/* vector types */
typedef short PxVector16;
typedef long PxVector32;

				/* prolog foreign functions types */
typedef long		FFInteger; 
typedef double		FFFloat;
typedef unsigned long	FFAtom;
typedef char *		FFString;
typedef char *		FFAddr;

#define FF_Ok		(0)	/* predicate sucess or failure */
#define FF_Fail		(1)	/* has to be same as true */

				/* error handling */
#define PX_ErrorInit(NAME) pxErrorString = NAME
#define PX_Error(MSG) return(PXError(MSG))
#define PX_ServerError(PCP) \
	(pxServerError && ((PCP)->xDisplay->request == pxErrorSerial + 1))

#define PX_Invalid	(-1)	/* px logical types */
#define PX_String	(0)	/* used in GetProperty */
#define PX_Integer	(1)
#define PX_List		(2)
#define PX_KeyList	(3)	/* data is key for another list */
#define PX_Vector8	(8)	/* used in GetProperty */
#define PX_Vector16	(16)	/* used in GetProperty */
#define PX_Vector32	(32)	/* used in GetProperty */
#define PX_SplitVector	(4)
#define PX_TimeCoord	(5)	/* for GetMotionEvents */
#define PX_FontProperty (6)
#define PX_Text16       (7)
#define PX_VectorFont	(9)
#define PX_VectorPath	(10)
#define PX_TextItem8	(11)
#define PX_TextItem16	(12)
#define PX_TextVector	(13)
#define PX_ColorVector	(14)
#define PX_VectorExtension (15)
#define PX_ModifierMap (17)
#define PX_HostAddress (18)

#define PX_Cont 	(0)	/* next vector element */
#define PX_End		(1)

#define PX_MostSplit(X) ((unsigned)(0xFFFF0000 & (X)) >> 16)
#define PX_LeastSplit(X)           (0x0000FFFF & (X))
#define PX_JoinSplit(X, Y) (((X) << 16) | ((Y) & 0xFFFF))

extern char *pxErrorString;	/* part of error message */
extern bool pxServerError;	/* X server detected error */
extern unsigned long pxErrorSerial;

extern pxType;
extern pxElements;		/* number of vector elements */
extern DLHeader *pxList;
extern PxVector8 *pxVector8;
extern PxVector16 *pxVector16;
extern PxVector32 *pxVector32;
extern XFontProp *pxFontProperty;
extern XChar2b *pxText16;
extern char **pxStringPointers;
extern XTextItem *pxTextItem8;
extern XTextItem16 *pxTextItem16;
extern XColor *pxColor;
extern XHostAddress *pxHostAddress;

extern unsigned pxUnsignedArg1;
extern unsigned pxUnsignedArg2;

extern pxPrecision;
extern pxPrecisionMask;

extern char *pxMallocBlock;

extern PXVectorFree();
extern void pxVectorXFree();

extern char *pxNil;		/* common strings */
extern char *bad_event_format;
extern char *bad_request;
extern char *coordinate_out_of_range;
extern char *no_matching_screen;
extern char *no_memory;
extern char *no_such_character;
extern char *no_such_connection;
extern char *no_such_depth;
extern char *no_such_fil;
extern char *no_such_gc;
extern char *no_such_image;
extern char *no_such_screen;
extern char *no_such_visual;
extern char *no_such_window;
extern char *not_text;
extern char *unknown_attribute;
extern char *unknown_event_type;

/*
 * eof
 */
