% Baby Zebra Puzzle
% An example constraint puzzle
% -----------------------------------
% Gerald Penn
% Comp. Ling. Program
% CMU


% Subsumption
%=======================

bot sub [house,descriptor,background].

  descriptor sub [nat_type,ani_type,bev_type].
    nat_type sub [norwegian,ukranian,spaniard].
      norwegian sub [].
      ukranian sub [].
      spaniard sub [].
    ani_type sub [fox,dog,zebra].
      fox sub [].
      dog sub [].
      zebra sub [].
    bev_type sub [juice,tea,milk].
      juice sub [].
      tea sub [].
      milk sub [].

  house sub []
      intro [nationality:nat_type,animal:ani_type,beverage:bev_type].

  background sub [clue]
             intro [house1:house,house2:house,house3:house].
    clue sub [maximality].
      maximality sub [].

ext([norwegian,ukranian,spaniard,fox,dog,zebra,juice,tea,milk]).

% Constraints
%=============================
background cons
  (house1:nationality:N1,                            % inequational constraints
   house2:nationality:(N2,(=\= N1)),
   house3:nationality:((=\= N1),(=\= N2)),

   house1:animal:A1,
   house2:animal:(A2,(=\= A1)),
   house3:animal:((=\= A1),(=\= A2)),

   house1:beverage:B1,
   house2:beverage:(B2,(=\= B1)),
   house3:beverage:((=\= B1),(=\= B2))).

clue cons
  (house3:beverage:milk,            % clue 1

   house1:nationality:norwegian,     % clue 4

   (house1:nationality:spaniard,house1:animal:dog    % clue 2
   ;house2:nationality:spaniard,house2:animal:dog
   ;house3:nationality:spaniard,house3:animal:dog),

   (house1:nationality:ukranian,house1:beverage:tea  % clue 3
   ;house2:nationality:ukranian,house2:beverage:tea
   ;house3:nationality:ukranian,house3:beverage:tea),

   (house1:beverage:juice,house1:animal:fox  % clue 6
   ;house2:beverage:juice,house2:animal:fox
   ;house3:beverage:juice,house3:animal:fox),

   (house1:nationality:norwegian,house2:beverage:tea % clue 5
   ;house2:nationality:norwegian,house3:beverage:tea
   ;house2:nationality:norwegian,house1:beverage:tea
   ;house3:nationality:norwegian,house2:beverage:tea)).

maximality cons
  (house1:nationality:(norwegian;ukranian;spaniard), % maximality constraints
   house2:nationality:(norwegian;ukranian;spaniard),
   house3:nationality:(norwegian;ukranian;spaniard),

   house1:animal:(fox;dog;zebra),
   house2:animal:(fox;dog;zebra),
   house3:animal:(fox;dog;zebra),

   house1:beverage:(juice;tea;milk),
   house2:beverage:(juice;tea;milk),
   house3:beverage:(juice;tea;milk)).
  

