
link_also=true
rm_k2=true
rm_c=true
mk_s=false
optim=false
profile=false
debug=false
exec_file=a.out
includes=""
z2k2_opt=""
link_files=""
cc_opt=""
lib=cautious

while : ; do
  case $1 in
    "")
      break;;
    *.ml)
      $z2k2 -stdlib $stdlib $includes $z2k2_opt $1 || exit $?
      file_k2=`dirname $1`/`basename $1 .ml`.k2
      file_c=`dirname $1`/`basename $1 .ml`.c
      if $rm_c; then
	echo "(:declaration \"#include \\\"$header\\\"\")" | cat - $macros_k2 $file_k2 | $k2 -l -o $file_c || exit $?
      else 
	echo "(:declaration \"#include \\\"$header\\\"\")" | cat - $macros_k2 $file_k2 | $k2 -l | $cb 2>/dev/null > $file_c || exit $?
      fi
      if $mk_s; then
	object_file=`dirname $1`/`basename $1 .ml`.s
      else
	object_file=`dirname $1`/`basename $1 .ml`.o
        link_files="$link_files $object_file"
      fi
      $cc $cc_opt -c $file_c -o $object_file || exit $?
      if test !$debug; then
 	if $rm_c; then
	  rm -f $file_c
	fi
 	if $rm_k2; then
	  rm -f $file_k2
	fi
      fi;;
    *.k2)
      file_k2=$1
      file_c=`dirname $1`/`basename $1 .k2`.c
      if $rm_c; then
	{ cat $macros_k2 $file_k2 | $k2 -l -o $file_c; } || exit $?
      else 
	{ cat $macros_k2 $file_k2 | $k2 -l|$cb 2> /dev/null > $file_c; } || exit $?
      fi
      if $mk_s; then
	object_file=`dirname $1`/`basename $1 .k2`.s
      else
	object_file=`dirname $1`/`basename $1 .k2`.o
        link_files="$link_files $object_file"
      fi
      $cc $cc_opt -c $file_c -o $object_file || exit $?
      if test !$debug; then
 	if $rm_c; then
	  rm -f $file_c
	fi
      fi;;
    *.c)
      if $mk_s; then
	object_file=`dirname $1`/`basename $1 .c`.s
      else
	object_file=`dirname $1`/`basename $1 .c`.o
        link_files="$link_files $object_file"
      fi
      $cc $cc_opt -c $1 -o $object_file || exit $?
      ;;
    *.mli)
      $z2k2 -stdlib $stdlib $includes $z2k2_opt $1 || exit $?
      ;;
    *.o)
      link_files="$link_files $1";;
    -c)
      link_also=false;;      
    -I|-include)
      includes="$includes -I $2"
      shift;;
    -O|-open)
      z2k2_opt="$z2k2_opt -O $2"
      lib=$2
      shift;;
    -p|-profile)
      profile=true
      cc_opt="$cc_opt -p";;
    -K)
      rm_k2=false;;
    -C)
      rm_c=false;;
    -i)
      z2k2_opt="$z2k2_opt $1";;
    -f|-fast)
      cc_opt="$cc_opt $option_O";;
    -g|-debug)
      debug=true
      cc_opt="$cc_opt -g";;
    -S)
      cc_opt="$cc_opt -S"
      link_also=false
      mk_s=true;;
    -o|-exec)
      exec_file=$2
      shift;;
    -stdlib)
      stdlib=$2
      shift;;
    -v|-version)
      echo "Caml Light Object Translator version 0.51"
      echo "  Standard library from $stdlib"
      $z2k2 -version
      $linker -version;;
    *.a)
      link_files="$link_files $1";;
    -cc)
      cc=$2; shift;;
    -ccopt)
      cc_opt="$cc_opt $2"; shift;;
    -custom)
      shift;;
    -*)
      echo "Unknown option \"$1\", ignored" >&2;;
    *)
      echo "I don't know what to do with file \"$1\", ignored" >&2;;
  esac
  shift
done

if $link_also && test -n "$link_files"; then
  file=`$linker -O $lib -stdlib $stdlib $includes \
		-exec $exec_file $link_files || exit $?`
  file_k2=$file.k2
  file_c=$file.c
  file_o=$file.o
  $k2 -t -l $file_k2 -o $file_c || exit $?
  if test $lib = none; then
    lib_files=""
  elif test $lib = fast; then
    lib_files="$stdlib/lib.a"
  else 
    lib_files="$stdlib/cautious.a $stdlib/lib.a"
  fi
  $cc $cc_opt $file_c $link_files $lib_files $runtime $gc -o $exec_file -lm || exit $?
  if test !$debug; then
    rm -f $file_k2 $file_c $file_o
  fi
fi

exit 0
