#open "printf";;

type lexeme =
     Mot of string
   | Symbole of char
   | Constante_entiere of int
   | Constante_flottante of float;;

let pr lex = match lex with
               Mot s -> print_string("Mot(" ^ s ^ ")\n")
             | Symbole c -> printf "Symbole(%c)\n" c
             | Constante_entiere i -> printf "Entier(%d)\n" i
             | Constante_flottante f -> printf "Float(%f)\n" f
;;

let rec saute_blancs flux =
  match flux with
    [< ' ` ` >] -> saute_blancs flux
  | [< ' `\t` >] -> saute_blancs flux
  | [< ' `\n` >] -> saute_blancs flux
  | [< >] -> ();;

let rec lire_entier accumulateur flux =
  match flux with
    [< '(`0`..`9` as c) >] ->
      lire_entier (10 * accumulateur + int_of_char c - 48) flux
  | [< >] -> accumulateur;;
let rec lire_decimales accumulateur echelle flux =
  match flux with
    [< '(`0`..`9` as c) >] ->
      lire_decimales
        (accumulateur +. float_of_int(int_of_char c - 48) *. echelle)
        (echelle /. 10.0) flux
  | [< >] -> accumulateur;;

let tampon = "----------------";;
let rec lire_mot position flux =
  match flux with
    [< '(`A`..`Z` | `a`..`z` | `` | `` | `_` as c) >] ->
      if position < string_length tampon then set_nth_char tampon position c;
      lire_mot (position+1) flux
  | [< >] -> sub_string tampon 0 (min position (string_length tampon));;
let rec lire_lexeme flux =
  saute_blancs flux;
  match flux with
    [< '(`A`..`Z` | `a`..`z` | `` | `` as c) >] ->
      set_nth_char tampon 0 c;
      Mot(lire_mot 1 flux)
  | [< '(`0`..`9` as c) >] ->
      let n = lire_entier (int_of_char c - 48) flux in
      begin match flux with
        [< '`.` >] ->
          Constante_flottante(lire_decimales (float_of_int n) 0.1 flux)
      | [< >] -> Constante_entiere(n)
      end
  | [< 'c >] -> Symbole c;;
let rec analyseur_lexical flux =
  match flux with
    [< lire_lexeme lexeme >] -> [< 'lexeme; analyseur_lexical flux >]
  | [< >] -> [< >];;
let flux_lexemes = 
    analyseur_lexical(stream_of_string "123bonjour   ! 45.67");;

pr(stream_next flux_lexemes);;
pr(stream_next flux_lexemes);;
pr(stream_next flux_lexemes);;
pr(stream_next flux_lexemes);;

