(* The Fibonacci function, once more. *)

let rec fib n =
  if n < 2 then 1 else fib(n-1) + fib(n-2)
;;

if vect_length sys__command_line != 2 then
  begin
    print_string "Usage: fib <number>\n";
    exit 1
  end
else
  begin
    let n =
      try
        int_of_string sys__command_line.(1)
      with Failure "int_of_string" ->
        print_string "Bad integer constant\n";
        exit 1
    in
      print_int (fib n);
      print_newline();
      exit 0
  end
;;

