(* division euclidienne *)
 
type nat =  O_C |  S_C of nat;;
type ('B,'A) prod =  pair_C of 'A * 'B;;
type sumbool =  left_C |  right_C;;
type 'A sumor =  inleft_C of 'A |  inright_C;;
let fst u = (fun (pair_C (VAR3,VAR4)) -> VAR3) u;;
let snd u = (fun (pair_C (VAR3,VAR4)) -> VAR4) u;;
 
let fail () = raise (Failure "fail");;
 
let le_or_gt n =
 let rec VAR1 VAR2 =
  match VAR2 with
     O_C -> (fun m -> left_C)
   | S_C VAR3 ->
       fun m ->
             match m with
                O_C -> right_C
              | S_C VAR3' ->
                  match VAR1 VAR3 VAR3' with
                     left_C -> left_C | right_C -> right_C in
  VAR1 n;;
 
let O_or_S n =
 match n with O_C -> inright_C | S_C VAR3 -> inleft_C VAR3;;
 
let le_or_s n =
 let rec VAR1 VAR2 =
  match VAR2 with
     O_C -> (fun m -> left_C)
   | S_C VAR3 ->
       fun m ->
             match m with
                O_C -> right_C
              | S_C VAR3' ->
                  match VAR1 VAR3 VAR3' with
                     left_C -> left_C | right_C -> right_C in
  VAR1 n;;
 
let gt_S_s n m =
 match le_or_gt n m with
    left_C ->
      (match le_or_s m n with left_C -> right_C | right_C -> fail())
  | right_C -> left_C;;
 
let division_extractible n d =
 let rec VAR1 VAR2 =
  match VAR2 with
     O_C -> pair_C (O_C,O_C)
   | S_C VAR3 ->
       match d with
          O_C ->
            (match fail () with
                left_C -> pair_C (fst (VAR1 VAR3),S_C (snd (VAR1
VAR3)))
              | right_C -> pair_C (S_C (fst (VAR1 VAR3)),O_C))
        | S_C VAR3' ->
            match gt_S_s VAR3' (snd (VAR1 VAR3)) with
               left_C -> pair_C (fst (VAR1 VAR3),S_C (snd (VAR1
VAR3)))
             | right_C -> pair_C (S_C (fst (VAR1 VAR3)),O_C) in
  VAR1 n;;
 
let UN = S_C O_C;;
 
let DEUX = S_C UN;;
 
let TROIS = S_C DEUX;;
 
let rec PLUS n p = match p with O_C -> n | (S_C m) -> (S_C (PLUS n
m));;
 
let SIX = PLUS TROIS TROIS;;
 
let DOUZE = PLUS SIX SIX;;
 
let rec print_nat = function O_C -> print_int 0 | S_C n ->
print_string "S ";print_nat n;;
 
let print_resultat = function pair_C (a,b) -> print_nat a;
print_string "-->";print_nat b;;
 
print_resultat (division_extractible DOUZE DOUZE);;
print_newline();;
 
 
 
