(* Benchmarks on:
   Closure creation, pattern matching
Camllight sur decstation 5000/200 17s
Caml V3.1 100 : 15.3 + 7.5 s
Caml light 0.5 sur sparc station 2
       19.3 real        19.1 user         0.0 sys
*)
type R =  R of b * a
and b = K of string | L of string * string * string * b * a
      | M of string * string * c | N of b list
and a = A of string * c | B of string * string * c
      | C of c * a * a | E of c * a | F of c | G of string | J of a list
and c = O of int | Q of bool | S of c * string * c
      | T of string | U of string * c | X of c * c * c
and V = c of int | d of bool | g of int list
and W = W of (string -> D)
and D = D of V | V of H | Y of (D * D -> Z -> Z) | I of (D -> Z -> D)
and H = H of int and Z = Z of (H -> D);;
let evh = H 0 and iZt = H 1 and oZt = H 2;;
let i_t = W (function t -> failwith "err");;
let i_z =
  Z (function H 0 -> V (H 3) | H 1|H 2 -> D (g []) | _ -> failwith "err");;
let ct x (Z z) = z x;;
let gf Sr = match ct evh Sr with V (H l as cl) -> cl | _ -> failwith "err";;
let tlf dt (W t) = t dt;;
let clt t dt = match tlf dt t with V cl -> cl | _ -> failwith "err";;
let vf t dt = ct (clt t dt) and dx t x v y = if y = t then v else x y;;
let hz (Z z as Zt) = let nfH = V (H (let (H zz) = gf Zt in zz+1)) in
    Z (dx evh z nfH);;
let dt_z cl (Z z) v = Z (dx cl z v);;
let dt_g t dt = dt_z (clt dt t) and dt_t (W t) dt v = W (dx dt t v);;
let hg dt (t,z) = let cl = ct evh z in dt_t t dt cl,hz z;;
let wg dt v (t,s) = let cl = gf s in dt_t t dt (V cl), dt_z cl (hz s) v;;
let gtg s = match ct oZt s with D (g ptt) -> ptt | _ -> failwith "err";;
let trc = function D (c v) -> (function dx -> dt_z oZt dx (D (g (v::gtg dx))))
   | _ -> failwith "err";;
let gg z = match ct iZt z with D (g pp) -> pp | _ -> failwith "err";;
let gd x = match x with D (d bb) -> bb | _ -> failwith "err";;
let irt a = match gg a with [] -> failwith "err"
  | l::x -> dt_z iZt a (D (g x)),D (c l);;
let gp x = match x with Y x -> x | _ -> failwith "err";;
let fg x = match x with I x -> x | _ -> failwith "err";;
let rq = function
     "+" -> (function D (c x1),D (c x2) -> D (c (x1+x2)) | _ -> failwith "err")
   | "*" -> (function D (c x1),D (c x2) -> D (c (x1*x2)) | _ -> failwith "err")
   | "-" -> (function D (c x1),D (c x2) -> D (c (x1-x2)) | _ -> failwith "err")
   | "=" -> (function D (c x1),D (c x2) -> D (d (x1=x2))
                    | D (d x1),D (d x2) -> D (d (x1=x2)) | _ -> failwith "err")
   | ">" -> (function D (c x1),D (c x2) -> D (d (x1>x2)) | _ -> failwith "err")
   | _ -> failwith "err";;
let rec dpx = function
     (O n) -> (function x -> function xx -> D (c n))
   | (Q bb) -> (function x -> function xx -> D (d bb))
   | (T dt) -> (function x -> function xx -> vf x dt xx)
   | (S (t,ox,u)) ->
       (let r = rq ox and mt = dpx t and mu = dpx u in
        function x -> function xx -> r (mt x xx,mu x xx))
   | (U (mx,a)) ->
       (let ma = dpx a in
        function x -> function xx -> let z = fg (tlf mx x) in z (ma x xx) xx)
   | (X (tt,t,u)) ->
       let mtt = dpx tt and mt = dpx t and mu = dpx u in
       function x -> function xx -> (if gd (mtt x xx) then mt else mu) x xx;;
let rec dc = function
     (A (dt,x)) ->
       (let zz = dpx x in function z -> function xx -> dt_g dt z xx (zz z xx))
   | (B (dxp,dt,xdp)) ->
       (let xdp = dpx xdp in function z -> function xx ->
        let y = gp (tlf dxp z) in y (tlf dt z,xdp z xx) xx)
   | (C (t,t1,t2)) ->
       (let t = dpx t and t1 = dc t1 and t2 = dc t2 in
        function z -> function xx -> if gd (t z xx) then t1 z xx else t2 z xx)
   | (E (t,tt)) ->
       (let tt = dc tt and t = dpx t in function z ->
        let rec zz xx = if gd (t z xx) then zz (tt z xx) else xx in zz)
   | (F x) ->
       (let x = dpx x in function z -> function xx -> trc (x z xx) xx)
   | (G dt) ->
       (function z -> function xx -> let xx',zz = irt xx in dt_g dt z xx' zz)
   | (J dpx) ->
       match dpx with
          [] -> (function z -> function xx -> xx)
        | t::x -> let t = dc t and zz = dc (J x) in
                  function z -> function xx -> zz z (t z xx);;
let rec vx = function
     (K dt) -> (function (e,xx) -> hg dt (e,xx))
   | (M (mx,i,x)) ->
       (let x_1 = dpx x in function (e,xx) ->
        let rec x x1 xx1 = let t_i,z_i = wg i x1 (e,xx1) in
        let ti = dt_t t_i mx (I x) in x_1 ti z_i in dt_t e mx (I x),xx)
   | (L (dpx,z,x_1,x,tt)) ->
       (let tt = dc tt and zx = vx x in function (e,xx) ->
        let rec p (ref1,x1) xx1 = let t_z = dt_t e z ref1 in
        let t_x_1,z_x_1 = wg x_1 x1 (t_z,xx1) in
        let t_x,z_x = zx (t_x_1,z_x_1) in let t_p = dt_t t_x dpx (Y p) in
        tt t_p z_x in dt_t e dpx (Y p),xx)
   | (N dc) ->
       match dc with [] -> (function zl -> zl)
        | ll::l ->
       let zl = vx ll and zll = vx (N l) in
       function (e,xx) -> zll (zl (e,xx));;
let rg1 (R (l,tt)) =
 let (e,xx) = vx l (i_t,i_z) in let tx = dc tt e in
 function itlist ->
  let xx' = dt_z iZt xx (D (g itlist)) in let z = tx xx' in rev (gtg z);;
let rg2 =
 rg1 (R (N [K "x"; K "xx"; M ("z","x", X (S (T "x","=",O 1),O 1, X
     (S (T "x","=",O 2),O 1, S (U ("z",S (T "x","-",O 1)),"+",
      U ("z",S (T "x","-",O 2))))))], J (G "xx":: [E (S (T "xx",">",O 0),
      J (A ("xx",S (T "xx","-",O 1)):: [G "x"; F (U ("z",T "x"))]))])));;
let rg3 =
 rg2 [20;1;2;3;4;5;6;7;8;9;10;11;12;13;14;15;16;17;18;19;20] in
 if rg3 =[1; 1; 2; 3; 5; 8; 13; 21; 34; 55; 89; 144; 233; 377; 610; 987; 1597;
         2584; 4181; 6765] then () else failwith "wrong result";;
