
(******* Quelques definitions du prelude CAML **************)

(******
let eq_int (m,n) = m==n
and eq_string (s,t) = s=t;;
*******)

(* 0- les indispensables *)

(* exception failure of string;;

let failwith s = raise(failure s)
;; *)

(* 1- les paires *)

(* let fst (x,y) = x
and snd (x,y) = y
;; *)

(* 2- Les listes *)

(* let rec append = function
    ([], L2) -> L2
  | (a::L,L2) -> a :: append (L, L2)
;;

let prefix @ = append
;; *)

(* let do_list f = do_rec where rec do_rec = function
     []  -> ()
  | a::L -> f a; do_rec L
;; *)

(* let map f = map_rec where rec map_rec = function
     []  -> []
  | a::L -> f a :: map_rec L
;; *)

(* let it_list f = it_rec
  where rec it_rec = function
    (a, []) -> a
  | (a, b::L) -> it_rec (f (a,b), L)
;; *)

(* let it_list2 f = it_rec
  where rec it_rec = function
     (a, [], []) -> a
   | (a, a1::L1, a2::L2) -> it_rec (f (a,a1,a2), L1, L2)
   | _ -> failwith "it_list2"
;; *)

let fold f = fold_rec where rec fold_rec = fun
    a1 [] -> (a1, [])
  | a1 (b1::bl) ->
      let (a2,c2) = f a1 b1 in
      let (a,cl) = fold_rec a2 bl in
        (a, c2::cl)
;;

(* let exists p = exists_rec where rec exists_rec = function
     []  -> false
  | a::L -> (p a) or (exists_rec L)
;; *)

(* let for_all p = for_all_rec where rec for_all_rec = function
     []  -> true
  | a::L -> (p a) & (for_all_rec L)
;; *)

(* let rec rev_append = fun
    [] L -> L
  | (x::L1) L2 -> rev_append L1 (x::L2)
;;

let rev L = rev_append L []
;; *)

(* let rec length = function
     []  -> 0
  | a::L -> succ(length L)
;; *)

let try_find f = try_find_rec where rec try_find_rec = function
     []  -> failwith "try_find"
  | a::L -> try f a with Failure _ -> try_find_rec L
;;

let partition p = part_rec where rec part_rec = function
     []  -> [],[]
  | a::L -> let (pos,neg) = part_rec L in
              if p a then  a::pos, neg else pos, a::neg
;;

(* 3- Les ensembles et les listes d'association *)

let mymem eq a = mem_rec where rec mem_rec = function
     []  -> false
  | b::L -> eq a b or mem_rec L
;;

let union eq L1 L2 = union_rec L1
  where rec union_rec = function
      []  -> L2
   | a::L -> if mymem eq a L2 then union_rec L else a :: union_rec L
;;


let mymem_assoc eq a = mem_rec where rec mem_rec = function
       []    -> false
  | (b,_)::L -> eq a b or mem_rec L
;;

let myassoc eq a = assoc_rec where rec assoc_rec = function
       []    -> failwith "find"
  | (b,d)::L -> if eq a b then d else assoc_rec L
;;

(* 4- Les sorties *)

(* let print_newline () = print_string "\n"
;; *)

let message s = print_string s; print_newline()
;;
