#open "prelude";;
#open "terms";;
#open "equations";;
#open "orderings";;
#open "kb";;

let Group_rules = [
  Rule(1, 1, Term(`*`, [Term(`U`,[]); Var 1]), Var 1);
  Rule(2, 1, Term(`*`, [Term(`I`,[Var 1]); Var 1]), Term(`U`,[]));
  Rule(3, 3, Term(`*`, [Term(`*`, [Var 1; Var 2]); Var 3]),
             Term(`*`, [Var 1; Term(`*`, [Var 2; Var 3])]))
];;

let Geom_rules = [
  Rule(1, 1, Term(`*`, [Term(`U`,[]); Var 1]), Var 1);
  Rule(2, 1, Term(`*`, [Term(`I`,[Var 1]); Var 1]), Term(`U`,[]));
  Rule(3, 3, Term(`*`, [Term(`*`, [Var 1; Var 2]); Var 3]),
             Term(`*`, [Var 1; Term(`*`, [Var 2; Var 3])]));
  Rule(4, 0, Term (`*`,[(Term (`A`,[])); (Term (`B`,[]))]),
    (Term (`*`,[(Term (`B`,[])); (Term (`A`,[]))])));
  Rule(5, 0, Term (`*`,[(Term (`C`,[])); (Term (`C`,[]))]),(Term (`U`,[])));
  Rule(6, 0,
  Term
   (`*`,
    [(Term (`C`,[]));
     (Term (`*`,[(Term (`A`,[])); (Term (`I`,[(Term (`C`,[]))]))]))]),
  Term (`I`,[(Term (`A`,[]))]));
  Rule(7, 0,
  Term
   (`*`,
    [(Term (`C`,[]));
     (Term (`*`,[(Term (`B`,[])); (Term (`I`,[(Term (`C`,[]))]))]))]),
  Term (`B`,[]))
];;

let Group_rank = function
    `U` -> 0
  | `*` -> 1
  | `I` -> 2
  | `B` -> 3
  | `C` -> 4
  | `A` -> 5
;;

let Group_precedence op1 op2 =
  let r1 = Group_rank op1
  and r2 = Group_rank op2 in
    if r1==r2 then Equal else
    if r1 > r2 then Greater else NotGE
;;

let Group_order = rpo Group_precedence lex_ext 
;;

let greater x y =
  match Group_order x y with Greater -> true | _ -> false
;;

kb_complete greater [] (* Geom_rules *) Group_rules
;;
